"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDeliveryStream = void 0;
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2020-07-18T01:07:53.078Z","fingerprint":"DkrQrBJ5USk67vqqJx6BeGKOQLr+vuTMlyLVvq05GB0="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cfn_parse = require("../../core/lib/cfn-parse"); // Automatically re-written from '@aws-cdk/core/lib/cfn-parse'
/**
 * Determine whether the given properties match those of a `CfnDeliveryStreamProps`
 *
 * @param properties - the TypeScript properties of a `CfnDeliveryStreamProps`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStreamPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('deliveryStreamName', cdk.validateString)(properties.deliveryStreamName));
    errors.collect(cdk.propertyValidator('deliveryStreamType', cdk.validateString)(properties.deliveryStreamType));
    errors.collect(cdk.propertyValidator('elasticsearchDestinationConfiguration', CfnDeliveryStream_ElasticsearchDestinationConfigurationPropertyValidator)(properties.elasticsearchDestinationConfiguration));
    errors.collect(cdk.propertyValidator('extendedS3DestinationConfiguration', CfnDeliveryStream_ExtendedS3DestinationConfigurationPropertyValidator)(properties.extendedS3DestinationConfiguration));
    errors.collect(cdk.propertyValidator('kinesisStreamSourceConfiguration', CfnDeliveryStream_KinesisStreamSourceConfigurationPropertyValidator)(properties.kinesisStreamSourceConfiguration));
    errors.collect(cdk.propertyValidator('redshiftDestinationConfiguration', CfnDeliveryStream_RedshiftDestinationConfigurationPropertyValidator)(properties.redshiftDestinationConfiguration));
    errors.collect(cdk.propertyValidator('s3DestinationConfiguration', CfnDeliveryStream_S3DestinationConfigurationPropertyValidator)(properties.s3DestinationConfiguration));
    errors.collect(cdk.propertyValidator('splunkDestinationConfiguration', CfnDeliveryStream_SplunkDestinationConfigurationPropertyValidator)(properties.splunkDestinationConfiguration));
    return errors.wrap('supplied properties not correct for "CfnDeliveryStreamProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream` resource
 *
 * @param properties - the TypeScript properties of a `CfnDeliveryStreamProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStreamPropsValidator(properties).assertSuccess();
    return {
        DeliveryStreamName: cdk.stringToCloudFormation(properties.deliveryStreamName),
        DeliveryStreamType: cdk.stringToCloudFormation(properties.deliveryStreamType),
        ElasticsearchDestinationConfiguration: cfnDeliveryStreamElasticsearchDestinationConfigurationPropertyToCloudFormation(properties.elasticsearchDestinationConfiguration),
        ExtendedS3DestinationConfiguration: cfnDeliveryStreamExtendedS3DestinationConfigurationPropertyToCloudFormation(properties.extendedS3DestinationConfiguration),
        KinesisStreamSourceConfiguration: cfnDeliveryStreamKinesisStreamSourceConfigurationPropertyToCloudFormation(properties.kinesisStreamSourceConfiguration),
        RedshiftDestinationConfiguration: cfnDeliveryStreamRedshiftDestinationConfigurationPropertyToCloudFormation(properties.redshiftDestinationConfiguration),
        S3DestinationConfiguration: cfnDeliveryStreamS3DestinationConfigurationPropertyToCloudFormation(properties.s3DestinationConfiguration),
        SplunkDestinationConfiguration: cfnDeliveryStreamSplunkDestinationConfigurationPropertyToCloudFormation(properties.splunkDestinationConfiguration),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        deliveryStreamName: properties.DeliveryStreamName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DeliveryStreamName),
        deliveryStreamType: properties.DeliveryStreamType == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DeliveryStreamType),
        elasticsearchDestinationConfiguration: properties.ElasticsearchDestinationConfiguration == null ? undefined : CfnDeliveryStreamElasticsearchDestinationConfigurationPropertyFromCloudFormation(properties.ElasticsearchDestinationConfiguration),
        extendedS3DestinationConfiguration: properties.ExtendedS3DestinationConfiguration == null ? undefined : CfnDeliveryStreamExtendedS3DestinationConfigurationPropertyFromCloudFormation(properties.ExtendedS3DestinationConfiguration),
        kinesisStreamSourceConfiguration: properties.KinesisStreamSourceConfiguration == null ? undefined : CfnDeliveryStreamKinesisStreamSourceConfigurationPropertyFromCloudFormation(properties.KinesisStreamSourceConfiguration),
        redshiftDestinationConfiguration: properties.RedshiftDestinationConfiguration == null ? undefined : CfnDeliveryStreamRedshiftDestinationConfigurationPropertyFromCloudFormation(properties.RedshiftDestinationConfiguration),
        s3DestinationConfiguration: properties.S3DestinationConfiguration == null ? undefined : CfnDeliveryStreamS3DestinationConfigurationPropertyFromCloudFormation(properties.S3DestinationConfiguration),
        splunkDestinationConfiguration: properties.SplunkDestinationConfiguration == null ? undefined : CfnDeliveryStreamSplunkDestinationConfigurationPropertyFromCloudFormation(properties.SplunkDestinationConfiguration),
    };
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`
 *
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
class CfnDeliveryStream extends cdk.CfnResource {
    /**
     * Create a new `AWS::KinesisFirehose::DeliveryStream`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnDeliveryStream.CFN_RESOURCE_TYPE_NAME, properties: props });
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.deliveryStreamName = props.deliveryStreamName;
        this.deliveryStreamType = props.deliveryStreamType;
        this.elasticsearchDestinationConfiguration = props.elasticsearchDestinationConfiguration;
        this.extendedS3DestinationConfiguration = props.extendedS3DestinationConfiguration;
        this.kinesisStreamSourceConfiguration = props.kinesisStreamSourceConfiguration;
        this.redshiftDestinationConfiguration = props.redshiftDestinationConfiguration;
        this.s3DestinationConfiguration = props.s3DestinationConfiguration;
        this.splunkDestinationConfiguration = props.splunkDestinationConfiguration;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        var _a;
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnDeliveryStreamPropsFromCloudFormation(resourceProperties);
        const ret = new CfnDeliveryStream(scope, id, props);
        const cfnOptions = ret.cfnOptions;
        cfnOptions.creationPolicy = cfnParser.parseCreationPolicy(resourceAttributes.CreationPolicy);
        cfnOptions.updatePolicy = cfnParser.parseUpdatePolicy(resourceAttributes.UpdatePolicy);
        cfnOptions.deletionPolicy = cfnParser.parseDeletionPolicy(resourceAttributes.DeletionPolicy);
        cfnOptions.updateReplacePolicy = cfnParser.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy);
        cfnOptions.metadata = cfnParser.parseValue(resourceAttributes.Metadata);
        // handle DependsOn
        resourceAttributes.DependsOn = (_a = resourceAttributes.DependsOn) !== null && _a !== void 0 ? _a : [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
            const depResource = options.finder.findResource(dep);
            if (!depResource) {
                throw new Error(`Resource '${id}' depends on '${dep}' that doesn't exist`);
            }
            ret.node.addDependency(depResource);
        }
        // handle Condition
        if (resourceAttributes.Condition) {
            const condition = options.finder.findCondition(resourceAttributes.Condition);
            if (!condition) {
                throw new Error(`Resource '${id}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
            }
            cfnOptions.condition = condition;
        }
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnDeliveryStream.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            deliveryStreamName: this.deliveryStreamName,
            deliveryStreamType: this.deliveryStreamType,
            elasticsearchDestinationConfiguration: this.elasticsearchDestinationConfiguration,
            extendedS3DestinationConfiguration: this.extendedS3DestinationConfiguration,
            kinesisStreamSourceConfiguration: this.kinesisStreamSourceConfiguration,
            redshiftDestinationConfiguration: this.redshiftDestinationConfiguration,
            s3DestinationConfiguration: this.s3DestinationConfiguration,
            splunkDestinationConfiguration: this.splunkDestinationConfiguration,
        };
    }
    renderProperties(props) {
        return cfnDeliveryStreamPropsToCloudFormation(props);
    }
}
exports.CfnDeliveryStream = CfnDeliveryStream;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnDeliveryStream.CFN_RESOURCE_TYPE_NAME = "AWS::KinesisFirehose::DeliveryStream";
/**
 * Determine whether the given properties match those of a `BufferingHintsProperty`
 *
 * @param properties - the TypeScript properties of a `BufferingHintsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_BufferingHintsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('intervalInSeconds', cdk.validateNumber)(properties.intervalInSeconds));
    errors.collect(cdk.propertyValidator('sizeInMBs', cdk.validateNumber)(properties.sizeInMBs));
    return errors.wrap('supplied properties not correct for "BufferingHintsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.BufferingHints` resource
 *
 * @param properties - the TypeScript properties of a `BufferingHintsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.BufferingHints` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamBufferingHintsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_BufferingHintsPropertyValidator(properties).assertSuccess();
    return {
        IntervalInSeconds: cdk.numberToCloudFormation(properties.intervalInSeconds),
        SizeInMBs: cdk.numberToCloudFormation(properties.sizeInMBs),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamBufferingHintsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        intervalInSeconds: properties.IntervalInSeconds == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.IntervalInSeconds),
        sizeInMBs: properties.SizeInMBs == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.SizeInMBs),
    };
}
/**
 * Determine whether the given properties match those of a `CloudWatchLoggingOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `CloudWatchLoggingOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_CloudWatchLoggingOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('logGroupName', cdk.validateString)(properties.logGroupName));
    errors.collect(cdk.propertyValidator('logStreamName', cdk.validateString)(properties.logStreamName));
    return errors.wrap('supplied properties not correct for "CloudWatchLoggingOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.CloudWatchLoggingOptions` resource
 *
 * @param properties - the TypeScript properties of a `CloudWatchLoggingOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.CloudWatchLoggingOptions` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamCloudWatchLoggingOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_CloudWatchLoggingOptionsPropertyValidator(properties).assertSuccess();
    return {
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        LogGroupName: cdk.stringToCloudFormation(properties.logGroupName),
        LogStreamName: cdk.stringToCloudFormation(properties.logStreamName),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamCloudWatchLoggingOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        enabled: properties.Enabled == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.Enabled),
        logGroupName: properties.LogGroupName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.LogGroupName),
        logStreamName: properties.LogStreamName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.LogStreamName),
    };
}
/**
 * Determine whether the given properties match those of a `CopyCommandProperty`
 *
 * @param properties - the TypeScript properties of a `CopyCommandProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_CopyCommandPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('copyOptions', cdk.validateString)(properties.copyOptions));
    errors.collect(cdk.propertyValidator('dataTableColumns', cdk.validateString)(properties.dataTableColumns));
    errors.collect(cdk.propertyValidator('dataTableName', cdk.requiredValidator)(properties.dataTableName));
    errors.collect(cdk.propertyValidator('dataTableName', cdk.validateString)(properties.dataTableName));
    return errors.wrap('supplied properties not correct for "CopyCommandProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.CopyCommand` resource
 *
 * @param properties - the TypeScript properties of a `CopyCommandProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.CopyCommand` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamCopyCommandPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_CopyCommandPropertyValidator(properties).assertSuccess();
    return {
        CopyOptions: cdk.stringToCloudFormation(properties.copyOptions),
        DataTableColumns: cdk.stringToCloudFormation(properties.dataTableColumns),
        DataTableName: cdk.stringToCloudFormation(properties.dataTableName),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamCopyCommandPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        copyOptions: properties.CopyOptions == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.CopyOptions),
        dataTableColumns: properties.DataTableColumns == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DataTableColumns),
        dataTableName: cfn_parse.FromCloudFormation.getString(properties.DataTableName),
    };
}
/**
 * Determine whether the given properties match those of a `DataFormatConversionConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DataFormatConversionConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_DataFormatConversionConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('inputFormatConfiguration', CfnDeliveryStream_InputFormatConfigurationPropertyValidator)(properties.inputFormatConfiguration));
    errors.collect(cdk.propertyValidator('outputFormatConfiguration', CfnDeliveryStream_OutputFormatConfigurationPropertyValidator)(properties.outputFormatConfiguration));
    errors.collect(cdk.propertyValidator('schemaConfiguration', CfnDeliveryStream_SchemaConfigurationPropertyValidator)(properties.schemaConfiguration));
    return errors.wrap('supplied properties not correct for "DataFormatConversionConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.DataFormatConversionConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DataFormatConversionConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.DataFormatConversionConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamDataFormatConversionConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_DataFormatConversionConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        InputFormatConfiguration: cfnDeliveryStreamInputFormatConfigurationPropertyToCloudFormation(properties.inputFormatConfiguration),
        OutputFormatConfiguration: cfnDeliveryStreamOutputFormatConfigurationPropertyToCloudFormation(properties.outputFormatConfiguration),
        SchemaConfiguration: cfnDeliveryStreamSchemaConfigurationPropertyToCloudFormation(properties.schemaConfiguration),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamDataFormatConversionConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        enabled: properties.Enabled == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.Enabled),
        inputFormatConfiguration: properties.InputFormatConfiguration == null ? undefined : CfnDeliveryStreamInputFormatConfigurationPropertyFromCloudFormation(properties.InputFormatConfiguration),
        outputFormatConfiguration: properties.OutputFormatConfiguration == null ? undefined : CfnDeliveryStreamOutputFormatConfigurationPropertyFromCloudFormation(properties.OutputFormatConfiguration),
        schemaConfiguration: properties.SchemaConfiguration == null ? undefined : CfnDeliveryStreamSchemaConfigurationPropertyFromCloudFormation(properties.SchemaConfiguration),
    };
}
/**
 * Determine whether the given properties match those of a `DeserializerProperty`
 *
 * @param properties - the TypeScript properties of a `DeserializerProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_DeserializerPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('hiveJsonSerDe', CfnDeliveryStream_HiveJsonSerDePropertyValidator)(properties.hiveJsonSerDe));
    errors.collect(cdk.propertyValidator('openXJsonSerDe', CfnDeliveryStream_OpenXJsonSerDePropertyValidator)(properties.openXJsonSerDe));
    return errors.wrap('supplied properties not correct for "DeserializerProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.Deserializer` resource
 *
 * @param properties - the TypeScript properties of a `DeserializerProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.Deserializer` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamDeserializerPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_DeserializerPropertyValidator(properties).assertSuccess();
    return {
        HiveJsonSerDe: cfnDeliveryStreamHiveJsonSerDePropertyToCloudFormation(properties.hiveJsonSerDe),
        OpenXJsonSerDe: cfnDeliveryStreamOpenXJsonSerDePropertyToCloudFormation(properties.openXJsonSerDe),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamDeserializerPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        hiveJsonSerDe: properties.HiveJsonSerDe == null ? undefined : CfnDeliveryStreamHiveJsonSerDePropertyFromCloudFormation(properties.HiveJsonSerDe),
        openXJsonSerDe: properties.OpenXJsonSerDe == null ? undefined : CfnDeliveryStreamOpenXJsonSerDePropertyFromCloudFormation(properties.OpenXJsonSerDe),
    };
}
/**
 * Determine whether the given properties match those of a `ElasticsearchBufferingHintsProperty`
 *
 * @param properties - the TypeScript properties of a `ElasticsearchBufferingHintsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_ElasticsearchBufferingHintsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('intervalInSeconds', cdk.validateNumber)(properties.intervalInSeconds));
    errors.collect(cdk.propertyValidator('sizeInMBs', cdk.validateNumber)(properties.sizeInMBs));
    return errors.wrap('supplied properties not correct for "ElasticsearchBufferingHintsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ElasticsearchBufferingHints` resource
 *
 * @param properties - the TypeScript properties of a `ElasticsearchBufferingHintsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ElasticsearchBufferingHints` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamElasticsearchBufferingHintsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_ElasticsearchBufferingHintsPropertyValidator(properties).assertSuccess();
    return {
        IntervalInSeconds: cdk.numberToCloudFormation(properties.intervalInSeconds),
        SizeInMBs: cdk.numberToCloudFormation(properties.sizeInMBs),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamElasticsearchBufferingHintsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        intervalInSeconds: properties.IntervalInSeconds == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.IntervalInSeconds),
        sizeInMBs: properties.SizeInMBs == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.SizeInMBs),
    };
}
/**
 * Determine whether the given properties match those of a `ElasticsearchDestinationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ElasticsearchDestinationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_ElasticsearchDestinationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('bufferingHints', CfnDeliveryStream_ElasticsearchBufferingHintsPropertyValidator)(properties.bufferingHints));
    errors.collect(cdk.propertyValidator('cloudWatchLoggingOptions', CfnDeliveryStream_CloudWatchLoggingOptionsPropertyValidator)(properties.cloudWatchLoggingOptions));
    errors.collect(cdk.propertyValidator('clusterEndpoint', cdk.validateString)(properties.clusterEndpoint));
    errors.collect(cdk.propertyValidator('domainArn', cdk.validateString)(properties.domainArn));
    errors.collect(cdk.propertyValidator('indexName', cdk.requiredValidator)(properties.indexName));
    errors.collect(cdk.propertyValidator('indexName', cdk.validateString)(properties.indexName));
    errors.collect(cdk.propertyValidator('indexRotationPeriod', cdk.validateString)(properties.indexRotationPeriod));
    errors.collect(cdk.propertyValidator('processingConfiguration', CfnDeliveryStream_ProcessingConfigurationPropertyValidator)(properties.processingConfiguration));
    errors.collect(cdk.propertyValidator('retryOptions', CfnDeliveryStream_ElasticsearchRetryOptionsPropertyValidator)(properties.retryOptions));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('s3BackupMode', cdk.validateString)(properties.s3BackupMode));
    errors.collect(cdk.propertyValidator('s3Configuration', cdk.requiredValidator)(properties.s3Configuration));
    errors.collect(cdk.propertyValidator('s3Configuration', CfnDeliveryStream_S3DestinationConfigurationPropertyValidator)(properties.s3Configuration));
    errors.collect(cdk.propertyValidator('typeName', cdk.validateString)(properties.typeName));
    errors.collect(cdk.propertyValidator('vpcConfiguration', CfnDeliveryStream_VpcConfigurationPropertyValidator)(properties.vpcConfiguration));
    return errors.wrap('supplied properties not correct for "ElasticsearchDestinationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ElasticsearchDestinationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ElasticsearchDestinationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ElasticsearchDestinationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamElasticsearchDestinationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_ElasticsearchDestinationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        BufferingHints: cfnDeliveryStreamElasticsearchBufferingHintsPropertyToCloudFormation(properties.bufferingHints),
        CloudWatchLoggingOptions: cfnDeliveryStreamCloudWatchLoggingOptionsPropertyToCloudFormation(properties.cloudWatchLoggingOptions),
        ClusterEndpoint: cdk.stringToCloudFormation(properties.clusterEndpoint),
        DomainARN: cdk.stringToCloudFormation(properties.domainArn),
        IndexName: cdk.stringToCloudFormation(properties.indexName),
        IndexRotationPeriod: cdk.stringToCloudFormation(properties.indexRotationPeriod),
        ProcessingConfiguration: cfnDeliveryStreamProcessingConfigurationPropertyToCloudFormation(properties.processingConfiguration),
        RetryOptions: cfnDeliveryStreamElasticsearchRetryOptionsPropertyToCloudFormation(properties.retryOptions),
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
        S3BackupMode: cdk.stringToCloudFormation(properties.s3BackupMode),
        S3Configuration: cfnDeliveryStreamS3DestinationConfigurationPropertyToCloudFormation(properties.s3Configuration),
        TypeName: cdk.stringToCloudFormation(properties.typeName),
        VpcConfiguration: cfnDeliveryStreamVpcConfigurationPropertyToCloudFormation(properties.vpcConfiguration),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamElasticsearchDestinationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        bufferingHints: properties.BufferingHints == null ? undefined : CfnDeliveryStreamElasticsearchBufferingHintsPropertyFromCloudFormation(properties.BufferingHints),
        cloudWatchLoggingOptions: properties.CloudWatchLoggingOptions == null ? undefined : CfnDeliveryStreamCloudWatchLoggingOptionsPropertyFromCloudFormation(properties.CloudWatchLoggingOptions),
        clusterEndpoint: properties.ClusterEndpoint == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ClusterEndpoint),
        domainArn: properties.DomainARN == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DomainARN),
        indexName: cfn_parse.FromCloudFormation.getString(properties.IndexName),
        indexRotationPeriod: properties.IndexRotationPeriod == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.IndexRotationPeriod),
        processingConfiguration: properties.ProcessingConfiguration == null ? undefined : CfnDeliveryStreamProcessingConfigurationPropertyFromCloudFormation(properties.ProcessingConfiguration),
        retryOptions: properties.RetryOptions == null ? undefined : CfnDeliveryStreamElasticsearchRetryOptionsPropertyFromCloudFormation(properties.RetryOptions),
        roleArn: cfn_parse.FromCloudFormation.getString(properties.RoleARN),
        s3BackupMode: properties.S3BackupMode == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.S3BackupMode),
        s3Configuration: CfnDeliveryStreamS3DestinationConfigurationPropertyFromCloudFormation(properties.S3Configuration),
        typeName: properties.TypeName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.TypeName),
        vpcConfiguration: properties.VpcConfiguration == null ? undefined : CfnDeliveryStreamVpcConfigurationPropertyFromCloudFormation(properties.VpcConfiguration),
    };
}
/**
 * Determine whether the given properties match those of a `ElasticsearchRetryOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `ElasticsearchRetryOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_ElasticsearchRetryOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('durationInSeconds', cdk.validateNumber)(properties.durationInSeconds));
    return errors.wrap('supplied properties not correct for "ElasticsearchRetryOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ElasticsearchRetryOptions` resource
 *
 * @param properties - the TypeScript properties of a `ElasticsearchRetryOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ElasticsearchRetryOptions` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamElasticsearchRetryOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_ElasticsearchRetryOptionsPropertyValidator(properties).assertSuccess();
    return {
        DurationInSeconds: cdk.numberToCloudFormation(properties.durationInSeconds),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamElasticsearchRetryOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        durationInSeconds: properties.DurationInSeconds == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.DurationInSeconds),
    };
}
/**
 * Determine whether the given properties match those of a `EncryptionConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `EncryptionConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_EncryptionConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('kmsEncryptionConfig', CfnDeliveryStream_KMSEncryptionConfigPropertyValidator)(properties.kmsEncryptionConfig));
    errors.collect(cdk.propertyValidator('noEncryptionConfig', cdk.validateString)(properties.noEncryptionConfig));
    return errors.wrap('supplied properties not correct for "EncryptionConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.EncryptionConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `EncryptionConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.EncryptionConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamEncryptionConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_EncryptionConfigurationPropertyValidator(properties).assertSuccess();
    return {
        KMSEncryptionConfig: cfnDeliveryStreamKMSEncryptionConfigPropertyToCloudFormation(properties.kmsEncryptionConfig),
        NoEncryptionConfig: cdk.stringToCloudFormation(properties.noEncryptionConfig),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamEncryptionConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        kmsEncryptionConfig: properties.KMSEncryptionConfig == null ? undefined : CfnDeliveryStreamKMSEncryptionConfigPropertyFromCloudFormation(properties.KMSEncryptionConfig),
        noEncryptionConfig: properties.NoEncryptionConfig == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.NoEncryptionConfig),
    };
}
/**
 * Determine whether the given properties match those of a `ExtendedS3DestinationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ExtendedS3DestinationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_ExtendedS3DestinationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('bucketArn', cdk.requiredValidator)(properties.bucketArn));
    errors.collect(cdk.propertyValidator('bucketArn', cdk.validateString)(properties.bucketArn));
    errors.collect(cdk.propertyValidator('bufferingHints', CfnDeliveryStream_BufferingHintsPropertyValidator)(properties.bufferingHints));
    errors.collect(cdk.propertyValidator('cloudWatchLoggingOptions', CfnDeliveryStream_CloudWatchLoggingOptionsPropertyValidator)(properties.cloudWatchLoggingOptions));
    errors.collect(cdk.propertyValidator('compressionFormat', cdk.validateString)(properties.compressionFormat));
    errors.collect(cdk.propertyValidator('dataFormatConversionConfiguration', CfnDeliveryStream_DataFormatConversionConfigurationPropertyValidator)(properties.dataFormatConversionConfiguration));
    errors.collect(cdk.propertyValidator('encryptionConfiguration', CfnDeliveryStream_EncryptionConfigurationPropertyValidator)(properties.encryptionConfiguration));
    errors.collect(cdk.propertyValidator('errorOutputPrefix', cdk.validateString)(properties.errorOutputPrefix));
    errors.collect(cdk.propertyValidator('prefix', cdk.validateString)(properties.prefix));
    errors.collect(cdk.propertyValidator('processingConfiguration', CfnDeliveryStream_ProcessingConfigurationPropertyValidator)(properties.processingConfiguration));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('s3BackupConfiguration', CfnDeliveryStream_S3DestinationConfigurationPropertyValidator)(properties.s3BackupConfiguration));
    errors.collect(cdk.propertyValidator('s3BackupMode', cdk.validateString)(properties.s3BackupMode));
    return errors.wrap('supplied properties not correct for "ExtendedS3DestinationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ExtendedS3DestinationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ExtendedS3DestinationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ExtendedS3DestinationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamExtendedS3DestinationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_ExtendedS3DestinationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        BucketARN: cdk.stringToCloudFormation(properties.bucketArn),
        BufferingHints: cfnDeliveryStreamBufferingHintsPropertyToCloudFormation(properties.bufferingHints),
        CloudWatchLoggingOptions: cfnDeliveryStreamCloudWatchLoggingOptionsPropertyToCloudFormation(properties.cloudWatchLoggingOptions),
        CompressionFormat: cdk.stringToCloudFormation(properties.compressionFormat),
        DataFormatConversionConfiguration: cfnDeliveryStreamDataFormatConversionConfigurationPropertyToCloudFormation(properties.dataFormatConversionConfiguration),
        EncryptionConfiguration: cfnDeliveryStreamEncryptionConfigurationPropertyToCloudFormation(properties.encryptionConfiguration),
        ErrorOutputPrefix: cdk.stringToCloudFormation(properties.errorOutputPrefix),
        Prefix: cdk.stringToCloudFormation(properties.prefix),
        ProcessingConfiguration: cfnDeliveryStreamProcessingConfigurationPropertyToCloudFormation(properties.processingConfiguration),
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
        S3BackupConfiguration: cfnDeliveryStreamS3DestinationConfigurationPropertyToCloudFormation(properties.s3BackupConfiguration),
        S3BackupMode: cdk.stringToCloudFormation(properties.s3BackupMode),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamExtendedS3DestinationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        bucketArn: cfn_parse.FromCloudFormation.getString(properties.BucketARN),
        bufferingHints: properties.BufferingHints == null ? undefined : CfnDeliveryStreamBufferingHintsPropertyFromCloudFormation(properties.BufferingHints),
        cloudWatchLoggingOptions: properties.CloudWatchLoggingOptions == null ? undefined : CfnDeliveryStreamCloudWatchLoggingOptionsPropertyFromCloudFormation(properties.CloudWatchLoggingOptions),
        compressionFormat: properties.CompressionFormat == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.CompressionFormat),
        dataFormatConversionConfiguration: properties.DataFormatConversionConfiguration == null ? undefined : CfnDeliveryStreamDataFormatConversionConfigurationPropertyFromCloudFormation(properties.DataFormatConversionConfiguration),
        encryptionConfiguration: properties.EncryptionConfiguration == null ? undefined : CfnDeliveryStreamEncryptionConfigurationPropertyFromCloudFormation(properties.EncryptionConfiguration),
        errorOutputPrefix: properties.ErrorOutputPrefix == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ErrorOutputPrefix),
        prefix: properties.Prefix == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Prefix),
        processingConfiguration: properties.ProcessingConfiguration == null ? undefined : CfnDeliveryStreamProcessingConfigurationPropertyFromCloudFormation(properties.ProcessingConfiguration),
        roleArn: cfn_parse.FromCloudFormation.getString(properties.RoleARN),
        s3BackupConfiguration: properties.S3BackupConfiguration == null ? undefined : CfnDeliveryStreamS3DestinationConfigurationPropertyFromCloudFormation(properties.S3BackupConfiguration),
        s3BackupMode: properties.S3BackupMode == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.S3BackupMode),
    };
}
/**
 * Determine whether the given properties match those of a `HiveJsonSerDeProperty`
 *
 * @param properties - the TypeScript properties of a `HiveJsonSerDeProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_HiveJsonSerDePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('timestampFormats', cdk.listValidator(cdk.validateString))(properties.timestampFormats));
    return errors.wrap('supplied properties not correct for "HiveJsonSerDeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.HiveJsonSerDe` resource
 *
 * @param properties - the TypeScript properties of a `HiveJsonSerDeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.HiveJsonSerDe` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamHiveJsonSerDePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_HiveJsonSerDePropertyValidator(properties).assertSuccess();
    return {
        TimestampFormats: cdk.listMapper(cdk.stringToCloudFormation)(properties.timestampFormats),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamHiveJsonSerDePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        timestampFormats: cfn_parse.FromCloudFormation.getStringArray(properties.TimestampFormats),
    };
}
/**
 * Determine whether the given properties match those of a `InputFormatConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `InputFormatConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_InputFormatConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('deserializer', CfnDeliveryStream_DeserializerPropertyValidator)(properties.deserializer));
    return errors.wrap('supplied properties not correct for "InputFormatConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.InputFormatConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `InputFormatConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.InputFormatConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamInputFormatConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_InputFormatConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Deserializer: cfnDeliveryStreamDeserializerPropertyToCloudFormation(properties.deserializer),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamInputFormatConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        deserializer: properties.Deserializer == null ? undefined : CfnDeliveryStreamDeserializerPropertyFromCloudFormation(properties.Deserializer),
    };
}
/**
 * Determine whether the given properties match those of a `KMSEncryptionConfigProperty`
 *
 * @param properties - the TypeScript properties of a `KMSEncryptionConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_KMSEncryptionConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('awskmsKeyArn', cdk.requiredValidator)(properties.awskmsKeyArn));
    errors.collect(cdk.propertyValidator('awskmsKeyArn', cdk.validateString)(properties.awskmsKeyArn));
    return errors.wrap('supplied properties not correct for "KMSEncryptionConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.KMSEncryptionConfig` resource
 *
 * @param properties - the TypeScript properties of a `KMSEncryptionConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.KMSEncryptionConfig` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamKMSEncryptionConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_KMSEncryptionConfigPropertyValidator(properties).assertSuccess();
    return {
        AWSKMSKeyARN: cdk.stringToCloudFormation(properties.awskmsKeyArn),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamKMSEncryptionConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        awskmsKeyArn: cfn_parse.FromCloudFormation.getString(properties.AWSKMSKeyARN),
    };
}
/**
 * Determine whether the given properties match those of a `KinesisStreamSourceConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `KinesisStreamSourceConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_KinesisStreamSourceConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('kinesisStreamArn', cdk.requiredValidator)(properties.kinesisStreamArn));
    errors.collect(cdk.propertyValidator('kinesisStreamArn', cdk.validateString)(properties.kinesisStreamArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "KinesisStreamSourceConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.KinesisStreamSourceConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `KinesisStreamSourceConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.KinesisStreamSourceConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamKinesisStreamSourceConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_KinesisStreamSourceConfigurationPropertyValidator(properties).assertSuccess();
    return {
        KinesisStreamARN: cdk.stringToCloudFormation(properties.kinesisStreamArn),
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamKinesisStreamSourceConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        kinesisStreamArn: cfn_parse.FromCloudFormation.getString(properties.KinesisStreamARN),
        roleArn: cfn_parse.FromCloudFormation.getString(properties.RoleARN),
    };
}
/**
 * Determine whether the given properties match those of a `OpenXJsonSerDeProperty`
 *
 * @param properties - the TypeScript properties of a `OpenXJsonSerDeProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_OpenXJsonSerDePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('caseInsensitive', cdk.validateBoolean)(properties.caseInsensitive));
    errors.collect(cdk.propertyValidator('columnToJsonKeyMappings', cdk.hashValidator(cdk.validateString))(properties.columnToJsonKeyMappings));
    errors.collect(cdk.propertyValidator('convertDotsInJsonKeysToUnderscores', cdk.validateBoolean)(properties.convertDotsInJsonKeysToUnderscores));
    return errors.wrap('supplied properties not correct for "OpenXJsonSerDeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.OpenXJsonSerDe` resource
 *
 * @param properties - the TypeScript properties of a `OpenXJsonSerDeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.OpenXJsonSerDe` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamOpenXJsonSerDePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_OpenXJsonSerDePropertyValidator(properties).assertSuccess();
    return {
        CaseInsensitive: cdk.booleanToCloudFormation(properties.caseInsensitive),
        ColumnToJsonKeyMappings: cdk.hashMapper(cdk.stringToCloudFormation)(properties.columnToJsonKeyMappings),
        ConvertDotsInJsonKeysToUnderscores: cdk.booleanToCloudFormation(properties.convertDotsInJsonKeysToUnderscores),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamOpenXJsonSerDePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        caseInsensitive: properties.CaseInsensitive == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.CaseInsensitive),
        columnToJsonKeyMappings: cfn_parse.FromCloudFormation.getMap(properties.ColumnToJsonKeyMappings, (prop1) => cfn_parse.FromCloudFormation.getString(prop1)),
        convertDotsInJsonKeysToUnderscores: properties.ConvertDotsInJsonKeysToUnderscores == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.ConvertDotsInJsonKeysToUnderscores),
    };
}
/**
 * Determine whether the given properties match those of a `OrcSerDeProperty`
 *
 * @param properties - the TypeScript properties of a `OrcSerDeProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_OrcSerDePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('blockSizeBytes', cdk.validateNumber)(properties.blockSizeBytes));
    errors.collect(cdk.propertyValidator('bloomFilterColumns', cdk.listValidator(cdk.validateString))(properties.bloomFilterColumns));
    errors.collect(cdk.propertyValidator('bloomFilterFalsePositiveProbability', cdk.validateNumber)(properties.bloomFilterFalsePositiveProbability));
    errors.collect(cdk.propertyValidator('compression', cdk.validateString)(properties.compression));
    errors.collect(cdk.propertyValidator('dictionaryKeyThreshold', cdk.validateNumber)(properties.dictionaryKeyThreshold));
    errors.collect(cdk.propertyValidator('enablePadding', cdk.validateBoolean)(properties.enablePadding));
    errors.collect(cdk.propertyValidator('formatVersion', cdk.validateString)(properties.formatVersion));
    errors.collect(cdk.propertyValidator('paddingTolerance', cdk.validateNumber)(properties.paddingTolerance));
    errors.collect(cdk.propertyValidator('rowIndexStride', cdk.validateNumber)(properties.rowIndexStride));
    errors.collect(cdk.propertyValidator('stripeSizeBytes', cdk.validateNumber)(properties.stripeSizeBytes));
    return errors.wrap('supplied properties not correct for "OrcSerDeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.OrcSerDe` resource
 *
 * @param properties - the TypeScript properties of a `OrcSerDeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.OrcSerDe` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamOrcSerDePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_OrcSerDePropertyValidator(properties).assertSuccess();
    return {
        BlockSizeBytes: cdk.numberToCloudFormation(properties.blockSizeBytes),
        BloomFilterColumns: cdk.listMapper(cdk.stringToCloudFormation)(properties.bloomFilterColumns),
        BloomFilterFalsePositiveProbability: cdk.numberToCloudFormation(properties.bloomFilterFalsePositiveProbability),
        Compression: cdk.stringToCloudFormation(properties.compression),
        DictionaryKeyThreshold: cdk.numberToCloudFormation(properties.dictionaryKeyThreshold),
        EnablePadding: cdk.booleanToCloudFormation(properties.enablePadding),
        FormatVersion: cdk.stringToCloudFormation(properties.formatVersion),
        PaddingTolerance: cdk.numberToCloudFormation(properties.paddingTolerance),
        RowIndexStride: cdk.numberToCloudFormation(properties.rowIndexStride),
        StripeSizeBytes: cdk.numberToCloudFormation(properties.stripeSizeBytes),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamOrcSerDePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        blockSizeBytes: properties.BlockSizeBytes == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.BlockSizeBytes),
        bloomFilterColumns: cfn_parse.FromCloudFormation.getStringArray(properties.BloomFilterColumns),
        bloomFilterFalsePositiveProbability: properties.BloomFilterFalsePositiveProbability == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.BloomFilterFalsePositiveProbability),
        compression: properties.Compression == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Compression),
        dictionaryKeyThreshold: properties.DictionaryKeyThreshold == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.DictionaryKeyThreshold),
        enablePadding: properties.EnablePadding == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.EnablePadding),
        formatVersion: properties.FormatVersion == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.FormatVersion),
        paddingTolerance: properties.PaddingTolerance == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.PaddingTolerance),
        rowIndexStride: properties.RowIndexStride == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.RowIndexStride),
        stripeSizeBytes: properties.StripeSizeBytes == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.StripeSizeBytes),
    };
}
/**
 * Determine whether the given properties match those of a `OutputFormatConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `OutputFormatConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_OutputFormatConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('serializer', CfnDeliveryStream_SerializerPropertyValidator)(properties.serializer));
    return errors.wrap('supplied properties not correct for "OutputFormatConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.OutputFormatConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `OutputFormatConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.OutputFormatConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamOutputFormatConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_OutputFormatConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Serializer: cfnDeliveryStreamSerializerPropertyToCloudFormation(properties.serializer),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamOutputFormatConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        serializer: properties.Serializer == null ? undefined : CfnDeliveryStreamSerializerPropertyFromCloudFormation(properties.Serializer),
    };
}
/**
 * Determine whether the given properties match those of a `ParquetSerDeProperty`
 *
 * @param properties - the TypeScript properties of a `ParquetSerDeProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_ParquetSerDePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('blockSizeBytes', cdk.validateNumber)(properties.blockSizeBytes));
    errors.collect(cdk.propertyValidator('compression', cdk.validateString)(properties.compression));
    errors.collect(cdk.propertyValidator('enableDictionaryCompression', cdk.validateBoolean)(properties.enableDictionaryCompression));
    errors.collect(cdk.propertyValidator('maxPaddingBytes', cdk.validateNumber)(properties.maxPaddingBytes));
    errors.collect(cdk.propertyValidator('pageSizeBytes', cdk.validateNumber)(properties.pageSizeBytes));
    errors.collect(cdk.propertyValidator('writerVersion', cdk.validateString)(properties.writerVersion));
    return errors.wrap('supplied properties not correct for "ParquetSerDeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ParquetSerDe` resource
 *
 * @param properties - the TypeScript properties of a `ParquetSerDeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ParquetSerDe` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamParquetSerDePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_ParquetSerDePropertyValidator(properties).assertSuccess();
    return {
        BlockSizeBytes: cdk.numberToCloudFormation(properties.blockSizeBytes),
        Compression: cdk.stringToCloudFormation(properties.compression),
        EnableDictionaryCompression: cdk.booleanToCloudFormation(properties.enableDictionaryCompression),
        MaxPaddingBytes: cdk.numberToCloudFormation(properties.maxPaddingBytes),
        PageSizeBytes: cdk.numberToCloudFormation(properties.pageSizeBytes),
        WriterVersion: cdk.stringToCloudFormation(properties.writerVersion),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamParquetSerDePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        blockSizeBytes: properties.BlockSizeBytes == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.BlockSizeBytes),
        compression: properties.Compression == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Compression),
        enableDictionaryCompression: properties.EnableDictionaryCompression == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.EnableDictionaryCompression),
        maxPaddingBytes: properties.MaxPaddingBytes == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.MaxPaddingBytes),
        pageSizeBytes: properties.PageSizeBytes == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.PageSizeBytes),
        writerVersion: properties.WriterVersion == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.WriterVersion),
    };
}
/**
 * Determine whether the given properties match those of a `ProcessingConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ProcessingConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_ProcessingConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('processors', cdk.listValidator(CfnDeliveryStream_ProcessorPropertyValidator))(properties.processors));
    return errors.wrap('supplied properties not correct for "ProcessingConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ProcessingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ProcessingConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ProcessingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamProcessingConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_ProcessingConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        Processors: cdk.listMapper(cfnDeliveryStreamProcessorPropertyToCloudFormation)(properties.processors),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamProcessingConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        enabled: properties.Enabled == null ? undefined : cfn_parse.FromCloudFormation.getBoolean(properties.Enabled),
        processors: cfn_parse.FromCloudFormation.getArray(properties.Processors, (prop1) => CfnDeliveryStreamProcessorPropertyFromCloudFormation(prop1)),
    };
}
/**
 * Determine whether the given properties match those of a `ProcessorProperty`
 *
 * @param properties - the TypeScript properties of a `ProcessorProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_ProcessorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('parameters', cdk.listValidator(CfnDeliveryStream_ProcessorParameterPropertyValidator))(properties.parameters));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "ProcessorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.Processor` resource
 *
 * @param properties - the TypeScript properties of a `ProcessorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.Processor` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamProcessorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_ProcessorPropertyValidator(properties).assertSuccess();
    return {
        Parameters: cdk.listMapper(cfnDeliveryStreamProcessorParameterPropertyToCloudFormation)(properties.parameters),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamProcessorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        parameters: cfn_parse.FromCloudFormation.getArray(properties.Parameters, (prop1) => CfnDeliveryStreamProcessorParameterPropertyFromCloudFormation(prop1)),
        type: cfn_parse.FromCloudFormation.getString(properties.Type),
    };
}
/**
 * Determine whether the given properties match those of a `ProcessorParameterProperty`
 *
 * @param properties - the TypeScript properties of a `ProcessorParameterProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_ProcessorParameterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('parameterName', cdk.requiredValidator)(properties.parameterName));
    errors.collect(cdk.propertyValidator('parameterName', cdk.validateString)(properties.parameterName));
    errors.collect(cdk.propertyValidator('parameterValue', cdk.requiredValidator)(properties.parameterValue));
    errors.collect(cdk.propertyValidator('parameterValue', cdk.validateString)(properties.parameterValue));
    return errors.wrap('supplied properties not correct for "ProcessorParameterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ProcessorParameter` resource
 *
 * @param properties - the TypeScript properties of a `ProcessorParameterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.ProcessorParameter` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamProcessorParameterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_ProcessorParameterPropertyValidator(properties).assertSuccess();
    return {
        ParameterName: cdk.stringToCloudFormation(properties.parameterName),
        ParameterValue: cdk.stringToCloudFormation(properties.parameterValue),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamProcessorParameterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        parameterName: cfn_parse.FromCloudFormation.getString(properties.ParameterName),
        parameterValue: cfn_parse.FromCloudFormation.getString(properties.ParameterValue),
    };
}
/**
 * Determine whether the given properties match those of a `RedshiftDestinationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `RedshiftDestinationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_RedshiftDestinationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('cloudWatchLoggingOptions', CfnDeliveryStream_CloudWatchLoggingOptionsPropertyValidator)(properties.cloudWatchLoggingOptions));
    errors.collect(cdk.propertyValidator('clusterJdbcurl', cdk.requiredValidator)(properties.clusterJdbcurl));
    errors.collect(cdk.propertyValidator('clusterJdbcurl', cdk.validateString)(properties.clusterJdbcurl));
    errors.collect(cdk.propertyValidator('copyCommand', cdk.requiredValidator)(properties.copyCommand));
    errors.collect(cdk.propertyValidator('copyCommand', CfnDeliveryStream_CopyCommandPropertyValidator)(properties.copyCommand));
    errors.collect(cdk.propertyValidator('password', cdk.requiredValidator)(properties.password));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('processingConfiguration', CfnDeliveryStream_ProcessingConfigurationPropertyValidator)(properties.processingConfiguration));
    errors.collect(cdk.propertyValidator('retryOptions', CfnDeliveryStream_RedshiftRetryOptionsPropertyValidator)(properties.retryOptions));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('s3BackupConfiguration', CfnDeliveryStream_S3DestinationConfigurationPropertyValidator)(properties.s3BackupConfiguration));
    errors.collect(cdk.propertyValidator('s3BackupMode', cdk.validateString)(properties.s3BackupMode));
    errors.collect(cdk.propertyValidator('s3Configuration', cdk.requiredValidator)(properties.s3Configuration));
    errors.collect(cdk.propertyValidator('s3Configuration', CfnDeliveryStream_S3DestinationConfigurationPropertyValidator)(properties.s3Configuration));
    errors.collect(cdk.propertyValidator('username', cdk.requiredValidator)(properties.username));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    return errors.wrap('supplied properties not correct for "RedshiftDestinationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.RedshiftDestinationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `RedshiftDestinationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.RedshiftDestinationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamRedshiftDestinationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_RedshiftDestinationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CloudWatchLoggingOptions: cfnDeliveryStreamCloudWatchLoggingOptionsPropertyToCloudFormation(properties.cloudWatchLoggingOptions),
        ClusterJDBCURL: cdk.stringToCloudFormation(properties.clusterJdbcurl),
        CopyCommand: cfnDeliveryStreamCopyCommandPropertyToCloudFormation(properties.copyCommand),
        Password: cdk.stringToCloudFormation(properties.password),
        ProcessingConfiguration: cfnDeliveryStreamProcessingConfigurationPropertyToCloudFormation(properties.processingConfiguration),
        RetryOptions: cfnDeliveryStreamRedshiftRetryOptionsPropertyToCloudFormation(properties.retryOptions),
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
        S3BackupConfiguration: cfnDeliveryStreamS3DestinationConfigurationPropertyToCloudFormation(properties.s3BackupConfiguration),
        S3BackupMode: cdk.stringToCloudFormation(properties.s3BackupMode),
        S3Configuration: cfnDeliveryStreamS3DestinationConfigurationPropertyToCloudFormation(properties.s3Configuration),
        Username: cdk.stringToCloudFormation(properties.username),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamRedshiftDestinationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        cloudWatchLoggingOptions: properties.CloudWatchLoggingOptions == null ? undefined : CfnDeliveryStreamCloudWatchLoggingOptionsPropertyFromCloudFormation(properties.CloudWatchLoggingOptions),
        clusterJdbcurl: cfn_parse.FromCloudFormation.getString(properties.ClusterJDBCURL),
        copyCommand: CfnDeliveryStreamCopyCommandPropertyFromCloudFormation(properties.CopyCommand),
        password: cfn_parse.FromCloudFormation.getString(properties.Password),
        processingConfiguration: properties.ProcessingConfiguration == null ? undefined : CfnDeliveryStreamProcessingConfigurationPropertyFromCloudFormation(properties.ProcessingConfiguration),
        retryOptions: properties.RetryOptions == null ? undefined : CfnDeliveryStreamRedshiftRetryOptionsPropertyFromCloudFormation(properties.RetryOptions),
        roleArn: cfn_parse.FromCloudFormation.getString(properties.RoleARN),
        s3BackupConfiguration: properties.S3BackupConfiguration == null ? undefined : CfnDeliveryStreamS3DestinationConfigurationPropertyFromCloudFormation(properties.S3BackupConfiguration),
        s3BackupMode: properties.S3BackupMode == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.S3BackupMode),
        s3Configuration: CfnDeliveryStreamS3DestinationConfigurationPropertyFromCloudFormation(properties.S3Configuration),
        username: cfn_parse.FromCloudFormation.getString(properties.Username),
    };
}
/**
 * Determine whether the given properties match those of a `RedshiftRetryOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `RedshiftRetryOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_RedshiftRetryOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('durationInSeconds', cdk.validateNumber)(properties.durationInSeconds));
    return errors.wrap('supplied properties not correct for "RedshiftRetryOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.RedshiftRetryOptions` resource
 *
 * @param properties - the TypeScript properties of a `RedshiftRetryOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.RedshiftRetryOptions` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamRedshiftRetryOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_RedshiftRetryOptionsPropertyValidator(properties).assertSuccess();
    return {
        DurationInSeconds: cdk.numberToCloudFormation(properties.durationInSeconds),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamRedshiftRetryOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        durationInSeconds: properties.DurationInSeconds == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.DurationInSeconds),
    };
}
/**
 * Determine whether the given properties match those of a `S3DestinationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `S3DestinationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_S3DestinationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('bucketArn', cdk.requiredValidator)(properties.bucketArn));
    errors.collect(cdk.propertyValidator('bucketArn', cdk.validateString)(properties.bucketArn));
    errors.collect(cdk.propertyValidator('bufferingHints', CfnDeliveryStream_BufferingHintsPropertyValidator)(properties.bufferingHints));
    errors.collect(cdk.propertyValidator('cloudWatchLoggingOptions', CfnDeliveryStream_CloudWatchLoggingOptionsPropertyValidator)(properties.cloudWatchLoggingOptions));
    errors.collect(cdk.propertyValidator('compressionFormat', cdk.validateString)(properties.compressionFormat));
    errors.collect(cdk.propertyValidator('encryptionConfiguration', CfnDeliveryStream_EncryptionConfigurationPropertyValidator)(properties.encryptionConfiguration));
    errors.collect(cdk.propertyValidator('errorOutputPrefix', cdk.validateString)(properties.errorOutputPrefix));
    errors.collect(cdk.propertyValidator('prefix', cdk.validateString)(properties.prefix));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    return errors.wrap('supplied properties not correct for "S3DestinationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `S3DestinationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamS3DestinationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_S3DestinationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        BucketARN: cdk.stringToCloudFormation(properties.bucketArn),
        BufferingHints: cfnDeliveryStreamBufferingHintsPropertyToCloudFormation(properties.bufferingHints),
        CloudWatchLoggingOptions: cfnDeliveryStreamCloudWatchLoggingOptionsPropertyToCloudFormation(properties.cloudWatchLoggingOptions),
        CompressionFormat: cdk.stringToCloudFormation(properties.compressionFormat),
        EncryptionConfiguration: cfnDeliveryStreamEncryptionConfigurationPropertyToCloudFormation(properties.encryptionConfiguration),
        ErrorOutputPrefix: cdk.stringToCloudFormation(properties.errorOutputPrefix),
        Prefix: cdk.stringToCloudFormation(properties.prefix),
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamS3DestinationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        bucketArn: cfn_parse.FromCloudFormation.getString(properties.BucketARN),
        bufferingHints: properties.BufferingHints == null ? undefined : CfnDeliveryStreamBufferingHintsPropertyFromCloudFormation(properties.BufferingHints),
        cloudWatchLoggingOptions: properties.CloudWatchLoggingOptions == null ? undefined : CfnDeliveryStreamCloudWatchLoggingOptionsPropertyFromCloudFormation(properties.CloudWatchLoggingOptions),
        compressionFormat: properties.CompressionFormat == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.CompressionFormat),
        encryptionConfiguration: properties.EncryptionConfiguration == null ? undefined : CfnDeliveryStreamEncryptionConfigurationPropertyFromCloudFormation(properties.EncryptionConfiguration),
        errorOutputPrefix: properties.ErrorOutputPrefix == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.ErrorOutputPrefix),
        prefix: properties.Prefix == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Prefix),
        roleArn: cfn_parse.FromCloudFormation.getString(properties.RoleARN),
    };
}
/**
 * Determine whether the given properties match those of a `SchemaConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `SchemaConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_SchemaConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('catalogId', cdk.validateString)(properties.catalogId));
    errors.collect(cdk.propertyValidator('databaseName', cdk.validateString)(properties.databaseName));
    errors.collect(cdk.propertyValidator('region', cdk.validateString)(properties.region));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('tableName', cdk.validateString)(properties.tableName));
    errors.collect(cdk.propertyValidator('versionId', cdk.validateString)(properties.versionId));
    return errors.wrap('supplied properties not correct for "SchemaConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.SchemaConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `SchemaConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.SchemaConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamSchemaConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_SchemaConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CatalogId: cdk.stringToCloudFormation(properties.catalogId),
        DatabaseName: cdk.stringToCloudFormation(properties.databaseName),
        Region: cdk.stringToCloudFormation(properties.region),
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
        TableName: cdk.stringToCloudFormation(properties.tableName),
        VersionId: cdk.stringToCloudFormation(properties.versionId),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamSchemaConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        catalogId: properties.CatalogId == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.CatalogId),
        databaseName: properties.DatabaseName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.DatabaseName),
        region: properties.Region == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.Region),
        roleArn: properties.RoleARN == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.RoleARN),
        tableName: properties.TableName == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.TableName),
        versionId: properties.VersionId == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.VersionId),
    };
}
/**
 * Determine whether the given properties match those of a `SerializerProperty`
 *
 * @param properties - the TypeScript properties of a `SerializerProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_SerializerPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('orcSerDe', CfnDeliveryStream_OrcSerDePropertyValidator)(properties.orcSerDe));
    errors.collect(cdk.propertyValidator('parquetSerDe', CfnDeliveryStream_ParquetSerDePropertyValidator)(properties.parquetSerDe));
    return errors.wrap('supplied properties not correct for "SerializerProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.Serializer` resource
 *
 * @param properties - the TypeScript properties of a `SerializerProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.Serializer` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamSerializerPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_SerializerPropertyValidator(properties).assertSuccess();
    return {
        OrcSerDe: cfnDeliveryStreamOrcSerDePropertyToCloudFormation(properties.orcSerDe),
        ParquetSerDe: cfnDeliveryStreamParquetSerDePropertyToCloudFormation(properties.parquetSerDe),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamSerializerPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        orcSerDe: properties.OrcSerDe == null ? undefined : CfnDeliveryStreamOrcSerDePropertyFromCloudFormation(properties.OrcSerDe),
        parquetSerDe: properties.ParquetSerDe == null ? undefined : CfnDeliveryStreamParquetSerDePropertyFromCloudFormation(properties.ParquetSerDe),
    };
}
/**
 * Determine whether the given properties match those of a `SplunkDestinationConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `SplunkDestinationConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_SplunkDestinationConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('cloudWatchLoggingOptions', CfnDeliveryStream_CloudWatchLoggingOptionsPropertyValidator)(properties.cloudWatchLoggingOptions));
    errors.collect(cdk.propertyValidator('hecAcknowledgmentTimeoutInSeconds', cdk.validateNumber)(properties.hecAcknowledgmentTimeoutInSeconds));
    errors.collect(cdk.propertyValidator('hecEndpoint', cdk.requiredValidator)(properties.hecEndpoint));
    errors.collect(cdk.propertyValidator('hecEndpoint', cdk.validateString)(properties.hecEndpoint));
    errors.collect(cdk.propertyValidator('hecEndpointType', cdk.requiredValidator)(properties.hecEndpointType));
    errors.collect(cdk.propertyValidator('hecEndpointType', cdk.validateString)(properties.hecEndpointType));
    errors.collect(cdk.propertyValidator('hecToken', cdk.requiredValidator)(properties.hecToken));
    errors.collect(cdk.propertyValidator('hecToken', cdk.validateString)(properties.hecToken));
    errors.collect(cdk.propertyValidator('processingConfiguration', CfnDeliveryStream_ProcessingConfigurationPropertyValidator)(properties.processingConfiguration));
    errors.collect(cdk.propertyValidator('retryOptions', CfnDeliveryStream_SplunkRetryOptionsPropertyValidator)(properties.retryOptions));
    errors.collect(cdk.propertyValidator('s3BackupMode', cdk.validateString)(properties.s3BackupMode));
    errors.collect(cdk.propertyValidator('s3Configuration', cdk.requiredValidator)(properties.s3Configuration));
    errors.collect(cdk.propertyValidator('s3Configuration', CfnDeliveryStream_S3DestinationConfigurationPropertyValidator)(properties.s3Configuration));
    return errors.wrap('supplied properties not correct for "SplunkDestinationConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.SplunkDestinationConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `SplunkDestinationConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.SplunkDestinationConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamSplunkDestinationConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_SplunkDestinationConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CloudWatchLoggingOptions: cfnDeliveryStreamCloudWatchLoggingOptionsPropertyToCloudFormation(properties.cloudWatchLoggingOptions),
        HECAcknowledgmentTimeoutInSeconds: cdk.numberToCloudFormation(properties.hecAcknowledgmentTimeoutInSeconds),
        HECEndpoint: cdk.stringToCloudFormation(properties.hecEndpoint),
        HECEndpointType: cdk.stringToCloudFormation(properties.hecEndpointType),
        HECToken: cdk.stringToCloudFormation(properties.hecToken),
        ProcessingConfiguration: cfnDeliveryStreamProcessingConfigurationPropertyToCloudFormation(properties.processingConfiguration),
        RetryOptions: cfnDeliveryStreamSplunkRetryOptionsPropertyToCloudFormation(properties.retryOptions),
        S3BackupMode: cdk.stringToCloudFormation(properties.s3BackupMode),
        S3Configuration: cfnDeliveryStreamS3DestinationConfigurationPropertyToCloudFormation(properties.s3Configuration),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamSplunkDestinationConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        cloudWatchLoggingOptions: properties.CloudWatchLoggingOptions == null ? undefined : CfnDeliveryStreamCloudWatchLoggingOptionsPropertyFromCloudFormation(properties.CloudWatchLoggingOptions),
        hecAcknowledgmentTimeoutInSeconds: properties.HECAcknowledgmentTimeoutInSeconds == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.HECAcknowledgmentTimeoutInSeconds),
        hecEndpoint: cfn_parse.FromCloudFormation.getString(properties.HECEndpoint),
        hecEndpointType: cfn_parse.FromCloudFormation.getString(properties.HECEndpointType),
        hecToken: cfn_parse.FromCloudFormation.getString(properties.HECToken),
        processingConfiguration: properties.ProcessingConfiguration == null ? undefined : CfnDeliveryStreamProcessingConfigurationPropertyFromCloudFormation(properties.ProcessingConfiguration),
        retryOptions: properties.RetryOptions == null ? undefined : CfnDeliveryStreamSplunkRetryOptionsPropertyFromCloudFormation(properties.RetryOptions),
        s3BackupMode: properties.S3BackupMode == null ? undefined : cfn_parse.FromCloudFormation.getString(properties.S3BackupMode),
        s3Configuration: CfnDeliveryStreamS3DestinationConfigurationPropertyFromCloudFormation(properties.S3Configuration),
    };
}
/**
 * Determine whether the given properties match those of a `SplunkRetryOptionsProperty`
 *
 * @param properties - the TypeScript properties of a `SplunkRetryOptionsProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_SplunkRetryOptionsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('durationInSeconds', cdk.validateNumber)(properties.durationInSeconds));
    return errors.wrap('supplied properties not correct for "SplunkRetryOptionsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.SplunkRetryOptions` resource
 *
 * @param properties - the TypeScript properties of a `SplunkRetryOptionsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.SplunkRetryOptions` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamSplunkRetryOptionsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_SplunkRetryOptionsPropertyValidator(properties).assertSuccess();
    return {
        DurationInSeconds: cdk.numberToCloudFormation(properties.durationInSeconds),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamSplunkRetryOptionsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        durationInSeconds: properties.DurationInSeconds == null ? undefined : cfn_parse.FromCloudFormation.getNumber(properties.DurationInSeconds),
    };
}
/**
 * Determine whether the given properties match those of a `VpcConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `VpcConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnDeliveryStream_VpcConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.requiredValidator)(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.requiredValidator)(properties.subnetIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    return errors.wrap('supplied properties not correct for "VpcConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.VpcConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `VpcConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KinesisFirehose::DeliveryStream.VpcConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnDeliveryStreamVpcConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnDeliveryStream_VpcConfigurationPropertyValidator(properties).assertSuccess();
    return {
        RoleARN: cdk.stringToCloudFormation(properties.roleArn),
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
    };
}
// @ts-ignore TS6133
function CfnDeliveryStreamVpcConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        roleArn: cfn_parse.FromCloudFormation.getString(properties.RoleARN),
        securityGroupIds: cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds),
        subnetIds: cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds),
    };
}
//# sourceMappingURL=data:application/json;base64,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