import * as assets from "../../assets";
import * as ecr from "../../aws-ecr";
import { Construct } from "../../core";
/**
 * Options for DockerImageAsset
 */
export interface DockerImageAssetOptions extends assets.FingerprintOptions {
    /**
     * ECR repository name
     *
     * Specify this property if you need to statically address the image, e.g.
     * from a Kubernetes Pod. Note, this is only the repository name, without the
     * registry and the tag parts.
     *
     * @default - the default ECR repository for CDK assets
     * @deprecated to control the location of docker image assets, please override
     * `Stack.addDockerImageAsset`. this feature will be removed in future
     * releases.
     */
    readonly repositoryName?: string;
    /**
     * Build args to pass to the `docker build` command.
     *
     * Since Docker build arguments are resolved before deployment, keys and
     * values cannot refer to unresolved tokens (such as `lambda.functionArn` or
     * `queue.queueUrl`).
     *
     * @default - no build args are passed
     */
    readonly buildArgs?: {
        [key: string]: string;
    };
    /**
     * Docker target to build to
     *
     * @default - no target
     */
    readonly target?: string;
    /**
     * Path to the Dockerfile (relative to the directory).
     *
     * @default 'Dockerfile'
     */
    readonly file?: string;
}
/**
 * Props for DockerImageAssets
 */
export interface DockerImageAssetProps extends DockerImageAssetOptions {
    /**
     * The directory where the Dockerfile is stored
     */
    readonly directory: string;
}
/**
 * An asset that represents a Docker image.
 *
 * The image will be created in build time and uploaded to an ECR repository.
 */
export declare class DockerImageAsset extends Construct implements assets.IAsset {
    /**
     * The full URI of the image (including a tag). Use this reference to pull
     * the asset.
     */
    imageUri: string;
    /**
     * Repository where the image is stored
     */
    repository: ecr.IRepository;
    readonly sourceHash: string;
    constructor(scope: Construct, id: string, props: DockerImageAssetProps);
}
