"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogQueryWidget = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const widget_1 = require("./widget");
/**
 * Display query results from Logs Insights
 */
class LogQueryWidget extends widget_1.ConcreteWidget {
    constructor(props) {
        super(props.width || 6, props.height || 6);
        this.props = props;
        if (props.logGroupNames.length === 0) {
            throw new Error('Specify at least one log group name.');
        }
        if (!!props.queryString === !!props.queryLines) {
            throw new Error('Specify exactly one of \'queryString\' and \'queryLines\'');
        }
    }
    toJson() {
        const sources = this.props.logGroupNames.map(l => `SOURCE '${l}'`).join(' | ');
        const query = this.props.queryLines
            ? this.props.queryLines.join('\n| ')
            : this.props.queryString;
        return [{
                type: 'log',
                width: this.width,
                height: this.height,
                x: this.x,
                y: this.y,
                properties: {
                    view: 'table',
                    title: this.props.title,
                    region: this.props.region || cdk.Aws.REGION,
                    query: `${sources} | ${query}`,
                },
            }];
    }
}
exports.LogQueryWidget = LogQueryWidget;
//# sourceMappingURL=data:application/json;base64,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