"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CacheBehavior = void 0;
const distribution_1 = require("../distribution");
/**
 * Allows configuring a variety of CloudFront functionality for a given URL path pattern.
 *
 * Note: This really should simply by called 'Behavior', but this name is already taken by the legacy
 * CloudFrontWebDistribution implementation.
 */
class CacheBehavior {
    constructor(props) {
        this.props = props;
        this.origin = props.origin;
    }
    /**
     * Creates and returns the CloudFormation representation of this behavior.
     * This renders as a "CacheBehaviorProperty" regardless of if this is a default
     * cache behavior or not, as the two are identical except that the pathPattern
     * is omitted for the default cache behavior.
     *
     * @internal
     */
    _renderBehavior() {
        var _a, _b, _c;
        return {
            pathPattern: this.props.pathPattern,
            targetOriginId: this.origin.id,
            allowedMethods: (_b = (_a = this.props.allowedMethods) === null || _a === void 0 ? void 0 : _a.methods) !== null && _b !== void 0 ? _b : undefined,
            forwardedValues: {
                queryString: (_c = this.props.forwardQueryString) !== null && _c !== void 0 ? _c : false,
                queryStringCacheKeys: this.props.forwardQueryStringCacheKeys,
            },
            viewerProtocolPolicy: distribution_1.ViewerProtocolPolicy.ALLOW_ALL,
        };
    }
}
exports.CacheBehavior = CacheBehavior;
//# sourceMappingURL=data:application/json;base64,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