# PLFA Tools Aggregator

## Purpose

The MIDI Inc. Sherlock PLFA Analysis Software has a paid add-on package called PLFA Tools. The software takes as input GC results of PLFA (and NLFA) samples and assigns peaks to categories (General FAME, Gram Negative, etc.). The software creates a new Excel Worksheet for each sample, possibly resulting in hundreds of worksheets of various formats. The purpose of this package is to automate the aggregation of the data into a single CSV file for analysis.

## License

As a work of the United States government, this project is in the public domain within the United States.

Additionally, we waive copyright and related rights in the work worldwide through the CC0 1.0 Universal public domain dedication.

## Installation information

Can be installed using pip:

```pip install plfatools```

Must be using Python 3 or later to use this package.

## Using this package

### From command line

PlfaTools can be used via the command line by running the main file within the aggregator package. It takes two arguments: 1) a full path to the directory containing the files to be aggregated and 2) a full path to the directory where you want the final.csv file to be written.

Example:

```cmd
> python -m plfatools "C:\Files\Experiment1\PlfaOutput" "C:\Files\Experiment1\Output"
```

Where:

* ```"C:\Files\Experiment1\PlfaOutput"``` is the directory with xlsx files to be aggregated
* ```"C:\Files\Experiment1\Output"``` is the directory where "final.csv" file containing aggregated data is written

### From Python

PlfaTools can also be imported as a module: ```import plfatools```

The ```Aggregator``` Class contains four functions, listed below in order of decreasing generality:

* ```read_dir()``` : Reads a directory path that contains multiple files from PLFA Tools and returns a pandas DataFrame with all data from all files and worksheets
* ```read_file()``` : Reads a file from PLFA Tools and returns a pandas DataFrame with all data from all worksheets
* ```transform_stacked_to_tidy()``` : Accepts a Pandas DataFrame generated by "read_dir" or "read_file" and returns a new DataFrame in a tidy format
* ```transform_raw_to_stacked()``` : Reformats output from PLFA Tools, of a single sample, into proper tabular format

**Note**: If there are other .xlsx files in the directory to be aggregated this will cause errors as the main file assumes all the XLSX files in the directory are GC results.

Example:

```python
import pathlib
import plfatools

# create an aggregator object
aggregator = plfatools.Aggregator()

# specify path to directory with PLFA Tools output (Windows paths)
path_to_directory = pathlib.Path('C:\\Files\\Experiment1\\PlfaOutput')

# aggregate and format instrument output and assign it to a Pandas DataFrame
plfa_data = aggregator.read_dir(path_to_directory)

# alternatively, read a single file and assign the formatted output to Pandas DataFrame
path_to_file = path_to_directory / 'gc-output.xlsx'
plfa_data = aggregator.read_file(path_to_file)

```
