"""
Main interface for codeguru-reviewer service type definitions.

Usage::

    from mypy_boto3.codeguru_reviewer.type_defs import RepositoryAssociationTypeDef

    data: RepositoryAssociationTypeDef = {...}
"""
from datetime import datetime
import sys
from typing import List

if sys.version_info >= (3, 8):
    from typing import Literal
else:
    from typing_extensions import Literal
if sys.version_info >= (3, 8):
    from typing import TypedDict
else:
    from typing_extensions import TypedDict


__all__ = (
    "RepositoryAssociationTypeDef",
    "AssociateRepositoryResponseTypeDef",
    "MetricsTypeDef",
    "CommitDiffSourceCodeTypeTypeDef",
    "SourceCodeTypeTypeDef",
    "CodeReviewTypeDef",
    "DescribeCodeReviewResponseTypeDef",
    "RecommendationFeedbackTypeDef",
    "DescribeRecommendationFeedbackResponseTypeDef",
    "DescribeRepositoryAssociationResponseTypeDef",
    "DisassociateRepositoryResponseTypeDef",
    "MetricsSummaryTypeDef",
    "CodeReviewSummaryTypeDef",
    "ListCodeReviewsResponseTypeDef",
    "RecommendationFeedbackSummaryTypeDef",
    "ListRecommendationFeedbackResponseTypeDef",
    "RecommendationSummaryTypeDef",
    "ListRecommendationsResponseTypeDef",
    "RepositoryAssociationSummaryTypeDef",
    "ListRepositoryAssociationsResponseTypeDef",
    "PaginatorConfigTypeDef",
    "CodeCommitRepositoryTypeDef",
    "RepositoryTypeDef",
)

RepositoryAssociationTypeDef = TypedDict(
    "RepositoryAssociationTypeDef",
    {
        "AssociationId": str,
        "AssociationArn": str,
        "Name": str,
        "Owner": str,
        "ProviderType": Literal["CodeCommit", "GitHub"],
        "State": Literal["Associated", "Associating", "Failed", "Disassociating"],
        "StateReason": str,
        "LastUpdatedTimeStamp": datetime,
        "CreatedTimeStamp": datetime,
    },
    total=False,
)

AssociateRepositoryResponseTypeDef = TypedDict(
    "AssociateRepositoryResponseTypeDef",
    {"RepositoryAssociation": RepositoryAssociationTypeDef},
    total=False,
)

MetricsTypeDef = TypedDict(
    "MetricsTypeDef", {"MeteredLinesOfCodeCount": int, "FindingsCount": int}, total=False
)

CommitDiffSourceCodeTypeTypeDef = TypedDict(
    "CommitDiffSourceCodeTypeTypeDef", {"SourceCommit": str, "DestinationCommit": str}, total=False
)

SourceCodeTypeTypeDef = TypedDict(
    "SourceCodeTypeTypeDef", {"CommitDiff": CommitDiffSourceCodeTypeTypeDef}, total=False
)

CodeReviewTypeDef = TypedDict(
    "CodeReviewTypeDef",
    {
        "Name": str,
        "CodeReviewArn": str,
        "RepositoryName": str,
        "Owner": str,
        "ProviderType": Literal["CodeCommit", "GitHub"],
        "State": Literal["Completed", "Pending", "Failed", "Deleting"],
        "StateReason": str,
        "CreatedTimeStamp": datetime,
        "LastUpdatedTimeStamp": datetime,
        "Type": Literal["PullRequest"],
        "PullRequestId": str,
        "SourceCodeType": SourceCodeTypeTypeDef,
        "Metrics": MetricsTypeDef,
    },
    total=False,
)

DescribeCodeReviewResponseTypeDef = TypedDict(
    "DescribeCodeReviewResponseTypeDef", {"CodeReview": CodeReviewTypeDef}, total=False
)

RecommendationFeedbackTypeDef = TypedDict(
    "RecommendationFeedbackTypeDef",
    {
        "CodeReviewArn": str,
        "RecommendationId": str,
        "Reactions": List[Literal["ThumbsUp", "ThumbsDown"]],
        "UserId": str,
        "CreatedTimeStamp": datetime,
        "LastUpdatedTimeStamp": datetime,
    },
    total=False,
)

DescribeRecommendationFeedbackResponseTypeDef = TypedDict(
    "DescribeRecommendationFeedbackResponseTypeDef",
    {"RecommendationFeedback": RecommendationFeedbackTypeDef},
    total=False,
)

DescribeRepositoryAssociationResponseTypeDef = TypedDict(
    "DescribeRepositoryAssociationResponseTypeDef",
    {"RepositoryAssociation": RepositoryAssociationTypeDef},
    total=False,
)

DisassociateRepositoryResponseTypeDef = TypedDict(
    "DisassociateRepositoryResponseTypeDef",
    {"RepositoryAssociation": RepositoryAssociationTypeDef},
    total=False,
)

MetricsSummaryTypeDef = TypedDict(
    "MetricsSummaryTypeDef", {"MeteredLinesOfCodeCount": int, "FindingsCount": int}, total=False
)

CodeReviewSummaryTypeDef = TypedDict(
    "CodeReviewSummaryTypeDef",
    {
        "Name": str,
        "CodeReviewArn": str,
        "RepositoryName": str,
        "Owner": str,
        "ProviderType": Literal["CodeCommit", "GitHub"],
        "State": Literal["Completed", "Pending", "Failed", "Deleting"],
        "CreatedTimeStamp": datetime,
        "LastUpdatedTimeStamp": datetime,
        "Type": Literal["PullRequest"],
        "PullRequestId": str,
        "MetricsSummary": MetricsSummaryTypeDef,
    },
    total=False,
)

ListCodeReviewsResponseTypeDef = TypedDict(
    "ListCodeReviewsResponseTypeDef",
    {"CodeReviewSummaries": List[CodeReviewSummaryTypeDef], "NextToken": str},
    total=False,
)

RecommendationFeedbackSummaryTypeDef = TypedDict(
    "RecommendationFeedbackSummaryTypeDef",
    {"RecommendationId": str, "Reactions": List[Literal["ThumbsUp", "ThumbsDown"]], "UserId": str},
    total=False,
)

ListRecommendationFeedbackResponseTypeDef = TypedDict(
    "ListRecommendationFeedbackResponseTypeDef",
    {
        "RecommendationFeedbackSummaries": List[RecommendationFeedbackSummaryTypeDef],
        "NextToken": str,
    },
    total=False,
)

RecommendationSummaryTypeDef = TypedDict(
    "RecommendationSummaryTypeDef",
    {
        "FilePath": str,
        "RecommendationId": str,
        "StartLine": int,
        "EndLine": int,
        "Description": str,
    },
    total=False,
)

ListRecommendationsResponseTypeDef = TypedDict(
    "ListRecommendationsResponseTypeDef",
    {"RecommendationSummaries": List[RecommendationSummaryTypeDef], "NextToken": str},
    total=False,
)

RepositoryAssociationSummaryTypeDef = TypedDict(
    "RepositoryAssociationSummaryTypeDef",
    {
        "AssociationArn": str,
        "LastUpdatedTimeStamp": datetime,
        "AssociationId": str,
        "Name": str,
        "Owner": str,
        "ProviderType": Literal["CodeCommit", "GitHub"],
        "State": Literal["Associated", "Associating", "Failed", "Disassociating"],
    },
    total=False,
)

ListRepositoryAssociationsResponseTypeDef = TypedDict(
    "ListRepositoryAssociationsResponseTypeDef",
    {"RepositoryAssociationSummaries": List[RepositoryAssociationSummaryTypeDef], "NextToken": str},
    total=False,
)

PaginatorConfigTypeDef = TypedDict(
    "PaginatorConfigTypeDef", {"MaxItems": int, "PageSize": int, "StartingToken": str}, total=False
)

CodeCommitRepositoryTypeDef = TypedDict("CodeCommitRepositoryTypeDef", {"Name": str})

RepositoryTypeDef = TypedDict(
    "RepositoryTypeDef", {"CodeCommit": CodeCommitRepositoryTypeDef}, total=False
)
