# coding: utf-8

"""
    Lumos Connectors

    The Lumos Connector API is a self-describing API which allows third-party systems to easily integrate with Lumos. It provides endpoints to retrieve information about each connector, their capabilities.  # How to use this API? To get started with the Lumos Connector API, you'll 1. want to call the `POST /list-connector-app-ids` endpoint, which gives you a list of available connector app IDs, each ID corresponds to a specific integration. 2. Once you have the relevant connector app ID, use the `POST /{connector-app-id}/info` endpoint to find out what capabilities the integration supports. This will also tell you what input parameters are needed and what output you can expect for each of the API endpoints for a specific integration.  This will be integration specific. By using this info, you can correctly format your requests and handle the responses when managing resources.

    The version of the OpenAPI document: 0.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from connector.generated.models.error_response import ErrorResponse
from connector.generated.models.get_last_activity_response import GetLastActivityResponse
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

GETLASTACTIVITY200RESPONSE_ANY_OF_SCHEMAS = ["ErrorResponse", "GetLastActivityResponse"]

class GetLastActivity200Response(BaseModel):
    """
    GetLastActivity200Response
    """

    # data type: GetLastActivityResponse
    anyof_schema_1_validator: Optional[GetLastActivityResponse] = None
    # data type: ErrorResponse
    anyof_schema_2_validator: Optional[ErrorResponse] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[ErrorResponse, GetLastActivityResponse]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "ErrorResponse", "GetLastActivityResponse" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        instance = GetLastActivity200Response.model_construct()
        error_messages = []
        # validate data type: GetLastActivityResponse
        if not isinstance(v, GetLastActivityResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `GetLastActivityResponse`")
        else:
            return v

        # validate data type: ErrorResponse
        if not isinstance(v, ErrorResponse):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ErrorResponse`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in GetLastActivity200Response with anyOf schemas: ErrorResponse, GetLastActivityResponse. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        # anyof_schema_1_validator: Optional[GetLastActivityResponse] = None
        try:
            instance.actual_instance = GetLastActivityResponse.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[ErrorResponse] = None
        try:
            instance.actual_instance = ErrorResponse.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into GetLastActivity200Response with anyOf schemas: ErrorResponse, GetLastActivityResponse. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ErrorResponse, GetLastActivityResponse]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


