# coding: utf-8

"""
    Lumos Connectors

    The Lumos Connector API is a self-describing API which allows third-party systems to easily integrate with Lumos. It provides endpoints to retrieve information about each connector, their capabilities.  # How to use this API? To get started with the Lumos Connector API, you'll 1. want to call the `POST /list-connector-app-ids` endpoint, which gives you a list of available connector app IDs, each ID corresponds to a specific integration. 2. Once you have the relevant connector app ID, use the `POST /{connector-app-id}/info` endpoint to find out what capabilities the integration supports. This will also tell you what input parameters are needed and what output you can expect for each of the API endpoints for a specific integration.  This will be integration specific. By using this info, you can correctly format your requests and handle the responses when managing resources.

    The version of the OpenAPI document: 0.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from connector.generated.models.found_entitlement_association import FoundEntitlementAssociation
from connector.generated.models.page import Page
from typing import Optional, Set
from typing_extensions import Self

class FindEntitlementAssociationsResponse(BaseModel):
    """
    FindEntitlementAssociationsResponse
    """ # noqa: E501
    response: List[FoundEntitlementAssociation]
    raw_data: Optional[Any] = None
    page: Optional[Page] = None
    __properties: ClassVar[List[str]] = ["response", "raw_data", "page"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FindEntitlementAssociationsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in response (list)
        _items = []
        if self.response:
            for _item in self.response:
                if _item:
                    _items.append(_item.to_dict())
            _dict['response'] = _items
        # override the default output from pydantic by calling `to_dict()` of page
        if self.page:
            _dict['page'] = self.page.to_dict()
        # set to None if raw_data (nullable) is None
        # and model_fields_set contains the field
        if self.raw_data is None and "raw_data" in self.model_fields_set:
            _dict['raw_data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FindEntitlementAssociationsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "response": [FoundEntitlementAssociation.from_dict(_item) for _item in obj["response"]] if obj.get("response") is not None else None,
            "raw_data": obj.get("raw_data"),
            "page": Page.from_dict(obj["page"]) if obj.get("page") is not None else None
        })
        return _obj


