# coding: utf-8

"""
    Lumos Connectors

    The Lumos Connector API is a self-describing API which allows third-party systems to easily integrate with Lumos. It provides endpoints to retrieve information about each connector, their capabilities.  # How to use this API? To get started with the Lumos Connector API, you'll 1. want to call the `POST /list-connector-app-ids` endpoint, which gives you a list of available connector app IDs, each ID corresponds to a specific integration. 2. Once you have the relevant connector app ID, use the `POST /{connector-app-id}/info` endpoint to find out what capabilities the integration supports. This will also tell you what input parameters are needed and what output you can expect for each of the API endpoints for a specific integration.  This will be integration specific. By using this info, you can correctly format your requests and handle the responses when managing resources.

    The version of the OpenAPI document: 0.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class ErrorCode(str, Enum):
    """
    ErrorCode
    """

    """
    allowed enum values
    """
    NOT_FOUND = 'not_found'
    INTERNAL_ERROR = 'internal_error'
    API_ERROR = 'api_error'
    UNAUTHORIZED = 'unauthorized'
    BAD_REQUEST = 'bad_request'
    PERMISSION_DENIED = 'permission_denied'
    NOT_IMPLEMENTED = 'not_implemented'
    UNEXPECTED_ERROR = 'unexpected_error'
    UNSUPPORTED_OPERATION = 'unsupported_operation'
    UNKNOWN_VALUE = 'unknown_value'
    INVALID_VALUE = 'invalid_value'
    UNAUTHENTICATED = 'Unauthenticated'
    REQUEST_TIMEOUT = 'Request_Timeout'
    CONNECTION_TIMEOUT = 'Connection_Timeout'
    CONNECTION_REJECTED = 'Connection_Rejected'
    RATE_LIMIT = 'Rate_Limit'
    AUTHENTICATION_EXPIRED = 'Authentication_Expired'
    SERVICE_ERROR = 'Service_Error'
    INVALID_RESPONSE = 'Invalid_Response'
    CLIENT_CALL_ERROR = 'Client_Call_Error'
    CONNECTION_CLOSED = 'Connection_Closed'
    CREDS_REVOKED = 'Creds_Revoked'
    INVALID_PAGE_TOKEN = 'Invalid_Page_Token'
    INTEGRATION_MISSING_PARAMETER = 'Integration_Missing_Parameter'

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of ErrorCode from a JSON string"""
        return cls(json.loads(json_str))


