# coding: utf-8

"""
    Lumos Connectors

    The Lumos Connector API is a self-describing API which allows third-party systems to easily integrate with Lumos. It provides endpoints to retrieve information about each connector, their capabilities.  # How to use this API? To get started with the Lumos Connector API, you'll 1. want to call the `POST /list-connector-app-ids` endpoint, which gives you a list of available connector app IDs, each ID corresponds to a specific integration. 2. Once you have the relevant connector app ID, use the `POST /{connector-app-id}/info` endpoint to find out what capabilities the integration supports. This will also tell you what input parameters are needed and what output you can expect for each of the API endpoints for a specific integration.  This will be integration specific. By using this info, you can correctly format your requests and handle the responses when managing resources.

    The version of the OpenAPI document: 0.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictStr
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class DeleteAccount(BaseModel):
    """
    DeleteAccount
    """ # noqa: E501
    account_id: StrictStr
    __properties: ClassVar[List[str]] = ["account_id"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeleteAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeleteAccount from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "account_id": obj.get("account_id")
        })
        return _obj


