# coding: utf-8

"""
    Lumos Connectors

    The Lumos Connector API is a self-describing API which allows third-party systems to easily integrate with Lumos. It provides endpoints to retrieve information about each connector, their capabilities.  # How to use this API? To get started with the Lumos Connector API, you'll 1. want to call the `POST /list-connector-app-ids` endpoint, which gives you a list of available connector app IDs, each ID corresponds to a specific integration. 2. Once you have the relevant connector app ID, use the `POST /{connector-app-id}/info` endpoint to find out what capabilities the integration supports. This will also tell you what input parameters are needed and what output you can expect for each of the API endpoints for a specific integration.  This will be integration specific. By using this info, you can correctly format your requests and handle the responses when managing resources.

    The version of the OpenAPI document: 0.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from connector.generated.models.basic_credential import BasicCredential
from connector.generated.models.o_auth_credential import OAuthCredential
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

AUTHCREDENTIAL_ONE_OF_SCHEMAS = ["BasicCredential", "OAuthCredential"]

class AuthCredential(BaseModel):
    """
    AuthCredential
    """
    # data type: OAuthCredential
    oneof_schema_1_validator: Optional[OAuthCredential] = None
    # data type: BasicCredential
    oneof_schema_2_validator: Optional[BasicCredential] = None
    actual_instance: Optional[Union[BasicCredential, OAuthCredential]] = None
    one_of_schemas: Set[str] = { "BasicCredential", "OAuthCredential" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    discriminator_value_class_map: Dict[str, str] = {
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = AuthCredential.model_construct()
        error_messages = []
        match = 0
        # validate data type: OAuthCredential
        if not isinstance(v, OAuthCredential):
            error_messages.append(f"Error! Input type `{type(v)}` is not `OAuthCredential`")
        else:
            match += 1
        # validate data type: BasicCredential
        if not isinstance(v, BasicCredential):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BasicCredential`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in AuthCredential with oneOf schemas: BasicCredential, OAuthCredential. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in AuthCredential with oneOf schemas: BasicCredential, OAuthCredential. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into OAuthCredential
        try:
            instance.actual_instance = OAuthCredential.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into BasicCredential
        try:
            instance.actual_instance = BasicCredential.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into AuthCredential with oneOf schemas: BasicCredential, OAuthCredential. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into AuthCredential with oneOf schemas: BasicCredential, OAuthCredential. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], BasicCredential, OAuthCredential]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


