from __future__ import annotations
from datetime import datetime
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, Union

from . import schedule_entity_theme

class ShiftActivity(AdditionalDataHolder, Parsable):
    @property
    def additional_data(self,) -> Dict[str, Any]:
        """
        Gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Returns: Dict[str, Any]
        """
        return self._additional_data

    @additional_data.setter
    def additional_data(self,value: Dict[str, Any]) -> None:
        """
        Sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Args:
            value: Value to set for the AdditionalData property.
        """
        self._additional_data = value

    @property
    def code(self,) -> Optional[str]:
        """
        Gets the code property value. Customer defined code for the shiftActivity. Required.
        Returns: Optional[str]
        """
        return self._code

    @code.setter
    def code(self,value: Optional[str] = None) -> None:
        """
        Sets the code property value. Customer defined code for the shiftActivity. Required.
        Args:
            value: Value to set for the code property.
        """
        self._code = value

    def __init__(self,) -> None:
        """
        Instantiates a new shiftActivity and sets the default values.
        """
        # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        self._additional_data: Dict[str, Any] = {}

        # Customer defined code for the shiftActivity. Required.
        self._code: Optional[str] = None
        # The name of the shiftActivity. Required.
        self._display_name: Optional[str] = None
        # The end date and time for the shiftActivity. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
        self._end_date_time: Optional[datetime] = None
        # Indicates whether the microsoft.graph.user should be paid for the activity during their shift. Required.
        self._is_paid: Optional[bool] = None
        # The OdataType property
        self._odata_type: Optional[str] = None
        # The start date and time for the shiftActivity. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
        self._start_date_time: Optional[datetime] = None
        # The theme property
        self._theme: Optional[schedule_entity_theme.ScheduleEntityTheme] = None

    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> ShiftActivity:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: ShiftActivity
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return ShiftActivity()

    @property
    def display_name(self,) -> Optional[str]:
        """
        Gets the displayName property value. The name of the shiftActivity. Required.
        Returns: Optional[str]
        """
        return self._display_name

    @display_name.setter
    def display_name(self,value: Optional[str] = None) -> None:
        """
        Sets the displayName property value. The name of the shiftActivity. Required.
        Args:
            value: Value to set for the displayName property.
        """
        self._display_name = value

    @property
    def end_date_time(self,) -> Optional[datetime]:
        """
        Gets the endDateTime property value. The end date and time for the shiftActivity. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
        Returns: Optional[datetime]
        """
        return self._end_date_time

    @end_date_time.setter
    def end_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the endDateTime property value. The end date and time for the shiftActivity. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
        Args:
            value: Value to set for the endDateTime property.
        """
        self._end_date_time = value

    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "code": lambda n : setattr(self, 'code', n.get_str_value()),
            "display_name": lambda n : setattr(self, 'display_name', n.get_str_value()),
            "end_date_time": lambda n : setattr(self, 'end_date_time', n.get_datetime_value()),
            "is_paid": lambda n : setattr(self, 'is_paid', n.get_bool_value()),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "start_date_time": lambda n : setattr(self, 'start_date_time', n.get_datetime_value()),
            "theme": lambda n : setattr(self, 'theme', n.get_enum_value(schedule_entity_theme.ScheduleEntityTheme)),
        }
        return fields

    @property
    def is_paid(self,) -> Optional[bool]:
        """
        Gets the isPaid property value. Indicates whether the microsoft.graph.user should be paid for the activity during their shift. Required.
        Returns: Optional[bool]
        """
        return self._is_paid

    @is_paid.setter
    def is_paid(self,value: Optional[bool] = None) -> None:
        """
        Sets the isPaid property value. Indicates whether the microsoft.graph.user should be paid for the activity during their shift. Required.
        Args:
            value: Value to set for the isPaid property.
        """
        self._is_paid = value

    @property
    def odata_type(self,) -> Optional[str]:
        """
        Gets the @odata.type property value. The OdataType property
        Returns: Optional[str]
        """
        return self._odata_type

    @odata_type.setter
    def odata_type(self,value: Optional[str] = None) -> None:
        """
        Sets the @odata.type property value. The OdataType property
        Args:
            value: Value to set for the OdataType property.
        """
        self._odata_type = value

    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        writer.write_str_value("code", self.code)
        writer.write_str_value("displayName", self.display_name)
        writer.write_datetime_value("endDateTime", self.end_date_time)
        writer.write_bool_value("isPaid", self.is_paid)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_datetime_value("startDateTime", self.start_date_time)
        writer.write_enum_value("theme", self.theme)
        writer.write_additional_data_value(self.additional_data)

    @property
    def start_date_time(self,) -> Optional[datetime]:
        """
        Gets the startDateTime property value. The start date and time for the shiftActivity. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
        Returns: Optional[datetime]
        """
        return self._start_date_time

    @start_date_time.setter
    def start_date_time(self,value: Optional[datetime] = None) -> None:
        """
        Sets the startDateTime property value. The start date and time for the shiftActivity. The Timestamp type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z. Required.
        Args:
            value: Value to set for the startDateTime property.
        """
        self._start_date_time = value

    @property
    def theme(self,) -> Optional[schedule_entity_theme.ScheduleEntityTheme]:
        """
        Gets the theme property value. The theme property
        Returns: Optional[schedule_entity_theme.ScheduleEntityTheme]
        """
        return self._theme

    @theme.setter
    def theme(self,value: Optional[schedule_entity_theme.ScheduleEntityTheme] = None) -> None:
        """
        Sets the theme property value. The theme property
        Args:
            value: Value to set for the theme property.
        """
        self._theme = value


