from __future__ import annotations
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, Union

class PasswordProfile(AdditionalDataHolder, Parsable):
    @property
    def additional_data(self,) -> Dict[str, Any]:
        """
        Gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Returns: Dict[str, Any]
        """
        return self._additional_data

    @additional_data.setter
    def additional_data(self,value: Dict[str, Any]) -> None:
        """
        Sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Args:
            value: Value to set for the AdditionalData property.
        """
        self._additional_data = value

    def __init__(self,) -> None:
        """
        Instantiates a new passwordProfile and sets the default values.
        """
        # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        self._additional_data: Dict[str, Any] = {}

        # true if the user must change her password on the next login; otherwise false. If not set, default is false. NOTE:  For Azure B2C tenants, set to false and instead use custom policies and user flows to force password reset at first sign in. See Force password reset at first logon.
        self._force_change_password_next_sign_in: Optional[bool] = None
        # If true, at next sign-in, the user must perform a multi-factor authentication (MFA) before being forced to change their password. The behavior is identical to forceChangePasswordNextSignIn except that the user is required to first perform a multi-factor authentication before password change. After a password change, this property will be automatically reset to false. If not set, default is false.
        self._force_change_password_next_sign_in_with_mfa: Optional[bool] = None
        # The OdataType property
        self._odata_type: Optional[str] = None
        # The password for the user. This property is required when a user is created. It can be updated, but the user will be required to change the password on the next login. The password must satisfy minimum requirements as specified by the user’s passwordPolicies property. By default, a strong password is required.
        self._password: Optional[str] = None

    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> PasswordProfile:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: PasswordProfile
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return PasswordProfile()

    @property
    def force_change_password_next_sign_in(self,) -> Optional[bool]:
        """
        Gets the forceChangePasswordNextSignIn property value. true if the user must change her password on the next login; otherwise false. If not set, default is false. NOTE:  For Azure B2C tenants, set to false and instead use custom policies and user flows to force password reset at first sign in. See Force password reset at first logon.
        Returns: Optional[bool]
        """
        return self._force_change_password_next_sign_in

    @force_change_password_next_sign_in.setter
    def force_change_password_next_sign_in(self,value: Optional[bool] = None) -> None:
        """
        Sets the forceChangePasswordNextSignIn property value. true if the user must change her password on the next login; otherwise false. If not set, default is false. NOTE:  For Azure B2C tenants, set to false and instead use custom policies and user flows to force password reset at first sign in. See Force password reset at first logon.
        Args:
            value: Value to set for the forceChangePasswordNextSignIn property.
        """
        self._force_change_password_next_sign_in = value

    @property
    def force_change_password_next_sign_in_with_mfa(self,) -> Optional[bool]:
        """
        Gets the forceChangePasswordNextSignInWithMfa property value. If true, at next sign-in, the user must perform a multi-factor authentication (MFA) before being forced to change their password. The behavior is identical to forceChangePasswordNextSignIn except that the user is required to first perform a multi-factor authentication before password change. After a password change, this property will be automatically reset to false. If not set, default is false.
        Returns: Optional[bool]
        """
        return self._force_change_password_next_sign_in_with_mfa

    @force_change_password_next_sign_in_with_mfa.setter
    def force_change_password_next_sign_in_with_mfa(self,value: Optional[bool] = None) -> None:
        """
        Sets the forceChangePasswordNextSignInWithMfa property value. If true, at next sign-in, the user must perform a multi-factor authentication (MFA) before being forced to change their password. The behavior is identical to forceChangePasswordNextSignIn except that the user is required to first perform a multi-factor authentication before password change. After a password change, this property will be automatically reset to false. If not set, default is false.
        Args:
            value: Value to set for the forceChangePasswordNextSignInWithMfa property.
        """
        self._force_change_password_next_sign_in_with_mfa = value

    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "force_change_password_next_sign_in": lambda n : setattr(self, 'force_change_password_next_sign_in', n.get_bool_value()),
            "force_change_password_next_sign_in_with_mfa": lambda n : setattr(self, 'force_change_password_next_sign_in_with_mfa', n.get_bool_value()),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "password": lambda n : setattr(self, 'password', n.get_str_value()),
        }
        return fields

    @property
    def odata_type(self,) -> Optional[str]:
        """
        Gets the @odata.type property value. The OdataType property
        Returns: Optional[str]
        """
        return self._odata_type

    @odata_type.setter
    def odata_type(self,value: Optional[str] = None) -> None:
        """
        Sets the @odata.type property value. The OdataType property
        Args:
            value: Value to set for the OdataType property.
        """
        self._odata_type = value

    @property
    def password(self,) -> Optional[str]:
        """
        Gets the password property value. The password for the user. This property is required when a user is created. It can be updated, but the user will be required to change the password on the next login. The password must satisfy minimum requirements as specified by the user’s passwordPolicies property. By default, a strong password is required.
        Returns: Optional[str]
        """
        return self._password

    @password.setter
    def password(self,value: Optional[str] = None) -> None:
        """
        Sets the password property value. The password for the user. This property is required when a user is created. It can be updated, but the user will be required to change the password on the next login. The password must satisfy minimum requirements as specified by the user’s passwordPolicies property. By default, a strong password is required.
        Args:
            value: Value to set for the password property.
        """
        self._password = value

    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        writer.write_bool_value("forceChangePasswordNextSignIn", self.force_change_password_next_sign_in)
        writer.write_bool_value("forceChangePasswordNextSignInWithMfa", self.force_change_password_next_sign_in_with_mfa)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_str_value("password", self.password)
        writer.write_additional_data_value(self.additional_data)


