from __future__ import annotations
from kiota_abstractions.serialization import AdditionalDataHolder, Parsable, ParseNode, SerializationWriter
from typing import Any, Callable, Dict, List, Optional, Union

from . import file_hash

class FileSecurityState(AdditionalDataHolder, Parsable):
    @property
    def additional_data(self,) -> Dict[str, Any]:
        """
        Gets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Returns: Dict[str, Any]
        """
        return self._additional_data

    @additional_data.setter
    def additional_data(self,value: Dict[str, Any]) -> None:
        """
        Sets the additionalData property value. Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        Args:
            value: Value to set for the AdditionalData property.
        """
        self._additional_data = value

    def __init__(self,) -> None:
        """
        Instantiates a new fileSecurityState and sets the default values.
        """
        # Stores additional data not described in the OpenAPI description found when deserializing. Can be used for serialization as well.
        self._additional_data: Dict[str, Any] = {}

        # Complex type containing file hashes (cryptographic and location-sensitive).
        self._file_hash: Optional[file_hash.FileHash] = None
        # File name (without path).
        self._name: Optional[str] = None
        # The OdataType property
        self._odata_type: Optional[str] = None
        # Full file path of the file/imageFile.
        self._path: Optional[str] = None
        # Provider generated/calculated risk score of the alert file. Recommended value range of 0-1, which equates to a percentage.
        self._risk_score: Optional[str] = None

    @staticmethod
    def create_from_discriminator_value(parse_node: Optional[ParseNode] = None) -> FileSecurityState:
        """
        Creates a new instance of the appropriate class based on discriminator value
        Args:
            parseNode: The parse node to use to read the discriminator value and create the object
        Returns: FileSecurityState
        """
        if parse_node is None:
            raise Exception("parse_node cannot be undefined")
        return FileSecurityState()

    @property
    def file_hash(self,) -> Optional[file_hash.FileHash]:
        """
        Gets the fileHash property value. Complex type containing file hashes (cryptographic and location-sensitive).
        Returns: Optional[file_hash.FileHash]
        """
        return self._file_hash

    @file_hash.setter
    def file_hash(self,value: Optional[file_hash.FileHash] = None) -> None:
        """
        Sets the fileHash property value. Complex type containing file hashes (cryptographic and location-sensitive).
        Args:
            value: Value to set for the fileHash property.
        """
        self._file_hash = value

    def get_field_deserializers(self,) -> Dict[str, Callable[[ParseNode], None]]:
        """
        The deserialization information for the current model
        Returns: Dict[str, Callable[[ParseNode], None]]
        """
        fields = {
            "file_hash": lambda n : setattr(self, 'file_hash', n.get_object_value(file_hash.FileHash)),
            "name": lambda n : setattr(self, 'name', n.get_str_value()),
            "@odata.type": lambda n : setattr(self, 'odata_type', n.get_str_value()),
            "path": lambda n : setattr(self, 'path', n.get_str_value()),
            "risk_score": lambda n : setattr(self, 'risk_score', n.get_str_value()),
        }
        return fields

    @property
    def name(self,) -> Optional[str]:
        """
        Gets the name property value. File name (without path).
        Returns: Optional[str]
        """
        return self._name

    @name.setter
    def name(self,value: Optional[str] = None) -> None:
        """
        Sets the name property value. File name (without path).
        Args:
            value: Value to set for the name property.
        """
        self._name = value

    @property
    def odata_type(self,) -> Optional[str]:
        """
        Gets the @odata.type property value. The OdataType property
        Returns: Optional[str]
        """
        return self._odata_type

    @odata_type.setter
    def odata_type(self,value: Optional[str] = None) -> None:
        """
        Sets the @odata.type property value. The OdataType property
        Args:
            value: Value to set for the OdataType property.
        """
        self._odata_type = value

    @property
    def path(self,) -> Optional[str]:
        """
        Gets the path property value. Full file path of the file/imageFile.
        Returns: Optional[str]
        """
        return self._path

    @path.setter
    def path(self,value: Optional[str] = None) -> None:
        """
        Sets the path property value. Full file path of the file/imageFile.
        Args:
            value: Value to set for the path property.
        """
        self._path = value

    @property
    def risk_score(self,) -> Optional[str]:
        """
        Gets the riskScore property value. Provider generated/calculated risk score of the alert file. Recommended value range of 0-1, which equates to a percentage.
        Returns: Optional[str]
        """
        return self._risk_score

    @risk_score.setter
    def risk_score(self,value: Optional[str] = None) -> None:
        """
        Sets the riskScore property value. Provider generated/calculated risk score of the alert file. Recommended value range of 0-1, which equates to a percentage.
        Args:
            value: Value to set for the riskScore property.
        """
        self._risk_score = value

    def serialize(self,writer: SerializationWriter) -> None:
        """
        Serializes information the current object
        Args:
            writer: Serialization writer to use to serialize this model
        """
        if writer is None:
            raise Exception("writer cannot be undefined")
        writer.write_object_value("fileHash", self.file_hash)
        writer.write_str_value("name", self.name)
        writer.write_str_value("@odata.type", self.odata_type)
        writer.write_str_value("path", self.path)
        writer.write_str_value("riskScore", self.risk_score)
        writer.write_additional_data_value(self.additional_data)


