# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../nbs/03_data.transforms.kssl.ipynb.

# %% ../../../nbs/03_data.transforms.kssl.ipynb 3
from fastai.vision.all import *
from fastai.data.all import *
from pathlib import Path
import pandas as pd

from __future__ import annotations

# %% auto 0
__all__ = ['get_spectra_files', 'to_spectra', 'rand_w_avg', 'get_target']

# %% ../../../nbs/03_data.transforms.kssl.ipynb 5
def get_spectra_files(path:Path, # Path to the a kssl folder (contains spectra replicates and wet chemistry)
                     ) -> list: # List of spectra replicates (if any)
    "Return paths of spectra `.csv` files in path"
    return [f for f in path.ls() if re.match('\d', f.name)]

# %% ../../../nbs/03_data.transforms.kssl.ipynb 8
def to_spectra(fnames:list, # List of paths to individual spectrum file
              ) -> torch.Tensor: # Spectra
    "Transform list of paths to spectra to list of torch arrays"
    n = pd.read_csv(fnames[0]).shape[0]
    m = len(fnames)
    x = np.empty((m,n))
    for i, fname in enumerate(fnames):
        x[i,:] = pd.read_csv(fname)['absorbance'].values
    return tensor(x)

# %% ../../../nbs/03_data.transforms.kssl.ipynb 10
def rand_w_avg(x: list, # List of spectra as tensors
              ) -> torch.tensor: # Weighted random averaged spectrum
    "Transform spectra replicates taking their random weighted averages"
    n = len(x)
    def weights(n):
        weights = torch.rand(n)
        return (weights/weights.sum()).unsqueeze(dim=0)
    return torch.matmul(weights(n), x)

# %% ../../../nbs/03_data.transforms.kssl.ipynb 12
def get_target(path:Path, # Path to the a kssl folder (contains spectra replicates and wet chemistry)
               analytes:list|None=None, # List of analytes (soil properties) of interest
              ) -> torch.tensor: # Analytes as tensor
    path_target = [f for f in path.ls() if re.match('target', f.name)][0]
    df = pd.read_csv(path_target)
    if analytes:
        df = df[df.analyte.isin(analytes)]
    return tensor(df['value'].values)
