# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/00_data.core.ipynb.

# %% auto 0
__all__ = ['read_opus', 'select_rows']

# %% ../../nbs/00_data.core.ipynb 3
from brukeropusreader import read_file
import numpy as np
from typing import Tuple, Dict, Callable
import pandas as pd

# %% ../../nbs/00_data.core.ipynb 5
def read_opus(
    fname:str # file name
) -> Tuple: # (spectrum, wavenumbers) as `np.ndarray`
    """OPUS (Bruker Optics) infrared spectra reader
    
    It uses patched `brukeropusreader` third party Python package. 
    
    To install it run: 
    `conda install -c "spectrocat/label/dev" brukeropusreader`
    """
    f = read_file(fname)
    return f['AB'], f.get_range('AB')    

# %% ../../nbs/00_data.core.ipynb 8
def select_rows(df:pd.DataFrame, #  DataFrame whose rows should be selected
                where:Dict[str, Callable], # Pandas columns as keys & predicates as values.
               ) -> pd.DataFrame:
    "When passed to Pandas pipe, perform row selection given multiple predicates"
    df = df.copy()
    for col, f in where.items():
        df = df[df[col].apply(f)]
    return df
