# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['panos']

package_data = \
{'': ['*']}

install_requires = \
['pan-python>=0.17.0,<0.18.0']

setup_kwargs = {
    'name': 'pan-os-python',
    'version': '1.8.0',
    'description': 'Framework for interacting with Palo Alto Networks devices via API',
    'long_description': 'Palo Alto Networks PAN-OS SDK for Python\n========================================\n\nThe PAN-OS SDK for Python (pan-os-python) is a package to help interact with\nPalo Alto Networks devices (including physical and virtualized Next-generation\nFirewalls and Panorama).  The pan-os-python SDK is object oriented and mimics\nthe traditional interaction with the device via the GUI or CLI/API.\n\n* Documentation: http://pan-os-python.readthedocs.io\n\n-----\n\n[![Latest version released on PyPi](https://img.shields.io/pypi/v/pan-os-python.svg)](https://pypi.python.org/pypi/pan-os-python)\n[![Python versions](https://img.shields.io/badge/python-3.5%20%7C%203.6%20%7C%203.7%20%7C%203.8-blueviolet)](https://pypi.python.org/pypi/pan-os-python)\n[![License](https://img.shields.io/pypi/l/pan-os-python)](https://github.com/PaloAltoNetworks/pan-os-python/blob/develop/LICENSE)\n[![Documentation Status](https://img.shields.io/badge/docs-latest-brightgreen.svg)](http://pan-os-python.readthedocs.io/en/latest/?badge=latest)\n[![Chat on GitHub Discussions](https://img.shields.io/badge/chat%20on-GitHub%20Discussions-brightgreen)](https://github.com/PaloAltoNetworks/pan-os-python/discussions)\n\n[![semantic-release](https://img.shields.io/badge/%20%20%F0%9F%93%A6%F0%9F%9A%80-semantic--release-e10079.svg)](https://github.com/semantic-release/semantic-release)\n[![Conventional Commits](https://img.shields.io/badge/Conventional%20Commits-1.0.0-yellow.svg)](https://conventionalcommits.org/)\n[![Powered by DepHell](https://img.shields.io/badge/Powered%20by-DepHell-red)](https://github.com/dephell/dephell)\n[![GitHub contributors](https://img.shields.io/github/contributors/PaloAltoNetworks/pan-os-python)](https://github.com/PaloAltoNetworks/pan-os-python/graphs/contributors/)\n\n-----\n\nFeatures\n--------\n\n- Object model of Firewall and Panorama configuration\n- Multiple connection methods including Panorama as a proxy\n- All operations natively vsys-aware\n- Support for high availability pairs and retry/recovery during node failure\n- Batch User-ID operations\n- Device API exception classification\n\nStatus\n------\n\nPalo Alto Networks PAN-OS SDK for Python is considered stable. It is fully tested\nand used in many production environments. Semantic versioning is applied to indicate\nbug fixes, new features, and breaking changes in each version.\n\nInstall\n-------\n\nInstall using pip:\n\n```shell\npip install pan-os-python\n```\n\nUpgrade to the latest version:\n\n```shell\npip install --upgrade pan-os-python\n```\n\nIf you have poetry installed, you can also add pan-os-python to your project:\n \n```shell\npoetry add pan-os-python\n```\n\nHow to import\n-------------\n\nTo use pan-os-python in a project:\n\n```python\nimport panos\n```\n\nYou can also be more specific about which modules you want to import:\n\n```python\nfrom panos import firewall\nfrom panos import network\n```\n\n\nA few examples\n--------------\n\nFor configuration tasks, create a tree structure using the classes in\neach module. Nodes hierarchy must follow the model in the\n[Configuration Tree](http://pan-os-python.readthedocs.io/en/latest/configtree.html).\n\nThe following examples assume the modules were imported as such:\n\n```python\nfrom panos import firewall\nfrom panos import network\n```\n\nCreate an interface and commit:\n\n```python\nfw = firewall.Firewall("10.0.0.1", api_username="admin", api_password="admin")\neth1 = network.EthernetInterface("ethernet1/1", mode="layer3")\nfw.add(eth1)\neth1.create()\nfw.commit()\n```\n\nOperational commands leverage the \'op\' method of the device:\n\n```python\nfw = firewall.Firewall("10.0.0.1", api_username="admin", api_password="admin")\nprint fw.op("show system info")\n```\n\nSome operational commands have methods to refresh the variables in an object:\n\n```python\n# populates the version, serial, and model variables from the live device\nfw.refresh_system_info()\n```\n\nSee more examples in the [Usage Guide](http://pan-os-python.readthedocs.io/en/latest/usage.html).\n\nUpgrade from pandevice\n----------------------\n\nThis `pan-os-python` package is the evolution of the older `pandevice` package. To\nupgrade from `pandevice` to `pan-os-python`, follow these steps.\n\nStep 1. Ensure you are using python3\n\n   [Python2 is end-of-life](https://www.python.org/doc/sunset-python-2/) and not\n   supported by `pan-os-python`.\n\nStep 2. Uninstall pandevice:\n\n```shell\npip uninstall pandevice\n # or\npoetry remove pandevice\n```\n\nStep 3. Install pan-os-python:\n\n```shell\npip3 install pan-os-python\n # or\npoetry add pan-os-python\n```\n\nStep 4. Change the import statements in your code from `pandevice` to `panos`. For example:\n\n```python\nimport pandevice\nfrom pandevice.firewall import Firewall\n\n # would change to\n\nimport panos\nfrom panos.firewall import Firewall\n```\n\nStep 5. Test your script or application\n\n   There are no known breaking changes\n   between `pandevice v0.14.0` and `pan-os-python v1.0.0`, but it is a major\n   upgrade so please verify everything works as expected.\n\nContributors\n------------\n\n- Brian Torres-Gil - [btorresgil](https://github.com/btorresgil)\n- Garfield Freeman - [shinmog](https://github.com/shinmog)\n- John Anderson - [lampwins](https://github.com/lampwins)\n- Aditya Sripal - [AdityaSripal](https://github.com/AdityaSripal)\n\nThank you to [Kevin Steves](https://github.com/kevinsteves), creator of the [pan-python library](https://github.com/kevinsteves/pan-python)\n',
    'author': 'Palo Alto Networks',
    'author_email': 'devrel@paloaltonetworks.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/PaloAltoNetworks/pan-os-python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*, !=3.4.*',
}


setup(**setup_kwargs)
