
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/kinematics/SwerveDriveOdometry.h>





namespace rpygen {

using namespace frc;


template <size_t NumModules>
struct bind_frc__SwerveDriveOdometry {

    

    py::class_<typename frc::SwerveDriveOdometry<NumModules>> cls_SwerveDriveOdometry;




    py::module &m;
    std::string clsName;

bind_frc__SwerveDriveOdometry(py::module &m, const char * clsName) :
    cls_SwerveDriveOdometry(m, clsName),



    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_SwerveDriveOdometry.doc() =
    "Class for swerve drive odometry. Odometry allows you to track the robot's\n"
"position on the field over a course of a match using readings from your\n"
"swerve drive encoders and swerve azimuth encoders.\n"
"\n"
"Teams can use odometry during the autonomous period for complex tasks like\n"
"path following. Furthermore, odometry can be used for latency compensation\n"
"when using computer-vision systems.";

  cls_SwerveDriveOdometry
      .def(py::init<SwerveDriveKinematics<NumModules >, const Rotation2d&, const Pose2d&>(),
      py::arg("kinematics"), py::arg("gyroAngle"), py::arg("initialPose")=Pose2d ( ), release_gil()    , py::keep_alive<1, 3>()    , py::keep_alive<1, 4>(), py::doc(
    "Constructs a SwerveDriveOdometry object.\n"
"\n"
":param kinematics:  The swerve drive kinematics for your drivetrain.\n"
":param gyroAngle:   The angle reported by the gyroscope.\n"
":param initialPose: The starting position of the robot on the field.")
  )
    
      .def("resetPosition", &frc::SwerveDriveOdometry<NumModules>::ResetPosition,
      py::arg("pose"), py::arg("gyroAngle"), release_gil(), py::doc(
    "Resets the robot's position on the field.\n"
"\n"
"The gyroscope angle does not need to be reset here on the user's robot\n"
"code. The library automatically takes care of offsetting the gyro angle.\n"
"\n"
":param pose:      The position on the field that your robot is at.\n"
":param gyroAngle: The angle reported by the gyroscope.")
  )
    
      .def("getPose", &frc::SwerveDriveOdometry<NumModules>::GetPose, release_gil(), py::doc(
    "Returns the position of the robot on the field.\n"
"\n"
":returns: The pose of the robot.")
  )
    
      .def("updateWithTime", []() {
  if constexpr (NumModules == 2) {
    return [](SwerveDriveOdometry<NumModules> * self,
              units::second_t currentTime, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2) {
      return self->UpdateWithTime(currentTime, gyroAngle, s1, s2);
    };
  } else if constexpr (NumModules == 3) {
    return [](SwerveDriveOdometry<NumModules> * self,
              units::second_t currentTime, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2, SwerveModuleState s3) {
      return self->UpdateWithTime(currentTime, gyroAngle, s1, s2, s3);
    };
  } else if constexpr (NumModules == 4) {
    return [](SwerveDriveOdometry<NumModules> * self,
              units::second_t currentTime, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2,
              SwerveModuleState s3, SwerveModuleState s4) {
      return self->UpdateWithTime(currentTime, gyroAngle, s1, s2, s3, s4);
    };
  } else if constexpr (NumModules == 6) {
    return [](SwerveDriveOdometry<NumModules> * self,
              units::second_t currentTime, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2,
              SwerveModuleState s3, SwerveModuleState s4,
              SwerveModuleState s5, SwerveModuleState s6) {
      return self->UpdateWithTime(currentTime, gyroAngle, s1, s2, s3, s4, s5, s6);
    };
  }
}()
, py::doc(
    "Updates the robot's position on the field using forward kinematics and\n"
"integration of the pose over time. This method takes in the current time as\n"
"a parameter to calculate period (difference between two timestamps). The\n"
"period is used to calculate the change in distance from a velocity. This\n"
"also takes in an angle parameter which is used instead of the\n"
"angular rate that is calculated from forward kinematics.\n"
"\n"
":param currentTime:  The current time.\n"
":param gyroAngle:    The angle reported by the gyroscope.\n"
":param moduleStates: The current state of all swerve modules. Please provide\n"
"                     the states in the same order in which you instantiated\n"
"                     your SwerveDriveKinematics.\n"
"\n"
":returns: The new pose of the robot.")
  )
    
      .def("update", []() {
  if constexpr (NumModules == 2) {
    return [](SwerveDriveOdometry<NumModules> * self, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2) {
      return self->Update(gyroAngle, s1, s2);
    };
  } else if constexpr (NumModules == 3) {
    return [](SwerveDriveOdometry<NumModules> * self, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2, SwerveModuleState s3) {
      return self->Update(gyroAngle, s1, s2, s3);
    };
  } else if constexpr (NumModules == 4) {
    return [](SwerveDriveOdometry<NumModules> * self, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2,
              SwerveModuleState s3, SwerveModuleState s4) {
      return self->Update(gyroAngle, s1, s2, s3, s4);
    };
  } else if constexpr (NumModules == 6) {
    return [](SwerveDriveOdometry<NumModules> * self, const Rotation2d& gyroAngle,
              SwerveModuleState s1, SwerveModuleState s2,
              SwerveModuleState s3, SwerveModuleState s4,
              SwerveModuleState s5, SwerveModuleState s6) {
      return self->Update(gyroAngle, s1, s2, s3, s4, s5, s6);
    };
  }
}()
, py::doc(
    "Updates the robot's position on the field using forward kinematics and\n"
"integration of the pose over time. This method automatically calculates\n"
"the current time to calculate period (difference between two timestamps).\n"
"The period is used to calculate the change in distance from a velocity.\n"
"This also takes in an angle parameter which is used instead of the\n"
"angular rate that is calculated from forward kinematics.\n"
"\n"
":param gyroAngle:    The angle reported by the gyroscope.\n"
":param moduleStates: The current state of all swerve modules. Please provide\n"
"                     the states in the same order in which you instantiated\n"
"                     your SwerveDriveKinematics.\n"
"\n"
":returns: The new pose of the robot.")
  )
    
;

  

    if (set_doc) {
        cls_SwerveDriveOdometry.doc() = set_doc;
    }
    if (add_doc) {
        cls_SwerveDriveOdometry.doc() = py::cast<std::string>(cls_SwerveDriveOdometry.doc()) + add_doc;
    }

    
}

}; // struct bind_frc__SwerveDriveOdometry

}; // namespace rpygen