
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/filter/SlewRateLimiter.h>





namespace rpygen {

using namespace frc;


template <typename Unit>
struct bind_frc__SlewRateLimiter {

          using Unit_t = units::unit_t<Unit>;
      using Rate = units::compound_unit<Unit, units::inverse<units::seconds>>;


    py::class_<typename frc::SlewRateLimiter<Unit>> cls_SlewRateLimiter;




    py::module &m;
    std::string clsName;

bind_frc__SlewRateLimiter(py::module &m, const char * clsName) :
    cls_SlewRateLimiter(m, clsName),



    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_SlewRateLimiter.doc() =
    "A class that limits the rate of change of an input value.  Useful for\n"
"implementing voltage, setpoint, and/or output ramps.  A slew-rate limit\n"
"is most appropriate when the quantity being controlled is a velocity or\n"
"a voltage; when controlling a position, consider using a TrapezoidProfile\n"
"instead.\n"
"\n"
"@see TrapezoidProfile";

  cls_SlewRateLimiter
      .def(py::init<units::unit_t<Rate >, units::unit_t<Unit >>(),
      py::arg("rateLimit"), py::arg("initialValue")=Unit_t{ 0}, release_gil(), py::doc(
    "Creates a new SlewRateLimiter with the given rate limit and initial value.\n"
"\n"
":param rateLimit:    The rate-of-change limit.\n"
":param initialValue: The initial value of the input.")
  )
    
      .def("calculate", &frc::SlewRateLimiter<Unit>::Calculate,
      py::arg("input"), release_gil(), py::doc(
    "Filters the input to limit its slew rate.\n"
"\n"
":param input: The input value whose slew rate is to be limited.\n"
"\n"
":returns: The filtered value, which will not change faster than the slew\n"
"          rate.")
  )
    
      .def("reset", &frc::SlewRateLimiter<Unit>::Reset,
      py::arg("value"), release_gil(), py::doc(
    "Resets the slew rate limiter to the specified value; ignores the rate limit\n"
"when doing so.\n"
"\n"
":param value: The value to reset to.")
  )
    
;

  

    if (set_doc) {
        cls_SlewRateLimiter.doc() = set_doc;
    }
    if (add_doc) {
        cls_SlewRateLimiter.doc() = py::cast<std::string>(cls_SlewRateLimiter.doc()) + add_doc;
    }

    
}

}; // struct bind_frc__SlewRateLimiter

}; // namespace rpygen