
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/estimator/KalmanFilter.h>





namespace rpygen {

using namespace frc::detail;


template <int States, int Inputs, int Outputs>
struct bind_frc__detail__KalmanFilterImpl {

    

    py::class_<typename frc::detail::KalmanFilterImpl<States, Inputs, Outputs>> cls_KalmanFilterImpl;




    py::module &m;
    std::string clsName;

bind_frc__detail__KalmanFilterImpl(py::module &m, const char * clsName) :
    cls_KalmanFilterImpl(m, clsName),



    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_KalmanFilterImpl.doc() =
    "A Kalman filter combines predictions from a model and measurements to give an\n"
"estimate of the true system state. This is useful because many states cannot\n"
"be measured directly as a result of sensor noise, or because the state is\n"
"\"hidden\".\n"
"\n"
"Kalman filters use a K gain matrix to determine whether to trust the model or\n"
"measurements more. Kalman filter theory uses statistics to compute an optimal\n"
"K gain which minimizes the sum of squares error in the state estimate. This K\n"
"gain is used to correct the state estimate by some amount of the difference\n"
"between the actual measurements and the measurements predicted by the model.\n"
"\n"
"For more on the underlying math, read\n"
"https://file.tavsys.net/control/controls-engineering-in-frc.pdf chapter 9\n"
"\"Stochastic control theory\".\n"
"\n"
"@tparam States The number of states.\n"
"@tparam Inputs The number of inputs.\n"
"@tparam Outputs The number of outputs.";

  cls_KalmanFilterImpl
      .def(py::init<LinearSystem<States, Inputs, Outputs>&, const wpi::array<double, States>&, const wpi::array<double, Outputs>&, units::second_t>(),
      py::arg("plant"), py::arg("stateStdDevs"), py::arg("measurementStdDevs"), py::arg("dt"), release_gil()    , py::keep_alive<1, 2>()    , py::keep_alive<1, 3>()    , py::keep_alive<1, 4>(), py::doc(
    "Constructs a state-space observer with the given plant.\n"
"\n"
":param plant:              The plant used for the prediction step.\n"
":param stateStdDevs:       Standard deviations of model states.\n"
":param measurementStdDevs: Standard deviations of measurements.\n"
":param dt:                 Nominal discretization timestep.")
  )
    
      .def("K", static_cast<const Eigen::Matrix<double, States, Outputs> & (frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::*)() const>(
&frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::K), release_gil(), py::doc(
    "Returns the steady-state Kalman gain matrix K.")
  )
    
      .def("K", static_cast<double (frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::*)(int, int) const>(
&frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::K),
      py::arg("i"), py::arg("j"), release_gil(), py::doc(
    "Returns an element of the steady-state Kalman gain matrix K.\n"
"\n"
":param i: Row of K.\n"
":param j: Column of K.")
  )
    
      .def("xhat", static_cast<const Eigen::Vector<double, States> & (frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::*)() const>(
&frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::Xhat), release_gil(), py::doc(
    "Returns the state estimate x-hat.")
  )
    
      .def("xhat", static_cast<double (frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::*)(int) const>(
&frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::Xhat),
      py::arg("i"), release_gil(), py::doc(
    "Returns an element of the state estimate x-hat.\n"
"\n"
":param i: Row of x-hat.")
  )
    
      .def("setXhat", static_cast<void (frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::*)(const Eigen::Vector<double, States>&)>(
&frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::SetXhat),
      py::arg("xHat"), release_gil(), py::doc(
    "Set initial state estimate x-hat.\n"
"\n"
":param xHat: The state estimate x-hat.")
  )
    
      .def("setXhat", static_cast<void (frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::*)(int, double)>(
&frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::SetXhat),
      py::arg("i"), py::arg("value"), release_gil(), py::doc(
    "Set an element of the initial state estimate x-hat.\n"
"\n"
":param i:     Row of x-hat.\n"
":param value: Value for element of x-hat.")
  )
    
      .def("reset", &frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::Reset, release_gil(), py::doc(
    "Resets the observer.")
  )
    
      .def("predict", &frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::Predict,
      py::arg("u"), py::arg("dt"), release_gil(), py::doc(
    "Project the model into the future with a new control input u.\n"
"\n"
":param u:  New control input from controller.\n"
":param dt: Timestep for prediction.")
  )
    
      .def("correct", &frc::detail::KalmanFilterImpl<States, Inputs, Outputs>::Correct,
      py::arg("u"), py::arg("y"), release_gil(), py::doc(
    "Correct the state estimate x-hat using the measurements in y.\n"
"\n"
":param u: Same control input used in the last predict step.\n"
":param y: Measurement vector.")
  )
    
;

  

    if (set_doc) {
        cls_KalmanFilterImpl.doc() = set_doc;
    }
    if (add_doc) {
        cls_KalmanFilterImpl.doc() = py::cast<std::string>(cls_KalmanFilterImpl.doc()) + add_doc;
    }

    
}

}; // struct bind_frc__detail__KalmanFilterImpl

}; // namespace rpygen