
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/system/LinearSystemLoop.h>





namespace rpygen {

using namespace frc;


template <int States, int Inputs, int Outputs>
struct bind_frc__LinearSystemLoop {

    

    py::class_<typename frc::LinearSystemLoop<States, Inputs, Outputs>> cls_LinearSystemLoop;




    py::module &m;
    std::string clsName;

bind_frc__LinearSystemLoop(py::module &m, const char * clsName) :
    cls_LinearSystemLoop(m, clsName),



    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_LinearSystemLoop.doc() =
    "Combines a controller, feedforward, and observer for controlling a mechanism\n"
"with full state feedback.\n"
"\n"
"For everything in this file, \"inputs\" and \"outputs\" are defined from the\n"
"perspective of the plant. This means U is an input and Y is an output\n"
"(because you give the plant U (powers) and it gives you back a Y (sensor\n"
"values). This is the opposite of what they mean from the perspective of the\n"
"controller (U is an output because that's what goes to the motors and Y is an\n"
"input because that's what comes back from the sensors).\n"
"\n"
"For more on the underlying math, read\n"
"https://file.tavsys.net/control/controls-engineering-in-frc.pdf.\n"
"\n"
"@tparam States Number of states.\n"
"@tparam Inputs Number of inputs.\n"
"@tparam Outputs Number of outputs.";

  cls_LinearSystemLoop
      .def(py::init<LinearSystem<States, Inputs, Outputs>&, LinearQuadraticRegulator<States, Inputs>&, KalmanFilter<States, Inputs, Outputs>&, units::volt_t, units::second_t>(),
      py::arg("plant"), py::arg("controller"), py::arg("observer"), py::arg("maxVoltage"), py::arg("dt"), release_gil()    , py::keep_alive<1, 2>()    , py::keep_alive<1, 3>()    , py::keep_alive<1, 4>(), py::doc(
    "Constructs a state-space loop with the given plant, controller, and\n"
"observer. By default, the initial reference is all zeros. Users should\n"
"call reset with the initial system state before enabling the loop. This\n"
"constructor assumes that the input(s) to this system are voltage.\n"
"\n"
":param plant:      State-space plant.\n"
":param controller: State-space controller.\n"
":param observer:   State-space observer.\n"
":param maxVoltage: The maximum voltage that can be applied. Commonly 12.\n"
":param dt:         The nominal timestep.")
  )
    
      .def(py::init<LinearSystem<States, Inputs, Outputs>&, LinearQuadraticRegulator<States, Inputs>&, KalmanFilter<States, Inputs, Outputs>&, std::function<Eigen::Vector<double, Inputs> ( const Eigen::Vector<double, Inputs> & )>, units::second_t>(),
      py::arg("plant"), py::arg("controller"), py::arg("observer"), py::arg("clampFunction"), py::arg("dt"), release_gil()    , py::keep_alive<1, 2>()    , py::keep_alive<1, 3>()    , py::keep_alive<1, 4>(), py::doc(
    "Constructs a state-space loop with the given plant, controller, and\n"
"observer. By default, the initial reference is all zeros. Users should\n"
"call reset with the initial system state before enabling the loop. This\n"
"constructor assumes that the input(s) to this system are voltage.\n"
"\n"
":param plant:         State-space plant.\n"
":param controller:    State-space controller.\n"
":param observer:      State-space observer.\n"
":param clampFunction: The function used to clamp the input vector.\n"
":param dt:            The nominal timestep.")
  )
    
      .def(py::init<LinearQuadraticRegulator<States, Inputs>&, const LinearPlantInversionFeedforward<States, Inputs>&, KalmanFilter<States, Inputs, Outputs>&, units::volt_t>(),
      py::arg("controller"), py::arg("feedforward"), py::arg("observer"), py::arg("maxVoltage"), release_gil()    , py::keep_alive<1, 2>()    , py::keep_alive<1, 3>()    , py::keep_alive<1, 4>(), py::doc(
    "Constructs a state-space loop with the given controller, feedforward and\n"
"observer. By default, the initial reference is all zeros. Users should\n"
"call reset with the initial system state.\n"
"\n"
":param controller:  State-space controller.\n"
":param feedforward: Plant inversion feedforward.\n"
":param observer:    State-space observer.\n"
":param maxVoltage:  The maximum voltage that can be applied. Assumes\n"
"                    that the inputs are voltages.")
  )
    
      .def(py::init<LinearQuadraticRegulator<States, Inputs>&, const LinearPlantInversionFeedforward<States, Inputs>&, KalmanFilter<States, Inputs, Outputs>&, std::function<Eigen::Vector<double, Inputs> ( const Eigen::Vector<double, Inputs> & )>>(),
      py::arg("controller"), py::arg("feedforward"), py::arg("observer"), py::arg("clampFunction"), release_gil()    , py::keep_alive<1, 2>()    , py::keep_alive<1, 3>()    , py::keep_alive<1, 4>(), py::doc(
    "Constructs a state-space loop with the given controller, feedforward,\n"
"observer and clamp function. By default, the initial reference is all\n"
"zeros. Users should call reset with the initial system state.\n"
"\n"
":param controller:    State-space controller.\n"
":param feedforward:   Plant-inversion feedforward.\n"
":param observer:      State-space observer.\n"
":param clampFunction: The function used to clamp the input vector.")
  )
    
      .def("xhat", static_cast<const Eigen::Vector<double, States> & (frc::LinearSystemLoop<States, Inputs, Outputs>::*)() const>(
&frc::LinearSystemLoop<States, Inputs, Outputs>::Xhat), release_gil(), py::doc(
    "Returns the observer's state estimate x-hat.")
  )
    
      .def("xhat", static_cast<double (frc::LinearSystemLoop<States, Inputs, Outputs>::*)(int) const>(
&frc::LinearSystemLoop<States, Inputs, Outputs>::Xhat),
      py::arg("i"), release_gil(), py::doc(
    "Returns an element of the observer's state estimate x-hat.\n"
"\n"
":param i: Row of x-hat.")
  )
    
      .def("nextR", static_cast<const Eigen::Vector<double, States> & (frc::LinearSystemLoop<States, Inputs, Outputs>::*)() const>(
&frc::LinearSystemLoop<States, Inputs, Outputs>::NextR), release_gil(), py::doc(
    "Returns the controller's next reference r.")
  )
    
      .def("nextR", static_cast<double (frc::LinearSystemLoop<States, Inputs, Outputs>::*)(int) const>(
&frc::LinearSystemLoop<States, Inputs, Outputs>::NextR),
      py::arg("i"), release_gil(), py::doc(
    "Returns an element of the controller's next reference r.\n"
"\n"
":param i: Row of r.")
  )
    
      .def("U", static_cast<Eigen::Vector<double, Inputs > (frc::LinearSystemLoop<States, Inputs, Outputs>::*)() const>(
&frc::LinearSystemLoop<States, Inputs, Outputs>::U), release_gil(), py::doc(
    "Returns the controller's calculated control input u.")
  )
    
      .def("U", static_cast<double (frc::LinearSystemLoop<States, Inputs, Outputs>::*)(int) const>(
&frc::LinearSystemLoop<States, Inputs, Outputs>::U),
      py::arg("i"), release_gil(), py::doc(
    "Returns an element of the controller's calculated control input u.\n"
"\n"
":param i: Row of u.")
  )
    
      .def("setXhat", static_cast<void (frc::LinearSystemLoop<States, Inputs, Outputs>::*)(const Eigen::Vector<double, States>&)>(
&frc::LinearSystemLoop<States, Inputs, Outputs>::SetXhat),
      py::arg("xHat"), release_gil(), py::doc(
    "Set the initial state estimate x-hat.\n"
"\n"
":param xHat: The initial state estimate x-hat.")
  )
    
      .def("setXhat", static_cast<void (frc::LinearSystemLoop<States, Inputs, Outputs>::*)(int, double)>(
&frc::LinearSystemLoop<States, Inputs, Outputs>::SetXhat),
      py::arg("i"), py::arg("value"), release_gil(), py::doc(
    "Set an element of the initial state estimate x-hat.\n"
"\n"
":param i:     Row of x-hat.\n"
":param value: Value for element of x-hat.")
  )
    
      .def("setNextR", &frc::LinearSystemLoop<States, Inputs, Outputs>::SetNextR,
      py::arg("nextR"), release_gil(), py::doc(
    "Set the next reference r.\n"
"\n"
":param nextR: Next reference.")
  )
    
      .def("reset", &frc::LinearSystemLoop<States, Inputs, Outputs>::Reset,
      py::arg("initialState"), release_gil(), py::doc(
    "Zeroes reference r and controller output u. The previous reference\n"
"of the PlantInversionFeedforward and the initial state estimate of\n"
"the KalmanFilter are set to the initial state provided.\n"
"\n"
":param initialState: The initial state.")
  )
    
      .def("error", &frc::LinearSystemLoop<States, Inputs, Outputs>::Error, release_gil(), py::doc(
    "Returns difference between reference r and current state x-hat.")
  )
    
      .def("correct", &frc::LinearSystemLoop<States, Inputs, Outputs>::Correct,
      py::arg("y"), release_gil(), py::doc(
    "Correct the state estimate x-hat using the measurements in y.\n"
"\n"
":param y: Measurement vector.")
  )
    
      .def("predict", &frc::LinearSystemLoop<States, Inputs, Outputs>::Predict,
      py::arg("dt"), release_gil(), py::doc(
    "Sets new controller output, projects model forward, and runs observer\n"
"prediction.\n"
"\n"
"After calling this, the user should send the elements of u to the\n"
"actuators.\n"
"\n"
":param dt: Timestep for model update.")
  )
    
      .def("clampInput", &frc::LinearSystemLoop<States, Inputs, Outputs>::ClampInput,
      py::arg("u"), release_gil(), py::doc(
    "Clamps input vector between system's minimum and maximum allowable input.\n"
"\n"
":param u: Input vector to clamp.\n"
"\n"
":returns: Clamped input vector.")
  )
    
;

  

    if (set_doc) {
        cls_LinearSystemLoop.doc() = set_doc;
    }
    if (add_doc) {
        cls_LinearSystemLoop.doc() = py::cast<std::string>(cls_LinearSystemLoop.doc()) + add_doc;
    }

    
}

}; // struct bind_frc__LinearSystemLoop

}; // namespace rpygen