
 

// This file is autogenerated. DO NOT EDIT

#pragma once
#include <robotpy_build.h>


#include <../../_impl/include/frc/controller/LinearPlantInversionFeedforward.h>





namespace rpygen {

using namespace frc;


template <int States, int Inputs>
struct bind_frc__LinearPlantInversionFeedforward {

    

    py::class_<typename frc::LinearPlantInversionFeedforward<States, Inputs>> cls_LinearPlantInversionFeedforward;




    py::module &m;
    std::string clsName;

bind_frc__LinearPlantInversionFeedforward(py::module &m, const char * clsName) :
    cls_LinearPlantInversionFeedforward(m, clsName),



    m(m),
    clsName(clsName)
{
    
}

void finish(const char * set_doc = NULL, const char * add_doc = NULL) {

    cls_LinearPlantInversionFeedforward.doc() =
    "Constructs a plant inversion model-based feedforward from a LinearSystem.\n"
"\n"
"The feedforward is calculated as :strong:` u_ff = B:sup:`+` (r_k+1 - A\n"
"r_k) `, where :strong:` B:sup:`+` ` is the pseudoinverse\n"
"of B.\n"
"\n"
"For more on the underlying math, read\n"
"https://file.tavsys.net/control/controls-engineering-in-frc.pdf.\n"
"\n"
"@tparam States The number of states.\n"
"@tparam Inputs The number of inputs.";

  cls_LinearPlantInversionFeedforward
      .def(py::init<const Eigen::Matrix<double, States, States>&, const Eigen::Matrix<double, States, Inputs>&, units::second_t>(),
      py::arg("A"), py::arg("B"), py::arg("dt"), release_gil()    , py::keep_alive<1, 2>()    , py::keep_alive<1, 3>(), py::doc(
    "Constructs a feedforward with the given coefficients.\n"
"\n"
":param A:  Continuous system matrix of the plant being controlled.\n"
":param B:  Continuous input matrix of the plant being controlled.\n"
":param dt: Discretization timestep.")
  )
    
      .def("uff", static_cast<const Eigen::Vector<double, Inputs> & (frc::LinearPlantInversionFeedforward<States, Inputs>::*)() const>(
&frc::LinearPlantInversionFeedforward<States, Inputs>::Uff), release_gil(), py::doc(
    "Returns the previously calculated feedforward as an input vector.\n"
"\n"
":returns: The calculated feedforward.")
  )
    
      .def("uff", static_cast<double (frc::LinearPlantInversionFeedforward<States, Inputs>::*)(int) const>(
&frc::LinearPlantInversionFeedforward<States, Inputs>::Uff),
      py::arg("i"), release_gil(), py::doc(
    "Returns an element of the previously calculated feedforward.\n"
"\n"
":param i: Row of uff.\n"
"\n"
":returns: The row of the calculated feedforward.")
  )
    
      .def("R", static_cast<const Eigen::Vector<double, States> & (frc::LinearPlantInversionFeedforward<States, Inputs>::*)() const>(
&frc::LinearPlantInversionFeedforward<States, Inputs>::R), release_gil(), py::doc(
    "Returns the current reference vector r.\n"
"\n"
":returns: The current reference vector.")
  )
    
      .def("R", static_cast<double (frc::LinearPlantInversionFeedforward<States, Inputs>::*)(int) const>(
&frc::LinearPlantInversionFeedforward<States, Inputs>::R),
      py::arg("i"), release_gil(), py::doc(
    "Returns an element of the reference vector r.\n"
"\n"
":param i: Row of r.\n"
"\n"
":returns: The row of the current reference vector.")
  )
    
      .def("reset", static_cast<void (frc::LinearPlantInversionFeedforward<States, Inputs>::*)(const Eigen::Vector<double, States>&)>(
&frc::LinearPlantInversionFeedforward<States, Inputs>::Reset),
      py::arg("initialState"), release_gil(), py::doc(
    "Resets the feedforward with a specified initial state vector.\n"
"\n"
":param initialState: The initial state vector.")
  )
    
      .def("reset", static_cast<void (frc::LinearPlantInversionFeedforward<States, Inputs>::*)()>(
&frc::LinearPlantInversionFeedforward<States, Inputs>::Reset), release_gil(), py::doc(
    "Resets the feedforward with a zero initial state vector.")
  )
    
      .def("calculate", static_cast<Eigen::Vector<double, Inputs > (frc::LinearPlantInversionFeedforward<States, Inputs>::*)(const Eigen::Vector<double, States>&)>(
&frc::LinearPlantInversionFeedforward<States, Inputs>::Calculate),
      py::arg("nextR"), release_gil(), py::doc(
    "Calculate the feedforward with only the desired\n"
"future reference. This uses the internally stored \"current\"\n"
"reference.\n"
"\n"
"If this method is used the initial state of the system is the one set using\n"
"Reset(const Eigen::Vector<double, States>&). If the initial state is not\n"
"set it defaults to a zero vector.\n"
"\n"
":param nextR: The reference state of the future timestep (k + dt).\n"
"\n"
":returns: The calculated feedforward.")
  )
    
      .def("calculate", static_cast<Eigen::Vector<double, Inputs > (frc::LinearPlantInversionFeedforward<States, Inputs>::*)(const Eigen::Vector<double, States>&, const Eigen::Vector<double, States>&)>(
&frc::LinearPlantInversionFeedforward<States, Inputs>::Calculate),
      py::arg("r"), py::arg("nextR"), release_gil(), py::doc(
    "Calculate the feedforward with current and future reference vectors.\n"
"\n"
":param r:     The reference state of the current timestep (k).\n"
":param nextR: The reference state of the future timestep (k + dt).\n"
"\n"
":returns: The calculated feedforward.")
  )
    
;

  

    if (set_doc) {
        cls_LinearPlantInversionFeedforward.doc() = set_doc;
    }
    if (add_doc) {
        cls_LinearPlantInversionFeedforward.doc() = py::cast<std::string>(cls_LinearPlantInversionFeedforward.doc()) + add_doc;
    }

    cls_LinearPlantInversionFeedforward
  .def(py::init<const frc::LinearSystem<States, Inputs, 1>&, units::second_t>())
  .def(py::init<const frc::LinearSystem<States, Inputs, 2>&, units::second_t>());

}

}; // struct bind_frc__LinearPlantInversionFeedforward

}; // namespace rpygen