#include "ctre/phoenix/cci/PlatformCAN_CCI.h"

namespace ctre {
namespace phoenix {
/** platform namespace */
namespace platform {
/** platform-can namespace */
namespace can {

/**
 * Configures the can interface for API
 */
class PlatformCAN {
public:
    /**
     * Set CAN interface
     * @param canInterface Can interface to set. Linux example: "can0".
     * @return ErrorCode generated by function
     * @deprecated pass the CAN interface to device constructors instead,
     *             or call RegisterCANbus
     */
    static int32_t SetCANInterface(const char * canInterface);

    /**
     * Registers a non-compliant CANbus
     * @param canbus CANbus to register. Linux example: "can0".
     * @return ErrorCode generated by function
     */
    static int32_t RegisterCANbus(char const *canbus);

    /**
     * Starts all items in interface
     */
    static int32_t StartAll();

    /**
     * Destroys all items in interface
     */
    static int32_t DestroyAll();

    /**
     * Set Autocache state
     * @param state state of autocache
     */
    static void SetAutocacheLevel(ctre::phoenix::AutocacheState state);
};

}
}
}
}
