"""Data models for Firework sandbox client."""

from dataclasses import dataclass, field
from datetime import datetime, timezone
from typing import Optional, List, Dict, Any


@dataclass
class SandboxInfo:
    """Information about a sandbox instance."""

    id: str
    root_path: str
    state: str  # "running", "paused", "stopped"
    vcpu: int
    memory_mb: int
    created_at: datetime
    last_used_at: datetime
    template: str = "base"
    name: Optional[str] = None


@dataclass
class ProcessResult:
    """Result of a process execution."""

    stdout: str
    stderr: str
    exit_code: int
    runtime_seconds: float


@dataclass
class ProcessStreamEvent:
    """Event from a streaming process execution."""

    type: str  # "stdout", "stderr", "exit"
    content: str = ""
    exit_code: int = 0


@dataclass
class FileEntry:
    """Entry in a directory listing."""

    name: str
    size: int
    type: str  # "file", "directory", "symlink"
    modified_at: Optional[datetime] = None


@dataclass
class SandboxMetrics:
    """Resource metrics for a sandbox."""

    cpu_percent: float
    memory_mb: float
    disk_mb_used: float
    uptime_seconds: float
    process_count: int


@dataclass
class SSHInfo:
    """SSH connection information for a sandbox."""

    host: str
    port: int
    user: str = "root"
