"""Firework - Local sandbox client for Firecracker/Docker execution.

A high-level, local-only client library for managing sandboxes with
E2B/Daytona ergonomics. No authentication, no remote APIs - just pure
local execution.

Example:
    async with Sandbox.create(template="base") as sandbox:
        result = await sandbox.process.exec("echo Hello")
        print(result.stdout)

Available environments:
    - base: Minimal Python 3.11
    - python-ml: NumPy, Pandas, Scikit-learn
    - python-torch: PyTorch for deep learning
    - python-tensorflow: TensorFlow for deep learning
    - python-data: Polars, DuckDB, PyArrow
    - python-web: FastAPI, HTTPX, Pydantic
    - python-llm: OpenAI, Anthropic, LangChain
    - nodejs: Node.js 20 runtime
"""

from firework.config import LocalConfig
from firework.sandbox import Sandbox
from firework.models import (
    SandboxInfo,
    ProcessResult,
    ProcessStreamEvent,
    FileEntry,
    SandboxMetrics,
)
from firework.exceptions import (
    SandboxError,
    SandboxNotFound,
    SandboxTimeout,
    ProcessExecutionError,
    FilesystemError,
)
from firework.environments import (
    EnvironmentSpec,
    EnvironmentBuilder,
    BuiltEnvironment,
    list_environments,
    get_environment,
    BUILT_IN_ENVIRONMENTS,
)

__version__ = "0.1.0"
__all__ = [
    # Core
    "Sandbox",
    "LocalConfig",
    # Models
    "SandboxInfo",
    "ProcessResult",
    "ProcessStreamEvent",
    "FileEntry",
    "SandboxMetrics",
    # Exceptions
    "SandboxError",
    "SandboxNotFound",
    "SandboxTimeout",
    "ProcessExecutionError",
    "FilesystemError",
    # Environments
    "EnvironmentSpec",
    "EnvironmentBuilder",
    "BuiltEnvironment",
    "list_environments",
    "get_environment",
    "BUILT_IN_ENVIRONMENTS",
]
