#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu May 19 11:01:22 2022 by generateDS.py version 2.40.13.
# Python 3.7.7 (default, May  7 2020, 21:25:33)  [GCC 7.3.0]
#
# Command line options:
#   ('-o', 'nml.py')
#   ('--use-getter-setter', 'none')
#   ('--user-methods', 'helper_methods.py')
#
# Command line arguments:
#   NeuroML_v2.3.xsd
#
# Command line:
#   /home/padraig/anaconda2/envs/py37//bin/generateDS -o "nml.py" --use-getter-setter="none" --user-methods="helper_methods.py" NeuroML_v2.3.xsd
#
# Current working directory (os.getcwd()):
#   nml
#

import sys

try:
    ModulenotfoundExp_ = ModuleNotFoundError
except NameError:
    ModulenotfoundExp_ = ImportError
from six.moves import zip_longest
import os
import re as re_
import base64
import datetime as datetime_
import decimal as decimal_
from lxml import etree as etree_


Validate_simpletypes_ = True
SaveElementTreeNode = True
TagNamePrefix = ""
if sys.version_info.major == 2:
    BaseStrType_ = basestring
else:
    BaseStrType_ = str


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    try:
        if isinstance(infile, os.PathLike):
            infile = os.path.join(infile)
    except AttributeError:
        pass
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc


def parsexmlstring_(instring, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        try:
            parser = etree_.ETCompatXMLParser()
        except AttributeError:
            # fallback to xml.etree
            parser = etree_.XMLParser()
    element = etree_.fromstring(instring, parser=parser, **kwargs)
    return element


#
# Namespace prefix definition table (and other attributes, too)
#
# The module generatedsnamespaces, if it is importable, must contain
# a dictionary named GeneratedsNamespaceDefs.  This Python dictionary
# should map element type names (strings) to XML schema namespace prefix
# definitions.  The export method for any class for which there is
# a namespace prefix definition, will export that definition in the
# XML representation of that element.  See the export method of
# any generated element type class for an example of the use of this
# table.
# A sample table is:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceDefs = {
#         "ElementtypeA": "http://www.xxx.com/namespaceA",
#         "ElementtypeB": "http://www.xxx.com/namespaceB",
#     }
#
# Additionally, the generatedsnamespaces module can contain a python
# dictionary named GenerateDSNamespaceTypePrefixes that associates element
# types with the namespace prefixes that are to be added to the
# "xsi:type" attribute value.  See the _exportAttributes method of
# any generated element type and the generation of "xsi:type" for an
# example of the use of this table.
# An example table:
#
#     # File: generatedsnamespaces.py
#
#     GenerateDSNamespaceTypePrefixes = {
#         "ElementtypeC": "aaa:",
#         "ElementtypeD": "bbb:",
#     }
#

try:
    from generatedsnamespaces import GenerateDSNamespaceDefs as GenerateDSNamespaceDefs_
except ModulenotfoundExp_:
    GenerateDSNamespaceDefs_ = {}
try:
    from generatedsnamespaces import (
        GenerateDSNamespaceTypePrefixes as GenerateDSNamespaceTypePrefixes_,
    )
except ModulenotfoundExp_:
    GenerateDSNamespaceTypePrefixes_ = {}

#
# You can replace the following class definition by defining an
# importable module named "generatedscollector" containing a class
# named "GdsCollector".  See the default class definition below for
# clues about the possible content of that class.
#
try:
    from generatedscollector import GdsCollector as GdsCollector_
except ModulenotfoundExp_:

    class GdsCollector_(object):
        def __init__(self, messages=None):
            if messages is None:
                self.messages = []
            else:
                self.messages = messages

        def add_message(self, msg):
            self.messages.append(msg)

        def get_messages(self):
            return self.messages

        def clear_messages(self):
            self.messages = []

        def print_messages(self):
            for msg in self.messages:
                print("Warning: {}".format(msg))

        def write_messages(self, outstream):
            for msg in self.messages:
                outstream.write("Warning: {}\n".format(msg))


#
# The super-class for enum types
#

try:
    from enum import Enum
except ModulenotfoundExp_:
    Enum = object

#
# The root super-class for element type classes
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ModulenotfoundExp_ as exp:
    try:
        from generatedssupersuper import GeneratedsSuperSuper
    except ModulenotfoundExp_ as exp:

        class GeneratedsSuperSuper(object):
            pass

    class GeneratedsSuper(GeneratedsSuperSuper):
        __hash__ = object.__hash__
        tzoff_pattern = re_.compile(r"(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$")

        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name

            def utcoffset(self, dt):
                return self.__offset

            def tzname(self, dt):
                return self.__name

            def dst(self, dt):
                return None

        def __str__(self):
            settings = {
                "str_pretty_print": True,
                "str_indent_level": 0,
                "str_namespaceprefix": "",
                "str_name": self.__class__.__name__,
                "str_namespacedefs": "",
            }
            for n in settings:
                if hasattr(self, n):
                    settings[n] = getattr(self, n)
            if sys.version_info.major == 2:
                from StringIO import StringIO
            else:
                from io import StringIO
            output = StringIO()
            self.export(
                output,
                settings["str_indent_level"],
                pretty_print=settings["str_pretty_print"],
                namespaceprefix_=settings["str_namespaceprefix"],
                name_=settings["str_name"],
                namespacedef_=settings["str_namespacedefs"],
            )
            strval = output.getvalue()
            output.close()
            return strval

        def gds_format_string(self, input_data, input_name=""):
            return input_data

        def gds_parse_string(self, input_data, node=None, input_name=""):
            return input_data

        def gds_validate_string(self, input_data, node=None, input_name=""):
            if not input_data:
                return ""
            else:
                return input_data

        def gds_format_base64(self, input_data, input_name=""):
            return base64.b64encode(input_data).decode("ascii")

        def gds_validate_base64(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_integer(self, input_data, input_name=""):
            return "%d" % int(input_data)

        def gds_parse_integer(self, input_data, node=None, input_name=""):
            try:
                ival = int(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, "Requires integer value: %s" % exp)
            return ival

        def gds_validate_integer(self, input_data, node=None, input_name=""):
            try:
                value = int(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, "Requires integer value")
            return value

        def gds_format_integer_list(self, input_data, input_name=""):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return "%s" % " ".join(input_data)

        def gds_validate_integer_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, "Requires sequence of integer values")
            return values

        def gds_format_float(self, input_data, input_name=""):
            return ("%.15f" % float(input_data)).rstrip("0")

        def gds_parse_float(self, input_data, node=None, input_name=""):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, "Requires float or double value: %s" % exp)
            return fval_

        def gds_validate_float(self, input_data, node=None, input_name=""):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, "Requires float value")
            return value

        def gds_format_float_list(self, input_data, input_name=""):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return "%s" % " ".join(input_data)

        def gds_validate_float_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, "Requires sequence of float values")
            return values

        def gds_format_decimal(self, input_data, input_name=""):
            return_value = "%s" % input_data
            if "." in return_value:
                return_value = return_value.rstrip("0")
                if return_value.endswith("."):
                    return_value = return_value.rstrip(".")
            return return_value

        def gds_parse_decimal(self, input_data, node=None, input_name=""):
            try:
                decimal_value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, "Requires decimal value")
            return decimal_value

        def gds_validate_decimal(self, input_data, node=None, input_name=""):
            try:
                value = decimal_.Decimal(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, "Requires decimal value")
            return value

        def gds_format_decimal_list(self, input_data, input_name=""):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return " ".join([self.gds_format_decimal(item) for item in input_data])

        def gds_validate_decimal_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    decimal_.Decimal(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, "Requires sequence of decimal values")
            return values

        def gds_format_double(self, input_data, input_name=""):
            return "%s" % input_data

        def gds_parse_double(self, input_data, node=None, input_name=""):
            try:
                fval_ = float(input_data)
            except (TypeError, ValueError) as exp:
                raise_parse_error(node, "Requires double or float value: %s" % exp)
            return fval_

        def gds_validate_double(self, input_data, node=None, input_name=""):
            try:
                value = float(input_data)
            except (TypeError, ValueError):
                raise_parse_error(node, "Requires double or float value")
            return value

        def gds_format_double_list(self, input_data, input_name=""):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return "%s" % " ".join(input_data)

        def gds_validate_double_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(
                        node, "Requires sequence of double or float values"
                    )
            return values

        def gds_format_boolean(self, input_data, input_name=""):
            return ("%s" % input_data).lower()

        def gds_parse_boolean(self, input_data, node=None, input_name=""):
            input_data = input_data.strip()
            if input_data in ("true", "1"):
                bval = True
            elif input_data in ("false", "0"):
                bval = False
            else:
                raise_parse_error(node, "Requires boolean value")
            return bval

        def gds_validate_boolean(self, input_data, node=None, input_name=""):
            if input_data not in (
                True,
                1,
                False,
                0,
            ):
                raise_parse_error(
                    node, "Requires boolean value " "(one of True, 1, False, 0)"
                )
            return input_data

        def gds_format_boolean_list(self, input_data, input_name=""):
            if len(input_data) > 0 and not isinstance(input_data[0], BaseStrType_):
                input_data = [str(s) for s in input_data]
            return "%s" % " ".join(input_data)

        def gds_validate_boolean_list(self, input_data, node=None, input_name=""):
            values = input_data.split()
            for value in values:
                value = self.gds_parse_boolean(value, node, input_name)
                if value not in (
                    True,
                    1,
                    False,
                    0,
                ):
                    raise_parse_error(
                        node,
                        "Requires sequence of boolean values "
                        "(one of True, 1, False, 0)",
                    )
            return values

        def gds_validate_datetime(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_datetime(self, input_data, input_name=""):
            if input_data.microsecond == 0:
                _svalue = "%04d-%02d-%02dT%02d:%02d:%02d" % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = "%04d-%02d-%02dT%02d:%02d:%02d.%s" % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ("%f" % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += "Z"
                    else:
                        if total_seconds < 0:
                            _svalue += "-"
                            total_seconds *= -1
                        else:
                            _svalue += "+"
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += "{0:02d}:{1:02d}".format(hours, minutes)
            return _svalue

        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == "Z":
                tz = GeneratedsSuper._FixedOffsetTZ(0, "UTC")
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(":")
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == "-":
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split(".")
            if len(time_parts) > 1:
                micro_seconds = int(float("0." + time_parts[1]) * 1000000)
                input_data = "%s.%s" % (
                    time_parts[0],
                    "{}".format(micro_seconds).rjust(6, "0"),
                )
                dt = datetime_.datetime.strptime(input_data, "%Y-%m-%dT%H:%M:%S.%f")
            else:
                dt = datetime_.datetime.strptime(input_data, "%Y-%m-%dT%H:%M:%S")
            dt = dt.replace(tzinfo=tz)
            return dt

        def gds_validate_date(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_date(self, input_data, input_name=""):
            _svalue = "%04d-%02d-%02d" % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += "Z"
                        else:
                            if total_seconds < 0:
                                _svalue += "-"
                                total_seconds *= -1
                            else:
                                _svalue += "+"
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += "{0:02d}:{1:02d}".format(hours, minutes)
            except AttributeError:
                pass
            return _svalue

        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == "Z":
                tz = GeneratedsSuper._FixedOffsetTZ(0, "UTC")
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(":")
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == "-":
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, "%Y-%m-%d")
            dt = dt.replace(tzinfo=tz)
            return dt.date()

        def gds_validate_time(self, input_data, node=None, input_name=""):
            return input_data

        def gds_format_time(self, input_data, input_name=""):
            if input_data.microsecond == 0:
                _svalue = "%02d:%02d:%02d" % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = "%02d:%02d:%02d.%s" % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ("%f" % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += "Z"
                    else:
                        if total_seconds < 0:
                            _svalue += "-"
                            total_seconds *= -1
                        else:
                            _svalue += "+"
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += "{0:02d}:{1:02d}".format(hours, minutes)
            return _svalue

        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.
            # The target value must match at least one of the patterns
            # in order for the test to succeed.
            found1 = True
            target = str(target)
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    mo = re_.search(patterns2, target)
                    if mo is not None and len(mo.group(0)) == len(target):
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1

        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == "Z":
                tz = GeneratedsSuper._FixedOffsetTZ(0, "UTC")
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(":")
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == "-":
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split(".")) > 1:
                dt = datetime_.datetime.strptime(input_data, "%H:%M:%S.%f")
            else:
                dt = datetime_.datetime.strptime(input_data, "%H:%M:%S")
            dt = dt.replace(tzinfo=tz)
            return dt.time()

        def gds_check_cardinality_(
            self, value, input_name, min_occurs=0, max_occurs=1, required=None
        ):
            if value is None:
                length = 0
            elif isinstance(value, list):
                length = len(value)
            else:
                length = 1
            if required is not None:
                if required and length < 1:
                    self.gds_collector_.add_message(
                        "Required value {}{} is missing".format(
                            input_name, self.gds_get_node_lineno_()
                        )
                    )
            if length < min_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is below "
                    "the minimum allowed, "
                    "expected at least {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(), min_occurs, length
                    )
                )
            elif length > max_occurs:
                self.gds_collector_.add_message(
                    "Number of values for {}{} is above "
                    "the maximum allowed, "
                    "expected at most {}, found {}".format(
                        input_name, self.gds_get_node_lineno_(), max_occurs, length
                    )
                )

        def gds_validate_builtin_ST_(
            self,
            validator,
            value,
            input_name,
            min_occurs=None,
            max_occurs=None,
            required=None,
        ):
            if value is not None:
                try:
                    validator(value, input_name=input_name)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))

        def gds_validate_defined_ST_(
            self,
            validator,
            value,
            input_name,
            min_occurs=None,
            max_occurs=None,
            required=None,
        ):
            if value is not None:
                try:
                    validator(value)
                except GDSParseError as parse_error:
                    self.gds_collector_.add_message(str(parse_error))

        def gds_str_lower(self, instring):
            return instring.lower()

        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = "/".join(path_list)
            return path

        Tag_strip_pattern_ = re_.compile(r"\{.*\}")

        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub("", node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)

        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if "xsi" in node.nsmap:
                classname = node.get("{%s}type" % node.nsmap["xsi"])
                if classname is not None:
                    names = classname.split(":")
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1

        def gds_build_any(self, node, type_name=None):
            # provide default value in case option --disable-xml is used.
            content = ""
            content = etree_.tostring(node, encoding="unicode")
            return content

        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.items()))

        @staticmethod
        def gds_encode(instring):
            if sys.version_info.major == 2:
                if ExternalEncoding:
                    encoding = ExternalEncoding
                else:
                    encoding = "utf-8"
                return instring.encode(encoding)
            else:
                return instring

        @staticmethod
        def convert_unicode(instring):
            if isinstance(instring, str):
                result = quote_xml(instring)
            elif sys.version_info.major == 2 and isinstance(instring, unicode):
                result = quote_xml(instring).encode("utf8")
            else:
                result = GeneratedsSuper.gds_encode(str(instring))
            return result

        def __eq__(self, other):
            def excl_select_objs_(obj):
                return obj[0] != "parent_object_" and obj[0] != "gds_collector_"

            if type(self) != type(other):
                return False
            return all(
                x == y
                for x, y in zip_longest(
                    filter(excl_select_objs_, self.__dict__.items()),
                    filter(excl_select_objs_, other.__dict__.items()),
                )
            )

        def __ne__(self, other):
            return not self.__eq__(other)

        # Django ETL transform hooks.
        def gds_djo_etl_transform(self):
            pass

        def gds_djo_etl_transform_db_obj(self, dbobj):
            pass

        # SQLAlchemy ETL transform hooks.
        def gds_sqa_etl_transform(self):
            return 0, None

        def gds_sqa_etl_transform_db_obj(self, dbobj):
            pass

        def gds_get_node_lineno_(self):
            if (
                hasattr(self, "gds_elementtree_node_")
                and self.gds_elementtree_node_ is not None
            ):
                return " near line {}".format(self.gds_elementtree_node_.sourceline)
            else:
                return ""

    def getSubclassFromModule_(module, class_):
        """Get the subclass of a class from a specific module."""
        name = class_.__name__ + "Sub"
        if hasattr(module, name):
            return getattr(module, name)
        else:
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = ""
# Set this to false in order to deactivate during export, the use of
# name space prefixes captured from the input document.
UseCapturedNS_ = True
CapturedNsmap_ = {}
Tag_pattern_ = re_.compile(r"({.*})?(.*)")
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r"{(.*)}(.*)")
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

# Change this to redirect the generated superclass module to use a
# specific subclass module.
CurrentSubclassModule_ = None

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write("    ")


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ""
    s1 = isinstance(inStr, BaseStrType_) and inStr or "%s" % inStr
    s2 = ""
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos : mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start() : mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace("&", "&amp;")
    s1 = s1.replace("<", "&lt;")
    s1 = s1.replace(">", "&gt;")
    return s1


def quote_attrib(inStr):
    s1 = isinstance(inStr, BaseStrType_) and inStr or "%s" % inStr
    s1 = s1.replace("&", "&amp;")
    s1 = s1.replace("<", "&lt;")
    s1 = s1.replace(">", "&gt;")
    s1 = s1.replace("\n", "&#10;")
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find("\n") == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find("\n") == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ""
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(":")
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        if prefix == "xml":
            namespace = "http://www.w3.org/XML/1998/namespace"
        else:
            namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get(
                "{%s}%s"
                % (
                    namespace,
                    name,
                )
            )
    return value


def encode_str_2_3(instr):
    return instr


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if node is not None:
        msg = "%s (element %s/line %d)" % (
            msg,
            node.tag,
            node.sourceline,
        )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8

    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value

    def getCategory(self):
        return self.category

    def getContenttype(self, content_type):
        return self.content_type

    def getValue(self):
        return self.value

    def getName(self):
        return self.name

    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:  # category == MixedContainer.CategoryComplex
            self.value.export(
                outfile, level, namespace, name_=name, pretty_print=pretty_print
            )

    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write("<%s>%s</%s>" % (self.name, self.value, self.name))
        elif (
            self.content_type == MixedContainer.TypeInteger
            or self.content_type == MixedContainer.TypeBoolean
        ):
            outfile.write("<%s>%d</%s>" % (self.name, self.value, self.name))
        elif (
            self.content_type == MixedContainer.TypeFloat
            or self.content_type == MixedContainer.TypeDecimal
        ):
            outfile.write("<%s>%f</%s>" % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write("<%s>%g</%s>" % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write(
                "<%s>%s</%s>" % (self.name, base64.b64encode(self.value), self.name)
            )

    def to_etree(self, element, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, "%s" % self.name)
            subelement.text = self.to_etree_simple()
        else:  # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)

    def to_etree_simple(self, mapping_=None, reverse_mapping_=None, nsmap_=None):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (
            self.content_type == MixedContainer.TypeInteger
            or self.content_type == MixedContainer.TypeBoolean
        ):
            text = "%d" % self.value
        elif (
            self.content_type == MixedContainer.TypeFloat
            or self.content_type == MixedContainer.TypeDecimal
        ):
            text = "%f" % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = "%g" % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = "%s" % base64.b64encode(self.value)
        return text

    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value)
            )
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n'
                % (self.category, self.content_type, self.name, self.value)
            )
        else:  # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n'
                % (
                    self.category,
                    self.content_type,
                    self.name,
                )
            )
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(")\n")


class MemberSpec_(object):
    def __init__(
        self,
        name="",
        data_type="",
        container=0,
        optional=0,
        child_attrs=None,
        choice=None,
    ):
        self.name = name
        self.data_type = data_type
        self.container = container
        self.child_attrs = child_attrs
        self.choice = choice
        self.optional = optional

    def set_name(self, name):
        self.name = name

    def get_name(self):
        return self.name

    def set_data_type(self, data_type):
        self.data_type = data_type

    def get_data_type_chain(self):
        return self.data_type

    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return "xs:string"
        else:
            return self.data_type

    def set_container(self, container):
        self.container = container

    def get_container(self):
        return self.container

    def set_child_attrs(self, child_attrs):
        self.child_attrs = child_attrs

    def get_child_attrs(self):
        return self.child_attrs

    def set_choice(self, choice):
        self.choice = choice

    def get_choice(self):
        return self.choice

    def set_optional(self, optional):
        self.optional = optional

    def get_optional(self):
        return self.optional


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)


#
# Data representation classes.
#


class BlockTypes(str, Enum):
    VOLTAGE_CONC_DEP_BLOCK_MECHANISM = "voltageConcDepBlockMechanism"


class Metric(str, Enum):
    """Metric -- Allowed metrics for InhomogeneousParam"""

    PATH_LENGTHFROMROOT = "Path Length from root"


class PlasticityTypes(str, Enum):
    TSODYKS_MARKRAM_DEP_MECHANISM = "tsodyksMarkramDepMechanism"
    TSODYKS_MARKRAM_DEP_FAC_MECHANISM = "tsodyksMarkramDepFacMechanism"


class ZeroOrOne(str, Enum):
    """ZeroOrOne -- Value which is either 0 or 1"""

    _0 = "0"
    _1 = "1"


class allowedSpaces(str, Enum):
    EUCLIDEAN__1_D = "Euclidean_1D"
    EUCLIDEAN__2_D = "Euclidean_2D"
    EUCLIDEAN__3_D = "Euclidean_3D"
    GRID__1_D = "Grid_1D"
    GRID__2_D = "Grid_2D"
    GRID__3_D = "Grid_3D"


class channelTypes(str, Enum):
    ION_CHANNEL_PASSIVE = "ionChannelPassive"
    ION_CHANNEL_HH = "ionChannelHH"


class gateTypes(str, Enum):
    GATE_H_HRATES = "gateHHrates"
    GATE_H_HRATES_TAU = "gateHHratesTau"
    GATE_H_HTAU_INF = "gateHHtauInf"
    GATE_H_HRATES_INF = "gateHHratesInf"
    GATE_H_HRATES_TAU_INF = "gateHHratesTauInf"
    GATE_HH_INSTANTANEOUS = "gateHHInstantaneous"
    GATE_KS = "gateKS"
    GATE_FRACTIONAL = "gateFractional"


class networkTypes(str, Enum):
    NETWORK = "network"
    NETWORK_WITH_TEMPERATURE = "networkWithTemperature"


class populationTypes(str, Enum):
    POPULATION = "population"
    POPULATION_LIST = "populationList"


class Property(GeneratedsSuper):
    """Property -- A property ( a **tag**  and **value**  pair ), which can be on any  **baseStandalone**  either as a direct child, or within an  **Annotation** . Generally something which helps the visual display or facilitates simulation of a Component, but is not a core physiological property. Common examples include: **numberInternalDivisions,**  equivalent of nseg in NEURON; **radius,**  for a radius to use in graphical displays for abstract cells ( i. e. without defined morphologies ); **color,**  the color to use for a  **Population**  or  **populationList**  of cells; **recommended_dt_ms,**  the recommended timestep to use for simulating a  **Network** , **recommended_duration_ms**  the recommended duration to use when running a  **Network**"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("tag", "xs:string", 0, 0, {"use": "required", "name": "tag"}),
        MemberSpec_("value", "xs:string", 0, 0, {"use": "required", "name": "value"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, tag=None, value=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.tag = _cast(None, tag)
        self.tag_nsprefix_ = None
        self.value = _cast(None, value)
        self.value_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Property)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Property.subclass:
            return Property.subclass(*args_, **kwargs_)
        else:
            return Property(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Property",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Property")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Property":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Property"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Property",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Property"
    ):
        if self.tag is not None and "tag" not in already_processed:
            already_processed.add("tag")
            outfile.write(
                " tag=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.tag), input_name="tag")
                    ),
                )
            )
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Property",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("tag", node)
        if value is not None and "tag" not in already_processed:
            already_processed.add("tag")
            self.tag = value
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class Property


class Annotation(GeneratedsSuper):
    """Annotation -- A structured annotation containing metadata, specifically RDF or  **property**  elements"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "__ANY__",
            "__ANY__",
            1,
            1,
            {"maxOccurs": "unbounded", "minOccurs": "0", "processContents": "skip"},
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, anytypeobjs_=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Annotation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Annotation.subclass:
            return Annotation.subclass(*args_, **kwargs_)
        else:
            return Annotation(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if self.anytypeobjs_:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Annotation",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Annotation")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Annotation":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Annotation"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Annotation",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Annotation"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Annotation",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if not fromsubclass_:
            for obj_ in self.anytypeobjs_:
                showIndent(outfile, level, pretty_print)
                outfile.write(str(obj_))
                outfile.write("\n")

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        content_ = self.gds_build_any(child_, "Annotation")
        self.anytypeobjs_.append(content_)


# end class Annotation


class ComponentType(GeneratedsSuper):
    """ComponentType -- Contains an extension to NeuroML by creating custom LEMS ComponentType."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 0, {"use": "required", "name": "name"}),
        MemberSpec_(
            "extends", "xs:string", 0, 1, {"use": "optional", "name": "extends"}
        ),
        MemberSpec_(
            "description", "xs:string", 0, 1, {"use": "optional", "name": "description"}
        ),
        MemberSpec_(
            "Property",
            "Property",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "Property",
                "type": "LEMS_Property",
            },
            None,
        ),
        MemberSpec_(
            "Parameter",
            "Parameter",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "Parameter",
                "type": "Parameter",
            },
            None,
        ),
        MemberSpec_(
            "Constant",
            "Constant",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "Constant",
                "type": "Constant",
            },
            None,
        ),
        MemberSpec_(
            "Exposure",
            "Exposure",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "Exposure",
                "type": "Exposure",
            },
            None,
        ),
        MemberSpec_(
            "Requirement",
            "Requirement",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "Requirement",
                "type": "Requirement",
            },
            None,
        ),
        MemberSpec_(
            "InstanceRequirement",
            "InstanceRequirement",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "InstanceRequirement",
                "type": "InstanceRequirement",
            },
            None,
        ),
        MemberSpec_(
            "Dynamics",
            "Dynamics",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "Dynamics",
                "type": "Dynamics",
            },
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        name=None,
        extends=None,
        description=None,
        Property=None,
        Parameter=None,
        Constant=None,
        Exposure=None,
        Requirement=None,
        InstanceRequirement=None,
        Dynamics=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.extends = _cast(None, extends)
        self.extends_nsprefix_ = None
        self.description = _cast(None, description)
        self.description_nsprefix_ = None
        if Property is None:
            self.Property = []
        else:
            self.Property = Property
        self.Property_nsprefix_ = None
        if Parameter is None:
            self.Parameter = []
        else:
            self.Parameter = Parameter
        self.Parameter_nsprefix_ = None
        if Constant is None:
            self.Constant = []
        else:
            self.Constant = Constant
        self.Constant_nsprefix_ = None
        if Exposure is None:
            self.Exposure = []
        else:
            self.Exposure = Exposure
        self.Exposure_nsprefix_ = None
        if Requirement is None:
            self.Requirement = []
        else:
            self.Requirement = Requirement
        self.Requirement_nsprefix_ = None
        if InstanceRequirement is None:
            self.InstanceRequirement = []
        else:
            self.InstanceRequirement = InstanceRequirement
        self.InstanceRequirement_nsprefix_ = None
        if Dynamics is None:
            self.Dynamics = []
        else:
            self.Dynamics = Dynamics
        self.Dynamics_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ComponentType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ComponentType.subclass:
            return ComponentType.subclass(*args_, **kwargs_)
        else:
            return ComponentType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if (
            self.Property
            or self.Parameter
            or self.Constant
            or self.Exposure
            or self.Requirement
            or self.InstanceRequirement
            or self.Dynamics
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ComponentType",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ComponentType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ComponentType":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ComponentType"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ComponentType",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ComponentType",
    ):
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )
        if self.extends is not None and "extends" not in already_processed:
            already_processed.add("extends")
            outfile.write(
                " extends=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.extends), input_name="extends"
                        )
                    ),
                )
            )
        if self.description is not None and "description" not in already_processed:
            already_processed.add("description")
            outfile.write(
                " description=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.description), input_name="description"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ComponentType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for Property_ in self.Property:
            namespaceprefix_ = (
                self.Property_nsprefix_ + ":"
                if (UseCapturedNS_ and self.Property_nsprefix_)
                else ""
            )
            Property_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Property",
                pretty_print=pretty_print,
            )
        for Parameter_ in self.Parameter:
            namespaceprefix_ = (
                self.Parameter_nsprefix_ + ":"
                if (UseCapturedNS_ and self.Parameter_nsprefix_)
                else ""
            )
            Parameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Parameter",
                pretty_print=pretty_print,
            )
        for Constant_ in self.Constant:
            namespaceprefix_ = (
                self.Constant_nsprefix_ + ":"
                if (UseCapturedNS_ and self.Constant_nsprefix_)
                else ""
            )
            Constant_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Constant",
                pretty_print=pretty_print,
            )
        for Exposure_ in self.Exposure:
            namespaceprefix_ = (
                self.Exposure_nsprefix_ + ":"
                if (UseCapturedNS_ and self.Exposure_nsprefix_)
                else ""
            )
            Exposure_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Exposure",
                pretty_print=pretty_print,
            )
        for Requirement_ in self.Requirement:
            namespaceprefix_ = (
                self.Requirement_nsprefix_ + ":"
                if (UseCapturedNS_ and self.Requirement_nsprefix_)
                else ""
            )
            Requirement_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Requirement",
                pretty_print=pretty_print,
            )
        for InstanceRequirement_ in self.InstanceRequirement:
            namespaceprefix_ = (
                self.InstanceRequirement_nsprefix_ + ":"
                if (UseCapturedNS_ and self.InstanceRequirement_nsprefix_)
                else ""
            )
            InstanceRequirement_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="InstanceRequirement",
                pretty_print=pretty_print,
            )
        for Dynamics_ in self.Dynamics:
            namespaceprefix_ = (
                self.Dynamics_nsprefix_ + ":"
                if (UseCapturedNS_ and self.Dynamics_nsprefix_)
                else ""
            )
            Dynamics_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Dynamics",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        value = find_attr_value_("extends", node)
        if value is not None and "extends" not in already_processed:
            already_processed.add("extends")
            self.extends = value
        value = find_attr_value_("description", node)
        if value is not None and "description" not in already_processed:
            already_processed.add("description")
            self.description = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "Property":
            obj_ = LEMS_Property.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Property.append(obj_)
            obj_.original_tagname_ = "Property"
        elif nodeName_ == "Parameter":
            obj_ = Parameter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Parameter.append(obj_)
            obj_.original_tagname_ = "Parameter"
        elif nodeName_ == "Constant":
            obj_ = Constant.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Constant.append(obj_)
            obj_.original_tagname_ = "Constant"
        elif nodeName_ == "Exposure":
            obj_ = Exposure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Exposure.append(obj_)
            obj_.original_tagname_ = "Exposure"
        elif nodeName_ == "Requirement":
            obj_ = Requirement.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Requirement.append(obj_)
            obj_.original_tagname_ = "Requirement"
        elif nodeName_ == "InstanceRequirement":
            obj_ = InstanceRequirement.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.InstanceRequirement.append(obj_)
            obj_.original_tagname_ = "InstanceRequirement"
        elif nodeName_ == "Dynamics":
            obj_ = Dynamics.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Dynamics.append(obj_)
            obj_.original_tagname_ = "Dynamics"


# end class ComponentType


class Constant(GeneratedsSuper):
    """Constant -- LEMS ComponentType for Constant."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 0, {"use": "required", "name": "name"}),
        MemberSpec_(
            "dimension", "xs:string", 0, 0, {"use": "required", "name": "dimension"}
        ),
        MemberSpec_(
            "value", "Nml2Quantity", 0, 0, {"use": "required", "name": "value"}
        ),
        MemberSpec_(
            "description", "xs:string", 0, 1, {"use": "optional", "name": "description"}
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        name=None,
        dimension=None,
        value=None,
        description=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.dimension = _cast(None, dimension)
        self.dimension_nsprefix_ = None
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
        self.description = _cast(None, description)
        self.description_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Constant)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Constant.subclass:
            return Constant.subclass(*args_, **kwargs_)
        else:
            return Constant(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity(self, value):
        # Validate type Nml2Quantity, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_patterns_,
                    )
                )

    validate_Nml2Quantity_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*([_a-zA-Z0-9])*)$"]
    ]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Constant",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Constant")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Constant":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Constant"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Constant",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Constant"
    ):
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )
        if self.dimension is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            outfile.write(
                " dimension=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.dimension), input_name="dimension"
                        )
                    ),
                )
            )
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )
        if self.description is not None and "description" not in already_processed:
            already_processed.add("description")
            outfile.write(
                " description=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.description), input_name="description"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Constant",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        value = find_attr_value_("dimension", node)
        if value is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            self.dimension = value
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value
            self.validate_Nml2Quantity(self.value)  # validate type Nml2Quantity
        value = find_attr_value_("description", node)
        if value is not None and "description" not in already_processed:
            already_processed.add("description")
            self.description = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class Constant


class Exposure(GeneratedsSuper):
    """Exposure -- LEMS Exposure (ComponentType property)"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 0, {"use": "required", "name": "name"}),
        MemberSpec_(
            "dimension", "xs:string", 0, 0, {"use": "required", "name": "dimension"}
        ),
        MemberSpec_(
            "description", "xs:string", 0, 1, {"use": "optional", "name": "description"}
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        name=None,
        dimension=None,
        description=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.dimension = _cast(None, dimension)
        self.dimension_nsprefix_ = None
        self.description = _cast(None, description)
        self.description_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Exposure)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Exposure.subclass:
            return Exposure.subclass(*args_, **kwargs_)
        else:
            return Exposure(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Exposure",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Exposure")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Exposure":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Exposure"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Exposure",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Exposure"
    ):
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )
        if self.dimension is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            outfile.write(
                " dimension=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.dimension), input_name="dimension"
                        )
                    ),
                )
            )
        if self.description is not None and "description" not in already_processed:
            already_processed.add("description")
            outfile.write(
                " description=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.description), input_name="description"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Exposure",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        value = find_attr_value_("dimension", node)
        if value is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            self.dimension = value
        value = find_attr_value_("description", node)
        if value is not None and "description" not in already_processed:
            already_processed.add("description")
            self.description = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class Exposure


class NamedDimensionalType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 0, {"use": "required", "name": "name"}),
        MemberSpec_(
            "dimension", "xs:string", 0, 0, {"use": "required", "name": "dimension"}
        ),
        MemberSpec_(
            "description", "xs:string", 0, 1, {"use": "optional", "name": "description"}
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        name=None,
        dimension=None,
        description=None,
        extensiontype_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.dimension = _cast(None, dimension)
        self.dimension_nsprefix_ = None
        self.description = _cast(None, description)
        self.description_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NamedDimensionalType
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NamedDimensionalType.subclass:
            return NamedDimensionalType.subclass(*args_, **kwargs_)
        else:
            return NamedDimensionalType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="NamedDimensionalType",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("NamedDimensionalType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "NamedDimensionalType":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="NamedDimensionalType",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="NamedDimensionalType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="NamedDimensionalType",
    ):
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )
        if self.dimension is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            outfile.write(
                " dimension=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.dimension), input_name="dimension"
                        )
                    ),
                )
            )
        if self.description is not None and "description" not in already_processed:
            already_processed.add("description")
            outfile.write(
                " description=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.description), input_name="description"
                        )
                    ),
                )
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="NamedDimensionalType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        value = find_attr_value_("dimension", node)
        if value is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            self.dimension = value
        value = find_attr_value_("description", node)
        if value is not None and "description" not in already_processed:
            already_processed.add("description")
            self.description = value
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class NamedDimensionalType


class NamedDimensionalVariable(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 0, {"use": "required", "name": "name"}),
        MemberSpec_(
            "dimension", "xs:string", 0, 0, {"use": "required", "name": "dimension"}
        ),
        MemberSpec_(
            "description", "xs:string", 0, 1, {"use": "optional", "name": "description"}
        ),
        MemberSpec_(
            "exposure", "xs:string", 0, 1, {"use": "optional", "name": "exposure"}
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        name=None,
        dimension=None,
        description=None,
        exposure=None,
        extensiontype_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.dimension = _cast(None, dimension)
        self.dimension_nsprefix_ = None
        self.description = _cast(None, description)
        self.description_nsprefix_ = None
        self.exposure = _cast(None, exposure)
        self.exposure_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, NamedDimensionalVariable
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if NamedDimensionalVariable.subclass:
            return NamedDimensionalVariable.subclass(*args_, **kwargs_)
        else:
            return NamedDimensionalVariable(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="NamedDimensionalVariable",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("NamedDimensionalVariable")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "NamedDimensionalVariable":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="NamedDimensionalVariable",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="NamedDimensionalVariable",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="NamedDimensionalVariable",
    ):
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )
        if self.dimension is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            outfile.write(
                " dimension=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.dimension), input_name="dimension"
                        )
                    ),
                )
            )
        if self.description is not None and "description" not in already_processed:
            already_processed.add("description")
            outfile.write(
                " description=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.description), input_name="description"
                        )
                    ),
                )
            )
        if self.exposure is not None and "exposure" not in already_processed:
            already_processed.add("exposure")
            outfile.write(
                " exposure=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.exposure), input_name="exposure"
                        )
                    ),
                )
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="NamedDimensionalVariable",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        value = find_attr_value_("dimension", node)
        if value is not None and "dimension" not in already_processed:
            already_processed.add("dimension")
            self.dimension = value
        value = find_attr_value_("description", node)
        if value is not None and "description" not in already_processed:
            already_processed.add("description")
            self.description = value
        value = find_attr_value_("exposure", node)
        if value is not None and "exposure" not in already_processed:
            already_processed.add("exposure")
            self.exposure = value
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class NamedDimensionalVariable


class Parameter(NamedDimensionalType):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = []
    subclass = None
    superclass = NamedDimensionalType

    def __init__(
        self,
        name=None,
        dimension=None,
        description=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("Parameter"), self).__init__(
            name, dimension, description, **kwargs_
        )

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Parameter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Parameter.subclass:
            return Parameter.subclass(*args_, **kwargs_)
        else:
            return Parameter(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if super(Parameter, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Parameter",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Parameter")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Parameter":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Parameter"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Parameter",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Parameter"
    ):
        super(Parameter, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Parameter"
        )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Parameter",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Parameter, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        super(Parameter, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(Parameter, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class Parameter


class LEMS_Property(NamedDimensionalType):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "default_value",
            "xs:double",
            0,
            1,
            {"use": "optional", "name": "default_value"},
        ),
    ]
    subclass = None
    superclass = NamedDimensionalType

    def __init__(
        self,
        name=None,
        dimension=None,
        description=None,
        default_value=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("LEMS_Property"), self).__init__(
            name, dimension, description, **kwargs_
        )
        self.default_value = _cast(float, default_value)
        self.default_value_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, LEMS_Property)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if LEMS_Property.subclass:
            return LEMS_Property.subclass(*args_, **kwargs_)
        else:
            return LEMS_Property(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if super(LEMS_Property, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="LEMS_Property",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("LEMS_Property")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "LEMS_Property":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="LEMS_Property"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="LEMS_Property",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="LEMS_Property",
    ):
        super(LEMS_Property, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="LEMS_Property"
        )
        if self.default_value is not None and "default_value" not in already_processed:
            already_processed.add("default_value")
            outfile.write(
                ' defaultValue="%s"'
                % self.gds_format_double(self.default_value, input_name="defaultValue")
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="LEMS_Property",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(LEMS_Property, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("defaultValue", node)
        if value is not None and "defaultValue" not in already_processed:
            already_processed.add("defaultValue")
            value = self.gds_parse_double(value, node, "defaultValue")
            self.default_value = value
        super(LEMS_Property, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(LEMS_Property, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class LEMS_Property


class Requirement(NamedDimensionalType):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = []
    subclass = None
    superclass = NamedDimensionalType

    def __init__(
        self,
        name=None,
        dimension=None,
        description=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("Requirement"), self).__init__(
            name, dimension, description, **kwargs_
        )

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Requirement)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Requirement.subclass:
            return Requirement.subclass(*args_, **kwargs_)
        else:
            return Requirement(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if super(Requirement, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Requirement",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Requirement")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Requirement":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Requirement"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Requirement",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="Requirement",
    ):
        super(Requirement, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Requirement"
        )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Requirement",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Requirement, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        super(Requirement, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(Requirement, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class Requirement


class InstanceRequirement(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 0, {"use": "required", "name": "name"}),
        MemberSpec_("type", "xs:string", 0, 0, {"use": "required", "name": "type"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, name=None, type=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.type = _cast(None, type)
        self.type_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InstanceRequirement
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InstanceRequirement.subclass:
            return InstanceRequirement.subclass(*args_, **kwargs_)
        else:
            return InstanceRequirement(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InstanceRequirement",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("InstanceRequirement")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "InstanceRequirement":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="InstanceRequirement",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="InstanceRequirement",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="InstanceRequirement",
    ):
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type), input_name="type"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InstanceRequirement",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class InstanceRequirement


class Dynamics(GeneratedsSuper):
    """Dynamics -- LEMS ComponentType for Dynamics"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "StateVariable",
            "StateVariable",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "StateVariable",
                "type": "StateVariable",
            },
            None,
        ),
        MemberSpec_(
            "DerivedVariable",
            "DerivedVariable",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "DerivedVariable",
                "type": "DerivedVariable",
            },
            None,
        ),
        MemberSpec_(
            "ConditionalDerivedVariable",
            "ConditionalDerivedVariable",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "ConditionalDerivedVariable",
                "type": "ConditionalDerivedVariable",
            },
            None,
        ),
        MemberSpec_(
            "TimeDerivative",
            "TimeDerivative",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "TimeDerivative",
                "type": "TimeDerivative",
            },
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        StateVariable=None,
        DerivedVariable=None,
        ConditionalDerivedVariable=None,
        TimeDerivative=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if StateVariable is None:
            self.StateVariable = []
        else:
            self.StateVariable = StateVariable
        self.StateVariable_nsprefix_ = None
        if DerivedVariable is None:
            self.DerivedVariable = []
        else:
            self.DerivedVariable = DerivedVariable
        self.DerivedVariable_nsprefix_ = None
        if ConditionalDerivedVariable is None:
            self.ConditionalDerivedVariable = []
        else:
            self.ConditionalDerivedVariable = ConditionalDerivedVariable
        self.ConditionalDerivedVariable_nsprefix_ = None
        if TimeDerivative is None:
            self.TimeDerivative = []
        else:
            self.TimeDerivative = TimeDerivative
        self.TimeDerivative_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Dynamics)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Dynamics.subclass:
            return Dynamics.subclass(*args_, **kwargs_)
        else:
            return Dynamics(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if (
            self.StateVariable
            or self.DerivedVariable
            or self.ConditionalDerivedVariable
            or self.TimeDerivative
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Dynamics",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Dynamics")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Dynamics":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Dynamics"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Dynamics",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Dynamics"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Dynamics",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for StateVariable_ in self.StateVariable:
            namespaceprefix_ = (
                self.StateVariable_nsprefix_ + ":"
                if (UseCapturedNS_ and self.StateVariable_nsprefix_)
                else ""
            )
            StateVariable_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="StateVariable",
                pretty_print=pretty_print,
            )
        for DerivedVariable_ in self.DerivedVariable:
            namespaceprefix_ = (
                self.DerivedVariable_nsprefix_ + ":"
                if (UseCapturedNS_ and self.DerivedVariable_nsprefix_)
                else ""
            )
            DerivedVariable_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="DerivedVariable",
                pretty_print=pretty_print,
            )
        for ConditionalDerivedVariable_ in self.ConditionalDerivedVariable:
            namespaceprefix_ = (
                self.ConditionalDerivedVariable_nsprefix_ + ":"
                if (UseCapturedNS_ and self.ConditionalDerivedVariable_nsprefix_)
                else ""
            )
            ConditionalDerivedVariable_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="ConditionalDerivedVariable",
                pretty_print=pretty_print,
            )
        for TimeDerivative_ in self.TimeDerivative:
            namespaceprefix_ = (
                self.TimeDerivative_nsprefix_ + ":"
                if (UseCapturedNS_ and self.TimeDerivative_nsprefix_)
                else ""
            )
            TimeDerivative_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="TimeDerivative",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "StateVariable":
            obj_ = StateVariable.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.StateVariable.append(obj_)
            obj_.original_tagname_ = "StateVariable"
        elif nodeName_ == "DerivedVariable":
            obj_ = DerivedVariable.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.DerivedVariable.append(obj_)
            obj_.original_tagname_ = "DerivedVariable"
        elif nodeName_ == "ConditionalDerivedVariable":
            obj_ = ConditionalDerivedVariable.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ConditionalDerivedVariable.append(obj_)
            obj_.original_tagname_ = "ConditionalDerivedVariable"
        elif nodeName_ == "TimeDerivative":
            obj_ = TimeDerivative.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.TimeDerivative.append(obj_)
            obj_.original_tagname_ = "TimeDerivative"


# end class Dynamics


class DerivedVariable(NamedDimensionalVariable):
    """DerivedVariable -- LEMS ComponentType for DerivedVariable"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("value", "xs:string", 0, 1, {"use": "optional", "name": "value"}),
        MemberSpec_("select", "xs:string", 0, 1, {"use": "optional", "name": "select"}),
    ]
    subclass = None
    superclass = NamedDimensionalVariable

    def __init__(
        self,
        name=None,
        dimension=None,
        description=None,
        exposure=None,
        value=None,
        select=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("DerivedVariable"), self).__init__(
            name, dimension, description, exposure, **kwargs_
        )
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
        self.select = _cast(None, select)
        self.select_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, DerivedVariable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DerivedVariable.subclass:
            return DerivedVariable.subclass(*args_, **kwargs_)
        else:
            return DerivedVariable(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if super(DerivedVariable, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DerivedVariable",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("DerivedVariable")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "DerivedVariable":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="DerivedVariable"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="DerivedVariable",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="DerivedVariable",
    ):
        super(DerivedVariable, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="DerivedVariable"
        )
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )
        if self.select is not None and "select" not in already_processed:
            already_processed.add("select")
            outfile.write(
                " select=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.select), input_name="select"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DerivedVariable",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(DerivedVariable, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value
        value = find_attr_value_("select", node)
        if value is not None and "select" not in already_processed:
            already_processed.add("select")
            self.select = value
        super(DerivedVariable, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(DerivedVariable, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class DerivedVariable


class StateVariable(NamedDimensionalVariable):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = []
    subclass = None
    superclass = NamedDimensionalVariable

    def __init__(
        self,
        name=None,
        dimension=None,
        description=None,
        exposure=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("StateVariable"), self).__init__(
            name, dimension, description, exposure, **kwargs_
        )

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, StateVariable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if StateVariable.subclass:
            return StateVariable.subclass(*args_, **kwargs_)
        else:
            return StateVariable(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if super(StateVariable, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="StateVariable",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("StateVariable")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "StateVariable":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="StateVariable"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="StateVariable",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="StateVariable",
    ):
        super(StateVariable, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="StateVariable"
        )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="StateVariable",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(StateVariable, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        super(StateVariable, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(StateVariable, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class StateVariable


class ConditionalDerivedVariable(NamedDimensionalVariable):
    """ConditionalDerivedVariable -- LEMS ComponentType for ConditionalDerivedVariable"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "Case",
            "Case",
            1,
            0,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "1",
                "name": "Case",
                "type": "Case",
            },
            None,
        ),
    ]
    subclass = None
    superclass = NamedDimensionalVariable

    def __init__(
        self,
        name=None,
        dimension=None,
        description=None,
        exposure=None,
        Case=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("ConditionalDerivedVariable"), self).__init__(
            name, dimension, description, exposure, **kwargs_
        )
        if Case is None:
            self.Case = []
        else:
            self.Case = Case
        self.Case_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ConditionalDerivedVariable
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ConditionalDerivedVariable.subclass:
            return ConditionalDerivedVariable.subclass(*args_, **kwargs_)
        else:
            return ConditionalDerivedVariable(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if self.Case or super(ConditionalDerivedVariable, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ConditionalDerivedVariable",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ConditionalDerivedVariable")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ConditionalDerivedVariable":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ConditionalDerivedVariable",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ConditionalDerivedVariable",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ConditionalDerivedVariable",
    ):
        super(ConditionalDerivedVariable, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ConditionalDerivedVariable",
        )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ConditionalDerivedVariable",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ConditionalDerivedVariable, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for Case_ in self.Case:
            namespaceprefix_ = (
                self.Case_nsprefix_ + ":"
                if (UseCapturedNS_ and self.Case_nsprefix_)
                else ""
            )
            Case_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="Case",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        super(ConditionalDerivedVariable, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "Case":
            obj_ = Case.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.Case.append(obj_)
            obj_.original_tagname_ = "Case"
        super(ConditionalDerivedVariable, self)._buildChildren(
            child_, node, nodeName_, True
        )


# end class ConditionalDerivedVariable


class Case(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "condition", "xs:string", 0, 1, {"use": "optional", "name": "condition"}
        ),
        MemberSpec_("value", "xs:string", 0, 0, {"use": "required", "name": "value"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, condition=None, value=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.condition = _cast(None, condition)
        self.condition_nsprefix_ = None
        self.value = _cast(None, value)
        self.value_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Case)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Case.subclass:
            return Case.subclass(*args_, **kwargs_)
        else:
            return Case(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Case",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Case")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Case":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Case"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Case",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Case"
    ):
        if self.condition is not None and "condition" not in already_processed:
            already_processed.add("condition")
            outfile.write(
                " condition=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.condition), input_name="condition"
                        )
                    ),
                )
            )
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Case",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("condition", node)
        if value is not None and "condition" not in already_processed:
            already_processed.add("condition")
            self.condition = value
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class Case


class TimeDerivative(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "variable", "xs:string", 0, 0, {"use": "required", "name": "variable"}
        ),
        MemberSpec_("value", "xs:string", 0, 0, {"use": "required", "name": "value"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, variable=None, value=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.variable = _cast(None, variable)
        self.variable_nsprefix_ = None
        self.value = _cast(None, value)
        self.value_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, TimeDerivative)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TimeDerivative.subclass:
            return TimeDerivative.subclass(*args_, **kwargs_)
        else:
            return TimeDerivative(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TimeDerivative",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("TimeDerivative")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "TimeDerivative":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="TimeDerivative"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="TimeDerivative",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="TimeDerivative",
    ):
        if self.variable is not None and "variable" not in already_processed:
            already_processed.add("variable")
            outfile.write(
                " variable=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.variable), input_name="variable"
                        )
                    ),
                )
            )
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TimeDerivative",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("variable", node)
        if value is not None and "variable" not in already_processed:
            already_processed.add("variable")
            self.variable = value
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class TimeDerivative


class IncludeType(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("href", "xs:anyURI", 0, 0, {"use": "required", "name": "href"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, href=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.href = _cast(None, href)
        self.href_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, IncludeType)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IncludeType.subclass:
            return IncludeType.subclass(*args_, **kwargs_)
        else:
            return IncludeType(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IncludeType",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("IncludeType")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "IncludeType":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="IncludeType"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="IncludeType",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="IncludeType",
    ):
        if self.href is not None and "href" not in already_processed:
            already_processed.add("href")
            outfile.write(
                " href=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.href), input_name="href"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IncludeType",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("href", node)
        if value is not None and "href" not in already_processed:
            already_processed.add("href")
            self.href = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class IncludeType


class Q10ConductanceScaling(GeneratedsSuper):
    """Q10ConductanceScaling -- A value for the conductance scaling which varies as a standard function of the difference between the current temperature, **temperature,**  and the temperature at which the conductance was originally determined, **experimentalTemp**
    \n
    :param q10Factor:
    :type q10Factor: none
    :param experimentalTemp:
    :type experimentalTemp: temperature

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "q10_factor",
            "Nml2Quantity_none",
            0,
            0,
            {"use": "required", "name": "q10_factor"},
        ),
        MemberSpec_(
            "experimental_temp",
            "Nml2Quantity_temperature",
            0,
            0,
            {"use": "required", "name": "experimental_temp"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, q10_factor=None, experimental_temp=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.q10_factor = _cast(None, q10_factor)
        self.q10_factor_nsprefix_ = None
        self.experimental_temp = _cast(None, experimental_temp)
        self.experimental_temp_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, Q10ConductanceScaling
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Q10ConductanceScaling.subclass:
            return Q10ConductanceScaling.subclass(*args_, **kwargs_)
        else:
            return Q10ConductanceScaling(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_none_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_none_patterns_,
                    )
                )

    validate_Nml2Quantity_none_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?)$"]
    ]

    def validate_Nml2Quantity_temperature(self, value):
        # Validate type Nml2Quantity_temperature, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_temperature_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_temperature_patterns_,
                    )
                )

    validate_Nml2Quantity_temperature_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(degC))$"]
    ]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Q10ConductanceScaling",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Q10ConductanceScaling")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Q10ConductanceScaling":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="Q10ConductanceScaling",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Q10ConductanceScaling",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="Q10ConductanceScaling",
    ):
        if self.q10_factor is not None and "q10_factor" not in already_processed:
            already_processed.add("q10_factor")
            outfile.write(
                " q10Factor=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.q10_factor), input_name="q10Factor"
                        )
                    ),
                )
            )
        if (
            self.experimental_temp is not None
            and "experimental_temp" not in already_processed
        ):
            already_processed.add("experimental_temp")
            outfile.write(
                " experimentalTemp=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.experimental_temp),
                            input_name="experimentalTemp",
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Q10ConductanceScaling",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("q10Factor", node)
        if value is not None and "q10Factor" not in already_processed:
            already_processed.add("q10Factor")
            self.q10_factor = value
            self.validate_Nml2Quantity_none(
                self.q10_factor
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("experimentalTemp", node)
        if value is not None and "experimentalTemp" not in already_processed:
            already_processed.add("experimentalTemp")
            self.experimental_temp = value
            self.validate_Nml2Quantity_temperature(
                self.experimental_temp
            )  # validate type Nml2Quantity_temperature

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class Q10ConductanceScaling


class Q10Settings(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("type", "NmlId", 0, 0, {"use": "required", "name": "type"}),
        MemberSpec_(
            "fixed_q10",
            "Nml2Quantity_none",
            0,
            1,
            {"use": "optional", "name": "fixed_q10"},
        ),
        MemberSpec_(
            "q10_factor",
            "Nml2Quantity_none",
            0,
            1,
            {"use": "optional", "name": "q10_factor"},
        ),
        MemberSpec_(
            "experimental_temp",
            "Nml2Quantity_temperature",
            0,
            1,
            {"use": "optional", "name": "experimental_temp"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        type=None,
        fixed_q10=None,
        q10_factor=None,
        experimental_temp=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.type = _cast(None, type)
        self.type_nsprefix_ = None
        self.fixed_q10 = _cast(None, fixed_q10)
        self.fixed_q10_nsprefix_ = None
        self.q10_factor = _cast(None, q10_factor)
        self.q10_factor_nsprefix_ = None
        self.experimental_temp = _cast(None, experimental_temp)
        self.experimental_temp_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Q10Settings)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Q10Settings.subclass:
            return Q10Settings.subclass(*args_, **kwargs_)
        else:
            return Q10Settings(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_none_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_none_patterns_,
                    )
                )

    validate_Nml2Quantity_none_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?)$"]
    ]

    def validate_Nml2Quantity_temperature(self, value):
        # Validate type Nml2Quantity_temperature, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_temperature_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_temperature_patterns_,
                    )
                )

    validate_Nml2Quantity_temperature_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(degC))$"]
    ]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Q10Settings",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Q10Settings")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Q10Settings":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Q10Settings"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Q10Settings",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="Q10Settings",
    ):
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type), input_name="type"
                        )
                    ),
                )
            )
        if self.fixed_q10 is not None and "fixed_q10" not in already_processed:
            already_processed.add("fixed_q10")
            outfile.write(
                " fixedQ10=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.fixed_q10), input_name="fixedQ10"
                        )
                    ),
                )
            )
        if self.q10_factor is not None and "q10_factor" not in already_processed:
            already_processed.add("q10_factor")
            outfile.write(
                " q10Factor=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.q10_factor), input_name="q10Factor"
                        )
                    ),
                )
            )
        if (
            self.experimental_temp is not None
            and "experimental_temp" not in already_processed
        ):
            already_processed.add("experimental_temp")
            outfile.write(
                " experimentalTemp=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.experimental_temp),
                            input_name="experimentalTemp",
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Q10Settings",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_NmlId(self.type)  # validate type NmlId
        value = find_attr_value_("fixedQ10", node)
        if value is not None and "fixedQ10" not in already_processed:
            already_processed.add("fixedQ10")
            self.fixed_q10 = value
            self.validate_Nml2Quantity_none(
                self.fixed_q10
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("q10Factor", node)
        if value is not None and "q10Factor" not in already_processed:
            already_processed.add("q10Factor")
            self.q10_factor = value
            self.validate_Nml2Quantity_none(
                self.q10_factor
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("experimentalTemp", node)
        if value is not None and "experimentalTemp" not in already_processed:
            already_processed.add("experimentalTemp")
            self.experimental_temp = value
            self.validate_Nml2Quantity_temperature(
                self.experimental_temp
            )  # validate type Nml2Quantity_temperature

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class Q10Settings


class HHRate(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("type", "NmlId", 0, 0, {"use": "required", "name": "type"}),
        MemberSpec_(
            "rate", "Nml2Quantity_pertime", 0, 1, {"use": "optional", "name": "rate"}
        ),
        MemberSpec_(
            "midpoint",
            "Nml2Quantity_voltage",
            0,
            1,
            {"use": "optional", "name": "midpoint"},
        ),
        MemberSpec_(
            "scale", "Nml2Quantity_voltage", 0, 1, {"use": "optional", "name": "scale"}
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        type=None,
        rate=None,
        midpoint=None,
        scale=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.type = _cast(None, type)
        self.type_nsprefix_ = None
        self.rate = _cast(None, rate)
        self.rate_nsprefix_ = None
        self.midpoint = _cast(None, midpoint)
        self.midpoint_nsprefix_ = None
        self.scale = _cast(None, scale)
        self.scale_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, HHRate)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HHRate.subclass:
            return HHRate.subclass(*args_, **kwargs_)
        else:
            return HHRate(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_pertime_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_pertime_patterns_,
                    )
                )

    validate_Nml2Quantity_pertime_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s|per_ms|Hz))$"]
    ]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV))$"]
    ]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="HHRate",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("HHRate")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "HHRate":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="HHRate"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="HHRate",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="HHRate"
    ):
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type), input_name="type"
                        )
                    ),
                )
            )
        if self.rate is not None and "rate" not in already_processed:
            already_processed.add("rate")
            outfile.write(
                " rate=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.rate), input_name="rate"
                        )
                    ),
                )
            )
        if self.midpoint is not None and "midpoint" not in already_processed:
            already_processed.add("midpoint")
            outfile.write(
                " midpoint=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.midpoint), input_name="midpoint"
                        )
                    ),
                )
            )
        if self.scale is not None and "scale" not in already_processed:
            already_processed.add("scale")
            outfile.write(
                " scale=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.scale), input_name="scale"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="HHRate",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_NmlId(self.type)  # validate type NmlId
        value = find_attr_value_("rate", node)
        if value is not None and "rate" not in already_processed:
            already_processed.add("rate")
            self.rate = value
            self.validate_Nml2Quantity_pertime(
                self.rate
            )  # validate type Nml2Quantity_pertime
        value = find_attr_value_("midpoint", node)
        if value is not None and "midpoint" not in already_processed:
            already_processed.add("midpoint")
            self.midpoint = value
            self.validate_Nml2Quantity_voltage(
                self.midpoint
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("scale", node)
        if value is not None and "scale" not in already_processed:
            already_processed.add("scale")
            self.scale = value
            self.validate_Nml2Quantity_voltage(
                self.scale
            )  # validate type Nml2Quantity_voltage

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class HHRate


class HHVariable(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("type", "NmlId", 0, 0, {"use": "required", "name": "type"}),
        MemberSpec_("rate", "xs:float", 0, 1, {"use": "optional", "name": "rate"}),
        MemberSpec_(
            "midpoint",
            "Nml2Quantity_voltage",
            0,
            1,
            {"use": "optional", "name": "midpoint"},
        ),
        MemberSpec_(
            "scale", "Nml2Quantity_voltage", 0, 1, {"use": "optional", "name": "scale"}
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        type=None,
        rate=None,
        midpoint=None,
        scale=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.type = _cast(None, type)
        self.type_nsprefix_ = None
        self.rate = _cast(float, rate)
        self.rate_nsprefix_ = None
        self.midpoint = _cast(None, midpoint)
        self.midpoint_nsprefix_ = None
        self.scale = _cast(None, scale)
        self.scale_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, HHVariable)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HHVariable.subclass:
            return HHVariable.subclass(*args_, **kwargs_)
        else:
            return HHVariable(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV))$"]
    ]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="HHVariable",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("HHVariable")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "HHVariable":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="HHVariable"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="HHVariable",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="HHVariable"
    ):
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type), input_name="type"
                        )
                    ),
                )
            )
        if self.rate is not None and "rate" not in already_processed:
            already_processed.add("rate")
            outfile.write(
                ' rate="%s"' % self.gds_format_float(self.rate, input_name="rate")
            )
        if self.midpoint is not None and "midpoint" not in already_processed:
            already_processed.add("midpoint")
            outfile.write(
                " midpoint=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.midpoint), input_name="midpoint"
                        )
                    ),
                )
            )
        if self.scale is not None and "scale" not in already_processed:
            already_processed.add("scale")
            outfile.write(
                " scale=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.scale), input_name="scale"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="HHVariable",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_NmlId(self.type)  # validate type NmlId
        value = find_attr_value_("rate", node)
        if value is not None and "rate" not in already_processed:
            already_processed.add("rate")
            value = self.gds_parse_float(value, node, "rate")
            self.rate = value
        value = find_attr_value_("midpoint", node)
        if value is not None and "midpoint" not in already_processed:
            already_processed.add("midpoint")
            self.midpoint = value
            self.validate_Nml2Quantity_voltage(
                self.midpoint
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("scale", node)
        if value is not None and "scale" not in already_processed:
            already_processed.add("scale")
            self.scale = value
            self.validate_Nml2Quantity_voltage(
                self.scale
            )  # validate type Nml2Quantity_voltage

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class HHVariable


class HHTime(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("type", "NmlId", 0, 0, {"use": "required", "name": "type"}),
        MemberSpec_(
            "rate", "Nml2Quantity_time", 0, 1, {"use": "optional", "name": "rate"}
        ),
        MemberSpec_(
            "midpoint",
            "Nml2Quantity_voltage",
            0,
            1,
            {"use": "optional", "name": "midpoint"},
        ),
        MemberSpec_(
            "scale", "Nml2Quantity_voltage", 0, 1, {"use": "optional", "name": "scale"}
        ),
        MemberSpec_(
            "tau", "Nml2Quantity_time", 0, 1, {"use": "optional", "name": "tau"}
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        type=None,
        rate=None,
        midpoint=None,
        scale=None,
        tau=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.type = _cast(None, type)
        self.type_nsprefix_ = None
        self.rate = _cast(None, rate)
        self.rate_nsprefix_ = None
        self.midpoint = _cast(None, midpoint)
        self.midpoint_nsprefix_ = None
        self.scale = _cast(None, scale)
        self.scale_nsprefix_ = None
        self.tau = _cast(None, tau)
        self.tau_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, HHTime)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if HHTime.subclass:
            return HHTime.subclass(*args_, **kwargs_)
        else:
            return HHTime(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV))$"]
    ]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="HHTime",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("HHTime")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "HHTime":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="HHTime"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="HHTime",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="HHTime"
    ):
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type), input_name="type"
                        )
                    ),
                )
            )
        if self.rate is not None and "rate" not in already_processed:
            already_processed.add("rate")
            outfile.write(
                " rate=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.rate), input_name="rate"
                        )
                    ),
                )
            )
        if self.midpoint is not None and "midpoint" not in already_processed:
            already_processed.add("midpoint")
            outfile.write(
                " midpoint=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.midpoint), input_name="midpoint"
                        )
                    ),
                )
            )
        if self.scale is not None and "scale" not in already_processed:
            already_processed.add("scale")
            outfile.write(
                " scale=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.scale), input_name="scale"
                        )
                    ),
                )
            )
        if self.tau is not None and "tau" not in already_processed:
            already_processed.add("tau")
            outfile.write(
                " tau=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.tau), input_name="tau")
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="HHTime",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_NmlId(self.type)  # validate type NmlId
        value = find_attr_value_("rate", node)
        if value is not None and "rate" not in already_processed:
            already_processed.add("rate")
            self.rate = value
            self.validate_Nml2Quantity_time(
                self.rate
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("midpoint", node)
        if value is not None and "midpoint" not in already_processed:
            already_processed.add("midpoint")
            self.midpoint = value
            self.validate_Nml2Quantity_voltage(
                self.midpoint
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("scale", node)
        if value is not None and "scale" not in already_processed:
            already_processed.add("scale")
            self.scale = value
            self.validate_Nml2Quantity_voltage(
                self.scale
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("tau", node)
        if value is not None and "tau" not in already_processed:
            already_processed.add("tau")
            self.tau = value
            self.validate_Nml2Quantity_time(self.tau)  # validate type Nml2Quantity_time

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class HHTime


class BlockMechanism(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("type", "BlockTypes", 0, 0, {"use": "required", "name": "type"}),
        MemberSpec_("species", "NmlId", 0, 0, {"use": "required", "name": "species"}),
        MemberSpec_(
            "block_concentration",
            "Nml2Quantity_concentration",
            0,
            0,
            {"use": "required", "name": "block_concentration"},
        ),
        MemberSpec_(
            "scaling_conc",
            "Nml2Quantity_concentration",
            0,
            0,
            {"use": "required", "name": "scaling_conc"},
        ),
        MemberSpec_(
            "scaling_volt",
            "Nml2Quantity_voltage",
            0,
            0,
            {"use": "required", "name": "scaling_volt"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        type=None,
        species=None,
        block_concentration=None,
        scaling_conc=None,
        scaling_volt=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.type = _cast(None, type)
        self.type_nsprefix_ = None
        self.species = _cast(None, species)
        self.species_nsprefix_ = None
        self.block_concentration = _cast(None, block_concentration)
        self.block_concentration_nsprefix_ = None
        self.scaling_conc = _cast(None, scaling_conc)
        self.scaling_conc_nsprefix_ = None
        self.scaling_volt = _cast(None, scaling_volt)
        self.scaling_volt_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, BlockMechanism)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BlockMechanism.subclass:
            return BlockMechanism.subclass(*args_, **kwargs_)
        else:
            return BlockMechanism(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_BlockTypes(self, value):
        # Validate type BlockTypes, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            value = value
            enumerations = ["voltageConcDepBlockMechanism"]
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on BlockTypes'
                    % {"value": encode_str_2_3(value), "lineno": lineno}
                )
                result = False

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_Nml2Quantity_concentration(self, value):
        # Validate type Nml2Quantity_concentration, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_concentration_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_concentration_patterns_,
                    )
                )

    validate_Nml2Quantity_concentration_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(mol_per_m3|mol_per_cm3|M|mM))$"]
    ]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV))$"]
    ]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BlockMechanism",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BlockMechanism")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "BlockMechanism":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BlockMechanism"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BlockMechanism",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BlockMechanism",
    ):
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type), input_name="type"
                        )
                    ),
                )
            )
        if self.species is not None and "species" not in already_processed:
            already_processed.add("species")
            outfile.write(
                " species=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.species), input_name="species"
                        )
                    ),
                )
            )
        if (
            self.block_concentration is not None
            and "block_concentration" not in already_processed
        ):
            already_processed.add("block_concentration")
            outfile.write(
                " blockConcentration=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.block_concentration),
                            input_name="blockConcentration",
                        )
                    ),
                )
            )
        if self.scaling_conc is not None and "scaling_conc" not in already_processed:
            already_processed.add("scaling_conc")
            outfile.write(
                " scalingConc=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.scaling_conc), input_name="scalingConc"
                        )
                    ),
                )
            )
        if self.scaling_volt is not None and "scaling_volt" not in already_processed:
            already_processed.add("scaling_volt")
            outfile.write(
                " scalingVolt=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.scaling_volt), input_name="scalingVolt"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BlockMechanism",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_BlockTypes(self.type)  # validate type BlockTypes
        value = find_attr_value_("species", node)
        if value is not None and "species" not in already_processed:
            already_processed.add("species")
            self.species = value
            self.validate_NmlId(self.species)  # validate type NmlId
        value = find_attr_value_("blockConcentration", node)
        if value is not None and "blockConcentration" not in already_processed:
            already_processed.add("blockConcentration")
            self.block_concentration = value
            self.validate_Nml2Quantity_concentration(
                self.block_concentration
            )  # validate type Nml2Quantity_concentration
        value = find_attr_value_("scalingConc", node)
        if value is not None and "scalingConc" not in already_processed:
            already_processed.add("scalingConc")
            self.scaling_conc = value
            self.validate_Nml2Quantity_concentration(
                self.scaling_conc
            )  # validate type Nml2Quantity_concentration
        value = find_attr_value_("scalingVolt", node)
        if value is not None and "scalingVolt" not in already_processed:
            already_processed.add("scalingVolt")
            self.scaling_volt = value
            self.validate_Nml2Quantity_voltage(
                self.scaling_volt
            )  # validate type Nml2Quantity_voltage

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class BlockMechanism


class PlasticityMechanism(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "type", "PlasticityTypes", 0, 0, {"use": "required", "name": "type"}
        ),
        MemberSpec_(
            "init_release_prob",
            "ZeroToOne",
            0,
            0,
            {"use": "required", "name": "init_release_prob"},
        ),
        MemberSpec_(
            "tau_rec", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "tau_rec"}
        ),
        MemberSpec_(
            "tau_fac", "Nml2Quantity_time", 0, 1, {"use": "optional", "name": "tau_fac"}
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        type=None,
        init_release_prob=None,
        tau_rec=None,
        tau_fac=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.type = _cast(None, type)
        self.type_nsprefix_ = None
        self.init_release_prob = _cast(float, init_release_prob)
        self.init_release_prob_nsprefix_ = None
        self.tau_rec = _cast(None, tau_rec)
        self.tau_rec_nsprefix_ = None
        self.tau_fac = _cast(None, tau_fac)
        self.tau_fac_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PlasticityMechanism
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PlasticityMechanism.subclass:
            return PlasticityMechanism.subclass(*args_, **kwargs_)
        else:
            return PlasticityMechanism(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_PlasticityTypes(self, value):
        # Validate type PlasticityTypes, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            value = value
            enumerations = [
                "tsodyksMarkramDepMechanism",
                "tsodyksMarkramDepFacMechanism",
            ]
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on PlasticityTypes'
                    % {"value": encode_str_2_3(value), "lineno": lineno}
                )
                result = False

    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:float.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (float)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on ZeroToOne'
                    % {"value": value, "lineno": lineno}
                )
                result = False
            if value > 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on ZeroToOne'
                    % {"value": value, "lineno": lineno}
                )
                result = False

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PlasticityMechanism",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PlasticityMechanism")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "PlasticityMechanism":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="PlasticityMechanism",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PlasticityMechanism",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="PlasticityMechanism",
    ):
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type), input_name="type"
                        )
                    ),
                )
            )
        if (
            self.init_release_prob is not None
            and "init_release_prob" not in already_processed
        ):
            already_processed.add("init_release_prob")
            outfile.write(
                ' initReleaseProb="%s"'
                % self.gds_format_float(
                    self.init_release_prob, input_name="initReleaseProb"
                )
            )
        if self.tau_rec is not None and "tau_rec" not in already_processed:
            already_processed.add("tau_rec")
            outfile.write(
                " tauRec=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.tau_rec), input_name="tauRec"
                        )
                    ),
                )
            )
        if self.tau_fac is not None and "tau_fac" not in already_processed:
            already_processed.add("tau_fac")
            outfile.write(
                " tauFac=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.tau_fac), input_name="tauFac"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PlasticityMechanism",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_PlasticityTypes(self.type)  # validate type PlasticityTypes
        value = find_attr_value_("initReleaseProb", node)
        if value is not None and "initReleaseProb" not in already_processed:
            already_processed.add("initReleaseProb")
            value = self.gds_parse_float(value, node, "initReleaseProb")
            self.init_release_prob = value
            self.validate_ZeroToOne(self.init_release_prob)  # validate type ZeroToOne
        value = find_attr_value_("tauRec", node)
        if value is not None and "tauRec" not in already_processed:
            already_processed.add("tauRec")
            self.tau_rec = value
            self.validate_Nml2Quantity_time(
                self.tau_rec
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("tauFac", node)
        if value is not None and "tauFac" not in already_processed:
            already_processed.add("tauFac")
            self.tau_fac = value
            self.validate_Nml2Quantity_time(
                self.tau_fac
            )  # validate type Nml2Quantity_time

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class PlasticityMechanism


class SegmentParent(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "segments",
            "NonNegativeInteger",
            0,
            0,
            {"use": "required", "name": "segments"},
        ),
        MemberSpec_(
            "fraction_along",
            "ZeroToOne",
            0,
            1,
            {"use": "optional", "name": "fraction_along"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, segments=None, fraction_along="1", gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.segments = _cast(int, segments)
        self.segments_nsprefix_ = None
        self.fraction_along = _cast(float, fraction_along)
        self.fraction_along_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SegmentParent)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SegmentParent.subclass:
            return SegmentParent.subclass(*args_, **kwargs_)
        else:
            return SegmentParent(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            pass

    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:float.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (float)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on ZeroToOne'
                    % {"value": value, "lineno": lineno}
                )
                result = False
            if value > 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on ZeroToOne'
                    % {"value": value, "lineno": lineno}
                )
                result = False

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SegmentParent",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SegmentParent")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SegmentParent":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SegmentParent"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SegmentParent",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SegmentParent",
    ):
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(
                ' segment="%s"'
                % self.gds_format_integer(self.segments, input_name="segment")
            )
        if self.fraction_along != 1 and "fraction_along" not in already_processed:
            already_processed.add("fraction_along")
            outfile.write(
                ' fractionAlong="%s"'
                % self.gds_format_float(self.fraction_along, input_name="fractionAlong")
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SegmentParent",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            self.segments = self.gds_parse_integer(value, node, "segment")
            if self.segments < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.segments
            )  # validate type NonNegativeInteger
        value = find_attr_value_("fractionAlong", node)
        if value is not None and "fractionAlong" not in already_processed:
            already_processed.add("fractionAlong")
            value = self.gds_parse_float(value, node, "fractionAlong")
            self.fraction_along = value
            self.validate_ZeroToOne(self.fraction_along)  # validate type ZeroToOne

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class SegmentParent


class Point3DWithDiam(GeneratedsSuper):
    """Point3DWithDiam -- Base type for ComponentTypes which specify an ( **x,**  **y,**  **z**  ) coordinate along with a **diameter.**  Note: no dimension used in the attributes for these coordinates! These are assumed to have dimension micrometer ( 10^-6 m ). This is due to micrometers being the default option for the majority of neuronal morphology formats, and dimensions are omitted here to facilitate reading and writing of morphologies in NeuroML.
    \n
    :param x: x coordinate of the point. Note: no dimension used, see description of  **point3DWithDiam**  for details.
    :type x: none
    :param y: y coordinate of the ppoint. Note: no dimension used, see description of  **point3DWithDiam**  for details.
    :type y: none
    :param z: z coordinate of the ppoint. Note: no dimension used, see description of  **point3DWithDiam**  for details.
    :type z: none
    :param diameter: Diameter of the ppoint. Note: no dimension used, see description of  **point3DWithDiam**  for details.
    :type diameter: none

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("x", "xs:double", 0, 0, {"use": "required", "name": "x"}),
        MemberSpec_("y", "xs:double", 0, 0, {"use": "required", "name": "y"}),
        MemberSpec_("z", "xs:double", 0, 0, {"use": "required", "name": "z"}),
        MemberSpec_(
            "diameter",
            "DoubleGreaterThanZero",
            0,
            0,
            {"use": "required", "name": "diameter"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, x=None, y=None, z=None, diameter=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.x = _cast(float, x)
        self.x_nsprefix_ = None
        self.y = _cast(float, y)
        self.y_nsprefix_ = None
        self.z = _cast(float, z)
        self.z_nsprefix_ = None
        self.diameter = _cast(float, diameter)
        self.diameter_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Point3DWithDiam)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Point3DWithDiam.subclass:
            return Point3DWithDiam.subclass(*args_, **kwargs_)
        else:
            return Point3DWithDiam(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_DoubleGreaterThanZero(self, value):
        # Validate type DoubleGreaterThanZero, a restriction on xs:double.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (float)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if value <= 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minExclusive restriction on DoubleGreaterThanZero'
                    % {"value": value, "lineno": lineno}
                )
                result = False

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Point3DWithDiam",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Point3DWithDiam")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Point3DWithDiam":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Point3DWithDiam"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Point3DWithDiam",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="Point3DWithDiam",
    ):
        if self.x is not None and "x" not in already_processed:
            already_processed.add("x")
            outfile.write(' x="%s"' % self.gds_format_double(self.x, input_name="x"))
        if self.y is not None and "y" not in already_processed:
            already_processed.add("y")
            outfile.write(' y="%s"' % self.gds_format_double(self.y, input_name="y"))
        if self.z is not None and "z" not in already_processed:
            already_processed.add("z")
            outfile.write(' z="%s"' % self.gds_format_double(self.z, input_name="z"))
        if self.diameter is not None and "diameter" not in already_processed:
            already_processed.add("diameter")
            outfile.write(
                ' diameter="%s"'
                % self.gds_format_double(self.diameter, input_name="diameter")
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Point3DWithDiam",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("x", node)
        if value is not None and "x" not in already_processed:
            already_processed.add("x")
            value = self.gds_parse_double(value, node, "x")
            self.x = value
        value = find_attr_value_("y", node)
        if value is not None and "y" not in already_processed:
            already_processed.add("y")
            value = self.gds_parse_double(value, node, "y")
            self.y = value
        value = find_attr_value_("z", node)
        if value is not None and "z" not in already_processed:
            already_processed.add("z")
            value = self.gds_parse_double(value, node, "z")
            self.z = value
        value = find_attr_value_("diameter", node)
        if value is not None and "diameter" not in already_processed:
            already_processed.add("diameter")
            value = self.gds_parse_double(value, node, "diameter")
            self.diameter = value
            self.validate_DoubleGreaterThanZero(
                self.diameter
            )  # validate type DoubleGreaterThanZero

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass

    def __str__(self):

        return (
            "("
            + str(self.x)
            + ", "
            + str(self.y)
            + ", "
            + str(self.z)
            + "), diam "
            + str(self.diameter)
            + "um"
        )

    def __repr__(self):

        return str(self)

    def distance_to(self, other_3d_point):
        """Find the distance between this point and another.

        :param other_3d_point: other 3D point to calculate distance to
        :type other_3d_point: Point3DWithDiam
        :returns: distance between the two points
        :rtype: float
        """
        a_x = self.x
        a_y = self.y
        a_z = self.z

        b_x = other_3d_point.x
        b_y = other_3d_point.y
        b_z = other_3d_point.z

        distance = ((a_x - b_x) ** 2 + (a_y - b_y) ** 2 + (a_z - b_z) ** 2) ** (0.5)
        return distance


# end class Point3DWithDiam


class ProximalDetails(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "translation_start",
            "xs:double",
            0,
            0,
            {"use": "required", "name": "translation_start"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, translation_start=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.translation_start = _cast(float, translation_start)
        self.translation_start_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ProximalDetails)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ProximalDetails.subclass:
            return ProximalDetails.subclass(*args_, **kwargs_)
        else:
            return ProximalDetails(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ProximalDetails",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ProximalDetails")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ProximalDetails":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ProximalDetails"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ProximalDetails",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ProximalDetails",
    ):
        if (
            self.translation_start is not None
            and "translation_start" not in already_processed
        ):
            already_processed.add("translation_start")
            outfile.write(
                ' translationStart="%s"'
                % self.gds_format_double(
                    self.translation_start, input_name="translationStart"
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ProximalDetails",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("translationStart", node)
        if value is not None and "translationStart" not in already_processed:
            already_processed.add("translationStart")
            value = self.gds_parse_double(value, node, "translationStart")
            self.translation_start = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class ProximalDetails


class DistalDetails(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "normalization_end",
            "xs:double",
            0,
            0,
            {"use": "required", "name": "normalization_end"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, normalization_end=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.normalization_end = _cast(float, normalization_end)
        self.normalization_end_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, DistalDetails)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if DistalDetails.subclass:
            return DistalDetails.subclass(*args_, **kwargs_)
        else:
            return DistalDetails(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DistalDetails",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("DistalDetails")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "DistalDetails":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="DistalDetails"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="DistalDetails",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="DistalDetails",
    ):
        if (
            self.normalization_end is not None
            and "normalization_end" not in already_processed
        ):
            already_processed.add("normalization_end")
            outfile.write(
                ' normalizationEnd="%s"'
                % self.gds_format_double(
                    self.normalization_end, input_name="normalizationEnd"
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="DistalDetails",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("normalizationEnd", node)
        if value is not None and "normalizationEnd" not in already_processed:
            already_processed.add("normalizationEnd")
            value = self.gds_parse_double(value, node, "normalizationEnd")
            self.normalization_end = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class DistalDetails


class Member(GeneratedsSuper):
    """Member -- A single identified **segment**  which is part of the  **segmentGroup**"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "segments",
            "NonNegativeInteger",
            0,
            0,
            {"use": "required", "name": "segments"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, segments=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.segments = _cast(int, segments)
        self.segments_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Member)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Member.subclass:
            return Member.subclass(*args_, **kwargs_)
        else:
            return Member(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            pass

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Member",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Member")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Member":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Member"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Member",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Member"
    ):
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(
                ' segment="%s"'
                % self.gds_format_integer(self.segments, input_name="segment")
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Member",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            self.segments = self.gds_parse_integer(value, node, "segment")
            if self.segments < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.segments
            )  # validate type NonNegativeInteger

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class Member


class Include(GeneratedsSuper):
    """Include -- Include all members of another  **segmentGroup**  in this group"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "segment_groups",
            "NmlId",
            0,
            0,
            {"use": "required", "name": "segment_groups"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, segment_groups=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.segment_groups = _cast(None, segment_groups)
        self.segment_groups_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Include)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Include.subclass:
            return Include.subclass(*args_, **kwargs_)
        else:
            return Include(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Include",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Include")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Include":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Include"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Include",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Include"
    ):
        if (
            self.segment_groups is not None
            and "segment_groups" not in already_processed
        ):
            already_processed.add("segment_groups")
            outfile.write(
                " segmentGroup=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segment_groups), input_name="segmentGroup"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Include",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class Include


class Path(GeneratedsSuper):
    """Path -- Include all the  **segment** s between those specified by  **from**  and  **to** , inclusive"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "from_",
            "SegmentEndPoint",
            0,
            1,
            {"minOccurs": "0", "name": "from", "type": "SegmentEndPoint"},
            None,
        ),
        MemberSpec_(
            "to",
            "SegmentEndPoint",
            0,
            1,
            {"minOccurs": "0", "name": "to", "type": "SegmentEndPoint"},
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, from_=None, to=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.from_ = from_
        self.from__nsprefix_ = None
        self.to = to
        self.to_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Path)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Path.subclass:
            return Path.subclass(*args_, **kwargs_)
        else:
            return Path(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if self.from_ is not None or self.to is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Path",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Path")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Path":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Path"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Path",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Path"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Path",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.from_ is not None:
            namespaceprefix_ = (
                self.from__nsprefix_ + ":"
                if (UseCapturedNS_ and self.from__nsprefix_)
                else ""
            )
            self.from_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="from",
                pretty_print=pretty_print,
            )
        if self.to is not None:
            namespaceprefix_ = (
                self.to_nsprefix_ + ":"
                if (UseCapturedNS_ and self.to_nsprefix_)
                else ""
            )
            self.to.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="to",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "from":
            obj_ = SegmentEndPoint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.from_ = obj_
            obj_.original_tagname_ = "from"
        elif nodeName_ == "to":
            obj_ = SegmentEndPoint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.to = obj_
            obj_.original_tagname_ = "to"


# end class Path


class SubTree(GeneratedsSuper):
    """SubTree -- Include all the  **segment** s distal to that specified by  **from**  in the  **segmentGroup**"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "from_",
            "SegmentEndPoint",
            0,
            1,
            {"minOccurs": "0", "name": "from", "type": "SegmentEndPoint"},
            3,
        ),
        MemberSpec_(
            "to",
            "SegmentEndPoint",
            0,
            1,
            {"minOccurs": "0", "name": "to", "type": "SegmentEndPoint"},
            3,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, from_=None, to=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.from_ = from_
        self.from__nsprefix_ = None
        self.to = to
        self.to_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SubTree)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SubTree.subclass:
            return SubTree.subclass(*args_, **kwargs_)
        else:
            return SubTree(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if self.from_ is not None or self.to is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="SubTree",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SubTree")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SubTree":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SubTree"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SubTree",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="SubTree"
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="SubTree",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.from_ is not None:
            namespaceprefix_ = (
                self.from__nsprefix_ + ":"
                if (UseCapturedNS_ and self.from__nsprefix_)
                else ""
            )
            self.from_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="from",
                pretty_print=pretty_print,
            )
        if self.to is not None:
            namespaceprefix_ = (
                self.to_nsprefix_ + ":"
                if (UseCapturedNS_ and self.to_nsprefix_)
                else ""
            )
            self.to.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="to",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "from":
            obj_ = SegmentEndPoint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.from_ = obj_
            obj_.original_tagname_ = "from"
        elif nodeName_ == "to":
            obj_ = SegmentEndPoint.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.to = obj_
            obj_.original_tagname_ = "to"


# end class SubTree


class SegmentEndPoint(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "segments",
            "NonNegativeInteger",
            0,
            0,
            {"use": "required", "name": "segments"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, segments=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.segments = _cast(int, segments)
        self.segments_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SegmentEndPoint)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SegmentEndPoint.subclass:
            return SegmentEndPoint.subclass(*args_, **kwargs_)
        else:
            return SegmentEndPoint(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            pass

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SegmentEndPoint",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SegmentEndPoint")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SegmentEndPoint":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SegmentEndPoint"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SegmentEndPoint",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SegmentEndPoint",
    ):
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(
                ' segment="%s"'
                % self.gds_format_integer(self.segments, input_name="segment")
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SegmentEndPoint",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            self.segments = self.gds_parse_integer(value, node, "segment")
            if self.segments < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.segments
            )  # validate type NonNegativeInteger

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class SegmentEndPoint


class MembraneProperties(GeneratedsSuper):
    """MembraneProperties -- Properties specific to the membrane, such as the **populations**  of channels, **channelDensities,**  **specificCapacitance,**  etc."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "channel_populations",
            "ChannelPopulation",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "channelPopulation",
                "type": "ChannelPopulation",
            },
            None,
        ),
        MemberSpec_(
            "channel_densities",
            "ChannelDensity",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "channelDensity",
                "type": "ChannelDensity",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_v_shifts",
            "ChannelDensityVShift",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "channelDensityVShift",
                "type": "ChannelDensityVShift",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_nernsts",
            "ChannelDensityNernst",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "channelDensityNernst",
                "type": "ChannelDensityNernst",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_ghks",
            "ChannelDensityGHK",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "channelDensityGHK",
                "type": "ChannelDensityGHK",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_ghk2s",
            "ChannelDensityGHK2",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "channelDensityGHK2",
                "type": "ChannelDensityGHK2",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_non_uniforms",
            "ChannelDensityNonUniform",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "channelDensityNonUniform",
                "type": "ChannelDensityNonUniform",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_non_uniform_nernsts",
            "ChannelDensityNonUniformNernst",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "channelDensityNonUniformNernst",
                "type": "ChannelDensityNonUniformNernst",
            },
            None,
        ),
        MemberSpec_(
            "channel_density_non_uniform_ghks",
            "ChannelDensityNonUniformGHK",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "channelDensityNonUniformGHK",
                "type": "ChannelDensityNonUniformGHK",
            },
            None,
        ),
        MemberSpec_(
            "spike_threshes",
            "SpikeThresh",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "spikeThresh",
                "type": "SpikeThresh",
            },
            None,
        ),
        MemberSpec_(
            "specific_capacitances",
            "SpecificCapacitance",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "specificCapacitance",
                "type": "SpecificCapacitance",
            },
            None,
        ),
        MemberSpec_(
            "init_memb_potentials",
            "InitMembPotential",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "initMembPotential",
                "type": "InitMembPotential",
            },
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        channel_populations=None,
        channel_densities=None,
        channel_density_v_shifts=None,
        channel_density_nernsts=None,
        channel_density_ghks=None,
        channel_density_ghk2s=None,
        channel_density_non_uniforms=None,
        channel_density_non_uniform_nernsts=None,
        channel_density_non_uniform_ghks=None,
        spike_threshes=None,
        specific_capacitances=None,
        init_memb_potentials=None,
        extensiontype_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if channel_populations is None:
            self.channel_populations = []
        else:
            self.channel_populations = channel_populations
        self.channel_populations_nsprefix_ = None
        if channel_densities is None:
            self.channel_densities = []
        else:
            self.channel_densities = channel_densities
        self.channel_densities_nsprefix_ = None
        if channel_density_v_shifts is None:
            self.channel_density_v_shifts = []
        else:
            self.channel_density_v_shifts = channel_density_v_shifts
        self.channel_density_v_shifts_nsprefix_ = None
        if channel_density_nernsts is None:
            self.channel_density_nernsts = []
        else:
            self.channel_density_nernsts = channel_density_nernsts
        self.channel_density_nernsts_nsprefix_ = None
        if channel_density_ghks is None:
            self.channel_density_ghks = []
        else:
            self.channel_density_ghks = channel_density_ghks
        self.channel_density_ghks_nsprefix_ = None
        if channel_density_ghk2s is None:
            self.channel_density_ghk2s = []
        else:
            self.channel_density_ghk2s = channel_density_ghk2s
        self.channel_density_ghk2s_nsprefix_ = None
        if channel_density_non_uniforms is None:
            self.channel_density_non_uniforms = []
        else:
            self.channel_density_non_uniforms = channel_density_non_uniforms
        self.channel_density_non_uniforms_nsprefix_ = None
        if channel_density_non_uniform_nernsts is None:
            self.channel_density_non_uniform_nernsts = []
        else:
            self.channel_density_non_uniform_nernsts = (
                channel_density_non_uniform_nernsts
            )
        self.channel_density_non_uniform_nernsts_nsprefix_ = None
        if channel_density_non_uniform_ghks is None:
            self.channel_density_non_uniform_ghks = []
        else:
            self.channel_density_non_uniform_ghks = channel_density_non_uniform_ghks
        self.channel_density_non_uniform_ghks_nsprefix_ = None
        if spike_threshes is None:
            self.spike_threshes = []
        else:
            self.spike_threshes = spike_threshes
        self.spike_threshes_nsprefix_ = None
        if specific_capacitances is None:
            self.specific_capacitances = []
        else:
            self.specific_capacitances = specific_capacitances
        self.specific_capacitances_nsprefix_ = None
        if init_memb_potentials is None:
            self.init_memb_potentials = []
        else:
            self.init_memb_potentials = init_memb_potentials
        self.init_memb_potentials_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MembraneProperties
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MembraneProperties.subclass:
            return MembraneProperties.subclass(*args_, **kwargs_)
        else:
            return MembraneProperties(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if (
            self.channel_populations
            or self.channel_densities
            or self.channel_density_v_shifts
            or self.channel_density_nernsts
            or self.channel_density_ghks
            or self.channel_density_ghk2s
            or self.channel_density_non_uniforms
            or self.channel_density_non_uniform_nernsts
            or self.channel_density_non_uniform_ghks
            or self.spike_threshes
            or self.specific_capacitances
            or self.init_memb_potentials
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="MembraneProperties",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("MembraneProperties")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "MembraneProperties":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="MembraneProperties",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="MembraneProperties",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="MembraneProperties",
    ):
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="MembraneProperties",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for channelPopulation_ in self.channel_populations:
            namespaceprefix_ = (
                self.channel_populations_nsprefix_ + ":"
                if (UseCapturedNS_ and self.channel_populations_nsprefix_)
                else ""
            )
            channelPopulation_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelPopulation",
                pretty_print=pretty_print,
            )
        for channelDensity_ in self.channel_densities:
            namespaceprefix_ = (
                self.channel_densities_nsprefix_ + ":"
                if (UseCapturedNS_ and self.channel_densities_nsprefix_)
                else ""
            )
            channelDensity_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensity",
                pretty_print=pretty_print,
            )
        for channelDensityVShift_ in self.channel_density_v_shifts:
            namespaceprefix_ = (
                self.channel_density_v_shifts_nsprefix_ + ":"
                if (UseCapturedNS_ and self.channel_density_v_shifts_nsprefix_)
                else ""
            )
            channelDensityVShift_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityVShift",
                pretty_print=pretty_print,
            )
        for channelDensityNernst_ in self.channel_density_nernsts:
            namespaceprefix_ = (
                self.channel_density_nernsts_nsprefix_ + ":"
                if (UseCapturedNS_ and self.channel_density_nernsts_nsprefix_)
                else ""
            )
            channelDensityNernst_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityNernst",
                pretty_print=pretty_print,
            )
        for channelDensityGHK_ in self.channel_density_ghks:
            namespaceprefix_ = (
                self.channel_density_ghks_nsprefix_ + ":"
                if (UseCapturedNS_ and self.channel_density_ghks_nsprefix_)
                else ""
            )
            channelDensityGHK_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityGHK",
                pretty_print=pretty_print,
            )
        for channelDensityGHK2_ in self.channel_density_ghk2s:
            namespaceprefix_ = (
                self.channel_density_ghk2s_nsprefix_ + ":"
                if (UseCapturedNS_ and self.channel_density_ghk2s_nsprefix_)
                else ""
            )
            channelDensityGHK2_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityGHK2",
                pretty_print=pretty_print,
            )
        for channelDensityNonUniform_ in self.channel_density_non_uniforms:
            namespaceprefix_ = (
                self.channel_density_non_uniforms_nsprefix_ + ":"
                if (UseCapturedNS_ and self.channel_density_non_uniforms_nsprefix_)
                else ""
            )
            channelDensityNonUniform_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityNonUniform",
                pretty_print=pretty_print,
            )
        for channelDensityNonUniformNernst_ in self.channel_density_non_uniform_nernsts:
            namespaceprefix_ = (
                self.channel_density_non_uniform_nernsts_nsprefix_ + ":"
                if (
                    UseCapturedNS_
                    and self.channel_density_non_uniform_nernsts_nsprefix_
                )
                else ""
            )
            channelDensityNonUniformNernst_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityNonUniformNernst",
                pretty_print=pretty_print,
            )
        for channelDensityNonUniformGHK_ in self.channel_density_non_uniform_ghks:
            namespaceprefix_ = (
                self.channel_density_non_uniform_ghks_nsprefix_ + ":"
                if (UseCapturedNS_ and self.channel_density_non_uniform_ghks_nsprefix_)
                else ""
            )
            channelDensityNonUniformGHK_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityNonUniformGHK",
                pretty_print=pretty_print,
            )
        for spikeThresh_ in self.spike_threshes:
            namespaceprefix_ = (
                self.spike_threshes_nsprefix_ + ":"
                if (UseCapturedNS_ and self.spike_threshes_nsprefix_)
                else ""
            )
            spikeThresh_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="spikeThresh",
                pretty_print=pretty_print,
            )
        for specificCapacitance_ in self.specific_capacitances:
            namespaceprefix_ = (
                self.specific_capacitances_nsprefix_ + ":"
                if (UseCapturedNS_ and self.specific_capacitances_nsprefix_)
                else ""
            )
            specificCapacitance_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="specificCapacitance",
                pretty_print=pretty_print,
            )
        for initMembPotential_ in self.init_memb_potentials:
            namespaceprefix_ = (
                self.init_memb_potentials_nsprefix_ + ":"
                if (UseCapturedNS_ and self.init_memb_potentials_nsprefix_)
                else ""
            )
            initMembPotential_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="initMembPotential",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "channelPopulation":
            obj_ = ChannelPopulation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.channel_populations.append(obj_)
            obj_.original_tagname_ = "channelPopulation"
        elif nodeName_ == "channelDensity":
            class_obj_ = self.get_class_obj_(child_, ChannelDensity)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.channel_densities.append(obj_)
            obj_.original_tagname_ = "channelDensity"
        elif nodeName_ == "channelDensityVShift":
            obj_ = ChannelDensityVShift.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.channel_density_v_shifts.append(obj_)
            obj_.original_tagname_ = "channelDensityVShift"
        elif nodeName_ == "channelDensityNernst":
            class_obj_ = self.get_class_obj_(child_, ChannelDensityNernst)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.channel_density_nernsts.append(obj_)
            obj_.original_tagname_ = "channelDensityNernst"
        elif nodeName_ == "channelDensityGHK":
            obj_ = ChannelDensityGHK.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.channel_density_ghks.append(obj_)
            obj_.original_tagname_ = "channelDensityGHK"
        elif nodeName_ == "channelDensityGHK2":
            obj_ = ChannelDensityGHK2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.channel_density_ghk2s.append(obj_)
            obj_.original_tagname_ = "channelDensityGHK2"
        elif nodeName_ == "channelDensityNonUniform":
            obj_ = ChannelDensityNonUniform.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.channel_density_non_uniforms.append(obj_)
            obj_.original_tagname_ = "channelDensityNonUniform"
        elif nodeName_ == "channelDensityNonUniformNernst":
            obj_ = ChannelDensityNonUniformNernst.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.channel_density_non_uniform_nernsts.append(obj_)
            obj_.original_tagname_ = "channelDensityNonUniformNernst"
        elif nodeName_ == "channelDensityNonUniformGHK":
            obj_ = ChannelDensityNonUniformGHK.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.channel_density_non_uniform_ghks.append(obj_)
            obj_.original_tagname_ = "channelDensityNonUniformGHK"
        elif nodeName_ == "spikeThresh":
            obj_ = SpikeThresh.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.spike_threshes.append(obj_)
            obj_.original_tagname_ = "spikeThresh"
        elif nodeName_ == "specificCapacitance":
            obj_ = SpecificCapacitance.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.specific_capacitances.append(obj_)
            obj_.original_tagname_ = "specificCapacitance"
        elif nodeName_ == "initMembPotential":
            obj_ = InitMembPotential.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.init_memb_potentials.append(obj_)
            obj_.original_tagname_ = "initMembPotential"


# end class MembraneProperties


class MembraneProperties2CaPools(MembraneProperties):
    """MembraneProperties2CaPools -- Variant of membraneProperties with 2 independent Ca pools"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "channel_density_nernst_ca2s",
            "ChannelDensityNernstCa2",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "channelDensityNernstCa2",
                "type": "ChannelDensityNernstCa2",
            },
            None,
        ),
    ]
    subclass = None
    superclass = MembraneProperties

    def __init__(
        self,
        channel_populations=None,
        channel_densities=None,
        channel_density_v_shifts=None,
        channel_density_nernsts=None,
        channel_density_ghks=None,
        channel_density_ghk2s=None,
        channel_density_non_uniforms=None,
        channel_density_non_uniform_nernsts=None,
        channel_density_non_uniform_ghks=None,
        spike_threshes=None,
        specific_capacitances=None,
        init_memb_potentials=None,
        channel_density_nernst_ca2s=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("MembraneProperties2CaPools"), self).__init__(
            channel_populations,
            channel_densities,
            channel_density_v_shifts,
            channel_density_nernsts,
            channel_density_ghks,
            channel_density_ghk2s,
            channel_density_non_uniforms,
            channel_density_non_uniform_nernsts,
            channel_density_non_uniform_ghks,
            spike_threshes,
            specific_capacitances,
            init_memb_potentials,
            **kwargs_
        )
        if channel_density_nernst_ca2s is None:
            self.channel_density_nernst_ca2s = []
        else:
            self.channel_density_nernst_ca2s = channel_density_nernst_ca2s
        self.channel_density_nernst_ca2s_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, MembraneProperties2CaPools
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if MembraneProperties2CaPools.subclass:
            return MembraneProperties2CaPools.subclass(*args_, **kwargs_)
        else:
            return MembraneProperties2CaPools(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if (
            self.channel_density_nernst_ca2s
            or super(MembraneProperties2CaPools, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="MembraneProperties2CaPools",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("MembraneProperties2CaPools")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "MembraneProperties2CaPools":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="MembraneProperties2CaPools",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="MembraneProperties2CaPools",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="MembraneProperties2CaPools",
    ):
        super(MembraneProperties2CaPools, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="MembraneProperties2CaPools",
        )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="MembraneProperties2CaPools",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(MembraneProperties2CaPools, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for channelDensityNernstCa2_ in self.channel_density_nernst_ca2s:
            namespaceprefix_ = (
                self.channel_density_nernst_ca2s_nsprefix_ + ":"
                if (UseCapturedNS_ and self.channel_density_nernst_ca2s_nsprefix_)
                else ""
            )
            channelDensityNernstCa2_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="channelDensityNernstCa2",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        super(MembraneProperties2CaPools, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "channelDensityNernstCa2":
            obj_ = ChannelDensityNernstCa2.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.channel_density_nernst_ca2s.append(obj_)
            obj_.original_tagname_ = "channelDensityNernstCa2"
        super(MembraneProperties2CaPools, self)._buildChildren(
            child_, node, nodeName_, True
        )


# end class MembraneProperties2CaPools


class SpikeThresh(GeneratedsSuper):
    """SpikeThresh -- Membrane potential at which to emit a spiking event. Note, usually the spiking event will not be emitted again until the membrane potential has fallen below this value and rises again to cross it in a positive direction
    \n
    :param value:
    :type value: voltage

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "value", "Nml2Quantity_voltage", 0, 0, {"use": "required", "name": "value"}
        ),
        MemberSpec_(
            "segment_groups",
            "NmlId",
            0,
            1,
            {"use": "optional", "name": "segment_groups"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, value=None, segment_groups="all", gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
        self.segment_groups = _cast(None, segment_groups)
        self.segment_groups_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SpikeThresh)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeThresh.subclass:
            return SpikeThresh.subclass(*args_, **kwargs_)
        else:
            return SpikeThresh(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV))$"]
    ]

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeThresh",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpikeThresh")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SpikeThresh":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SpikeThresh"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpikeThresh",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpikeThresh",
    ):
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(
                " segmentGroup=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segment_groups), input_name="segmentGroup"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeThresh",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value
            self.validate_Nml2Quantity_voltage(
                self.value
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class SpikeThresh


class SpecificCapacitance(GeneratedsSuper):
    """SpecificCapacitance -- Capacitance per unit area
    \n
    :param value:
    :type value: specificCapacitance

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "value",
            "Nml2Quantity_specificCapacitance",
            0,
            0,
            {"use": "required", "name": "value"},
        ),
        MemberSpec_(
            "segment_groups",
            "NmlId",
            0,
            1,
            {"use": "optional", "name": "segment_groups"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, value=None, segment_groups="all", gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
        self.segment_groups = _cast(None, segment_groups)
        self.segment_groups_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpecificCapacitance
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpecificCapacitance.subclass:
            return SpecificCapacitance.subclass(*args_, **kwargs_)
        else:
            return SpecificCapacitance(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_specificCapacitance(self, value):
        # Validate type Nml2Quantity_specificCapacitance, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_specificCapacitance_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_specificCapacitance_patterns_,
                    )
                )

    validate_Nml2Quantity_specificCapacitance_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(F_per_m2|uF_per_cm2))$"]
    ]

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpecificCapacitance",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpecificCapacitance")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SpecificCapacitance":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpecificCapacitance",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpecificCapacitance",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpecificCapacitance",
    ):
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(
                " segmentGroup=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segment_groups), input_name="segmentGroup"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpecificCapacitance",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value
            self.validate_Nml2Quantity_specificCapacitance(
                self.value
            )  # validate type Nml2Quantity_specificCapacitance
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class SpecificCapacitance


class InitMembPotential(GeneratedsSuper):
    """InitMembPotential -- Explicitly set initial membrane potential for the cell
    \n
    :param value:
    :type value: voltage

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "value", "Nml2Quantity_voltage", 0, 0, {"use": "required", "name": "value"}
        ),
        MemberSpec_(
            "segment_groups",
            "NmlId",
            0,
            1,
            {"use": "optional", "name": "segment_groups"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, value=None, segment_groups="all", gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
        self.segment_groups = _cast(None, segment_groups)
        self.segment_groups_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, InitMembPotential)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InitMembPotential.subclass:
            return InitMembPotential.subclass(*args_, **kwargs_)
        else:
            return InitMembPotential(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV))$"]
    ]

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InitMembPotential",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("InitMembPotential")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "InitMembPotential":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="InitMembPotential",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="InitMembPotential",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="InitMembPotential",
    ):
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(
                " segmentGroup=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segment_groups), input_name="segmentGroup"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InitMembPotential",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value
            self.validate_Nml2Quantity_voltage(
                self.value
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class InitMembPotential


class Resistivity(GeneratedsSuper):
    """Resistivity -- The resistivity, or specific axial resistance, of the cytoplasm
    \n
    :param value:
    :type value: resistivity

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "value",
            "Nml2Quantity_resistivity",
            0,
            0,
            {"use": "required", "name": "value"},
        ),
        MemberSpec_(
            "segment_groups",
            "NmlId",
            0,
            1,
            {"use": "optional", "name": "segment_groups"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, value=None, segment_groups="all", gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.value = _cast(None, value)
        self.value_nsprefix_ = None
        self.segment_groups = _cast(None, segment_groups)
        self.segment_groups_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Resistivity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Resistivity.subclass:
            return Resistivity.subclass(*args_, **kwargs_)
        else:
            return Resistivity(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_resistivity(self, value):
        # Validate type Nml2Quantity_resistivity, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_resistivity_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_resistivity_patterns_,
                    )
                )

    validate_Nml2Quantity_resistivity_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(ohm_cm|kohm_cm|ohm_m))$"]
    ]

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Resistivity",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Resistivity")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Resistivity":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Resistivity"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Resistivity",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="Resistivity",
    ):
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(
                " segmentGroup=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segment_groups), input_name="segmentGroup"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Resistivity",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value
            self.validate_Nml2Quantity_resistivity(
                self.value
            )  # validate type Nml2Quantity_resistivity
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class Resistivity


class VariableParameter(GeneratedsSuper):
    """VariableParameter -- Specifies a **parameter**  ( e. g. condDensity ) which can vary its value across a **segmentGroup.**  The value is calculated from **value**  attribute of the  **inhomogeneousValue**  subelement. This element is normally a child of  **channelDensityNonUniform** ,  **channelDensityNonUniformNernst**  or  **channelDensityNonUniformGHK**  and is used to calculate the value of the conductance, etc. which will vary on different parts of the cell. The **segmentGroup**  specified here needs to define an  **inhomogeneousParameter**  ( referenced from **inhomogeneousParameter**  in the  **inhomogeneousValue**  ), which calculates a **variable**  ( e. g. p ) varying across the cell ( e. g. based on the path length from soma ), which is then used in the **value**  attribute of the  **inhomogeneousValue**  ( so for example condDensity = f( p ) )"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "parameter", "xs:string", 0, 0, {"use": "required", "name": "parameter"}
        ),
        MemberSpec_(
            "segment_groups",
            "xs:string",
            0,
            0,
            {"use": "required", "name": "segment_groups"},
        ),
        MemberSpec_(
            "inhomogeneous_value",
            "InhomogeneousValue",
            0,
            1,
            {
                "minOccurs": "0",
                "name": "inhomogeneousValue",
                "type": "InhomogeneousValue",
            },
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        parameter=None,
        segment_groups=None,
        inhomogeneous_value=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.parameter = _cast(None, parameter)
        self.parameter_nsprefix_ = None
        self.segment_groups = _cast(None, segment_groups)
        self.segment_groups_nsprefix_ = None
        self.inhomogeneous_value = inhomogeneous_value
        self.inhomogeneous_value_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, VariableParameter)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VariableParameter.subclass:
            return VariableParameter.subclass(*args_, **kwargs_)
        else:
            return VariableParameter(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if self.inhomogeneous_value is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="VariableParameter",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("VariableParameter")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "VariableParameter":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="VariableParameter",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="VariableParameter",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="VariableParameter",
    ):
        if self.parameter is not None and "parameter" not in already_processed:
            already_processed.add("parameter")
            outfile.write(
                " parameter=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.parameter), input_name="parameter"
                        )
                    ),
                )
            )
        if (
            self.segment_groups is not None
            and "segment_groups" not in already_processed
        ):
            already_processed.add("segment_groups")
            outfile.write(
                " segmentGroup=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segment_groups), input_name="segmentGroup"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="VariableParameter",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.inhomogeneous_value is not None:
            namespaceprefix_ = (
                self.inhomogeneous_value_nsprefix_ + ":"
                if (UseCapturedNS_ and self.inhomogeneous_value_nsprefix_)
                else ""
            )
            self.inhomogeneous_value.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="inhomogeneousValue",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("parameter", node)
        if value is not None and "parameter" not in already_processed:
            already_processed.add("parameter")
            self.parameter = value
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "inhomogeneousValue":
            obj_ = InhomogeneousValue.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.inhomogeneous_value = obj_
            obj_.original_tagname_ = "inhomogeneousValue"


# end class VariableParameter


class InhomogeneousValue(GeneratedsSuper):
    """InhomogeneousValue -- Specifies the **value**  of an **inhomogeneousParameter.**  For usage see  **variableParameter**"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "inhomogeneous_parameters",
            "xs:string",
            0,
            0,
            {"use": "required", "name": "inhomogeneous_parameters"},
        ),
        MemberSpec_("value", "xs:string", 0, 0, {"use": "required", "name": "value"}),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, inhomogeneous_parameters=None, value=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.inhomogeneous_parameters = _cast(None, inhomogeneous_parameters)
        self.inhomogeneous_parameters_nsprefix_ = None
        self.value = _cast(None, value)
        self.value_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InhomogeneousValue
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InhomogeneousValue.subclass:
            return InhomogeneousValue.subclass(*args_, **kwargs_)
        else:
            return InhomogeneousValue(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InhomogeneousValue",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("InhomogeneousValue")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "InhomogeneousValue":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="InhomogeneousValue",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="InhomogeneousValue",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="InhomogeneousValue",
    ):
        if (
            self.inhomogeneous_parameters is not None
            and "inhomogeneous_parameters" not in already_processed
        ):
            already_processed.add("inhomogeneous_parameters")
            outfile.write(
                " inhomogeneousParameter=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.inhomogeneous_parameters),
                            input_name="inhomogeneousParameter",
                        )
                    ),
                )
            )
        if self.value is not None and "value" not in already_processed:
            already_processed.add("value")
            outfile.write(
                " value=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.value), input_name="value"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InhomogeneousValue",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("inhomogeneousParameter", node)
        if value is not None and "inhomogeneousParameter" not in already_processed:
            already_processed.add("inhomogeneousParameter")
            self.inhomogeneous_parameters = value
        value = find_attr_value_("value", node)
        if value is not None and "value" not in already_processed:
            already_processed.add("value")
            self.value = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class InhomogeneousValue


class Species(GeneratedsSuper):
    """Species -- Description of a chemical species identified by **ion,**  which has internal, **concentration,**  and external, **extConcentration**  values for its concentration
    \n
    :param initialConcentration
    :
    :type initialConcentration: concentration
    :param initialExtConcentration:
    :type initialExtConcentration: concentration

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("id", "NmlId", 0, 0, {"use": "required", "name": "id"}),
        MemberSpec_(
            "concentration_model",
            "NmlId",
            0,
            0,
            {"use": "required", "name": "concentration_model"},
        ),
        MemberSpec_("ion", "NmlId", 0, 1, {"use": "optional", "name": "ion"}),
        MemberSpec_(
            "initial_concentration",
            "Nml2Quantity_concentration",
            0,
            0,
            {"use": "required", "name": "initial_concentration"},
        ),
        MemberSpec_(
            "initial_ext_concentration",
            "Nml2Quantity_concentration",
            0,
            0,
            {"use": "required", "name": "initial_ext_concentration"},
        ),
        MemberSpec_(
            "segment_groups",
            "NmlId",
            0,
            1,
            {"use": "optional", "name": "segment_groups"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        id=None,
        concentration_model=None,
        ion=None,
        initial_concentration=None,
        initial_ext_concentration=None,
        segment_groups="all",
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.concentration_model = _cast(None, concentration_model)
        self.concentration_model_nsprefix_ = None
        self.ion = _cast(None, ion)
        self.ion_nsprefix_ = None
        self.initial_concentration = _cast(None, initial_concentration)
        self.initial_concentration_nsprefix_ = None
        self.initial_ext_concentration = _cast(None, initial_ext_concentration)
        self.initial_ext_concentration_nsprefix_ = None
        self.segment_groups = _cast(None, segment_groups)
        self.segment_groups_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Species)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Species.subclass:
            return Species.subclass(*args_, **kwargs_)
        else:
            return Species(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_Nml2Quantity_concentration(self, value):
        # Validate type Nml2Quantity_concentration, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_concentration_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_concentration_patterns_,
                    )
                )

    validate_Nml2Quantity_concentration_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(mol_per_m3|mol_per_cm3|M|mM))$"]
    ]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Species",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Species")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Species":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Species"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Species",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Species"
    ):
        if self.id is not None and "id" not in already_processed:
            already_processed.add("id")
            outfile.write(
                " id=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.id), input_name="id")
                    ),
                )
            )
        if (
            self.concentration_model is not None
            and "concentration_model" not in already_processed
        ):
            already_processed.add("concentration_model")
            outfile.write(
                " concentrationModel=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.concentration_model),
                            input_name="concentrationModel",
                        )
                    ),
                )
            )
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(
                " ion=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.ion), input_name="ion")
                    ),
                )
            )
        if (
            self.initial_concentration is not None
            and "initial_concentration" not in already_processed
        ):
            already_processed.add("initial_concentration")
            outfile.write(
                " initialConcentration=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.initial_concentration),
                            input_name="initialConcentration",
                        )
                    ),
                )
            )
        if (
            self.initial_ext_concentration is not None
            and "initial_ext_concentration" not in already_processed
        ):
            already_processed.add("initial_ext_concentration")
            outfile.write(
                " initialExtConcentration=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.initial_ext_concentration),
                            input_name="initialExtConcentration",
                        )
                    ),
                )
            )
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(
                " segmentGroup=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segment_groups), input_name="segmentGroup"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Species",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("id", node)
        if value is not None and "id" not in already_processed:
            already_processed.add("id")
            self.id = value
            self.validate_NmlId(self.id)  # validate type NmlId
        value = find_attr_value_("concentrationModel", node)
        if value is not None and "concentrationModel" not in already_processed:
            already_processed.add("concentrationModel")
            self.concentration_model = value
            self.validate_NmlId(self.concentration_model)  # validate type NmlId
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        value = find_attr_value_("initialConcentration", node)
        if value is not None and "initialConcentration" not in already_processed:
            already_processed.add("initialConcentration")
            self.initial_concentration = value
            self.validate_Nml2Quantity_concentration(
                self.initial_concentration
            )  # validate type Nml2Quantity_concentration
        value = find_attr_value_("initialExtConcentration", node)
        if value is not None and "initialExtConcentration" not in already_processed:
            already_processed.add("initialExtConcentration")
            self.initial_ext_concentration = value
            self.validate_Nml2Quantity_concentration(
                self.initial_ext_concentration
            )  # validate type Nml2Quantity_concentration
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class Species


class IntracellularProperties(GeneratedsSuper):
    """IntracellularProperties -- Biophysical properties related to the intracellular space within the  **cell** , such as the  **resistivity**  and the list of ionic  **species**  present. **caConc**  and **caConcExt**  are explicitly exposed here to facilitate accessing these values from other Components, even though **caConcExt**  is clearly not an intracellular property"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "species",
            "Species",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "species",
                "type": "Species",
            },
            None,
        ),
        MemberSpec_(
            "resistivities",
            "Resistivity",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "resistivity",
                "type": "Resistivity",
            },
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        species=None,
        resistivities=None,
        extensiontype_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if species is None:
            self.species = []
        else:
            self.species = species
        self.species_nsprefix_ = None
        if resistivities is None:
            self.resistivities = []
        else:
            self.resistivities = resistivities
        self.resistivities_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IntracellularProperties
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IntracellularProperties.subclass:
            return IntracellularProperties.subclass(*args_, **kwargs_)
        else:
            return IntracellularProperties(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if self.species or self.resistivities:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="IntracellularProperties",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("IntracellularProperties")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "IntracellularProperties":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="IntracellularProperties",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="IntracellularProperties",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="IntracellularProperties",
    ):
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="IntracellularProperties",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for species_ in self.species:
            namespaceprefix_ = (
                self.species_nsprefix_ + ":"
                if (UseCapturedNS_ and self.species_nsprefix_)
                else ""
            )
            species_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="species",
                pretty_print=pretty_print,
            )
        for resistivity_ in self.resistivities:
            namespaceprefix_ = (
                self.resistivities_nsprefix_ + ":"
                if (UseCapturedNS_ and self.resistivities_nsprefix_)
                else ""
            )
            resistivity_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="resistivity",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "species":
            obj_ = Species.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.species.append(obj_)
            obj_.original_tagname_ = "species"
        elif nodeName_ == "resistivity":
            obj_ = Resistivity.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.resistivities.append(obj_)
            obj_.original_tagname_ = "resistivity"


# end class IntracellularProperties


class IntracellularProperties2CaPools(IntracellularProperties):
    """IntracellularProperties2CaPools -- Variant of intracellularProperties with 2 independent Ca pools"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = []
    subclass = None
    superclass = IntracellularProperties

    def __init__(
        self, species=None, resistivities=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("IntracellularProperties2CaPools"), self).__init__(
            species, resistivities, **kwargs_
        )

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, IntracellularProperties2CaPools
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if IntracellularProperties2CaPools.subclass:
            return IntracellularProperties2CaPools.subclass(*args_, **kwargs_)
        else:
            return IntracellularProperties2CaPools(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if super(IntracellularProperties2CaPools, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IntracellularProperties2CaPools",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "IntracellularProperties2CaPools"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "IntracellularProperties2CaPools"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="IntracellularProperties2CaPools",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="IntracellularProperties2CaPools",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="IntracellularProperties2CaPools",
    ):
        super(IntracellularProperties2CaPools, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="IntracellularProperties2CaPools",
        )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="IntracellularProperties2CaPools",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(IntracellularProperties2CaPools, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        super(IntracellularProperties2CaPools, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(IntracellularProperties2CaPools, self)._buildChildren(
            child_, node, nodeName_, True
        )
        pass


# end class IntracellularProperties2CaPools


class ExtracellularPropertiesLocal(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "species",
            "Species",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "species",
                "type": "Species",
            },
            None,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, species=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        if species is None:
            self.species = []
        else:
            self.species = species
        self.species_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExtracellularPropertiesLocal
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExtracellularPropertiesLocal.subclass:
            return ExtracellularPropertiesLocal.subclass(*args_, **kwargs_)
        else:
            return ExtracellularPropertiesLocal(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if self.species:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ExtracellularPropertiesLocal",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ExtracellularPropertiesLocal")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "ExtracellularPropertiesLocal"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ExtracellularPropertiesLocal",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ExtracellularPropertiesLocal",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ExtracellularPropertiesLocal",
    ):
        pass

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ExtracellularPropertiesLocal",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for species_ in self.species:
            namespaceprefix_ = (
                self.species_nsprefix_ + ":"
                if (UseCapturedNS_ and self.species_nsprefix_)
                else ""
            )
            species_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="species",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        pass

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "species":
            obj_ = Species.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.species.append(obj_)
            obj_.original_tagname_ = "species"


# end class ExtracellularPropertiesLocal


class SpaceStructure(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "x_spacing", "xs:float", 0, 1, {"use": "optional", "name": "x_spacing"}
        ),
        MemberSpec_(
            "y_spacing", "xs:float", 0, 1, {"use": "optional", "name": "y_spacing"}
        ),
        MemberSpec_(
            "z_spacing", "xs:float", 0, 1, {"use": "optional", "name": "z_spacing"}
        ),
        MemberSpec_(
            "x_start", "xs:float", 0, 1, {"use": "optional", "name": "x_start"}
        ),
        MemberSpec_(
            "y_start", "xs:float", 0, 1, {"use": "optional", "name": "y_start"}
        ),
        MemberSpec_(
            "z_start", "xs:float", 0, 1, {"use": "optional", "name": "z_start"}
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        x_spacing=None,
        y_spacing=None,
        z_spacing=None,
        x_start=0,
        y_start=0,
        z_start=0,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.x_spacing = _cast(float, x_spacing)
        self.x_spacing_nsprefix_ = None
        self.y_spacing = _cast(float, y_spacing)
        self.y_spacing_nsprefix_ = None
        self.z_spacing = _cast(float, z_spacing)
        self.z_spacing_nsprefix_ = None
        self.x_start = _cast(float, x_start)
        self.x_start_nsprefix_ = None
        self.y_start = _cast(float, y_start)
        self.y_start_nsprefix_ = None
        self.z_start = _cast(float, z_start)
        self.z_start_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SpaceStructure)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpaceStructure.subclass:
            return SpaceStructure.subclass(*args_, **kwargs_)
        else:
            return SpaceStructure(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpaceStructure",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpaceStructure")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SpaceStructure":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SpaceStructure"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpaceStructure",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpaceStructure",
    ):
        if self.x_spacing is not None and "x_spacing" not in already_processed:
            already_processed.add("x_spacing")
            outfile.write(
                ' xSpacing="%s"'
                % self.gds_format_float(self.x_spacing, input_name="xSpacing")
            )
        if self.y_spacing is not None and "y_spacing" not in already_processed:
            already_processed.add("y_spacing")
            outfile.write(
                ' ySpacing="%s"'
                % self.gds_format_float(self.y_spacing, input_name="ySpacing")
            )
        if self.z_spacing is not None and "z_spacing" not in already_processed:
            already_processed.add("z_spacing")
            outfile.write(
                ' zSpacing="%s"'
                % self.gds_format_float(self.z_spacing, input_name="zSpacing")
            )
        if self.x_start != 0 and "x_start" not in already_processed:
            already_processed.add("x_start")
            outfile.write(
                ' xStart="%s"'
                % self.gds_format_float(self.x_start, input_name="xStart")
            )
        if self.y_start != 0 and "y_start" not in already_processed:
            already_processed.add("y_start")
            outfile.write(
                ' yStart="%s"'
                % self.gds_format_float(self.y_start, input_name="yStart")
            )
        if self.z_start != 0 and "z_start" not in already_processed:
            already_processed.add("z_start")
            outfile.write(
                ' zStart="%s"'
                % self.gds_format_float(self.z_start, input_name="zStart")
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpaceStructure",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xSpacing", node)
        if value is not None and "xSpacing" not in already_processed:
            already_processed.add("xSpacing")
            value = self.gds_parse_float(value, node, "xSpacing")
            self.x_spacing = value
        value = find_attr_value_("ySpacing", node)
        if value is not None and "ySpacing" not in already_processed:
            already_processed.add("ySpacing")
            value = self.gds_parse_float(value, node, "ySpacing")
            self.y_spacing = value
        value = find_attr_value_("zSpacing", node)
        if value is not None and "zSpacing" not in already_processed:
            already_processed.add("zSpacing")
            value = self.gds_parse_float(value, node, "zSpacing")
            self.z_spacing = value
        value = find_attr_value_("xStart", node)
        if value is not None and "xStart" not in already_processed:
            already_processed.add("xStart")
            value = self.gds_parse_float(value, node, "xStart")
            self.x_start = value
        value = find_attr_value_("yStart", node)
        if value is not None and "yStart" not in already_processed:
            already_processed.add("yStart")
            value = self.gds_parse_float(value, node, "yStart")
            self.y_start = value
        value = find_attr_value_("zStart", node)
        if value is not None and "zStart" not in already_processed:
            already_processed.add("zStart")
            value = self.gds_parse_float(value, node, "zStart")
            self.z_start = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class SpaceStructure


class Layout(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("spaces", "NmlId", 0, 1, {"use": "optional", "name": "spaces"}),
        MemberSpec_(
            "random",
            "RandomLayout",
            0,
            0,
            {"name": "random", "type": "RandomLayout"},
            5,
        ),
        MemberSpec_(
            "grid", "GridLayout", 0, 0, {"name": "grid", "type": "GridLayout"}, 5
        ),
        MemberSpec_(
            "unstructured",
            "UnstructuredLayout",
            0,
            0,
            {"name": "unstructured", "type": "UnstructuredLayout"},
            5,
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        spaces=None,
        random=None,
        grid=None,
        unstructured=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.spaces = _cast(None, spaces)
        self.spaces_nsprefix_ = None
        self.random = random
        self.random_nsprefix_ = None
        self.grid = grid
        self.grid_nsprefix_ = None
        self.unstructured = unstructured
        self.unstructured_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Layout)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Layout.subclass:
            return Layout.subclass(*args_, **kwargs_)
        else:
            return Layout(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if (
            self.random is not None
            or self.grid is not None
            or self.unstructured is not None
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Layout",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Layout")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Layout":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Layout"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Layout",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Layout"
    ):
        if self.spaces is not None and "spaces" not in already_processed:
            already_processed.add("spaces")
            outfile.write(
                " space=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.spaces), input_name="space"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Layout",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.random is not None:
            namespaceprefix_ = (
                self.random_nsprefix_ + ":"
                if (UseCapturedNS_ and self.random_nsprefix_)
                else ""
            )
            self.random.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="random",
                pretty_print=pretty_print,
            )
        if self.grid is not None:
            namespaceprefix_ = (
                self.grid_nsprefix_ + ":"
                if (UseCapturedNS_ and self.grid_nsprefix_)
                else ""
            )
            self.grid.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="grid",
                pretty_print=pretty_print,
            )
        if self.unstructured is not None:
            namespaceprefix_ = (
                self.unstructured_nsprefix_ + ":"
                if (UseCapturedNS_ and self.unstructured_nsprefix_)
                else ""
            )
            self.unstructured.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="unstructured",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("space", node)
        if value is not None and "space" not in already_processed:
            already_processed.add("space")
            self.spaces = value
            self.validate_NmlId(self.spaces)  # validate type NmlId

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "random":
            obj_ = RandomLayout.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.random = obj_
            obj_.original_tagname_ = "random"
        elif nodeName_ == "grid":
            obj_ = GridLayout.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.grid = obj_
            obj_.original_tagname_ = "grid"
        elif nodeName_ == "unstructured":
            obj_ = UnstructuredLayout.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.unstructured = obj_
            obj_.original_tagname_ = "unstructured"


# end class Layout


class UnstructuredLayout(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "number",
            "xs:nonNegativeInteger",
            0,
            1,
            {"use": "optional", "name": "number"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(self, number=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.number = _cast(int, number)
        self.number_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, UnstructuredLayout
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if UnstructuredLayout.subclass:
            return UnstructuredLayout.subclass(*args_, **kwargs_)
        else:
            return UnstructuredLayout(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="UnstructuredLayout",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("UnstructuredLayout")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "UnstructuredLayout":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="UnstructuredLayout",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="UnstructuredLayout",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="UnstructuredLayout",
    ):
        if self.number is not None and "number" not in already_processed:
            already_processed.add("number")
            outfile.write(
                ' number="%s"'
                % self.gds_format_integer(self.number, input_name="number")
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="UnstructuredLayout",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("number", node)
        if value is not None and "number" not in already_processed:
            already_processed.add("number")
            self.number = self.gds_parse_integer(value, node, "number")
            if self.number < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class UnstructuredLayout


class RandomLayout(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "number",
            "xs:nonNegativeInteger",
            0,
            1,
            {"use": "optional", "name": "number"},
        ),
        MemberSpec_("regions", "NmlId", 0, 1, {"use": "optional", "name": "regions"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, number=None, regions=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.number = _cast(int, number)
        self.number_nsprefix_ = None
        self.regions = _cast(None, regions)
        self.regions_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, RandomLayout)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RandomLayout.subclass:
            return RandomLayout.subclass(*args_, **kwargs_)
        else:
            return RandomLayout(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="RandomLayout",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("RandomLayout")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "RandomLayout":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="RandomLayout"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="RandomLayout",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="RandomLayout",
    ):
        if self.number is not None and "number" not in already_processed:
            already_processed.add("number")
            outfile.write(
                ' number="%s"'
                % self.gds_format_integer(self.number, input_name="number")
            )
        if self.regions is not None and "regions" not in already_processed:
            already_processed.add("regions")
            outfile.write(
                " region=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.regions), input_name="region"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="RandomLayout",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("number", node)
        if value is not None and "number" not in already_processed:
            already_processed.add("number")
            self.number = self.gds_parse_integer(value, node, "number")
            if self.number < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
        value = find_attr_value_("region", node)
        if value is not None and "region" not in already_processed:
            already_processed.add("region")
            self.regions = value
            self.validate_NmlId(self.regions)  # validate type NmlId

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class RandomLayout


class GridLayout(GeneratedsSuper):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "x_size",
            "xs:nonNegativeInteger",
            0,
            1,
            {"use": "optional", "name": "x_size"},
        ),
        MemberSpec_(
            "y_size",
            "xs:nonNegativeInteger",
            0,
            1,
            {"use": "optional", "name": "y_size"},
        ),
        MemberSpec_(
            "z_size",
            "xs:nonNegativeInteger",
            0,
            1,
            {"use": "optional", "name": "z_size"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, x_size=None, y_size=None, z_size=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.x_size = _cast(int, x_size)
        self.x_size_nsprefix_ = None
        self.y_size = _cast(int, y_size)
        self.y_size_nsprefix_ = None
        self.z_size = _cast(int, z_size)
        self.z_size_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, GridLayout)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if GridLayout.subclass:
            return GridLayout.subclass(*args_, **kwargs_)
        else:
            return GridLayout(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GridLayout",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("GridLayout")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "GridLayout":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="GridLayout"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="GridLayout",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="GridLayout"
    ):
        if self.x_size is not None and "x_size" not in already_processed:
            already_processed.add("x_size")
            outfile.write(
                ' xSize="%s"' % self.gds_format_integer(self.x_size, input_name="xSize")
            )
        if self.y_size is not None and "y_size" not in already_processed:
            already_processed.add("y_size")
            outfile.write(
                ' ySize="%s"' % self.gds_format_integer(self.y_size, input_name="ySize")
            )
        if self.z_size is not None and "z_size" not in already_processed:
            already_processed.add("z_size")
            outfile.write(
                ' zSize="%s"' % self.gds_format_integer(self.z_size, input_name="zSize")
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="GridLayout",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xSize", node)
        if value is not None and "xSize" not in already_processed:
            already_processed.add("xSize")
            self.x_size = self.gds_parse_integer(value, node, "xSize")
            if self.x_size < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
        value = find_attr_value_("ySize", node)
        if value is not None and "ySize" not in already_processed:
            already_processed.add("ySize")
            self.y_size = self.gds_parse_integer(value, node, "ySize")
            if self.y_size < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
        value = find_attr_value_("zSize", node)
        if value is not None and "zSize" not in already_processed:
            already_processed.add("zSize")
            self.z_size = self.gds_parse_integer(value, node, "zSize")
            if self.z_size < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass


# end class GridLayout


class Instance(GeneratedsSuper):
    """Instance -- Specifies a single instance of a component in a  **population**  ( placed at  **location**  )."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "id", "xs:nonNegativeInteger", 0, 1, {"use": "optional", "name": "id"}
        ),
        MemberSpec_(
            "i", "xs:nonNegativeInteger", 0, 1, {"use": "optional", "name": "i"}
        ),
        MemberSpec_(
            "j", "xs:nonNegativeInteger", 0, 1, {"use": "optional", "name": "j"}
        ),
        MemberSpec_(
            "k", "xs:nonNegativeInteger", 0, 1, {"use": "optional", "name": "k"}
        ),
        MemberSpec_(
            "location", "Location", 0, 0, {"name": "location", "type": "Location"}, None
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        id=None,
        i=None,
        j=None,
        k=None,
        location=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.i = _cast(int, i)
        self.i_nsprefix_ = None
        self.j = _cast(int, j)
        self.j_nsprefix_ = None
        self.k = _cast(int, k)
        self.k_nsprefix_ = None
        self.location = location
        self.location_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Instance)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Instance.subclass:
            return Instance.subclass(*args_, **kwargs_)
        else:
            return Instance(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if self.location is not None:
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Instance",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Instance")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Instance":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Instance"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Instance",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Instance"
    ):
        if self.id is not None and "id" not in already_processed:
            already_processed.add("id")
            outfile.write(
                ' id="%s"' % self.gds_format_integer(self.id, input_name="id")
            )
        if self.i is not None and "i" not in already_processed:
            already_processed.add("i")
            outfile.write(' i="%s"' % self.gds_format_integer(self.i, input_name="i"))
        if self.j is not None and "j" not in already_processed:
            already_processed.add("j")
            outfile.write(' j="%s"' % self.gds_format_integer(self.j, input_name="j"))
        if self.k is not None and "k" not in already_processed:
            already_processed.add("k")
            outfile.write(' k="%s"' % self.gds_format_integer(self.k, input_name="k"))

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Instance",
        fromsubclass_=False,
        pretty_print=True,
    ):
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.location is not None:
            namespaceprefix_ = (
                self.location_nsprefix_ + ":"
                if (UseCapturedNS_ and self.location_nsprefix_)
                else ""
            )
            self.location.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="location",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("id", node)
        if value is not None and "id" not in already_processed:
            already_processed.add("id")
            self.id = self.gds_parse_integer(value, node, "id")
            if self.id < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
        value = find_attr_value_("i", node)
        if value is not None and "i" not in already_processed:
            already_processed.add("i")
            self.i = self.gds_parse_integer(value, node, "i")
            if self.i < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
        value = find_attr_value_("j", node)
        if value is not None and "j" not in already_processed:
            already_processed.add("j")
            self.j = self.gds_parse_integer(value, node, "j")
            if self.j < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
        value = find_attr_value_("k", node)
        if value is not None and "k" not in already_processed:
            already_processed.add("k")
            self.k = self.gds_parse_integer(value, node, "k")
            if self.k < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "location":
            obj_ = Location.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.location = obj_
            obj_.original_tagname_ = "location"

    def __str__(self):

        return (
            "Instance "
            + str(self.id)
            + (" at location: " + str(self.location) if self.location else "")
        )

    def __repr__(self):

        return str(self)


# end class Instance


class Location(GeneratedsSuper):
    """Location -- Specifies the ( x, y, z ) location of a single  **instance**  of a component in a  **population**
    \n
    :param x:
    :type x: none
    :param y:
    :type y: none
    :param z:
    :type z: none

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("x", "xs:float", 0, 0, {"use": "required", "name": "x"}),
        MemberSpec_("y", "xs:float", 0, 0, {"use": "required", "name": "y"}),
        MemberSpec_("z", "xs:float", 0, 0, {"use": "required", "name": "z"}),
    ]
    subclass = None
    superclass = None

    def __init__(self, x=None, y=None, z=None, gds_collector_=None, **kwargs_):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.x = _cast(float, x)
        self.x_nsprefix_ = None
        self.y = _cast(float, y)
        self.y_nsprefix_ = None
        self.z = _cast(float, z)
        self.z_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Location)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Location.subclass:
            return Location.subclass(*args_, **kwargs_)
        else:
            return Location(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Location",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Location")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Location":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Location"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Location",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Location"
    ):
        if self.x is not None and "x" not in already_processed:
            already_processed.add("x")
            outfile.write(' x="%s"' % self.gds_format_float(self.x, input_name="x"))
        if self.y is not None and "y" not in already_processed:
            already_processed.add("y")
            outfile.write(' y="%s"' % self.gds_format_float(self.y, input_name="y"))
        if self.z is not None and "z" not in already_processed:
            already_processed.add("z")
            outfile.write(' z="%s"' % self.gds_format_float(self.z, input_name="z"))

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Location",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("x", node)
        if value is not None and "x" not in already_processed:
            already_processed.add("x")
            value = self.gds_parse_float(value, node, "x")
            self.x = value
        value = find_attr_value_("y", node)
        if value is not None and "y" not in already_processed:
            already_processed.add("y")
            value = self.gds_parse_float(value, node, "y")
            self.y = value
        value = find_attr_value_("z", node)
        if value is not None and "z" not in already_processed:
            already_processed.add("z")
            value = self.gds_parse_float(value, node, "z")
            self.z = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass

    def _format(self, value):

        if int(value) == value:
            return str(int(value))
        else:
            return "%.4f" % value

    def __str__(self):

        return (
            "("
            + self._format(self.x)
            + ", "
            + self._format(self.y)
            + ", "
            + self._format(self.z)
            + ")"
        )

    def __repr__(self):

        return str(self)


# end class Location


class SynapticConnection(GeneratedsSuper):
    """SynapticConnection -- Explicit event connection between named components, which gets processed via a new instance of a **synapse**  component which is created on the target component"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("from_", "xs:string", 0, 0, {"use": "required", "name": "from_"}),
        MemberSpec_("to", "xs:string", 0, 0, {"use": "required", "name": "to"}),
        MemberSpec_(
            "synapse", "xs:string", 0, 0, {"use": "required", "name": "synapse"}
        ),
        MemberSpec_(
            "destination", "NmlId", 0, 1, {"use": "optional", "name": "destination"}
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        from_=None,
        to=None,
        synapse=None,
        destination=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.from_ = _cast(None, from_)
        self.from__nsprefix_ = None
        self.to = _cast(None, to)
        self.to_nsprefix_ = None
        self.synapse = _cast(None, synapse)
        self.synapse_nsprefix_ = None
        self.destination = _cast(None, destination)
        self.destination_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SynapticConnection
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SynapticConnection.subclass:
            return SynapticConnection.subclass(*args_, **kwargs_)
        else:
            return SynapticConnection(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SynapticConnection",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SynapticConnection")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SynapticConnection":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SynapticConnection",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SynapticConnection",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SynapticConnection",
    ):
        if self.from_ is not None and "from_" not in already_processed:
            already_processed.add("from_")
            outfile.write(
                " from=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.from_), input_name="from"
                        )
                    ),
                )
            )
        if self.to is not None and "to" not in already_processed:
            already_processed.add("to")
            outfile.write(
                " to=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.to), input_name="to")
                    ),
                )
            )
        if self.synapse is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            outfile.write(
                " synapse=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.synapse), input_name="synapse"
                        )
                    ),
                )
            )
        if self.destination is not None and "destination" not in already_processed:
            already_processed.add("destination")
            outfile.write(
                " destination=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.destination), input_name="destination"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SynapticConnection",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("from", node)
        if value is not None and "from" not in already_processed:
            already_processed.add("from")
            self.from_ = value
        value = find_attr_value_("to", node)
        if value is not None and "to" not in already_processed:
            already_processed.add("to")
            self.to = value
        value = find_attr_value_("synapse", node)
        if value is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            self.synapse = value
        value = find_attr_value_("destination", node)
        if value is not None and "destination" not in already_processed:
            already_processed.add("destination")
            self.destination = value
            self.validate_NmlId(self.destination)  # validate type NmlId

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass

    def _get_cell_id(self, ref):
        """Get cell ID"""
        if "[" in ref:
            return int(ref.split("[")[1].split("]")[0])
        else:
            return int(ref.split("/")[2])

    def _get_population(self, ref):
        """Get population"""
        if "[" in ref:
            return ref.split("[")[0]
        else:
            return ref.split("/")[0]

    def __str__(self):

        dest = self.destination if self.destination else "unspecified"
        return (
            "Synaptic connection from "
            + str(self._get_population(self.from_))
            + "(cell "
            + str(self._get_cell_id(self.from_))
            + ") -> "
            + str(self._get_population(self.to))
            + "(cell "
            + str(self._get_cell_id(self.to))
            + "), syn: "
            + self.synapse
            + ", destination: "
            + dest
        )

    # end class SynapticConnection


class ExplicitInput(GeneratedsSuper):
    """ExplicitInput -- An explicit input ( anything which extends  **basePointCurrent**  ) to a target cell in a population"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("target", "xs:string", 0, 0, {"use": "required", "name": "target"}),
        MemberSpec_("input", "xs:string", 0, 0, {"use": "required", "name": "input"}),
        MemberSpec_(
            "destination", "xs:string", 0, 1, {"use": "optional", "name": "destination"}
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, target=None, input=None, destination=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.target = _cast(None, target)
        self.target_nsprefix_ = None
        self.input = _cast(None, input)
        self.input_nsprefix_ = None
        self.destination = _cast(None, destination)
        self.destination_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ExplicitInput)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExplicitInput.subclass:
            return ExplicitInput.subclass(*args_, **kwargs_)
        else:
            return ExplicitInput(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ExplicitInput",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ExplicitInput")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ExplicitInput":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ExplicitInput"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ExplicitInput",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ExplicitInput",
    ):
        if self.target is not None and "target" not in already_processed:
            already_processed.add("target")
            outfile.write(
                " target=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.target), input_name="target"
                        )
                    ),
                )
            )
        if self.input is not None and "input" not in already_processed:
            already_processed.add("input")
            outfile.write(
                " input=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.input), input_name="input"
                        )
                    ),
                )
            )
        if self.destination is not None and "destination" not in already_processed:
            already_processed.add("destination")
            outfile.write(
                " destination=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.destination), input_name="destination"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ExplicitInput",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("target", node)
        if value is not None and "target" not in already_processed:
            already_processed.add("target")
            self.target = value
        value = find_attr_value_("input", node)
        if value is not None and "input" not in already_processed:
            already_processed.add("input")
            self.input = value
        value = find_attr_value_("destination", node)
        if value is not None and "destination" not in already_processed:
            already_processed.add("destination")
            self.destination = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass

    def _get_cell_id(self, id_string):
        if "[" in id_string:
            return int(id_string.split("[")[1].split("]")[0])
        else:
            return int(id_string.split("/")[2])

    def get_target_cell_id(self):
        """Get ID of target cell."""

        return self._get_cell_id(self.target)

    def get_segment_id(self):
        """Get the ID of the segment.

        Returns 0 if segment_id was not set.
        """
        return int(self.segment_id) if self.segment_id else 0

    def get_fraction_along(self):
        """Get fraction along.

        Returns 0.5 is fraction_along was not set.
        """

        return float(self.fraction_along) if self.fraction_along else 0.5

    def __str__(self):

        return (
            "Input "
            + str(self.id)
            + ": "
            + str(self.get_target_cell_id())
            + ":"
            + str(self.get_segment_id())
            + "("
            + "%.6f" % self.get_fraction_along()
            + ")"
        )

    def get_target_cell_id(
        self,
    ):
        """Get target cell ID"""
        if "[" in self.target:
            return int(self.target.split("[")[1].split("]")[0])
        else:
            return int(self.target.split("/")[2])

    def get_target_population(
        self,
    ):
        """Get target population."""
        if "[" in self.target:
            return self.target.split("[")[0]
        else:
            return self.target.split("/")[0]

    def __str__(self):

        dest = self.destination if self.destination else "unspecified"
        return (
            "Explicit Input of type "
            + str(self.input)
            + " to "
            + self.get_target_population()
            + "(cell "
            + str(self.get_target_cell_id())
            + "), destination: "
            + dest
        )

    # end class ExplicitInput


class Input(GeneratedsSuper):
    """Input -- Specifies a single input to a **target,**  optionally giving the **segmentId**  ( default 0 ) and **fractionAlong**  the segment ( default 0. 5 )."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "id", "NonNegativeInteger", 0, 0, {"use": "required", "name": "id"}
        ),
        MemberSpec_("target", "xs:string", 0, 0, {"use": "required", "name": "target"}),
        MemberSpec_(
            "destination", "NmlId", 0, 0, {"use": "required", "name": "destination"}
        ),
        MemberSpec_(
            "segment_id",
            "NonNegativeInteger",
            0,
            1,
            {"use": "optional", "name": "segment_id"},
        ),
        MemberSpec_(
            "fraction_along",
            "ZeroToOne",
            0,
            1,
            {"use": "optional", "name": "fraction_along"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self,
        id=None,
        target=None,
        destination=None,
        segment_id=None,
        fraction_along=None,
        extensiontype_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.target = _cast(None, target)
        self.target_nsprefix_ = None
        self.destination = _cast(None, destination)
        self.destination_nsprefix_ = None
        self.segment_id = _cast(int, segment_id)
        self.segment_id_nsprefix_ = None
        self.fraction_along = _cast(float, fraction_along)
        self.fraction_along_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Input)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Input.subclass:
            return Input.subclass(*args_, **kwargs_)
        else:
            return Input(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            pass

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_ZeroToOne(self, value):
        # Validate type ZeroToOne, a restriction on xs:float.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (float)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if value < 0:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd minInclusive restriction on ZeroToOne'
                    % {"value": value, "lineno": lineno}
                )
                result = False
            if value > 1:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd maxInclusive restriction on ZeroToOne'
                    % {"value": value, "lineno": lineno}
                )
                result = False

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Input",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Input")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Input":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Input"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Input",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Input"
    ):
        if self.id is not None and "id" not in already_processed:
            already_processed.add("id")
            outfile.write(
                ' id="%s"' % self.gds_format_integer(self.id, input_name="id")
            )
        if self.target is not None and "target" not in already_processed:
            already_processed.add("target")
            outfile.write(
                " target=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.target), input_name="target"
                        )
                    ),
                )
            )
        if self.destination is not None and "destination" not in already_processed:
            already_processed.add("destination")
            outfile.write(
                " destination=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.destination), input_name="destination"
                        )
                    ),
                )
            )
        if self.segment_id is not None and "segment_id" not in already_processed:
            already_processed.add("segment_id")
            outfile.write(
                ' segmentId="%s"'
                % self.gds_format_integer(self.segment_id, input_name="segmentId")
            )
        if (
            self.fraction_along is not None
            and "fraction_along" not in already_processed
        ):
            already_processed.add("fraction_along")
            outfile.write(
                ' fractionAlong="%s"'
                % self.gds_format_float(self.fraction_along, input_name="fractionAlong")
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Input",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("id", node)
        if value is not None and "id" not in already_processed:
            already_processed.add("id")
            self.id = self.gds_parse_integer(value, node, "id")
            if self.id < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.id
            )  # validate type NonNegativeInteger
        value = find_attr_value_("target", node)
        if value is not None and "target" not in already_processed:
            already_processed.add("target")
            self.target = value
        value = find_attr_value_("destination", node)
        if value is not None and "destination" not in already_processed:
            already_processed.add("destination")
            self.destination = value
            self.validate_NmlId(self.destination)  # validate type NmlId
        value = find_attr_value_("segmentId", node)
        if value is not None and "segmentId" not in already_processed:
            already_processed.add("segmentId")
            self.segment_id = self.gds_parse_integer(value, node, "segmentId")
            if self.segment_id < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.segment_id
            )  # validate type NonNegativeInteger
        value = find_attr_value_("fractionAlong", node)
        if value is not None and "fractionAlong" not in already_processed:
            already_processed.add("fractionAlong")
            value = self.gds_parse_float(value, node, "fractionAlong")
            self.fraction_along = value
            self.validate_ZeroToOne(self.fraction_along)  # validate type ZeroToOne
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass

    def _get_cell_id(self, id_string):
        if "[" in id_string:
            return int(id_string.split("[")[1].split("]")[0])
        else:
            return int(id_string.split("/")[2])

    def get_target_cell_id(self):
        """Get ID of target cell."""

        return self._get_cell_id(self.target)

    def get_segment_id(self):
        """Get the ID of the segment.

        Returns 0 if segment_id was not set.
        """
        return int(self.segment_id) if self.segment_id else 0

    def get_fraction_along(self):
        """Get fraction along.

        Returns 0.5 is fraction_along was not set.
        """

        return float(self.fraction_along) if self.fraction_along else 0.5

    def __str__(self):

        return (
            "Input "
            + str(self.id)
            + ": "
            + str(self.get_target_cell_id())
            + ":"
            + str(self.get_segment_id())
            + "("
            + "%.6f" % self.get_fraction_along()
            + ")"
        )

    # end class Input


class InputW(Input):
    """InputW -- Specifies input lists. Can set **weight**  to scale individual inputs.
    \n
    :param weight:
    :type weight: none

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("weight", "xs:float", 0, 0, {"use": "required", "name": "weight"}),
    ]
    subclass = None
    superclass = Input

    def __init__(
        self,
        id=None,
        target=None,
        destination=None,
        segment_id=None,
        fraction_along=None,
        weight=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("InputW"), self).__init__(
            id, target, destination, segment_id, fraction_along, **kwargs_
        )
        self.weight = _cast(float, weight)
        self.weight_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, InputW)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InputW.subclass:
            return InputW.subclass(*args_, **kwargs_)
        else:
            return InputW(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if super(InputW, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InputW",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("InputW")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "InputW":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="InputW"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="InputW",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="InputW"
    ):
        super(InputW, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="InputW"
        )
        if self.weight is not None and "weight" not in already_processed:
            already_processed.add("weight")
            outfile.write(
                ' weight="%s"' % self.gds_format_float(self.weight, input_name="weight")
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="InputW",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(InputW, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("weight", node)
        if value is not None and "weight" not in already_processed:
            already_processed.add("weight")
            value = self.gds_parse_float(value, node, "weight")
            self.weight = value
        super(InputW, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(InputW, self)._buildChildren(child_, node, nodeName_, True)
        pass

    def get_weight(self):
        """Get weight.

        If weight is not set, the default value of 1.0 is returned.
        """

        return float(self.weight) if self.weight != None else 1.0

    def __str__(self):

        return (
            "Input (weight) "
            + str(self.id)
            + ": "
            + str(self.get_target_cell_id())
            + ":"
            + str(self.get_segment_id())
            + "("
            + "%.6f" % self.get_fraction_along()
            + "), weight: "
            + "%.6f" % self.get_weight()
        )

    # end class InputW


class BaseWithoutId(GeneratedsSuper):
    """BaseWithoutId -- Base element without ID specified *yet*, e.g. for an element with a particular requirement on its id which does not comply with NmlId (e.g. Segment needs nonNegativeInteger)."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "neuro_lex_id",
            "NeuroLexId",
            0,
            1,
            {"use": "optional", "name": "neuro_lex_id"},
        ),
    ]
    subclass = None
    superclass = None

    def __init__(
        self, neuro_lex_id=None, extensiontype_=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        self.neuro_lex_id = _cast(None, neuro_lex_id)
        self.neuro_lex_id_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, BaseWithoutId)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseWithoutId.subclass:
            return BaseWithoutId.subclass(*args_, **kwargs_)
        else:
            return BaseWithoutId(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NeuroLexId(self, value):
        # Validate type NeuroLexId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NeuroLexId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NeuroLexId_patterns_,
                    )
                )

    validate_NeuroLexId_patterns_ = [["^([a-zA-Z0-9_:]*)$"]]

    def _hasContent(self):
        if ():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseWithoutId",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BaseWithoutId")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "BaseWithoutId":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseWithoutId"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BaseWithoutId",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BaseWithoutId",
    ):
        if self.neuro_lex_id is not None and "neuro_lex_id" not in already_processed:
            already_processed.add("neuro_lex_id")
            outfile.write(
                " neuroLexId=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.neuro_lex_id), input_name="neuroLexId"
                        )
                    ),
                )
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseWithoutId",
        fromsubclass_=False,
        pretty_print=True,
    ):
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("neuroLexId", node)
        if value is not None and "neuroLexId" not in already_processed:
            already_processed.add("neuroLexId")
            self.neuro_lex_id = value
            self.validate_NeuroLexId(self.neuro_lex_id)  # validate type NeuroLexId
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        pass

    def add(self, obj=None, hint=None, force=False):
        """Generic function to allow easy addition of a new member to a NeuroML object.

        Without arguments, when `obj=None`, it simply calls the `info()` method
        to provide the list of valid member types for the NeuroML class.

        Use `info(show_contents=True)` to see the valid members of this class,
        and their current contents.

        :param obj: object member to add
        :type obj: any NeuroML Type defined by the API
        :param hint: member name to add to when there are multiple members that `obj` can be added to
        :type hint: string
        :param force: boolean to force addition when an obj has already been added previously
        :type force: bool

        :raises Exception: if a member compatible to obj could not be found
        :raises Exception: if multiple members can accept the object and no hint is provided.
        """
        if not obj:
            self.info()
            return

        # getattr only returns the value of the provided member but one cannot
        # then use this to modify the member. Using `vars` also allows us to
        # modify the value
        targets = []
        all_members = self.get_members()
        for member in all_members:
            # get_data_type() returns the type as a string, e.g.: 'IncludeType'
            if member.get_data_type() == type(obj).__name__:
                targets.append(member)

        if len(targets) == 0:
            # no targets found
            e = Exception(
                """A member object of {} type could not be found in NeuroML class {}.\n{}
            """.format(
                    type(obj).__name__, type(self).__name__, self.info()
                )
            )
            raise e
        elif len(targets) == 1:
            # good, just add it
            self.__add(obj, targets[0], force)
        else:
            # more than one target
            if not hint:
                err_string = """Multiple members can accept {}. Please provide the name of the variable using the `hint` argument to specify which member to add to:\n""".format(
                    type(obj).__name__
                )
                for t in targets:
                    err_string += "- {}\n".format(t.get_name())
                raise Exception(err_string)

            # use hint to figure out which target to use
            for t in targets:
                if hint == t.get_name():
                    self.__add(obj, t, force)
                    break

    def __add(self, obj, member, force=False):
        """Private method to add new member to a specified variable in a NeuroML object.

        :param obj: object member to add
        :type obj: any NeuroML Type defined by the API
        :param member: member variable name to add to when there are multiple members that `obj` can be added to
        :type member: MemberSpec_
        :param force: boolean to force addition when an obj has already been added previously
        :type force: bool

        """
        import warnings

        # A single value, not a list:
        if member.get_container() == 0:
            if force:
                vars(self)[member.get_name()] = obj
            else:
                if vars(self)[member.get_name()]:
                    warnings.warn(
                        """{} has already been assigned.  Use `force=True` to overwrite. Hint: you can make changes to the already added object as required without needing to re-add it because only references to the objects are added, not their values.""".format(
                            member.get_name()
                        )
                    )
                else:
                    vars(self)[member.get_name()] = obj
        # List
        else:
            # Do not use 'obj in ..' for membership check because it also
            # returns true if an element with the same value exists in the
            # container
            # https://docs.python.org/3/reference/expressions.html#membership-test-operations
            if force:
                vars(self)[member.get_name()].append(obj)
            else:
                if any(obj is e for e in vars(self)[member.get_name()]):
                    warnings.warn(
                        """{} already exists in {}. Use `force=True` to force readdition. Hint: you can make changes to the already added object as required without needing to re-add it because only references to the objects are added, not their values.""".format(
                            obj, member.get_name()
                        )
                    )
                else:
                    vars(self)[member.get_name()].append(obj)

    def get_members(self):
        """Get member data items, also from ancestors.

        This function is required because generateDS does not include inherited
        members in the member_data_items list for a derived class. So, for
        example, while IonChannelHH has `gate_hh_rates` which it inherits from
        IonChannel, IonChannelHH's `member_data_items_` is empty. It relies on
        the IonChannel classes' `member_data_items_` list.

        :returns: list of members, including ones inherited from ancestors.
        """
        import copy

        # create a copy by value
        # if copied by reference (=), the member_data_items_ object variable is
        # modified to a large list, greatly increasing the memory usage.
        all_members = copy.copy(self.member_data_items_)
        for c in type(self).__mro__:
            try:
                all_members.extend(c.member_data_items_)
            except AttributeError:
                pass
            except TypeError:
                pass

        # deduplicate
        # TODO where are the duplicates coming from given that we're not
        # calling this recursively?
        all_members = list(set(all_members))
        return all_members

    def info(self, show_contents=False):
        """A helper function to get a list of members of this class.

        This is useful to quickly check what members can go into a particular
        NeuroML class (which will match the Schema definitions). It lists these
        members and notes whether they are "single" type elements (Child
        elements) or "List" elements (Children elements). It will also note
        whether a member is optional or required.

        See http://www.davekuhlman.org/generateDS.html#user-methods for more
        information on the MemberSpec_ class that generateDS uses.

        :param show_contents: also prints out the contents of the members
        :type show_contents: bool

        :returns: the string (for testing purposes)
        """

        info_str = "Valid members for {} are:\n".format(self.__class__.__name__)
        for member in self.member_data_items_:
            info_str += "* {} (class: {})\n".format(member.name, member.data_type)
            if show_contents:
                contents = getattr(self, member.get_name())
                info_str += "	* Contents: {}\n\n".format(contents)

        info_str += "Please see the NeuroML standard schema documentation at https://docs.neuroml.org/Userdocs/NeuroMLv2.html for more information."
        print(info_str)
        return info_str

    # end class BaseWithoutId


class BaseNonNegativeIntegerId(BaseWithoutId):
    """BaseNonNegativeIntegerId -- Anything which can have a unique (within its parent) id, which must be an integer zero or greater."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "id", "NonNegativeInteger", 0, 0, {"use": "required", "name": "id"}
        ),
    ]
    subclass = None
    superclass = BaseWithoutId

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        extensiontype_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("BaseNonNegativeIntegerId"), self).__init__(
            neuro_lex_id, extensiontype_, **kwargs_
        )
        self.id = _cast(int, id)
        self.id_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BaseNonNegativeIntegerId
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseNonNegativeIntegerId.subclass:
            return BaseNonNegativeIntegerId.subclass(*args_, **kwargs_)
        else:
            return BaseNonNegativeIntegerId(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            pass

    def _hasContent(self):
        if super(BaseNonNegativeIntegerId, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseNonNegativeIntegerId",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BaseNonNegativeIntegerId")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "BaseNonNegativeIntegerId":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="BaseNonNegativeIntegerId",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BaseNonNegativeIntegerId",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BaseNonNegativeIntegerId",
    ):
        super(BaseNonNegativeIntegerId, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="BaseNonNegativeIntegerId",
        )
        if self.id is not None and "id" not in already_processed:
            already_processed.add("id")
            outfile.write(
                ' id="%s"' % self.gds_format_integer(self.id, input_name="id")
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseNonNegativeIntegerId",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(BaseNonNegativeIntegerId, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("id", node)
        if value is not None and "id" not in already_processed:
            already_processed.add("id")
            self.id = self.gds_parse_integer(value, node, "id")
            if self.id < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.id
            )  # validate type NonNegativeInteger
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(BaseNonNegativeIntegerId, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(BaseNonNegativeIntegerId, self)._buildChildren(
            child_, node, nodeName_, True
        )
        pass


# end class BaseNonNegativeIntegerId


class Base(BaseWithoutId):
    """Base -- Anything which can have a unique (within its parent) id of the form NmlId (spaceless combination of letters, numbers and underscore)."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("id", "NmlId", 0, 0, {"use": "required", "name": "id"}),
    ]
    subclass = None
    superclass = BaseWithoutId

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        extensiontype_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("Base"), self).__init__(
            neuro_lex_id, extensiontype_, **kwargs_
        )
        self.id = _cast(None, id)
        self.id_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Base)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Base.subclass:
            return Base.subclass(*args_, **kwargs_)
        else:
            return Base(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if super(Base, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Base",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Base")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Base":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Base"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Base",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Base"
    ):
        super(Base, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Base"
        )
        if self.id is not None and "id" not in already_processed:
            already_processed.add("id")
            outfile.write(
                " id=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.id), input_name="id")
                    ),
                )
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Base",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Base, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("id", node)
        if value is not None and "id" not in already_processed:
            already_processed.add("id")
            self.id = value
            self.validate_NmlId(self.id)  # validate type NmlId
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(Base, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(Base, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class Base


class Standalone(Base):
    """Standalone -- Elements which can stand alone and be referenced by id, e.g. cell, morphology."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("metaid", "MetaId", 0, 1, {"use": "optional", "name": "metaid"}),
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {"minOccurs": "0", "name": "notes", "type": "xs:string"},
            None,
        ),
        MemberSpec_(
            "properties",
            "Property",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "property",
                "type": "Property",
            },
            None,
        ),
        MemberSpec_(
            "annotation",
            "Annotation",
            0,
            1,
            {"minOccurs": "0", "name": "annotation", "type": "Annotation"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        extensiontype_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("Standalone"), self).__init__(
            neuro_lex_id, id, extensiontype_, **kwargs_
        )
        self.metaid = _cast(None, metaid)
        self.metaid_nsprefix_ = None
        self.notes = notes
        self.validate_Notes(self.notes)
        self.notes_nsprefix_ = None
        if properties is None:
            self.properties = []
        else:
            self.properties = properties
        self.properties_nsprefix_ = None
        self.annotation = annotation
        self.annotation_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Standalone)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Standalone.subclass:
            return Standalone.subclass(*args_, **kwargs_)
        else:
            return Standalone(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        result = True
        # Validate type Notes, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            pass
        return result

    def validate_MetaId(self, value):
        # Validate type MetaId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_MetaId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_MetaId_patterns_,
                    )
                )

    validate_MetaId_patterns_ = [["^([a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if (
            self.notes is not None
            or self.properties
            or self.annotation is not None
            or super(Standalone, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Standalone",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Standalone")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Standalone":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Standalone"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Standalone",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Standalone"
    ):
        super(Standalone, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Standalone"
        )
        if self.metaid is not None and "metaid" not in already_processed:
            already_processed.add("metaid")
            outfile.write(
                " metaid=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.metaid), input_name="metaid"
                        )
                    ),
                )
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Standalone",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Standalone, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            namespaceprefix_ = (
                self.notes_nsprefix_ + ":"
                if (UseCapturedNS_ and self.notes_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        for property_ in self.properties:
            namespaceprefix_ = (
                self.properties_nsprefix_ + ":"
                if (UseCapturedNS_ and self.properties_nsprefix_)
                else ""
            )
            property_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="property",
                pretty_print=pretty_print,
            )
        if self.annotation is not None:
            namespaceprefix_ = (
                self.annotation_nsprefix_ + ":"
                if (UseCapturedNS_ and self.annotation_nsprefix_)
                else ""
            )
            self.annotation.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="annotation",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("metaid", node)
        if value is not None and "metaid" not in already_processed:
            already_processed.add("metaid")
            self.metaid = value
            self.validate_MetaId(self.metaid)  # validate type MetaId
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(Standalone, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "notes":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "notes")
            value_ = self.gds_validate_string(value_, node, "notes")
            self.notes = value_
            self.notes_nsprefix_ = child_.prefix
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "property":
            obj_ = Property.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.properties.append(obj_)
            obj_.original_tagname_ = "property"
        elif nodeName_ == "annotation":
            obj_ = Annotation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.annotation = obj_
            obj_.original_tagname_ = "annotation"
        super(Standalone, self)._buildChildren(child_, node, nodeName_, True)


# end class Standalone


class SpikeSourcePoisson(Standalone):
    """SpikeSourcePoisson -- Spike source, generating spikes according to a Poisson process.
    \n
    :param start:
    :type start: time
    :param duration:
    :type duration: time
    :param rate:
    :type rate: per_time

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "start", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "start"}
        ),
        MemberSpec_(
            "duration",
            "Nml2Quantity_time",
            0,
            0,
            {"use": "required", "name": "duration"},
        ),
        MemberSpec_(
            "rate", "Nml2Quantity_pertime", 0, 0, {"use": "required", "name": "rate"}
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        start=None,
        duration=None,
        rate=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("SpikeSourcePoisson"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.start = _cast(None, start)
        self.start_nsprefix_ = None
        self.duration = _cast(None, duration)
        self.duration_nsprefix_ = None
        self.rate = _cast(None, rate)
        self.rate_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpikeSourcePoisson
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeSourcePoisson.subclass:
            return SpikeSourcePoisson.subclass(*args_, **kwargs_)
        else:
            return SpikeSourcePoisson(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_pertime_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_pertime_patterns_,
                    )
                )

    validate_Nml2Quantity_pertime_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s|per_ms|Hz))$"]
    ]

    def _hasContent(self):
        if super(SpikeSourcePoisson, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeSourcePoisson",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpikeSourcePoisson")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SpikeSourcePoisson":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpikeSourcePoisson",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpikeSourcePoisson",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpikeSourcePoisson",
    ):
        super(SpikeSourcePoisson, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpikeSourcePoisson",
        )
        if self.start is not None and "start" not in already_processed:
            already_processed.add("start")
            outfile.write(
                " start=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.start), input_name="start"
                        )
                    ),
                )
            )
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(
                " duration=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.duration), input_name="duration"
                        )
                    ),
                )
            )
        if self.rate is not None and "rate" not in already_processed:
            already_processed.add("rate")
            outfile.write(
                " rate=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.rate), input_name="rate"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeSourcePoisson",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SpikeSourcePoisson, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("start", node)
        if value is not None and "start" not in already_processed:
            already_processed.add("start")
            self.start = value
            self.validate_Nml2Quantity_time(
                self.start
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("rate", node)
        if value is not None and "rate" not in already_processed:
            already_processed.add("rate")
            self.rate = value
            self.validate_Nml2Quantity_pertime(
                self.rate
            )  # validate type Nml2Quantity_pertime
        super(SpikeSourcePoisson, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(SpikeSourcePoisson, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class SpikeSourcePoisson


class InputList(Base):
    """InputList -- An explicit list of  **input** s to a **population.**"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "populations", "NmlId", 0, 0, {"use": "required", "name": "populations"}
        ),
        MemberSpec_(
            "component", "NmlId", 0, 0, {"use": "required", "name": "component"}
        ),
        MemberSpec_(
            "input",
            "Input",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "input",
                "type": "Input",
            },
            None,
        ),
        MemberSpec_(
            "input_ws",
            "InputW",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "inputW",
                "type": "InputW",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        populations=None,
        component=None,
        input=None,
        input_ws=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("InputList"), self).__init__(neuro_lex_id, id, **kwargs_)
        self.populations = _cast(None, populations)
        self.populations_nsprefix_ = None
        self.component = _cast(None, component)
        self.component_nsprefix_ = None
        if input is None:
            self.input = []
        else:
            self.input = input
        self.input_nsprefix_ = None
        if input_ws is None:
            self.input_ws = []
        else:
            self.input_ws = input_ws
        self.input_ws_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, InputList)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InputList.subclass:
            return InputList.subclass(*args_, **kwargs_)
        else:
            return InputList(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if self.input or self.input_ws or super(InputList, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="InputList",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("InputList")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "InputList":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="InputList"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="InputList",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="InputList"
    ):
        super(InputList, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="InputList"
        )
        if self.populations is not None and "populations" not in already_processed:
            already_processed.add("populations")
            outfile.write(
                " population=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.populations), input_name="population"
                        )
                    ),
                )
            )
        if self.component is not None and "component" not in already_processed:
            already_processed.add("component")
            outfile.write(
                " component=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.component), input_name="component"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="InputList",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(InputList, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for input_ in self.input:
            namespaceprefix_ = (
                self.input_nsprefix_ + ":"
                if (UseCapturedNS_ and self.input_nsprefix_)
                else ""
            )
            input_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="input",
                pretty_print=pretty_print,
            )
        for inputW_ in self.input_ws:
            namespaceprefix_ = (
                self.input_ws_nsprefix_ + ":"
                if (UseCapturedNS_ and self.input_ws_nsprefix_)
                else ""
            )
            inputW_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="inputW",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("population", node)
        if value is not None and "population" not in already_processed:
            already_processed.add("population")
            self.populations = value
            self.validate_NmlId(self.populations)  # validate type NmlId
        value = find_attr_value_("component", node)
        if value is not None and "component" not in already_processed:
            already_processed.add("component")
            self.component = value
            self.validate_NmlId(self.component)  # validate type NmlId
        super(InputList, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "input":
            class_obj_ = self.get_class_obj_(child_, Input)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.input.append(obj_)
            obj_.original_tagname_ = "input"
        elif nodeName_ == "inputW":
            obj_ = InputW.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.input_ws.append(obj_)
            obj_.original_tagname_ = "inputW"
        super(InputList, self)._buildChildren(child_, node, nodeName_, True)

    def exportHdf5(self, h5file, h5Group):
        """Export to HDF5 file."""
        # print("Exporting InputList: "+str(self.id)+" as HDF5")

        import numpy

        ilGroup = h5file.create_group(h5Group, "inputList_" + self.id)
        ilGroup._f_setattr("id", self.id)
        ilGroup._f_setattr("component", self.component)
        ilGroup._f_setattr("population", self.populations)

        cols = 4

        extra_cols = {}

        num_tot = len(self.input) + len(self.input_ws)

        if len(self.input_ws) > 0:
            extra_cols["column_" + str(cols)] = "weight"
            cols += 1

        # print("Exporting "+str(num_tot)+" inputs")
        a = numpy.zeros([num_tot, cols], numpy.float32)

        count = 0

        for input in self.input:
            a[count, 0] = input.id
            a[count, 1] = input.get_target_cell_id()
            a[count, 2] = input.get_segment_id()
            a[count, 3] = input.get_fraction_along()
            count += 1

        for input in self.input_ws:
            a[count, 0] = input.id
            a[count, 1] = input.get_target_cell_id()
            a[count, 2] = input.get_segment_id()
            a[count, 3] = input.get_fraction_along()
            a[count, 4] = input.get_weight()
            count += 1

        array = h5file.create_carray(
            ilGroup, self.id, obj=a, title="Locations of inputs in " + self.id
        )

        array._f_setattr("column_0", "id")
        array._f_setattr("column_1", "target_cell_id")
        array._f_setattr("column_2", "segment_id")
        array._f_setattr("column_3", "fraction_along")
        for k in extra_cols:
            array._f_setattr(k, extra_cols[k])

    def __str__(self):

        return (
            "Input list: "
            + self.id
            + " to "
            + self.populations
            + ", component "
            + self.component
        )

    # end class InputList


class BaseConnection(BaseNonNegativeIntegerId):
    """BaseConnection -- Base of all synaptic connections (chemical/electrical/analog, etc.) inside projections"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = []
    subclass = None
    superclass = BaseNonNegativeIntegerId

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        extensiontype_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("BaseConnection"), self).__init__(
            neuro_lex_id, id, extensiontype_, **kwargs_
        )
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, BaseConnection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseConnection.subclass:
            return BaseConnection.subclass(*args_, **kwargs_)
        else:
            return BaseConnection(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if super(BaseConnection, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseConnection",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BaseConnection")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "BaseConnection":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseConnection"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BaseConnection",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BaseConnection",
    ):
        super(BaseConnection, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseConnection"
        )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseConnection",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(BaseConnection, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(BaseConnection, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(BaseConnection, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class BaseConnection


class BaseProjection(Base):
    """BaseProjection -- Base for projection (set of synaptic connections) between two populations"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "presynaptic_population",
            "NmlId",
            0,
            0,
            {"use": "required", "name": "presynaptic_population"},
        ),
        MemberSpec_(
            "postsynaptic_population",
            "NmlId",
            0,
            0,
            {"use": "required", "name": "postsynaptic_population"},
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        presynaptic_population=None,
        postsynaptic_population=None,
        extensiontype_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("BaseProjection"), self).__init__(
            neuro_lex_id, id, extensiontype_, **kwargs_
        )
        self.presynaptic_population = _cast(None, presynaptic_population)
        self.presynaptic_population_nsprefix_ = None
        self.postsynaptic_population = _cast(None, postsynaptic_population)
        self.postsynaptic_population_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, BaseProjection)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BaseProjection.subclass:
            return BaseProjection.subclass(*args_, **kwargs_)
        else:
            return BaseProjection(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if super(BaseProjection, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseProjection",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BaseProjection")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "BaseProjection":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseProjection"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BaseProjection",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BaseProjection",
    ):
        super(BaseProjection, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="BaseProjection"
        )
        if (
            self.presynaptic_population is not None
            and "presynaptic_population" not in already_processed
        ):
            already_processed.add("presynaptic_population")
            outfile.write(
                " presynapticPopulation=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.presynaptic_population),
                            input_name="presynapticPopulation",
                        )
                    ),
                )
            )
        if (
            self.postsynaptic_population is not None
            and "postsynaptic_population" not in already_processed
        ):
            already_processed.add("postsynaptic_population")
            outfile.write(
                " postsynapticPopulation=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.postsynaptic_population),
                            input_name="postsynapticPopulation",
                        )
                    ),
                )
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="BaseProjection",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(BaseProjection, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("presynapticPopulation", node)
        if value is not None and "presynapticPopulation" not in already_processed:
            already_processed.add("presynapticPopulation")
            self.presynaptic_population = value
            self.validate_NmlId(self.presynaptic_population)  # validate type NmlId
        value = find_attr_value_("postsynapticPopulation", node)
        if value is not None and "postsynapticPopulation" not in already_processed:
            already_processed.add("postsynapticPopulation")
            self.postsynaptic_population = value
            self.validate_NmlId(self.postsynaptic_population)  # validate type NmlId
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(BaseProjection, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(BaseProjection, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class BaseProjection


class CellSet(Base):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("select", "xs:string", 0, 0, {"use": "required", "name": "select"}),
        MemberSpec_(
            "__ANY__",
            "__ANY__",
            1,
            1,
            {"maxOccurs": "unbounded", "minOccurs": "0", "processContents": "skip"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        select=None,
        anytypeobjs_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("CellSet"), self).__init__(neuro_lex_id, id, **kwargs_)
        self.select = _cast(None, select)
        self.select_nsprefix_ = None
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, CellSet)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CellSet.subclass:
            return CellSet.subclass(*args_, **kwargs_)
        else:
            return CellSet(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if self.anytypeobjs_ or super(CellSet, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="CellSet",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CellSet")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "CellSet":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CellSet"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="CellSet",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="CellSet"
    ):
        super(CellSet, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CellSet"
        )
        if self.select is not None and "select" not in already_processed:
            already_processed.add("select")
            outfile.write(
                " select=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.select), input_name="select"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="CellSet",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(CellSet, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if not fromsubclass_:
            for obj_ in self.anytypeobjs_:
                showIndent(outfile, level, pretty_print)
                outfile.write(str(obj_))
                outfile.write("\n")

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("select", node)
        if value is not None and "select" not in already_processed:
            already_processed.add("select")
            self.select = value
        super(CellSet, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        content_ = self.gds_build_any(child_, "CellSet")
        self.anytypeobjs_.append(content_)
        super(CellSet, self)._buildChildren(child_, node, nodeName_, True)


# end class CellSet


class Population(Standalone):
    """Population -- A population of components, with just one parameter for the **size,**  i. e. number of components to create. Note: quite often this is used with type= **populationList**  which means the size is determined by the number of  **instance** s ( with  **location** s ) in the list. The **size**  attribute is still set, and there will be a validation error if this does not match the number in the list.
    \n
    :param size: Number of instances of this Component to create when the population is instantiated
    :type size: none

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "component", "NmlId", 0, 0, {"use": "required", "name": "component"}
        ),
        MemberSpec_(
            "size", "NonNegativeInteger", 0, 1, {"use": "optional", "name": "size"}
        ),
        MemberSpec_(
            "type", "populationTypes", 0, 1, {"use": "optional", "name": "type"}
        ),
        MemberSpec_(
            "extracellular_properties",
            "NmlId",
            0,
            1,
            {"use": "optional", "name": "extracellular_properties"},
        ),
        MemberSpec_(
            "layout",
            "Layout",
            0,
            1,
            {"minOccurs": "0", "name": "layout", "type": "Layout"},
            4,
        ),
        MemberSpec_(
            "instances",
            "Instance",
            1,
            0,
            {"maxOccurs": "unbounded", "name": "instance", "type": "Instance"},
            4,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        component=None,
        size=None,
        type=None,
        extracellular_properties=None,
        layout=None,
        instances=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("Population"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.component = _cast(None, component)
        self.component_nsprefix_ = None
        self.size = _cast(int, size)
        self.size_nsprefix_ = None
        self.type = _cast(None, type)
        self.type_nsprefix_ = None
        self.extracellular_properties = _cast(None, extracellular_properties)
        self.extracellular_properties_nsprefix_ = None
        self.layout = layout
        self.layout_nsprefix_ = None
        if instances is None:
            self.instances = []
        else:
            self.instances = instances
        self.instances_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Population)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Population.subclass:
            return Population.subclass(*args_, **kwargs_)
        else:
            return Population(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            pass

    def validate_populationTypes(self, value):
        # Validate type populationTypes, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            value = value
            enumerations = ["population", "populationList"]
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on populationTypes'
                    % {"value": encode_str_2_3(value), "lineno": lineno}
                )
                result = False

    def _hasContent(self):
        if (
            self.layout is not None
            or self.instances
            or super(Population, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Population",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Population")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Population":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Population"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Population",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Population"
    ):
        super(Population, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Population"
        )
        if self.component is not None and "component" not in already_processed:
            already_processed.add("component")
            outfile.write(
                " component=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.component), input_name="component"
                        )
                    ),
                )
            )
        if self.size is not None and "size" not in already_processed:
            already_processed.add("size")
            outfile.write(
                ' size="%s"' % self.gds_format_integer(self.size, input_name="size")
            )
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type), input_name="type"
                        )
                    ),
                )
            )
        if (
            self.extracellular_properties is not None
            and "extracellular_properties" not in already_processed
        ):
            already_processed.add("extracellular_properties")
            outfile.write(
                " extracellularProperties=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.extracellular_properties),
                            input_name="extracellularProperties",
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Population",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Population, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.layout is not None:
            namespaceprefix_ = (
                self.layout_nsprefix_ + ":"
                if (UseCapturedNS_ and self.layout_nsprefix_)
                else ""
            )
            self.layout.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="layout",
                pretty_print=pretty_print,
            )
        for instance_ in self.instances:
            namespaceprefix_ = (
                self.instances_nsprefix_ + ":"
                if (UseCapturedNS_ and self.instances_nsprefix_)
                else ""
            )
            instance_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="instance",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("component", node)
        if value is not None and "component" not in already_processed:
            already_processed.add("component")
            self.component = value
            self.validate_NmlId(self.component)  # validate type NmlId
        value = find_attr_value_("size", node)
        if value is not None and "size" not in already_processed:
            already_processed.add("size")
            self.size = self.gds_parse_integer(value, node, "size")
            if self.size < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.size
            )  # validate type NonNegativeInteger
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_populationTypes(self.type)  # validate type populationTypes
        value = find_attr_value_("extracellularProperties", node)
        if value is not None and "extracellularProperties" not in already_processed:
            already_processed.add("extracellularProperties")
            self.extracellular_properties = value
            self.validate_NmlId(self.extracellular_properties)  # validate type NmlId
        super(Population, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "layout":
            obj_ = Layout.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.layout = obj_
            obj_.original_tagname_ = "layout"
        elif nodeName_ == "instance":
            obj_ = Instance.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.instances.append(obj_)
            obj_.original_tagname_ = "instance"
        super(Population, self)._buildChildren(child_, node, nodeName_, True)

    def exportHdf5(self, h5file, h5Group):
        """Export to HDF5 file."""
        # print("Exporting Population: "+str(self.id)+" as HDF5")

        import numpy

        popGroup = h5file.create_group(h5Group, "population_" + self.id)
        popGroup._f_setattr("id", self.id)
        popGroup._f_setattr("component", self.component)
        for p in self.properties:
            popGroup._f_setattr("property:" + p.tag, p.value)

        if len(self.instances) > 0:

            colCount = 3
            a = numpy.zeros([len(self.instances), colCount], numpy.float32)

            count = 0
            for instance in self.instances:
                a[count, 0] = instance.location.x
                a[count, 1] = instance.location.y
                a[count, 2] = instance.location.z

                count = count + 1

            popGroup._f_setattr("size", count)
            popGroup._f_setattr("type", "populationList")

            array = h5file.create_carray(
                popGroup, self.id, obj=a, title="Locations of cells in " + self.id
            )
            array._f_setattr("column_0", "x")
            array._f_setattr("column_1", "y")
            array._f_setattr("column_2", "z")

        else:
            popGroup._f_setattr("size", self.size)

    def get_size(self):
        return (
            len(self.instances)
            if len(self.instances) > 0
            else (self.size if self.size else 0)
        )

    def __str__(self):

        return (
            "Population: "
            + str(self.id)
            + " with "
            + str(self.get_size())
            + " components of type "
            + (self.component if self.component else "???")
        )

    # end class Population


class Region(Base):
    """Region -- Initial attempt to specify 3D region for placing cells. Work in progress. . ."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("spaces", "NmlId", 0, 1, {"use": "optional", "name": "spaces"}),
        MemberSpec_(
            "__ANY__",
            "__ANY__",
            1,
            1,
            {"maxOccurs": "unbounded", "minOccurs": "0", "processContents": "skip"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        spaces=None,
        anytypeobjs_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("Region"), self).__init__(neuro_lex_id, id, **kwargs_)
        self.spaces = _cast(None, spaces)
        self.spaces_nsprefix_ = None
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Region)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Region.subclass:
            return Region.subclass(*args_, **kwargs_)
        else:
            return Region(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if self.anytypeobjs_ or super(Region, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Region",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Region")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Region":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Region"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Region",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Region"
    ):
        super(Region, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Region"
        )
        if self.spaces is not None and "spaces" not in already_processed:
            already_processed.add("spaces")
            outfile.write(
                " space=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.spaces), input_name="space"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Region",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Region, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if not fromsubclass_:
            for obj_ in self.anytypeobjs_:
                showIndent(outfile, level, pretty_print)
                outfile.write(str(obj_))
                outfile.write("\n")

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("space", node)
        if value is not None and "space" not in already_processed:
            already_processed.add("space")
            self.spaces = value
            self.validate_NmlId(self.spaces)  # validate type NmlId
        super(Region, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        content_ = self.gds_build_any(child_, "Region")
        self.anytypeobjs_.append(content_)
        super(Region, self)._buildChildren(child_, node, nodeName_, True)


# end class Region


class Space(Base):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "based_on", "allowedSpaces", 0, 1, {"use": "optional", "name": "based_on"}
        ),
        MemberSpec_(
            "structure",
            "SpaceStructure",
            0,
            1,
            {"minOccurs": "0", "name": "structure", "type": "SpaceStructure"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        based_on=None,
        structure=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("Space"), self).__init__(neuro_lex_id, id, **kwargs_)
        self.based_on = _cast(None, based_on)
        self.based_on_nsprefix_ = None
        self.structure = structure
        self.structure_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Space)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Space.subclass:
            return Space.subclass(*args_, **kwargs_)
        else:
            return Space(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_allowedSpaces(self, value):
        # Validate type allowedSpaces, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            value = value
            enumerations = [
                "Euclidean_1D",
                "Euclidean_2D",
                "Euclidean_3D",
                "Grid_1D",
                "Grid_2D",
                "Grid_3D",
            ]
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on allowedSpaces'
                    % {"value": encode_str_2_3(value), "lineno": lineno}
                )
                result = False

    def _hasContent(self):
        if self.structure is not None or super(Space, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Space",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Space")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Space":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Space"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Space",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Space"
    ):
        super(Space, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Space"
        )
        if self.based_on is not None and "based_on" not in already_processed:
            already_processed.add("based_on")
            outfile.write(
                " basedOn=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.based_on), input_name="basedOn"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Space",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Space, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.structure is not None:
            namespaceprefix_ = (
                self.structure_nsprefix_ + ":"
                if (UseCapturedNS_ and self.structure_nsprefix_)
                else ""
            )
            self.structure.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="structure",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("basedOn", node)
        if value is not None and "basedOn" not in already_processed:
            already_processed.add("basedOn")
            self.based_on = value
            self.validate_allowedSpaces(self.based_on)  # validate type allowedSpaces
        super(Space, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "structure":
            obj_ = SpaceStructure.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.structure = obj_
            obj_.original_tagname_ = "structure"
        super(Space, self)._buildChildren(child_, node, nodeName_, True)


# end class Space


class Network(Standalone):
    """Network -- Network containing:  **population** s ( potentially of type  **populationList** , and so specifying a list of cell  **location** s );  **projection** s ( with lists of  **connection** s ) and/or  **explicitConnection** s; and  **inputList** s ( with lists of  **input** s ) and/or  **explicitInput** s. Note: often in NeuroML this will be of type  **networkWithTemperature**  if there are temperature dependent elements ( e. g. ion channels )."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("type", "networkTypes", 0, 1, {"use": "optional", "name": "type"}),
        MemberSpec_(
            "temperature",
            "Nml2Quantity_temperature",
            0,
            1,
            {"use": "optional", "name": "temperature"},
        ),
        MemberSpec_(
            "spaces",
            "Space",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "space",
                "type": "Space",
            },
            None,
        ),
        MemberSpec_(
            "regions",
            "Region",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "region",
                "type": "Region",
            },
            None,
        ),
        MemberSpec_(
            "extracellular_properties",
            "ExtracellularPropertiesLocal",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "extracellularProperties",
                "type": "ExtracellularPropertiesLocal",
            },
            None,
        ),
        MemberSpec_(
            "populations",
            "Population",
            1,
            0,
            {"maxOccurs": "unbounded", "name": "population", "type": "Population"},
            None,
        ),
        MemberSpec_(
            "cell_sets",
            "CellSet",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "cellSet",
                "type": "CellSet",
            },
            None,
        ),
        MemberSpec_(
            "synaptic_connections",
            "SynapticConnection",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "synapticConnection",
                "type": "SynapticConnection",
            },
            None,
        ),
        MemberSpec_(
            "projections",
            "Projection",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "projection",
                "type": "Projection",
            },
            None,
        ),
        MemberSpec_(
            "electrical_projections",
            "ElectricalProjection",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "electricalProjection",
                "type": "ElectricalProjection",
            },
            None,
        ),
        MemberSpec_(
            "continuous_projections",
            "ContinuousProjection",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "continuousProjection",
                "type": "ContinuousProjection",
            },
            None,
        ),
        MemberSpec_(
            "explicit_inputs",
            "ExplicitInput",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "explicitInput",
                "type": "ExplicitInput",
            },
            None,
        ),
        MemberSpec_(
            "input_lists",
            "InputList",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "inputList",
                "type": "InputList",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        type=None,
        temperature=None,
        spaces=None,
        regions=None,
        extracellular_properties=None,
        populations=None,
        cell_sets=None,
        synaptic_connections=None,
        projections=None,
        electrical_projections=None,
        continuous_projections=None,
        explicit_inputs=None,
        input_lists=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("Network"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.type = _cast(None, type)
        self.type_nsprefix_ = None
        self.temperature = _cast(None, temperature)
        self.temperature_nsprefix_ = None
        if spaces is None:
            self.spaces = []
        else:
            self.spaces = spaces
        self.spaces_nsprefix_ = None
        if regions is None:
            self.regions = []
        else:
            self.regions = regions
        self.regions_nsprefix_ = None
        if extracellular_properties is None:
            self.extracellular_properties = []
        else:
            self.extracellular_properties = extracellular_properties
        self.extracellular_properties_nsprefix_ = None
        if populations is None:
            self.populations = []
        else:
            self.populations = populations
        self.populations_nsprefix_ = None
        if cell_sets is None:
            self.cell_sets = []
        else:
            self.cell_sets = cell_sets
        self.cell_sets_nsprefix_ = None
        if synaptic_connections is None:
            self.synaptic_connections = []
        else:
            self.synaptic_connections = synaptic_connections
        self.synaptic_connections_nsprefix_ = None
        if projections is None:
            self.projections = []
        else:
            self.projections = projections
        self.projections_nsprefix_ = None
        if electrical_projections is None:
            self.electrical_projections = []
        else:
            self.electrical_projections = electrical_projections
        self.electrical_projections_nsprefix_ = None
        if continuous_projections is None:
            self.continuous_projections = []
        else:
            self.continuous_projections = continuous_projections
        self.continuous_projections_nsprefix_ = None
        if explicit_inputs is None:
            self.explicit_inputs = []
        else:
            self.explicit_inputs = explicit_inputs
        self.explicit_inputs_nsprefix_ = None
        if input_lists is None:
            self.input_lists = []
        else:
            self.input_lists = input_lists
        self.input_lists_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Network)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Network.subclass:
            return Network.subclass(*args_, **kwargs_)
        else:
            return Network(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_networkTypes(self, value):
        # Validate type networkTypes, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            value = value
            enumerations = ["network", "networkWithTemperature"]
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on networkTypes'
                    % {"value": encode_str_2_3(value), "lineno": lineno}
                )
                result = False

    def validate_Nml2Quantity_temperature(self, value):
        # Validate type Nml2Quantity_temperature, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_temperature_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_temperature_patterns_,
                    )
                )

    validate_Nml2Quantity_temperature_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(degC))$"]
    ]

    def _hasContent(self):
        if (
            self.spaces
            or self.regions
            or self.extracellular_properties
            or self.populations
            or self.cell_sets
            or self.synaptic_connections
            or self.projections
            or self.electrical_projections
            or self.continuous_projections
            or self.explicit_inputs
            or self.input_lists
            or super(Network, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Network",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Network")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Network":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Network"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Network",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Network"
    ):
        super(Network, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Network"
        )
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type), input_name="type"
                        )
                    ),
                )
            )
        if self.temperature is not None and "temperature" not in already_processed:
            already_processed.add("temperature")
            outfile.write(
                " temperature=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.temperature), input_name="temperature"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Network",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Network, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for space_ in self.spaces:
            namespaceprefix_ = (
                self.spaces_nsprefix_ + ":"
                if (UseCapturedNS_ and self.spaces_nsprefix_)
                else ""
            )
            space_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="space",
                pretty_print=pretty_print,
            )
        for region_ in self.regions:
            namespaceprefix_ = (
                self.regions_nsprefix_ + ":"
                if (UseCapturedNS_ and self.regions_nsprefix_)
                else ""
            )
            region_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="region",
                pretty_print=pretty_print,
            )
        for extracellularProperties_ in self.extracellular_properties:
            namespaceprefix_ = (
                self.extracellular_properties_nsprefix_ + ":"
                if (UseCapturedNS_ and self.extracellular_properties_nsprefix_)
                else ""
            )
            extracellularProperties_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="extracellularProperties",
                pretty_print=pretty_print,
            )
        for population_ in self.populations:
            namespaceprefix_ = (
                self.populations_nsprefix_ + ":"
                if (UseCapturedNS_ and self.populations_nsprefix_)
                else ""
            )
            population_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="population",
                pretty_print=pretty_print,
            )
        for cellSet_ in self.cell_sets:
            namespaceprefix_ = (
                self.cell_sets_nsprefix_ + ":"
                if (UseCapturedNS_ and self.cell_sets_nsprefix_)
                else ""
            )
            cellSet_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="cellSet",
                pretty_print=pretty_print,
            )
        for synapticConnection_ in self.synaptic_connections:
            namespaceprefix_ = (
                self.synaptic_connections_nsprefix_ + ":"
                if (UseCapturedNS_ and self.synaptic_connections_nsprefix_)
                else ""
            )
            synapticConnection_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="synapticConnection",
                pretty_print=pretty_print,
            )
        for projection_ in self.projections:
            namespaceprefix_ = (
                self.projections_nsprefix_ + ":"
                if (UseCapturedNS_ and self.projections_nsprefix_)
                else ""
            )
            projection_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="projection",
                pretty_print=pretty_print,
            )
        for electricalProjection_ in self.electrical_projections:
            namespaceprefix_ = (
                self.electrical_projections_nsprefix_ + ":"
                if (UseCapturedNS_ and self.electrical_projections_nsprefix_)
                else ""
            )
            electricalProjection_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="electricalProjection",
                pretty_print=pretty_print,
            )
        for continuousProjection_ in self.continuous_projections:
            namespaceprefix_ = (
                self.continuous_projections_nsprefix_ + ":"
                if (UseCapturedNS_ and self.continuous_projections_nsprefix_)
                else ""
            )
            continuousProjection_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="continuousProjection",
                pretty_print=pretty_print,
            )
        for explicitInput_ in self.explicit_inputs:
            namespaceprefix_ = (
                self.explicit_inputs_nsprefix_ + ":"
                if (UseCapturedNS_ and self.explicit_inputs_nsprefix_)
                else ""
            )
            explicitInput_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="explicitInput",
                pretty_print=pretty_print,
            )
        for inputList_ in self.input_lists:
            namespaceprefix_ = (
                self.input_lists_nsprefix_ + ":"
                if (UseCapturedNS_ and self.input_lists_nsprefix_)
                else ""
            )
            inputList_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="inputList",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
            self.validate_networkTypes(self.type)  # validate type networkTypes
        value = find_attr_value_("temperature", node)
        if value is not None and "temperature" not in already_processed:
            already_processed.add("temperature")
            self.temperature = value
            self.validate_Nml2Quantity_temperature(
                self.temperature
            )  # validate type Nml2Quantity_temperature
        super(Network, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "space":
            obj_ = Space.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.spaces.append(obj_)
            obj_.original_tagname_ = "space"
        elif nodeName_ == "region":
            obj_ = Region.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.regions.append(obj_)
            obj_.original_tagname_ = "region"
        elif nodeName_ == "extracellularProperties":
            obj_ = ExtracellularPropertiesLocal.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.extracellular_properties.append(obj_)
            obj_.original_tagname_ = "extracellularProperties"
        elif nodeName_ == "population":
            obj_ = Population.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.populations.append(obj_)
            obj_.original_tagname_ = "population"
        elif nodeName_ == "cellSet":
            obj_ = CellSet.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.cell_sets.append(obj_)
            obj_.original_tagname_ = "cellSet"
        elif nodeName_ == "synapticConnection":
            obj_ = SynapticConnection.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.synaptic_connections.append(obj_)
            obj_.original_tagname_ = "synapticConnection"
        elif nodeName_ == "projection":
            obj_ = Projection.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.projections.append(obj_)
            obj_.original_tagname_ = "projection"
        elif nodeName_ == "electricalProjection":
            obj_ = ElectricalProjection.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.electrical_projections.append(obj_)
            obj_.original_tagname_ = "electricalProjection"
        elif nodeName_ == "continuousProjection":
            obj_ = ContinuousProjection.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.continuous_projections.append(obj_)
            obj_.original_tagname_ = "continuousProjection"
        elif nodeName_ == "explicitInput":
            obj_ = ExplicitInput.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.explicit_inputs.append(obj_)
            obj_.original_tagname_ = "explicitInput"
        elif nodeName_ == "inputList":
            obj_ = InputList.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.input_lists.append(obj_)
            obj_.original_tagname_ = "inputList"
        super(Network, self)._buildChildren(child_, node, nodeName_, True)

    warn_count = 0

    def get_by_id(self, id):
        """Get a component by its ID

        :param id: ID of component to find
        :type id: str
        :returns:  component with specified ID or None if no component with specified ID found
        """
        all_ids = []
        for ms in self.member_data_items_:
            mlist = self.__getattribute__(ms.name)
            for m in mlist:
                if hasattr(m, "id"):
                    if m.id == id:
                        return m
                    else:
                        all_ids.append(m.id)
        from neuroml.loaders import print_

        if self.warn_count < 10:
            print_(
                "Id "
                + id
                + " not found in <network> element. All ids: "
                + str(sorted(all_ids))
            )
            self.warn_count += 1
        elif self.warn_count == 10:
            print_(" - Suppressing further warnings about id not found...")
        return None

    def __str__(self):

        return (
            "Network "
            + str(self.id)
            + " with "
            + str(len(self.populations))
            + " population(s)"
        )

    def exportHdf5(self, h5file, h5Group):
        """Export to HDF5 file."""
        # print("Exporting Network: "+str(self.id)+" as HDF5")

        import numpy

        netGroup = h5file.create_group(h5Group, "network")
        netGroup._f_setattr("id", self.id)
        netGroup._f_setattr("notes", self.notes)
        if self.temperature:
            netGroup._f_setattr("temperature", self.temperature)

        for pop in self.populations:
            pop.exportHdf5(h5file, netGroup)

        if len(self.synaptic_connections) > 0:
            raise Exception("<synapticConnection> not yet supported in HDF5 export")
        if len(self.explicit_inputs) > 0:
            raise Exception("<explicitInput> not yet supported in HDF5 export")

        for proj in self.projections:
            proj.exportHdf5(h5file, netGroup)

        for eproj in self.electrical_projections:
            eproj.exportHdf5(h5file, netGroup)

        for cproj in self.continuous_projections:
            cproj.exportHdf5(h5file, netGroup)

        for il in self.input_lists:
            il.exportHdf5(h5file, netGroup)

    # end class Network


class TransientPoissonFiringSynapse(Standalone):
    """TransientPoissonFiringSynapse -- Poisson spike generator firing at **averageRate**  after a **delay**  and for a **duration,**  connected to single **synapse**  that is triggered every time a spike is generated, providing an input current. Similar to ComponentType  **poissonFiringSynapse** .
    \n
    :param averageRate:
    :type averageRate: per_time
    :param delay:
    :type delay: time
    :param duration:
    :type duration: time

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "average_rate",
            "Nml2Quantity_pertime",
            0,
            0,
            {"use": "required", "name": "average_rate"},
        ),
        MemberSpec_(
            "delay", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "delay"}
        ),
        MemberSpec_(
            "duration",
            "Nml2Quantity_time",
            0,
            0,
            {"use": "required", "name": "duration"},
        ),
        MemberSpec_(
            "synapse", "xs:string", 0, 0, {"use": "required", "name": "synapse"}
        ),
        MemberSpec_(
            "spike_target",
            "xs:string",
            0,
            0,
            {"use": "required", "name": "spike_target"},
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        average_rate=None,
        delay=None,
        duration=None,
        synapse=None,
        spike_target=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("TransientPoissonFiringSynapse"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.average_rate = _cast(None, average_rate)
        self.average_rate_nsprefix_ = None
        self.delay = _cast(None, delay)
        self.delay_nsprefix_ = None
        self.duration = _cast(None, duration)
        self.duration_nsprefix_ = None
        self.synapse = _cast(None, synapse)
        self.synapse_nsprefix_ = None
        self.spike_target = _cast(None, spike_target)
        self.spike_target_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TransientPoissonFiringSynapse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TransientPoissonFiringSynapse.subclass:
            return TransientPoissonFiringSynapse.subclass(*args_, **kwargs_)
        else:
            return TransientPoissonFiringSynapse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_pertime_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_pertime_patterns_,
                    )
                )

    validate_Nml2Quantity_pertime_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s|per_ms|Hz))$"]
    ]

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def _hasContent(self):
        if super(TransientPoissonFiringSynapse, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TransientPoissonFiringSynapse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("TransientPoissonFiringSynapse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "TransientPoissonFiringSynapse"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="TransientPoissonFiringSynapse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="TransientPoissonFiringSynapse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="TransientPoissonFiringSynapse",
    ):
        super(TransientPoissonFiringSynapse, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="TransientPoissonFiringSynapse",
        )
        if self.average_rate is not None and "average_rate" not in already_processed:
            already_processed.add("average_rate")
            outfile.write(
                " averageRate=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.average_rate), input_name="averageRate"
                        )
                    ),
                )
            )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(
                " delay=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.delay), input_name="delay"
                        )
                    ),
                )
            )
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(
                " duration=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.duration), input_name="duration"
                        )
                    ),
                )
            )
        if self.synapse is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            outfile.write(
                " synapse=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.synapse), input_name="synapse"
                        )
                    ),
                )
            )
        if self.spike_target is not None and "spike_target" not in already_processed:
            already_processed.add("spike_target")
            outfile.write(
                " spikeTarget=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.spike_target), input_name="spikeTarget"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="TransientPoissonFiringSynapse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(TransientPoissonFiringSynapse, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("averageRate", node)
        if value is not None and "averageRate" not in already_processed:
            already_processed.add("averageRate")
            self.average_rate = value
            self.validate_Nml2Quantity_pertime(
                self.average_rate
            )  # validate type Nml2Quantity_pertime
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("synapse", node)
        if value is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            self.synapse = value
        value = find_attr_value_("spikeTarget", node)
        if value is not None and "spikeTarget" not in already_processed:
            already_processed.add("spikeTarget")
            self.spike_target = value
        super(TransientPoissonFiringSynapse, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(TransientPoissonFiringSynapse, self)._buildChildren(
            child_, node, nodeName_, True
        )
        pass


# end class TransientPoissonFiringSynapse


class PoissonFiringSynapse(Standalone):
    """PoissonFiringSynapse -- Poisson spike generator firing at **averageRate,**  which is connected to single **synapse**  that is triggered every time a spike is generated, producing an input current. See also  **transientPoissonFiringSynapse** .
    \n
    :param averageRate: The average rate at which spikes are emitted
    :type averageRate: per_time

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "average_rate",
            "Nml2Quantity_pertime",
            0,
            0,
            {"use": "required", "name": "average_rate"},
        ),
        MemberSpec_(
            "synapse", "xs:string", 0, 0, {"use": "required", "name": "synapse"}
        ),
        MemberSpec_(
            "spike_target",
            "xs:string",
            0,
            0,
            {"use": "required", "name": "spike_target"},
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        average_rate=None,
        synapse=None,
        spike_target=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("PoissonFiringSynapse"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.average_rate = _cast(None, average_rate)
        self.average_rate_nsprefix_ = None
        self.synapse = _cast(None, synapse)
        self.synapse_nsprefix_ = None
        self.spike_target = _cast(None, spike_target)
        self.spike_target_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, PoissonFiringSynapse
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PoissonFiringSynapse.subclass:
            return PoissonFiringSynapse.subclass(*args_, **kwargs_)
        else:
            return PoissonFiringSynapse(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_pertime_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_pertime_patterns_,
                    )
                )

    validate_Nml2Quantity_pertime_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s|per_ms|Hz))$"]
    ]

    def _hasContent(self):
        if super(PoissonFiringSynapse, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PoissonFiringSynapse",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PoissonFiringSynapse")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "PoissonFiringSynapse":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="PoissonFiringSynapse",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PoissonFiringSynapse",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="PoissonFiringSynapse",
    ):
        super(PoissonFiringSynapse, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="PoissonFiringSynapse",
        )
        if self.average_rate is not None and "average_rate" not in already_processed:
            already_processed.add("average_rate")
            outfile.write(
                " averageRate=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.average_rate), input_name="averageRate"
                        )
                    ),
                )
            )
        if self.synapse is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            outfile.write(
                " synapse=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.synapse), input_name="synapse"
                        )
                    ),
                )
            )
        if self.spike_target is not None and "spike_target" not in already_processed:
            already_processed.add("spike_target")
            outfile.write(
                " spikeTarget=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.spike_target), input_name="spikeTarget"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PoissonFiringSynapse",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(PoissonFiringSynapse, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("averageRate", node)
        if value is not None and "averageRate" not in already_processed:
            already_processed.add("averageRate")
            self.average_rate = value
            self.validate_Nml2Quantity_pertime(
                self.average_rate
            )  # validate type Nml2Quantity_pertime
        value = find_attr_value_("synapse", node)
        if value is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            self.synapse = value
        value = find_attr_value_("spikeTarget", node)
        if value is not None and "spikeTarget" not in already_processed:
            already_processed.add("spikeTarget")
            self.spike_target = value
        super(PoissonFiringSynapse, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(PoissonFiringSynapse, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class PoissonFiringSynapse


class SpikeGeneratorPoisson(Standalone):
    """SpikeGeneratorPoisson -- Generator of spikes whose ISI is distributed according to an exponential PDF with scale: 1 / **averageRate**
    \n
    :param averageRate: The average rate at which spikes are emitted
    :type averageRate: per_time

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "average_rate",
            "Nml2Quantity_pertime",
            0,
            0,
            {"use": "required", "name": "average_rate"},
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        average_rate=None,
        extensiontype_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("SpikeGeneratorPoisson"), self).__init__(
            neuro_lex_id,
            id,
            metaid,
            notes,
            properties,
            annotation,
            extensiontype_,
            **kwargs_
        )
        self.average_rate = _cast(None, average_rate)
        self.average_rate_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpikeGeneratorPoisson
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeGeneratorPoisson.subclass:
            return SpikeGeneratorPoisson.subclass(*args_, **kwargs_)
        else:
            return SpikeGeneratorPoisson(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_pertime(self, value):
        # Validate type Nml2Quantity_pertime, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_pertime_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_pertime_patterns_,
                    )
                )

    validate_Nml2Quantity_pertime_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(per_s|per_ms|Hz))$"]
    ]

    def _hasContent(self):
        if super(SpikeGeneratorPoisson, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeGeneratorPoisson",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpikeGeneratorPoisson")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SpikeGeneratorPoisson":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpikeGeneratorPoisson",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpikeGeneratorPoisson",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpikeGeneratorPoisson",
    ):
        super(SpikeGeneratorPoisson, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpikeGeneratorPoisson",
        )
        if self.average_rate is not None and "average_rate" not in already_processed:
            already_processed.add("average_rate")
            outfile.write(
                " averageRate=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.average_rate), input_name="averageRate"
                        )
                    ),
                )
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeGeneratorPoisson",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SpikeGeneratorPoisson, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("averageRate", node)
        if value is not None and "averageRate" not in already_processed:
            already_processed.add("averageRate")
            self.average_rate = value
            self.validate_Nml2Quantity_pertime(
                self.average_rate
            )  # validate type Nml2Quantity_pertime
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(SpikeGeneratorPoisson, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(SpikeGeneratorPoisson, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class SpikeGeneratorPoisson


class SpikeGeneratorRandom(Standalone):
    """SpikeGeneratorRandom -- Generator of spikes with a random interspike interval of at least **minISI**  and at most **maxISI**
    \n
    :param maxISI: Maximum interspike interval
    :type maxISI: time
    :param minISI: Minimum interspike interval
    :type minISI: time

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "max_isi", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "max_isi"}
        ),
        MemberSpec_(
            "min_isi", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "min_isi"}
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        max_isi=None,
        min_isi=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("SpikeGeneratorRandom"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.max_isi = _cast(None, max_isi)
        self.max_isi_nsprefix_ = None
        self.min_isi = _cast(None, min_isi)
        self.min_isi_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, SpikeGeneratorRandom
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeGeneratorRandom.subclass:
            return SpikeGeneratorRandom.subclass(*args_, **kwargs_)
        else:
            return SpikeGeneratorRandom(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def _hasContent(self):
        if super(SpikeGeneratorRandom, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeGeneratorRandom",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpikeGeneratorRandom")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SpikeGeneratorRandom":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpikeGeneratorRandom",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpikeGeneratorRandom",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpikeGeneratorRandom",
    ):
        super(SpikeGeneratorRandom, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="SpikeGeneratorRandom",
        )
        if self.max_isi is not None and "max_isi" not in already_processed:
            already_processed.add("max_isi")
            outfile.write(
                " maxISI=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.max_isi), input_name="maxISI"
                        )
                    ),
                )
            )
        if self.min_isi is not None and "min_isi" not in already_processed:
            already_processed.add("min_isi")
            outfile.write(
                " minISI=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.min_isi), input_name="minISI"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeGeneratorRandom",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SpikeGeneratorRandom, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("maxISI", node)
        if value is not None and "maxISI" not in already_processed:
            already_processed.add("maxISI")
            self.max_isi = value
            self.validate_Nml2Quantity_time(
                self.max_isi
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("minISI", node)
        if value is not None and "minISI" not in already_processed:
            already_processed.add("minISI")
            self.min_isi = value
            self.validate_Nml2Quantity_time(
                self.min_isi
            )  # validate type Nml2Quantity_time
        super(SpikeGeneratorRandom, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(SpikeGeneratorRandom, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class SpikeGeneratorRandom


class SpikeGenerator(Standalone):
    """SpikeGenerator -- Simple generator of spikes at a regular interval set by **period**
    \n
    :param period: Time between spikes. The first spike will be emitted after this time.
    :type period: time

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "period", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "period"}
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        period=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("SpikeGenerator"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.period = _cast(None, period)
        self.period_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SpikeGenerator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeGenerator.subclass:
            return SpikeGenerator.subclass(*args_, **kwargs_)
        else:
            return SpikeGenerator(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def _hasContent(self):
        if super(SpikeGenerator, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeGenerator",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpikeGenerator")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SpikeGenerator":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SpikeGenerator"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpikeGenerator",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SpikeGenerator",
    ):
        super(SpikeGenerator, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SpikeGenerator"
        )
        if self.period is not None and "period" not in already_processed:
            already_processed.add("period")
            outfile.write(
                " period=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.period), input_name="period"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SpikeGenerator",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SpikeGenerator, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("period", node)
        if value is not None and "period" not in already_processed:
            already_processed.add("period")
            self.period = value
            self.validate_Nml2Quantity_time(
                self.period
            )  # validate type Nml2Quantity_time
        super(SpikeGenerator, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(SpikeGenerator, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class SpikeGenerator


class TimedSynapticInput(Standalone):
    """TimedSynapticInput -- Spike array connected to a single **synapse,**  producing a current triggered by each  **spike**  in the array."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("synapse", "NmlId", 0, 0, {"use": "required", "name": "synapse"}),
        MemberSpec_(
            "spike_target",
            "xs:string",
            0,
            0,
            {"use": "required", "name": "spike_target"},
        ),
        MemberSpec_(
            "spikes",
            "Spike",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "spike",
                "type": "Spike",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        synapse=None,
        spike_target=None,
        spikes=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("TimedSynapticInput"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.synapse = _cast(None, synapse)
        self.synapse_nsprefix_ = None
        self.spike_target = _cast(None, spike_target)
        self.spike_target_nsprefix_ = None
        if spikes is None:
            self.spikes = []
        else:
            self.spikes = spikes
        self.spikes_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, TimedSynapticInput
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if TimedSynapticInput.subclass:
            return TimedSynapticInput.subclass(*args_, **kwargs_)
        else:
            return TimedSynapticInput(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if self.spikes or super(TimedSynapticInput, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="TimedSynapticInput",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("TimedSynapticInput")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "TimedSynapticInput":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="TimedSynapticInput",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="TimedSynapticInput",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="TimedSynapticInput",
    ):
        super(TimedSynapticInput, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="TimedSynapticInput",
        )
        if self.synapse is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            outfile.write(
                " synapse=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.synapse), input_name="synapse"
                        )
                    ),
                )
            )
        if self.spike_target is not None and "spike_target" not in already_processed:
            already_processed.add("spike_target")
            outfile.write(
                " spikeTarget=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.spike_target), input_name="spikeTarget"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="TimedSynapticInput",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(TimedSynapticInput, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for spike_ in self.spikes:
            namespaceprefix_ = (
                self.spikes_nsprefix_ + ":"
                if (UseCapturedNS_ and self.spikes_nsprefix_)
                else ""
            )
            spike_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="spike",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("synapse", node)
        if value is not None and "synapse" not in already_processed:
            already_processed.add("synapse")
            self.synapse = value
            self.validate_NmlId(self.synapse)  # validate type NmlId
        value = find_attr_value_("spikeTarget", node)
        if value is not None and "spikeTarget" not in already_processed:
            already_processed.add("spikeTarget")
            self.spike_target = value
        super(TimedSynapticInput, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "spike":
            obj_ = Spike.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.spikes.append(obj_)
            obj_.original_tagname_ = "spike"
        super(TimedSynapticInput, self)._buildChildren(child_, node, nodeName_, True)


# end class TimedSynapticInput


class SpikeArray(Standalone):
    """SpikeArray -- Set of spike ComponentTypes, each emitting one spike at a certain time. Can be used to feed a predetermined spike train into a cell"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "spikes",
            "Spike",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "spike",
                "type": "Spike",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        spikes=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("SpikeArray"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        if spikes is None:
            self.spikes = []
        else:
            self.spikes = spikes
        self.spikes_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SpikeArray)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SpikeArray.subclass:
            return SpikeArray.subclass(*args_, **kwargs_)
        else:
            return SpikeArray(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if self.spikes or super(SpikeArray, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="SpikeArray",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SpikeArray")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SpikeArray":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SpikeArray"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SpikeArray",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="SpikeArray"
    ):
        super(SpikeArray, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SpikeArray"
        )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="SpikeArray",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SpikeArray, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for spike_ in self.spikes:
            namespaceprefix_ = (
                self.spikes_nsprefix_ + ":"
                if (UseCapturedNS_ and self.spikes_nsprefix_)
                else ""
            )
            spike_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="spike",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        super(SpikeArray, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "spike":
            obj_ = Spike.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.spikes.append(obj_)
            obj_.original_tagname_ = "spike"
        super(SpikeArray, self)._buildChildren(child_, node, nodeName_, True)


# end class SpikeArray


class Spike(BaseNonNegativeIntegerId):
    """Spike -- Emits a single spike at the specified **time**
    \n
    :param time: Time at which to emit one spike event
    :type time: time

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "time", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "time"}
        ),
    ]
    subclass = None
    superclass = BaseNonNegativeIntegerId

    def __init__(
        self, neuro_lex_id=None, id=None, time=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("Spike"), self).__init__(neuro_lex_id, id, **kwargs_)
        self.time = _cast(None, time)
        self.time_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Spike)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Spike.subclass:
            return Spike.subclass(*args_, **kwargs_)
        else:
            return Spike(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def _hasContent(self):
        if super(Spike, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Spike",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Spike")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Spike":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Spike"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Spike",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Spike"
    ):
        super(Spike, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Spike"
        )
        if self.time is not None and "time" not in already_processed:
            already_processed.add("time")
            outfile.write(
                " time=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.time), input_name="time"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="Spike",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Spike, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("time", node)
        if value is not None and "time" not in already_processed:
            already_processed.add("time")
            self.time = value
            self.validate_Nml2Quantity_time(
                self.time
            )  # validate type Nml2Quantity_time
        super(Spike, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(Spike, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class Spike


class VoltageClampTriple(Standalone):
    """VoltageClampTriple -- Voltage clamp with 3 clamp levels. Applies a variable current **i**  ( through **simpleSeriesResistance**  ) to try to keep parent cell at **conditioningVoltage**  until time **delay,**  **testingVoltage**  until **delay**  + **duration,**  and **returnVoltage**  afterwards. Only enabled if **active**  = 1.
    \n
    :param active: Whether the voltage clamp is active ( 1 ) or inactive ( 0 ).
    :type active: none
    :param delay: Delay before switching from conditioningVoltage to testingVoltage.
    :type delay: time
    :param duration: Duration to hold at testingVoltage.
    :type duration: time
    :param conditioningVoltage: Target voltage before time delay
    :type conditioningVoltage: voltage
    :param testingVoltage: Target voltage between times delay and delay + duration
    :type testingVoltage: voltage
    :param returnVoltage: Target voltage after time duration
    :type returnVoltage: voltage
    :param simpleSeriesResistance: Current will be calculated by the difference in voltage between the target and parent, divided by this value
    :type simpleSeriesResistance: resistance

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("active", "ZeroOrOne", 0, 0, {"use": "required", "name": "active"}),
        MemberSpec_(
            "delay", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "delay"}
        ),
        MemberSpec_(
            "duration",
            "Nml2Quantity_time",
            0,
            0,
            {"use": "required", "name": "duration"},
        ),
        MemberSpec_(
            "conditioning_voltage",
            "Nml2Quantity_voltage",
            0,
            0,
            {"use": "required", "name": "conditioning_voltage"},
        ),
        MemberSpec_(
            "testing_voltage",
            "Nml2Quantity_voltage",
            0,
            0,
            {"use": "required", "name": "testing_voltage"},
        ),
        MemberSpec_(
            "return_voltage",
            "Nml2Quantity_voltage",
            0,
            0,
            {"use": "required", "name": "return_voltage"},
        ),
        MemberSpec_(
            "simple_series_resistance",
            "Nml2Quantity_resistance",
            0,
            0,
            {"use": "required", "name": "simple_series_resistance"},
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        active=None,
        delay=None,
        duration=None,
        conditioning_voltage=None,
        testing_voltage=None,
        return_voltage=None,
        simple_series_resistance=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("VoltageClampTriple"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.active = _cast(float, active)
        self.active_nsprefix_ = None
        self.delay = _cast(None, delay)
        self.delay_nsprefix_ = None
        self.duration = _cast(None, duration)
        self.duration_nsprefix_ = None
        self.conditioning_voltage = _cast(None, conditioning_voltage)
        self.conditioning_voltage_nsprefix_ = None
        self.testing_voltage = _cast(None, testing_voltage)
        self.testing_voltage_nsprefix_ = None
        self.return_voltage = _cast(None, return_voltage)
        self.return_voltage_nsprefix_ = None
        self.simple_series_resistance = _cast(None, simple_series_resistance)
        self.simple_series_resistance_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, VoltageClampTriple
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VoltageClampTriple.subclass:
            return VoltageClampTriple.subclass(*args_, **kwargs_)
        else:
            return VoltageClampTriple(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_ZeroOrOne(self, value):
        # Validate type ZeroOrOne, a restriction on xs:double.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, float):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (float)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            value = value
            enumerations = [0.0, 1.0]
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on ZeroOrOne'
                    % {"value": encode_str_2_3(value), "lineno": lineno}
                )
                result = False

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV))$"]
    ]

    def validate_Nml2Quantity_resistance(self, value):
        # Validate type Nml2Quantity_resistance, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_resistance_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_resistance_patterns_,
                    )
                )

    validate_Nml2Quantity_resistance_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(ohm|kohm|Mohm))$"]
    ]

    def _hasContent(self):
        if super(VoltageClampTriple, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="VoltageClampTriple",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("VoltageClampTriple")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "VoltageClampTriple":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="VoltageClampTriple",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="VoltageClampTriple",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="VoltageClampTriple",
    ):
        super(VoltageClampTriple, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="VoltageClampTriple",
        )
        if self.active is not None and "active" not in already_processed:
            already_processed.add("active")
            outfile.write(
                ' active="%s"'
                % self.gds_format_double(self.active, input_name="active")
            )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(
                " delay=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.delay), input_name="delay"
                        )
                    ),
                )
            )
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(
                " duration=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.duration), input_name="duration"
                        )
                    ),
                )
            )
        if (
            self.conditioning_voltage is not None
            and "conditioning_voltage" not in already_processed
        ):
            already_processed.add("conditioning_voltage")
            outfile.write(
                " conditioningVoltage=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.conditioning_voltage),
                            input_name="conditioningVoltage",
                        )
                    ),
                )
            )
        if (
            self.testing_voltage is not None
            and "testing_voltage" not in already_processed
        ):
            already_processed.add("testing_voltage")
            outfile.write(
                " testingVoltage=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.testing_voltage),
                            input_name="testingVoltage",
                        )
                    ),
                )
            )
        if (
            self.return_voltage is not None
            and "return_voltage" not in already_processed
        ):
            already_processed.add("return_voltage")
            outfile.write(
                " returnVoltage=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.return_voltage),
                            input_name="returnVoltage",
                        )
                    ),
                )
            )
        if (
            self.simple_series_resistance is not None
            and "simple_series_resistance" not in already_processed
        ):
            already_processed.add("simple_series_resistance")
            outfile.write(
                " simpleSeriesResistance=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.simple_series_resistance),
                            input_name="simpleSeriesResistance",
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="VoltageClampTriple",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(VoltageClampTriple, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("active", node)
        if value is not None and "active" not in already_processed:
            already_processed.add("active")
            value = self.gds_parse_double(value, node, "active")
            self.active = value
            self.validate_ZeroOrOne(self.active)  # validate type ZeroOrOne
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("conditioningVoltage", node)
        if value is not None and "conditioningVoltage" not in already_processed:
            already_processed.add("conditioningVoltage")
            self.conditioning_voltage = value
            self.validate_Nml2Quantity_voltage(
                self.conditioning_voltage
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("testingVoltage", node)
        if value is not None and "testingVoltage" not in already_processed:
            already_processed.add("testingVoltage")
            self.testing_voltage = value
            self.validate_Nml2Quantity_voltage(
                self.testing_voltage
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("returnVoltage", node)
        if value is not None and "returnVoltage" not in already_processed:
            already_processed.add("returnVoltage")
            self.return_voltage = value
            self.validate_Nml2Quantity_voltage(
                self.return_voltage
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("simpleSeriesResistance", node)
        if value is not None and "simpleSeriesResistance" not in already_processed:
            already_processed.add("simpleSeriesResistance")
            self.simple_series_resistance = value
            self.validate_Nml2Quantity_resistance(
                self.simple_series_resistance
            )  # validate type Nml2Quantity_resistance
        super(VoltageClampTriple, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(VoltageClampTriple, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class VoltageClampTriple


class VoltageClamp(Standalone):
    """VoltageClamp -- Voltage clamp. Applies a variable current **i**  to try to keep parent at **targetVoltage.**  Not yet fully tested!!! Consider using voltageClampTriple!!
    \n
    :param delay: Delay before change in current. Current is zero prior to this.
    :type delay: time
    :param duration: Duration for attempting to keep parent at targetVoltage. Current is zero after delay + duration.
    :type duration: time
    :param targetVoltage: Current will be applied to try to get parent to this target voltage
    :type targetVoltage: voltage
    :param simpleSeriesResistance: Current will be calculated by the difference in voltage between the target and parent, divided by this value
    :type simpleSeriesResistance: resistance

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "delay", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "delay"}
        ),
        MemberSpec_(
            "duration",
            "Nml2Quantity_time",
            0,
            0,
            {"use": "required", "name": "duration"},
        ),
        MemberSpec_(
            "target_voltage",
            "Nml2Quantity_voltage",
            0,
            0,
            {"use": "required", "name": "target_voltage"},
        ),
        MemberSpec_(
            "simple_series_resistance",
            "Nml2Quantity_resistance",
            0,
            0,
            {"use": "required", "name": "simple_series_resistance"},
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        duration=None,
        target_voltage=None,
        simple_series_resistance=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("VoltageClamp"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.delay_nsprefix_ = None
        self.duration = _cast(None, duration)
        self.duration_nsprefix_ = None
        self.target_voltage = _cast(None, target_voltage)
        self.target_voltage_nsprefix_ = None
        self.simple_series_resistance = _cast(None, simple_series_resistance)
        self.simple_series_resistance_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, VoltageClamp)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if VoltageClamp.subclass:
            return VoltageClamp.subclass(*args_, **kwargs_)
        else:
            return VoltageClamp(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV))$"]
    ]

    def validate_Nml2Quantity_resistance(self, value):
        # Validate type Nml2Quantity_resistance, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_resistance_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_resistance_patterns_,
                    )
                )

    validate_Nml2Quantity_resistance_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(ohm|kohm|Mohm))$"]
    ]

    def _hasContent(self):
        if super(VoltageClamp, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="VoltageClamp",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("VoltageClamp")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "VoltageClamp":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="VoltageClamp"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="VoltageClamp",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="VoltageClamp",
    ):
        super(VoltageClamp, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="VoltageClamp"
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(
                " delay=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.delay), input_name="delay"
                        )
                    ),
                )
            )
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(
                " duration=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.duration), input_name="duration"
                        )
                    ),
                )
            )
        if (
            self.target_voltage is not None
            and "target_voltage" not in already_processed
        ):
            already_processed.add("target_voltage")
            outfile.write(
                " targetVoltage=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.target_voltage),
                            input_name="targetVoltage",
                        )
                    ),
                )
            )
        if (
            self.simple_series_resistance is not None
            and "simple_series_resistance" not in already_processed
        ):
            already_processed.add("simple_series_resistance")
            outfile.write(
                " simpleSeriesResistance=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.simple_series_resistance),
                            input_name="simpleSeriesResistance",
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="VoltageClamp",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(VoltageClamp, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("targetVoltage", node)
        if value is not None and "targetVoltage" not in already_processed:
            already_processed.add("targetVoltage")
            self.target_voltage = value
            self.validate_Nml2Quantity_voltage(
                self.target_voltage
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("simpleSeriesResistance", node)
        if value is not None and "simpleSeriesResistance" not in already_processed:
            already_processed.add("simpleSeriesResistance")
            self.simple_series_resistance = value
            self.validate_Nml2Quantity_resistance(
                self.simple_series_resistance
            )  # validate type Nml2Quantity_resistance
        super(VoltageClamp, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(VoltageClamp, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class VoltageClamp


class CompoundInputDL(Standalone):
    """CompoundInputDL -- Generates a current which is the sum of all its child  **basePointCurrentDL**  elements, e. g. can be a combination of  **pulseGeneratorDL** ,  **sineGeneratorDL**  elements producing a single **i.**  Scaled by **weight,**  if set"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "pulse_generator_dls",
            "PulseGeneratorDL",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "pulseGeneratorDL",
                "type": "PulseGeneratorDL",
            },
            None,
        ),
        MemberSpec_(
            "sine_generator_dls",
            "SineGeneratorDL",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "sineGeneratorDL",
                "type": "SineGeneratorDL",
            },
            None,
        ),
        MemberSpec_(
            "ramp_generator_dls",
            "RampGeneratorDL",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "rampGeneratorDL",
                "type": "RampGeneratorDL",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        pulse_generator_dls=None,
        sine_generator_dls=None,
        ramp_generator_dls=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("CompoundInputDL"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        if pulse_generator_dls is None:
            self.pulse_generator_dls = []
        else:
            self.pulse_generator_dls = pulse_generator_dls
        self.pulse_generator_dls_nsprefix_ = None
        if sine_generator_dls is None:
            self.sine_generator_dls = []
        else:
            self.sine_generator_dls = sine_generator_dls
        self.sine_generator_dls_nsprefix_ = None
        if ramp_generator_dls is None:
            self.ramp_generator_dls = []
        else:
            self.ramp_generator_dls = ramp_generator_dls
        self.ramp_generator_dls_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, CompoundInputDL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CompoundInputDL.subclass:
            return CompoundInputDL.subclass(*args_, **kwargs_)
        else:
            return CompoundInputDL(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if (
            self.pulse_generator_dls
            or self.sine_generator_dls
            or self.ramp_generator_dls
            or super(CompoundInputDL, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="CompoundInputDL",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CompoundInputDL")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "CompoundInputDL":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CompoundInputDL"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="CompoundInputDL",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="CompoundInputDL",
    ):
        super(CompoundInputDL, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CompoundInputDL"
        )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="CompoundInputDL",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(CompoundInputDL, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for pulseGeneratorDL_ in self.pulse_generator_dls:
            namespaceprefix_ = (
                self.pulse_generator_dls_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pulse_generator_dls_nsprefix_)
                else ""
            )
            pulseGeneratorDL_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="pulseGeneratorDL",
                pretty_print=pretty_print,
            )
        for sineGeneratorDL_ in self.sine_generator_dls:
            namespaceprefix_ = (
                self.sine_generator_dls_nsprefix_ + ":"
                if (UseCapturedNS_ and self.sine_generator_dls_nsprefix_)
                else ""
            )
            sineGeneratorDL_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="sineGeneratorDL",
                pretty_print=pretty_print,
            )
        for rampGeneratorDL_ in self.ramp_generator_dls:
            namespaceprefix_ = (
                self.ramp_generator_dls_nsprefix_ + ":"
                if (UseCapturedNS_ and self.ramp_generator_dls_nsprefix_)
                else ""
            )
            rampGeneratorDL_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="rampGeneratorDL",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        super(CompoundInputDL, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "pulseGeneratorDL":
            obj_ = PulseGeneratorDL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pulse_generator_dls.append(obj_)
            obj_.original_tagname_ = "pulseGeneratorDL"
        elif nodeName_ == "sineGeneratorDL":
            obj_ = SineGeneratorDL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sine_generator_dls.append(obj_)
            obj_.original_tagname_ = "sineGeneratorDL"
        elif nodeName_ == "rampGeneratorDL":
            obj_ = RampGeneratorDL.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ramp_generator_dls.append(obj_)
            obj_.original_tagname_ = "rampGeneratorDL"
        super(CompoundInputDL, self)._buildChildren(child_, node, nodeName_, True)


# end class CompoundInputDL


class CompoundInput(Standalone):
    """CompoundInput -- Generates a current which is the sum of all its child  **basePointCurrent**  element, e. g. can be a combination of  **pulseGenerator** ,  **sineGenerator**  elements producing a single **i.**  Scaled by **weight,**  if set"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "pulse_generators",
            "PulseGenerator",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "pulseGenerator",
                "type": "PulseGenerator",
            },
            None,
        ),
        MemberSpec_(
            "sine_generators",
            "SineGenerator",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "sineGenerator",
                "type": "SineGenerator",
            },
            None,
        ),
        MemberSpec_(
            "ramp_generators",
            "RampGenerator",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "rampGenerator",
                "type": "RampGenerator",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        pulse_generators=None,
        sine_generators=None,
        ramp_generators=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("CompoundInput"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        if pulse_generators is None:
            self.pulse_generators = []
        else:
            self.pulse_generators = pulse_generators
        self.pulse_generators_nsprefix_ = None
        if sine_generators is None:
            self.sine_generators = []
        else:
            self.sine_generators = sine_generators
        self.sine_generators_nsprefix_ = None
        if ramp_generators is None:
            self.ramp_generators = []
        else:
            self.ramp_generators = ramp_generators
        self.ramp_generators_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, CompoundInput)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if CompoundInput.subclass:
            return CompoundInput.subclass(*args_, **kwargs_)
        else:
            return CompoundInput(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if (
            self.pulse_generators
            or self.sine_generators
            or self.ramp_generators
            or super(CompoundInput, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="CompoundInput",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("CompoundInput")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "CompoundInput":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CompoundInput"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="CompoundInput",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="CompoundInput",
    ):
        super(CompoundInput, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="CompoundInput"
        )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="CompoundInput",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(CompoundInput, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for pulseGenerator_ in self.pulse_generators:
            namespaceprefix_ = (
                self.pulse_generators_nsprefix_ + ":"
                if (UseCapturedNS_ and self.pulse_generators_nsprefix_)
                else ""
            )
            pulseGenerator_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="pulseGenerator",
                pretty_print=pretty_print,
            )
        for sineGenerator_ in self.sine_generators:
            namespaceprefix_ = (
                self.sine_generators_nsprefix_ + ":"
                if (UseCapturedNS_ and self.sine_generators_nsprefix_)
                else ""
            )
            sineGenerator_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="sineGenerator",
                pretty_print=pretty_print,
            )
        for rampGenerator_ in self.ramp_generators:
            namespaceprefix_ = (
                self.ramp_generators_nsprefix_ + ":"
                if (UseCapturedNS_ and self.ramp_generators_nsprefix_)
                else ""
            )
            rampGenerator_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="rampGenerator",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        super(CompoundInput, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "pulseGenerator":
            obj_ = PulseGenerator.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.pulse_generators.append(obj_)
            obj_.original_tagname_ = "pulseGenerator"
        elif nodeName_ == "sineGenerator":
            obj_ = SineGenerator.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sine_generators.append(obj_)
            obj_.original_tagname_ = "sineGenerator"
        elif nodeName_ == "rampGenerator":
            obj_ = RampGenerator.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.ramp_generators.append(obj_)
            obj_.original_tagname_ = "rampGenerator"
        super(CompoundInput, self)._buildChildren(child_, node, nodeName_, True)


# end class CompoundInput


class RampGeneratorDL(Standalone):
    """RampGeneratorDL -- Dimensionless equivalent of  **rampGenerator** . Generates a ramping current after a time **delay,**  for a fixed **duration.**  During this time the dimensionless current steadily changes from **startAmplitude**  to **finishAmplitude.**  Scaled by **weight,**  if set
    \n
    :param delay: Delay before change in current. Current is baselineAmplitude prior to this.
    :type delay: time
    :param duration: Duration for holding current at amplitude. Current is baselineAmplitude after delay + duration.
    :type duration: time
    :param startAmplitude: Amplitude of linearly varying current at time delay
    :type startAmplitude: none
    :param finishAmplitude: Amplitude of linearly varying current at time delay + duration
    :type finishAmplitude: none
    :param baselineAmplitude: Amplitude of current before time delay, and after time delay + duration
    :type baselineAmplitude: none

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "delay", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "delay"}
        ),
        MemberSpec_(
            "duration",
            "Nml2Quantity_time",
            0,
            0,
            {"use": "required", "name": "duration"},
        ),
        MemberSpec_(
            "start_amplitude",
            "Nml2Quantity_none",
            0,
            0,
            {"use": "required", "name": "start_amplitude"},
        ),
        MemberSpec_(
            "finish_amplitude",
            "Nml2Quantity_none",
            0,
            0,
            {"use": "required", "name": "finish_amplitude"},
        ),
        MemberSpec_(
            "baseline_amplitude",
            "Nml2Quantity_none",
            0,
            0,
            {"use": "required", "name": "baseline_amplitude"},
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        duration=None,
        start_amplitude=None,
        finish_amplitude=None,
        baseline_amplitude=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("RampGeneratorDL"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.delay_nsprefix_ = None
        self.duration = _cast(None, duration)
        self.duration_nsprefix_ = None
        self.start_amplitude = _cast(None, start_amplitude)
        self.start_amplitude_nsprefix_ = None
        self.finish_amplitude = _cast(None, finish_amplitude)
        self.finish_amplitude_nsprefix_ = None
        self.baseline_amplitude = _cast(None, baseline_amplitude)
        self.baseline_amplitude_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, RampGeneratorDL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RampGeneratorDL.subclass:
            return RampGeneratorDL.subclass(*args_, **kwargs_)
        else:
            return RampGeneratorDL(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_none_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_none_patterns_,
                    )
                )

    validate_Nml2Quantity_none_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?)$"]
    ]

    def _hasContent(self):
        if super(RampGeneratorDL, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="RampGeneratorDL",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("RampGeneratorDL")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "RampGeneratorDL":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="RampGeneratorDL"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="RampGeneratorDL",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="RampGeneratorDL",
    ):
        super(RampGeneratorDL, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="RampGeneratorDL"
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(
                " delay=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.delay), input_name="delay"
                        )
                    ),
                )
            )
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(
                " duration=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.duration), input_name="duration"
                        )
                    ),
                )
            )
        if (
            self.start_amplitude is not None
            and "start_amplitude" not in already_processed
        ):
            already_processed.add("start_amplitude")
            outfile.write(
                " startAmplitude=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.start_amplitude),
                            input_name="startAmplitude",
                        )
                    ),
                )
            )
        if (
            self.finish_amplitude is not None
            and "finish_amplitude" not in already_processed
        ):
            already_processed.add("finish_amplitude")
            outfile.write(
                " finishAmplitude=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.finish_amplitude),
                            input_name="finishAmplitude",
                        )
                    ),
                )
            )
        if (
            self.baseline_amplitude is not None
            and "baseline_amplitude" not in already_processed
        ):
            already_processed.add("baseline_amplitude")
            outfile.write(
                " baselineAmplitude=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.baseline_amplitude),
                            input_name="baselineAmplitude",
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="RampGeneratorDL",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(RampGeneratorDL, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("startAmplitude", node)
        if value is not None and "startAmplitude" not in already_processed:
            already_processed.add("startAmplitude")
            self.start_amplitude = value
            self.validate_Nml2Quantity_none(
                self.start_amplitude
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("finishAmplitude", node)
        if value is not None and "finishAmplitude" not in already_processed:
            already_processed.add("finishAmplitude")
            self.finish_amplitude = value
            self.validate_Nml2Quantity_none(
                self.finish_amplitude
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("baselineAmplitude", node)
        if value is not None and "baselineAmplitude" not in already_processed:
            already_processed.add("baselineAmplitude")
            self.baseline_amplitude = value
            self.validate_Nml2Quantity_none(
                self.baseline_amplitude
            )  # validate type Nml2Quantity_none
        super(RampGeneratorDL, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(RampGeneratorDL, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class RampGeneratorDL


class RampGenerator(Standalone):
    """RampGenerator -- Generates a ramping current after a time **delay,**  for a fixed **duration.**  During this time the current steadily changes from **startAmplitude**  to **finishAmplitude.**  Scaled by **weight,**  if set
    \n
    :param delay: Delay before change in current. Current is baselineAmplitude prior to this.
    :type delay: time
    :param duration: Duration for holding current at amplitude. Current is baselineAmplitude after delay + duration.
    :type duration: time
    :param startAmplitude: Amplitude of linearly varying current at time delay
    :type startAmplitude: current
    :param finishAmplitude: Amplitude of linearly varying current at time delay + duration
    :type finishAmplitude: current
    :param baselineAmplitude: Amplitude of current before time delay, and after time delay + duration
    :type baselineAmplitude: current

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "delay", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "delay"}
        ),
        MemberSpec_(
            "duration",
            "Nml2Quantity_time",
            0,
            0,
            {"use": "required", "name": "duration"},
        ),
        MemberSpec_(
            "start_amplitude",
            "Nml2Quantity_current",
            0,
            0,
            {"use": "required", "name": "start_amplitude"},
        ),
        MemberSpec_(
            "finish_amplitude",
            "Nml2Quantity_current",
            0,
            0,
            {"use": "required", "name": "finish_amplitude"},
        ),
        MemberSpec_(
            "baseline_amplitude",
            "Nml2Quantity_current",
            0,
            0,
            {"use": "required", "name": "baseline_amplitude"},
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        duration=None,
        start_amplitude=None,
        finish_amplitude=None,
        baseline_amplitude=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("RampGenerator"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.delay_nsprefix_ = None
        self.duration = _cast(None, duration)
        self.duration_nsprefix_ = None
        self.start_amplitude = _cast(None, start_amplitude)
        self.start_amplitude_nsprefix_ = None
        self.finish_amplitude = _cast(None, finish_amplitude)
        self.finish_amplitude_nsprefix_ = None
        self.baseline_amplitude = _cast(None, baseline_amplitude)
        self.baseline_amplitude_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, RampGenerator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if RampGenerator.subclass:
            return RampGenerator.subclass(*args_, **kwargs_)
        else:
            return RampGenerator(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_current_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_current_patterns_,
                    )
                )

    validate_Nml2Quantity_current_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(A|uA|nA|pA))$"]
    ]

    def _hasContent(self):
        if super(RampGenerator, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="RampGenerator",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("RampGenerator")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "RampGenerator":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="RampGenerator"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="RampGenerator",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="RampGenerator",
    ):
        super(RampGenerator, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="RampGenerator"
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(
                " delay=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.delay), input_name="delay"
                        )
                    ),
                )
            )
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(
                " duration=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.duration), input_name="duration"
                        )
                    ),
                )
            )
        if (
            self.start_amplitude is not None
            and "start_amplitude" not in already_processed
        ):
            already_processed.add("start_amplitude")
            outfile.write(
                " startAmplitude=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.start_amplitude),
                            input_name="startAmplitude",
                        )
                    ),
                )
            )
        if (
            self.finish_amplitude is not None
            and "finish_amplitude" not in already_processed
        ):
            already_processed.add("finish_amplitude")
            outfile.write(
                " finishAmplitude=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.finish_amplitude),
                            input_name="finishAmplitude",
                        )
                    ),
                )
            )
        if (
            self.baseline_amplitude is not None
            and "baseline_amplitude" not in already_processed
        ):
            already_processed.add("baseline_amplitude")
            outfile.write(
                " baselineAmplitude=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.baseline_amplitude),
                            input_name="baselineAmplitude",
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="RampGenerator",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(RampGenerator, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("startAmplitude", node)
        if value is not None and "startAmplitude" not in already_processed:
            already_processed.add("startAmplitude")
            self.start_amplitude = value
            self.validate_Nml2Quantity_current(
                self.start_amplitude
            )  # validate type Nml2Quantity_current
        value = find_attr_value_("finishAmplitude", node)
        if value is not None and "finishAmplitude" not in already_processed:
            already_processed.add("finishAmplitude")
            self.finish_amplitude = value
            self.validate_Nml2Quantity_current(
                self.finish_amplitude
            )  # validate type Nml2Quantity_current
        value = find_attr_value_("baselineAmplitude", node)
        if value is not None and "baselineAmplitude" not in already_processed:
            already_processed.add("baselineAmplitude")
            self.baseline_amplitude = value
            self.validate_Nml2Quantity_current(
                self.baseline_amplitude
            )  # validate type Nml2Quantity_current
        super(RampGenerator, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(RampGenerator, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class RampGenerator


class SineGeneratorDL(Standalone):
    """SineGeneratorDL -- Dimensionless equivalent of  **sineGenerator** . Generates a sinusoidally varying current after a time **delay,**  for a fixed **duration.**  The **period**  and maximum **amplitude**  of the current can be set as well as the **phase**  at which to start. Scaled by **weight,**  if set
    \n
    :param phase: Phase ( between 0 and 2*pi ) at which to start the varying current ( i. e. at time given by delay )
    :type phase: none
    :param delay: Delay before change in current. Current is zero prior to this.
    :type delay: time
    :param duration: Duration for holding current at amplitude. Current is zero after delay + duration.
    :type duration: time
    :param amplitude: Maximum amplitude of current
    :type amplitude: none
    :param period: Time period of oscillation
    :type period: time

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "delay", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "delay"}
        ),
        MemberSpec_(
            "phase", "Nml2Quantity_none", 0, 0, {"use": "required", "name": "phase"}
        ),
        MemberSpec_(
            "duration",
            "Nml2Quantity_time",
            0,
            0,
            {"use": "required", "name": "duration"},
        ),
        MemberSpec_(
            "amplitude",
            "Nml2Quantity_none",
            0,
            0,
            {"use": "required", "name": "amplitude"},
        ),
        MemberSpec_(
            "period", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "period"}
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        phase=None,
        duration=None,
        amplitude=None,
        period=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("SineGeneratorDL"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.delay_nsprefix_ = None
        self.phase = _cast(None, phase)
        self.phase_nsprefix_ = None
        self.duration = _cast(None, duration)
        self.duration_nsprefix_ = None
        self.amplitude = _cast(None, amplitude)
        self.amplitude_nsprefix_ = None
        self.period = _cast(None, period)
        self.period_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SineGeneratorDL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SineGeneratorDL.subclass:
            return SineGeneratorDL.subclass(*args_, **kwargs_)
        else:
            return SineGeneratorDL(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_none_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_none_patterns_,
                    )
                )

    validate_Nml2Quantity_none_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?)$"]
    ]

    def _hasContent(self):
        if super(SineGeneratorDL, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SineGeneratorDL",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SineGeneratorDL")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SineGeneratorDL":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SineGeneratorDL"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SineGeneratorDL",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SineGeneratorDL",
    ):
        super(SineGeneratorDL, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SineGeneratorDL"
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(
                " delay=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.delay), input_name="delay"
                        )
                    ),
                )
            )
        if self.phase is not None and "phase" not in already_processed:
            already_processed.add("phase")
            outfile.write(
                " phase=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.phase), input_name="phase"
                        )
                    ),
                )
            )
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(
                " duration=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.duration), input_name="duration"
                        )
                    ),
                )
            )
        if self.amplitude is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            outfile.write(
                " amplitude=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.amplitude), input_name="amplitude"
                        )
                    ),
                )
            )
        if self.period is not None and "period" not in already_processed:
            already_processed.add("period")
            outfile.write(
                " period=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.period), input_name="period"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SineGeneratorDL",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SineGeneratorDL, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("phase", node)
        if value is not None and "phase" not in already_processed:
            already_processed.add("phase")
            self.phase = value
            self.validate_Nml2Quantity_none(
                self.phase
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("amplitude", node)
        if value is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            self.amplitude = value
            self.validate_Nml2Quantity_none(
                self.amplitude
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("period", node)
        if value is not None and "period" not in already_processed:
            already_processed.add("period")
            self.period = value
            self.validate_Nml2Quantity_time(
                self.period
            )  # validate type Nml2Quantity_time
        super(SineGeneratorDL, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(SineGeneratorDL, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class SineGeneratorDL


class SineGenerator(Standalone):
    """SineGenerator -- Generates a sinusoidally varying current after a time **delay,**  for a fixed **duration.**  The **period**  and maximum **amplitude**  of the current can be set as well as the **phase**  at which to start. Scaled by **weight,**  if set
    \n
    :param phase: Phase ( between 0 and 2*pi ) at which to start the varying current ( i. e. at time given by delay )
    :type phase: none
    :param delay: Delay before change in current. Current is zero prior to this.
    :type delay: time
    :param duration: Duration for holding current at amplitude. Current is zero after delay + duration.
    :type duration: time
    :param amplitude: Maximum amplitude of current
    :type amplitude: current
    :param period: Time period of oscillation
    :type period: time

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "delay", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "delay"}
        ),
        MemberSpec_(
            "phase", "Nml2Quantity_none", 0, 0, {"use": "required", "name": "phase"}
        ),
        MemberSpec_(
            "duration",
            "Nml2Quantity_time",
            0,
            0,
            {"use": "required", "name": "duration"},
        ),
        MemberSpec_(
            "amplitude",
            "Nml2Quantity_current",
            0,
            0,
            {"use": "required", "name": "amplitude"},
        ),
        MemberSpec_(
            "period", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "period"}
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        phase=None,
        duration=None,
        amplitude=None,
        period=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("SineGenerator"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.delay_nsprefix_ = None
        self.phase = _cast(None, phase)
        self.phase_nsprefix_ = None
        self.duration = _cast(None, duration)
        self.duration_nsprefix_ = None
        self.amplitude = _cast(None, amplitude)
        self.amplitude_nsprefix_ = None
        self.period = _cast(None, period)
        self.period_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SineGenerator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SineGenerator.subclass:
            return SineGenerator.subclass(*args_, **kwargs_)
        else:
            return SineGenerator(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_none_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_none_patterns_,
                    )
                )

    validate_Nml2Quantity_none_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?)$"]
    ]

    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_current_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_current_patterns_,
                    )
                )

    validate_Nml2Quantity_current_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(A|uA|nA|pA))$"]
    ]

    def _hasContent(self):
        if super(SineGenerator, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SineGenerator",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SineGenerator")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SineGenerator":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SineGenerator"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SineGenerator",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SineGenerator",
    ):
        super(SineGenerator, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SineGenerator"
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(
                " delay=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.delay), input_name="delay"
                        )
                    ),
                )
            )
        if self.phase is not None and "phase" not in already_processed:
            already_processed.add("phase")
            outfile.write(
                " phase=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.phase), input_name="phase"
                        )
                    ),
                )
            )
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(
                " duration=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.duration), input_name="duration"
                        )
                    ),
                )
            )
        if self.amplitude is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            outfile.write(
                " amplitude=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.amplitude), input_name="amplitude"
                        )
                    ),
                )
            )
        if self.period is not None and "period" not in already_processed:
            already_processed.add("period")
            outfile.write(
                " period=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.period), input_name="period"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="SineGenerator",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SineGenerator, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("phase", node)
        if value is not None and "phase" not in already_processed:
            already_processed.add("phase")
            self.phase = value
            self.validate_Nml2Quantity_none(
                self.phase
            )  # validate type Nml2Quantity_none
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("amplitude", node)
        if value is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            self.amplitude = value
            self.validate_Nml2Quantity_current(
                self.amplitude
            )  # validate type Nml2Quantity_current
        value = find_attr_value_("period", node)
        if value is not None and "period" not in already_processed:
            already_processed.add("period")
            self.period = value
            self.validate_Nml2Quantity_time(
                self.period
            )  # validate type Nml2Quantity_time
        super(SineGenerator, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(SineGenerator, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class SineGenerator


class PulseGeneratorDL(Standalone):
    """PulseGeneratorDL -- Dimensionless equivalent of  **pulseGenerator** . Generates a constant current pulse of a certain **amplitude**  for a specified **duration**  after a **delay.**  Scaled by **weight,**  if set
    \n
    :param delay: Delay before change in current. Current is zero prior to this.
    :type delay: time
    :param duration: Duration for holding current at amplitude. Current is zero after delay + duration.
    :type duration: time
    :param amplitude: Amplitude of current pulse
    :type amplitude: none

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "delay", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "delay"}
        ),
        MemberSpec_(
            "duration",
            "Nml2Quantity_time",
            0,
            0,
            {"use": "required", "name": "duration"},
        ),
        MemberSpec_(
            "amplitude",
            "Nml2Quantity_none",
            0,
            0,
            {"use": "required", "name": "amplitude"},
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        duration=None,
        amplitude=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("PulseGeneratorDL"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.delay_nsprefix_ = None
        self.duration = _cast(None, duration)
        self.duration_nsprefix_ = None
        self.amplitude = _cast(None, amplitude)
        self.amplitude_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PulseGeneratorDL)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PulseGeneratorDL.subclass:
            return PulseGeneratorDL.subclass(*args_, **kwargs_)
        else:
            return PulseGeneratorDL(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def validate_Nml2Quantity_none(self, value):
        # Validate type Nml2Quantity_none, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_none_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_none_patterns_,
                    )
                )

    validate_Nml2Quantity_none_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?)$"]
    ]

    def _hasContent(self):
        if super(PulseGeneratorDL, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PulseGeneratorDL",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PulseGeneratorDL")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "PulseGeneratorDL":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="PulseGeneratorDL",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PulseGeneratorDL",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="PulseGeneratorDL",
    ):
        super(PulseGeneratorDL, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="PulseGeneratorDL",
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(
                " delay=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.delay), input_name="delay"
                        )
                    ),
                )
            )
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(
                " duration=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.duration), input_name="duration"
                        )
                    ),
                )
            )
        if self.amplitude is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            outfile.write(
                " amplitude=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.amplitude), input_name="amplitude"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PulseGeneratorDL",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(PulseGeneratorDL, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("amplitude", node)
        if value is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            self.amplitude = value
            self.validate_Nml2Quantity_none(
                self.amplitude
            )  # validate type Nml2Quantity_none
        super(PulseGeneratorDL, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(PulseGeneratorDL, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class PulseGeneratorDL


class PulseGenerator(Standalone):
    """PulseGenerator -- Generates a constant current pulse of a certain **amplitude**  for a specified **duration**  after a **delay.**  Scaled by **weight,**  if set
    \n
    :param delay: Delay before change in current. Current is zero prior to this.
    :type delay: time
    :param duration: Duration for holding current at amplitude. Current is zero after delay + duration.
    :type duration: time
    :param amplitude: Amplitude of current pulse
    :type amplitude: current

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "delay", "Nml2Quantity_time", 0, 0, {"use": "required", "name": "delay"}
        ),
        MemberSpec_(
            "duration",
            "Nml2Quantity_time",
            0,
            0,
            {"use": "required", "name": "duration"},
        ),
        MemberSpec_(
            "amplitude",
            "Nml2Quantity_current",
            0,
            0,
            {"use": "required", "name": "amplitude"},
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        delay=None,
        duration=None,
        amplitude=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("PulseGenerator"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.delay = _cast(None, delay)
        self.delay_nsprefix_ = None
        self.duration = _cast(None, duration)
        self.duration_nsprefix_ = None
        self.amplitude = _cast(None, amplitude)
        self.amplitude_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, PulseGenerator)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if PulseGenerator.subclass:
            return PulseGenerator.subclass(*args_, **kwargs_)
        else:
            return PulseGenerator(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Nml2Quantity_time(self, value):
        # Validate type Nml2Quantity_time, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_time_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_time_patterns_,
                    )
                )

    validate_Nml2Quantity_time_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(s|ms))$"]
    ]

    def validate_Nml2Quantity_current(self, value):
        # Validate type Nml2Quantity_current, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_current_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_current_patterns_,
                    )
                )

    validate_Nml2Quantity_current_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(A|uA|nA|pA))$"]
    ]

    def _hasContent(self):
        if super(PulseGenerator, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PulseGenerator",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("PulseGenerator")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "PulseGenerator":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="PulseGenerator"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="PulseGenerator",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="PulseGenerator",
    ):
        super(PulseGenerator, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="PulseGenerator"
        )
        if self.delay is not None and "delay" not in already_processed:
            already_processed.add("delay")
            outfile.write(
                " delay=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.delay), input_name="delay"
                        )
                    ),
                )
            )
        if self.duration is not None and "duration" not in already_processed:
            already_processed.add("duration")
            outfile.write(
                " duration=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.duration), input_name="duration"
                        )
                    ),
                )
            )
        if self.amplitude is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            outfile.write(
                " amplitude=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.amplitude), input_name="amplitude"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="PulseGenerator",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(PulseGenerator, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("delay", node)
        if value is not None and "delay" not in already_processed:
            already_processed.add("delay")
            self.delay = value
            self.validate_Nml2Quantity_time(
                self.delay
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("duration", node)
        if value is not None and "duration" not in already_processed:
            already_processed.add("duration")
            self.duration = value
            self.validate_Nml2Quantity_time(
                self.duration
            )  # validate type Nml2Quantity_time
        value = find_attr_value_("amplitude", node)
        if value is not None and "amplitude" not in already_processed:
            already_processed.add("amplitude")
            self.amplitude = value
            self.validate_Nml2Quantity_current(
                self.amplitude
            )  # validate type Nml2Quantity_current
        super(PulseGenerator, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(PulseGenerator, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class PulseGenerator


class ReactionScheme(Base):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("source", "xs:string", 0, 0, {"use": "required", "name": "source"}),
        MemberSpec_("type", "xs:string", 0, 0, {"use": "required", "name": "type"}),
        MemberSpec_(
            "__ANY__",
            "__ANY__",
            1,
            1,
            {"maxOccurs": "unbounded", "minOccurs": "0", "processContents": "skip"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        source=None,
        type=None,
        anytypeobjs_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("ReactionScheme"), self).__init__(
            neuro_lex_id, id, **kwargs_
        )
        self.source = _cast(None, source)
        self.source_nsprefix_ = None
        self.type = _cast(None, type)
        self.type_nsprefix_ = None
        if anytypeobjs_ is None:
            self.anytypeobjs_ = []
        else:
            self.anytypeobjs_ = anytypeobjs_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ReactionScheme)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ReactionScheme.subclass:
            return ReactionScheme.subclass(*args_, **kwargs_)
        else:
            return ReactionScheme(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if self.anytypeobjs_ or super(ReactionScheme, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ReactionScheme",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ReactionScheme")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ReactionScheme":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ReactionScheme"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ReactionScheme",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ReactionScheme",
    ):
        super(ReactionScheme, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ReactionScheme"
        )
        if self.source is not None and "source" not in already_processed:
            already_processed.add("source")
            outfile.write(
                " source=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.source), input_name="source"
                        )
                    ),
                )
            )
        if self.type is not None and "type" not in already_processed:
            already_processed.add("type")
            outfile.write(
                " type=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.type), input_name="type"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ReactionScheme",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ReactionScheme, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if not fromsubclass_:
            for obj_ in self.anytypeobjs_:
                showIndent(outfile, level, pretty_print)
                outfile.write(str(obj_))
                outfile.write("\n")

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("source", node)
        if value is not None and "source" not in already_processed:
            already_processed.add("source")
            self.source = value
        value = find_attr_value_("type", node)
        if value is not None and "type" not in already_processed:
            already_processed.add("type")
            self.type = value
        super(ReactionScheme, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        content_ = self.gds_build_any(child_, "ReactionScheme")
        self.anytypeobjs_.append(content_)
        super(ReactionScheme, self)._buildChildren(child_, node, nodeName_, True)


# end class ReactionScheme


class ExtracellularProperties(Base):
    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "species",
            "Species",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "species",
                "type": "Species",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self, neuro_lex_id=None, id=None, species=None, gds_collector_=None, **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("ExtracellularProperties"), self).__init__(
            neuro_lex_id, id, **kwargs_
        )
        if species is None:
            self.species = []
        else:
            self.species = species
        self.species_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ExtracellularProperties
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ExtracellularProperties.subclass:
            return ExtracellularProperties.subclass(*args_, **kwargs_)
        else:
            return ExtracellularProperties(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if self.species or super(ExtracellularProperties, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ExtracellularProperties",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ExtracellularProperties")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ExtracellularProperties":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ExtracellularProperties",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ExtracellularProperties",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ExtracellularProperties",
    ):
        super(ExtracellularProperties, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ExtracellularProperties",
        )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ExtracellularProperties",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ExtracellularProperties, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for species_ in self.species:
            namespaceprefix_ = (
                self.species_nsprefix_ + ":"
                if (UseCapturedNS_ and self.species_nsprefix_)
                else ""
            )
            species_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="species",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        super(ExtracellularProperties, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "species":
            obj_ = Species.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.species.append(obj_)
            obj_.original_tagname_ = "species"
        super(ExtracellularProperties, self)._buildChildren(
            child_, node, nodeName_, True
        )


# end class ExtracellularProperties


class ChannelDensityGHK2(Base):
    """ChannelDensityGHK2 -- Time varying conductance density, **gDensity,**  which is distributed on an area of the cell, producing a current density **iDensity.**  Modified version of Jaffe et al. 1994 ( used also in Lawrence et al. 2006 ). See https://github.com/OpenSourceBrain/ghk-nernst.
    \n
    :param condDensity:
    :type condDensity: conductanceDensity

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "ion_channel", "NmlId", 0, 0, {"use": "required", "name": "ion_channel"}
        ),
        MemberSpec_(
            "cond_density",
            "Nml2Quantity_conductanceDensity",
            0,
            1,
            {"use": "optional", "name": "cond_density"},
        ),
        MemberSpec_(
            "segment_groups",
            "NmlId",
            0,
            1,
            {"use": "optional", "name": "segment_groups"},
        ),
        MemberSpec_("segments", "NmlId", 0, 1, {"use": "optional", "name": "segments"}),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": "required", "name": "ion"}),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        cond_density=None,
        segment_groups="all",
        segments=None,
        ion=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("ChannelDensityGHK2"), self).__init__(
            neuro_lex_id, id, **kwargs_
        )
        self.ion_channel = _cast(None, ion_channel)
        self.ion_channel_nsprefix_ = None
        self.cond_density = _cast(None, cond_density)
        self.cond_density_nsprefix_ = None
        self.segment_groups = _cast(None, segment_groups)
        self.segment_groups_nsprefix_ = None
        self.segments = _cast(None, segments)
        self.segments_nsprefix_ = None
        self.ion = _cast(None, ion)
        self.ion_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityGHK2
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityGHK2.subclass:
            return ChannelDensityGHK2.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityGHK2(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_Nml2Quantity_conductanceDensity(self, value):
        # Validate type Nml2Quantity_conductanceDensity, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_conductanceDensity_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_conductanceDensity_patterns_,
                    )
                )

    validate_Nml2Quantity_conductanceDensity_patterns_ = [
        [
            "^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S_per_m2|mS_per_cm2|S_per_cm2))$"
        ]
    ]

    def _hasContent(self):
        if super(ChannelDensityGHK2, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityGHK2",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelDensityGHK2")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ChannelDensityGHK2":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityGHK2",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensityGHK2",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensityGHK2",
    ):
        super(ChannelDensityGHK2, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityGHK2",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(
                " ionChannel=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.ion_channel), input_name="ionChannel"
                        )
                    ),
                )
            )
        if self.cond_density is not None and "cond_density" not in already_processed:
            already_processed.add("cond_density")
            outfile.write(
                " condDensity=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.cond_density), input_name="condDensity"
                        )
                    ),
                )
            )
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(
                " segmentGroup=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segment_groups), input_name="segmentGroup"
                        )
                    ),
                )
            )
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(
                " segment=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segments), input_name="segment"
                        )
                    ),
                )
            )
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(
                " ion=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.ion), input_name="ion")
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityGHK2",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensityGHK2, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("condDensity", node)
        if value is not None and "condDensity" not in already_processed:
            already_processed.add("condDensity")
            self.cond_density = value
            self.validate_Nml2Quantity_conductanceDensity(
                self.cond_density
            )  # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            self.segments = value
            self.validate_NmlId(self.segments)  # validate type NmlId
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        super(ChannelDensityGHK2, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(ChannelDensityGHK2, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class ChannelDensityGHK2


class ChannelDensityGHK(Base):
    """ChannelDensityGHK -- Specifies a time varying conductance density, **gDensity,**  which is distributed on an area of the cell, producing a current density **iDensity**  and whose reversal potential is calculated from the Goldman Hodgkin Katz equation. Hard coded for Ca only! See https://github.com/OpenSourceBrain/ghk-nernst.
    \n
    :param permeability:
    :type permeability: permeability

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "ion_channel", "NmlId", 0, 0, {"use": "required", "name": "ion_channel"}
        ),
        MemberSpec_(
            "permeability",
            "Nml2Quantity_permeability",
            0,
            0,
            {"use": "required", "name": "permeability"},
        ),
        MemberSpec_(
            "segment_groups",
            "NmlId",
            0,
            1,
            {"use": "optional", "name": "segment_groups"},
        ),
        MemberSpec_("segments", "NmlId", 0, 1, {"use": "optional", "name": "segments"}),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": "required", "name": "ion"}),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        permeability=None,
        segment_groups="all",
        segments=None,
        ion=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("ChannelDensityGHK"), self).__init__(
            neuro_lex_id, id, **kwargs_
        )
        self.ion_channel = _cast(None, ion_channel)
        self.ion_channel_nsprefix_ = None
        self.permeability = _cast(None, permeability)
        self.permeability_nsprefix_ = None
        self.segment_groups = _cast(None, segment_groups)
        self.segment_groups_nsprefix_ = None
        self.segments = _cast(None, segments)
        self.segments_nsprefix_ = None
        self.ion = _cast(None, ion)
        self.ion_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ChannelDensityGHK)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityGHK.subclass:
            return ChannelDensityGHK.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityGHK(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_Nml2Quantity_permeability(self, value):
        # Validate type Nml2Quantity_permeability, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_permeability_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_permeability_patterns_,
                    )
                )

    validate_Nml2Quantity_permeability_patterns_ = [
        [
            "^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(m_per_s|um_per_ms|cm_per_s|cm_per_ms))$"
        ]
    ]

    def _hasContent(self):
        if super(ChannelDensityGHK, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityGHK",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelDensityGHK")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ChannelDensityGHK":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityGHK",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensityGHK",
                pretty_print=pretty_print,
            )
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensityGHK",
    ):
        super(ChannelDensityGHK, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityGHK",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(
                " ionChannel=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.ion_channel), input_name="ionChannel"
                        )
                    ),
                )
            )
        if self.permeability is not None and "permeability" not in already_processed:
            already_processed.add("permeability")
            outfile.write(
                " permeability=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.permeability), input_name="permeability"
                        )
                    ),
                )
            )
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(
                " segmentGroup=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segment_groups), input_name="segmentGroup"
                        )
                    ),
                )
            )
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(
                " segment=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segments), input_name="segment"
                        )
                    ),
                )
            )
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(
                " ion=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.ion), input_name="ion")
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_="",
        name_="ChannelDensityGHK",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensityGHK, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        pass

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("permeability", node)
        if value is not None and "permeability" not in already_processed:
            already_processed.add("permeability")
            self.permeability = value
            self.validate_Nml2Quantity_permeability(
                self.permeability
            )  # validate type Nml2Quantity_permeability
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            self.segments = value
            self.validate_NmlId(self.segments)  # validate type NmlId
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        super(ChannelDensityGHK, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        super(ChannelDensityGHK, self)._buildChildren(child_, node, nodeName_, True)
        pass


# end class ChannelDensityGHK


class ChannelDensityNernst(Base):
    """ChannelDensityNernst -- Specifies a time varying conductance density, **gDensity,**  which is distributed on an area of the **cell,**  producing a current density **iDensity**  and whose reversal potential is calculated from the Nernst equation. Hard coded for Ca only! See https://github.com/OpenSourceBrain/ghk-nernst.
    \n
    :param condDensity:
    :type condDensity: conductanceDensity

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "ion_channel", "NmlId", 0, 0, {"use": "required", "name": "ion_channel"}
        ),
        MemberSpec_(
            "cond_density",
            "Nml2Quantity_conductanceDensity",
            0,
            1,
            {"use": "optional", "name": "cond_density"},
        ),
        MemberSpec_(
            "segment_groups",
            "NmlId",
            0,
            1,
            {"use": "optional", "name": "segment_groups"},
        ),
        MemberSpec_("segments", "NmlId", 0, 1, {"use": "optional", "name": "segments"}),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": "required", "name": "ion"}),
        MemberSpec_(
            "variable_parameters",
            "VariableParameter",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "variableParameter",
                "type": "VariableParameter",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        cond_density=None,
        segment_groups="all",
        segments=None,
        ion=None,
        variable_parameters=None,
        extensiontype_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("ChannelDensityNernst"), self).__init__(
            neuro_lex_id, id, extensiontype_, **kwargs_
        )
        self.ion_channel = _cast(None, ion_channel)
        self.ion_channel_nsprefix_ = None
        self.cond_density = _cast(None, cond_density)
        self.cond_density_nsprefix_ = None
        self.segment_groups = _cast(None, segment_groups)
        self.segment_groups_nsprefix_ = None
        self.segments = _cast(None, segments)
        self.segments_nsprefix_ = None
        self.ion = _cast(None, ion)
        self.ion_nsprefix_ = None
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
        self.variable_parameters_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityNernst
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityNernst.subclass:
            return ChannelDensityNernst.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityNernst(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_Nml2Quantity_conductanceDensity(self, value):
        # Validate type Nml2Quantity_conductanceDensity, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_conductanceDensity_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_conductanceDensity_patterns_,
                    )
                )

    validate_Nml2Quantity_conductanceDensity_patterns_ = [
        [
            "^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S_per_m2|mS_per_cm2|S_per_cm2))$"
        ]
    ]

    def _hasContent(self):
        if self.variable_parameters or super(ChannelDensityNernst, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ChannelDensityNernst",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelDensityNernst")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ChannelDensityNernst":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNernst",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensityNernst",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensityNernst",
    ):
        super(ChannelDensityNernst, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNernst",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(
                " ionChannel=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.ion_channel), input_name="ionChannel"
                        )
                    ),
                )
            )
        if self.cond_density is not None and "cond_density" not in already_processed:
            already_processed.add("cond_density")
            outfile.write(
                " condDensity=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.cond_density), input_name="condDensity"
                        )
                    ),
                )
            )
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(
                " segmentGroup=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segment_groups), input_name="segmentGroup"
                        )
                    ),
                )
            )
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(
                " segment=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segments), input_name="segment"
                        )
                    ),
                )
            )
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(
                " ion=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.ion), input_name="ion")
                    ),
                )
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ChannelDensityNernst",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensityNernst, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for variableParameter_ in self.variable_parameters:
            namespaceprefix_ = (
                self.variable_parameters_nsprefix_ + ":"
                if (UseCapturedNS_ and self.variable_parameters_nsprefix_)
                else ""
            )
            variableParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="variableParameter",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("condDensity", node)
        if value is not None and "condDensity" not in already_processed:
            already_processed.add("condDensity")
            self.cond_density = value
            self.validate_Nml2Quantity_conductanceDensity(
                self.cond_density
            )  # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            self.segments = value
            self.validate_NmlId(self.segments)  # validate type NmlId
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(ChannelDensityNernst, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "variableParameter":
            obj_ = VariableParameter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = "variableParameter"
        super(ChannelDensityNernst, self)._buildChildren(child_, node, nodeName_, True)


# end class ChannelDensityNernst


class ChannelDensity(Base):
    """ChannelDensity -- Specifies a time varying ohmic conductance density, **gDensity,**  which is distributed on an area of the **cell**  ( specified in  **membraneProperties**  ) with fixed reversal potential **erev**  producing a current density **iDensity**
    \n
    :param erev: The reversal potential of the current produced
    :type erev: voltage
    :param condDensity:
    :type condDensity: conductanceDensity

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "ion_channel", "NmlId", 0, 0, {"use": "required", "name": "ion_channel"}
        ),
        MemberSpec_(
            "cond_density",
            "Nml2Quantity_conductanceDensity",
            0,
            1,
            {"use": "optional", "name": "cond_density"},
        ),
        MemberSpec_(
            "erev", "Nml2Quantity_voltage", 0, 0, {"use": "required", "name": "erev"}
        ),
        MemberSpec_(
            "segment_groups",
            "NmlId",
            0,
            1,
            {"use": "optional", "name": "segment_groups"},
        ),
        MemberSpec_(
            "segments",
            "NonNegativeInteger",
            0,
            1,
            {"use": "optional", "name": "segments"},
        ),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": "required", "name": "ion"}),
        MemberSpec_(
            "variable_parameters",
            "VariableParameter",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "variableParameter",
                "type": "VariableParameter",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        cond_density=None,
        erev=None,
        segment_groups="all",
        segments=None,
        ion=None,
        variable_parameters=None,
        extensiontype_=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("ChannelDensity"), self).__init__(
            neuro_lex_id, id, extensiontype_, **kwargs_
        )
        self.ion_channel = _cast(None, ion_channel)
        self.ion_channel_nsprefix_ = None
        self.cond_density = _cast(None, cond_density)
        self.cond_density_nsprefix_ = None
        self.erev = _cast(None, erev)
        self.erev_nsprefix_ = None
        self.segment_groups = _cast(None, segment_groups)
        self.segment_groups_nsprefix_ = None
        self.segments = _cast(int, segments)
        self.segments_nsprefix_ = None
        self.ion = _cast(None, ion)
        self.ion_nsprefix_ = None
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
        self.variable_parameters_nsprefix_ = None
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ChannelDensity)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensity.subclass:
            return ChannelDensity.subclass(*args_, **kwargs_)
        else:
            return ChannelDensity(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_Nml2Quantity_conductanceDensity(self, value):
        # Validate type Nml2Quantity_conductanceDensity, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_conductanceDensity_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_conductanceDensity_patterns_,
                    )
                )

    validate_Nml2Quantity_conductanceDensity_patterns_ = [
        [
            "^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(S_per_m2|mS_per_cm2|S_per_cm2))$"
        ]
    ]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV))$"]
    ]

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            pass

    def _hasContent(self):
        if self.variable_parameters or super(ChannelDensity, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ChannelDensity",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelDensity")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ChannelDensity":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ChannelDensity"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensity",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensity",
    ):
        super(ChannelDensity, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="ChannelDensity"
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(
                " ionChannel=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.ion_channel), input_name="ionChannel"
                        )
                    ),
                )
            )
        if self.cond_density is not None and "cond_density" not in already_processed:
            already_processed.add("cond_density")
            outfile.write(
                " condDensity=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.cond_density), input_name="condDensity"
                        )
                    ),
                )
            )
        if self.erev is not None and "erev" not in already_processed:
            already_processed.add("erev")
            outfile.write(
                " erev=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.erev), input_name="erev"
                        )
                    ),
                )
            )
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(
                " segmentGroup=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segment_groups), input_name="segmentGroup"
                        )
                    ),
                )
            )
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(
                ' segment="%s"'
                % self.gds_format_integer(self.segments, input_name="segment")
            )
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(
                " ion=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.ion), input_name="ion")
                    ),
                )
            )
        if self.extensiontype_ is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            if ":" not in self.extensiontype_:
                imported_ns_type_prefix_ = GenerateDSNamespaceTypePrefixes_.get(
                    self.extensiontype_, ""
                )
                outfile.write(
                    ' xsi:type="%s%s"' % (imported_ns_type_prefix_, self.extensiontype_)
                )
            else:
                outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ChannelDensity",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensity, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for variableParameter_ in self.variable_parameters:
            namespaceprefix_ = (
                self.variable_parameters_nsprefix_ + ":"
                if (UseCapturedNS_ and self.variable_parameters_nsprefix_)
                else ""
            )
            variableParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="variableParameter",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("condDensity", node)
        if value is not None and "condDensity" not in already_processed:
            already_processed.add("condDensity")
            self.cond_density = value
            self.validate_Nml2Quantity_conductanceDensity(
                self.cond_density
            )  # validate type Nml2Quantity_conductanceDensity
        value = find_attr_value_("erev", node)
        if value is not None and "erev" not in already_processed:
            already_processed.add("erev")
            self.erev = value
            self.validate_Nml2Quantity_voltage(
                self.erev
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            self.segments = self.gds_parse_integer(value, node, "segment")
            if self.segments < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.segments
            )  # validate type NonNegativeInteger
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        value = find_attr_value_("xsi:type", node)
        if value is not None and "xsi:type" not in already_processed:
            already_processed.add("xsi:type")
            self.extensiontype_ = value
        super(ChannelDensity, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "variableParameter":
            obj_ = VariableParameter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = "variableParameter"
        super(ChannelDensity, self)._buildChildren(child_, node, nodeName_, True)


# end class ChannelDensity


class ChannelDensityNonUniformGHK(Base):
    """ChannelDensityNonUniformGHK -- Specifies a time varying conductance density, which is distributed on a region of the **cell,**  and whose current is calculated from the Goldman-Hodgkin-Katz equation. Hard coded for Ca only!. The conductance density of the channel is not uniform, but is set using the  **variableParameter** . Note, there is no dynamical description of this in LEMS yet, as this type only makes sense for multicompartmental cells. A ComponentType for this needs to be present to enable export of NeuroML 2 multicompartmental cells via LEMS/jNeuroML to NEURON"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "ion_channel", "NmlId", 0, 0, {"use": "required", "name": "ion_channel"}
        ),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": "required", "name": "ion"}),
        MemberSpec_(
            "variable_parameters",
            "VariableParameter",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "variableParameter",
                "type": "VariableParameter",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        ion=None,
        variable_parameters=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("ChannelDensityNonUniformGHK"), self).__init__(
            neuro_lex_id, id, **kwargs_
        )
        self.ion_channel = _cast(None, ion_channel)
        self.ion_channel_nsprefix_ = None
        self.ion = _cast(None, ion)
        self.ion_nsprefix_ = None
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
        self.variable_parameters_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityNonUniformGHK
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityNonUniformGHK.subclass:
            return ChannelDensityNonUniformGHK.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityNonUniformGHK(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if (
            self.variable_parameters
            or super(ChannelDensityNonUniformGHK, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ChannelDensityNonUniformGHK",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelDensityNonUniformGHK")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "ChannelDensityNonUniformGHK"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNonUniformGHK",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensityNonUniformGHK",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensityNonUniformGHK",
    ):
        super(ChannelDensityNonUniformGHK, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNonUniformGHK",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(
                " ionChannel=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.ion_channel), input_name="ionChannel"
                        )
                    ),
                )
            )
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(
                " ion=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.ion), input_name="ion")
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ChannelDensityNonUniformGHK",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensityNonUniformGHK, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for variableParameter_ in self.variable_parameters:
            namespaceprefix_ = (
                self.variable_parameters_nsprefix_ + ":"
                if (UseCapturedNS_ and self.variable_parameters_nsprefix_)
                else ""
            )
            variableParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="variableParameter",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        super(ChannelDensityNonUniformGHK, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "variableParameter":
            obj_ = VariableParameter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = "variableParameter"
        super(ChannelDensityNonUniformGHK, self)._buildChildren(
            child_, node, nodeName_, True
        )


# end class ChannelDensityNonUniformGHK


class ChannelDensityNonUniformNernst(Base):
    """ChannelDensityNonUniformNernst -- Specifies a time varying conductance density, which is distributed on a region of the **cell,**  and whose reversal potential is calculated from the Nernst equation. Hard coded for Ca only!. The conductance density of the channel is not uniform, but is set using the  **variableParameter** . Note, there is no dynamical description of this in LEMS yet, as this type only makes sense for multicompartmental cells. A ComponentType for this needs to be present to enable export of NeuroML 2 multicompartmental cells via LEMS/jNeuroML to NEURON"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "ion_channel", "NmlId", 0, 0, {"use": "required", "name": "ion_channel"}
        ),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": "required", "name": "ion"}),
        MemberSpec_(
            "variable_parameters",
            "VariableParameter",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "variableParameter",
                "type": "VariableParameter",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        ion=None,
        variable_parameters=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("ChannelDensityNonUniformNernst"), self).__init__(
            neuro_lex_id, id, **kwargs_
        )
        self.ion_channel = _cast(None, ion_channel)
        self.ion_channel_nsprefix_ = None
        self.ion = _cast(None, ion)
        self.ion_nsprefix_ = None
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
        self.variable_parameters_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityNonUniformNernst
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityNonUniformNernst.subclass:
            return ChannelDensityNonUniformNernst.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityNonUniformNernst(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def _hasContent(self):
        if (
            self.variable_parameters
            or super(ChannelDensityNonUniformNernst, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ChannelDensityNonUniformNernst",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get(
            "ChannelDensityNonUniformNernst"
        )
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "ChannelDensityNonUniformNernst"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNonUniformNernst",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensityNonUniformNernst",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensityNonUniformNernst",
    ):
        super(ChannelDensityNonUniformNernst, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNonUniformNernst",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(
                " ionChannel=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.ion_channel), input_name="ionChannel"
                        )
                    ),
                )
            )
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(
                " ion=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.ion), input_name="ion")
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ChannelDensityNonUniformNernst",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensityNonUniformNernst, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for variableParameter_ in self.variable_parameters:
            namespaceprefix_ = (
                self.variable_parameters_nsprefix_ + ":"
                if (UseCapturedNS_ and self.variable_parameters_nsprefix_)
                else ""
            )
            variableParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="variableParameter",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        super(ChannelDensityNonUniformNernst, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "variableParameter":
            obj_ = VariableParameter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = "variableParameter"
        super(ChannelDensityNonUniformNernst, self)._buildChildren(
            child_, node, nodeName_, True
        )


# end class ChannelDensityNonUniformNernst


class ChannelDensityNonUniform(Base):
    """ChannelDensityNonUniform -- Specifies a time varying ohmic conductance density, which is distributed on a region of the **cell.**  The conductance density of the channel is not uniform, but is set using the  **variableParameter** . Note, there is no dynamical description of this in LEMS yet, as this type only makes sense for multicompartmental cells. A ComponentType for this needs to be present to enable export of NeuroML 2 multicompartmental cells via LEMS/jNeuroML to NEURON
    \n
    :param erev: The reversal potential of the current produced
    :type erev: voltage

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "ion_channel", "NmlId", 0, 0, {"use": "required", "name": "ion_channel"}
        ),
        MemberSpec_(
            "erev", "Nml2Quantity_voltage", 0, 0, {"use": "required", "name": "erev"}
        ),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": "required", "name": "ion"}),
        MemberSpec_(
            "variable_parameters",
            "VariableParameter",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "variableParameter",
                "type": "VariableParameter",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        erev=None,
        ion=None,
        variable_parameters=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("ChannelDensityNonUniform"), self).__init__(
            neuro_lex_id, id, **kwargs_
        )
        self.ion_channel = _cast(None, ion_channel)
        self.ion_channel_nsprefix_ = None
        self.erev = _cast(None, erev)
        self.erev_nsprefix_ = None
        self.ion = _cast(None, ion)
        self.ion_nsprefix_ = None
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
        self.variable_parameters_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, ChannelDensityNonUniform
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelDensityNonUniform.subclass:
            return ChannelDensityNonUniform.subclass(*args_, **kwargs_)
        else:
            return ChannelDensityNonUniform(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV))$"]
    ]

    def _hasContent(self):
        if (
            self.variable_parameters
            or super(ChannelDensityNonUniform, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ChannelDensityNonUniform",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelDensityNonUniform")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ChannelDensityNonUniform":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNonUniform",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelDensityNonUniform",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelDensityNonUniform",
    ):
        super(ChannelDensityNonUniform, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelDensityNonUniform",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(
                " ionChannel=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.ion_channel), input_name="ionChannel"
                        )
                    ),
                )
            )
        if self.erev is not None and "erev" not in already_processed:
            already_processed.add("erev")
            outfile.write(
                " erev=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.erev), input_name="erev"
                        )
                    ),
                )
            )
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(
                " ion=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.ion), input_name="ion")
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ChannelDensityNonUniform",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelDensityNonUniform, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for variableParameter_ in self.variable_parameters:
            namespaceprefix_ = (
                self.variable_parameters_nsprefix_ + ":"
                if (UseCapturedNS_ and self.variable_parameters_nsprefix_)
                else ""
            )
            variableParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="variableParameter",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("erev", node)
        if value is not None and "erev" not in already_processed:
            already_processed.add("erev")
            self.erev = value
            self.validate_Nml2Quantity_voltage(
                self.erev
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        super(ChannelDensityNonUniform, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "variableParameter":
            obj_ = VariableParameter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = "variableParameter"
        super(ChannelDensityNonUniform, self)._buildChildren(
            child_, node, nodeName_, True
        )


# end class ChannelDensityNonUniform


class ChannelPopulation(Base):
    """ChannelPopulation -- Population of a **number**  of ohmic ion channels. These each produce a conductance **channelg**  across a reversal potential **erev,**  giving a total current **i.**  Note that active membrane currents are more frequently specified as a density over an area of the  **cell**  using  **channelDensity**
    \n
    :param number: The number of channels present. This will be multiplied by the time varying conductance of the individual ion channel ( which extends  **baseIonChannel**  ) to produce the total conductance
    :type number: none
    :param erev: The reversal potential of the current produced
    :type erev: voltage

    """

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "ion_channel", "NmlId", 0, 0, {"use": "required", "name": "ion_channel"}
        ),
        MemberSpec_(
            "number", "NonNegativeInteger", 0, 0, {"use": "required", "name": "number"}
        ),
        MemberSpec_(
            "erev", "Nml2Quantity_voltage", 0, 0, {"use": "required", "name": "erev"}
        ),
        MemberSpec_(
            "segment_groups",
            "NmlId",
            0,
            1,
            {"use": "optional", "name": "segment_groups"},
        ),
        MemberSpec_(
            "segments",
            "NonNegativeInteger",
            0,
            1,
            {"use": "optional", "name": "segments"},
        ),
        MemberSpec_("ion", "NmlId", 0, 0, {"use": "required", "name": "ion"}),
        MemberSpec_(
            "variable_parameters",
            "VariableParameter",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "variableParameter",
                "type": "VariableParameter",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        ion_channel=None,
        number=None,
        erev=None,
        segment_groups="all",
        segments=None,
        ion=None,
        variable_parameters=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("ChannelPopulation"), self).__init__(
            neuro_lex_id, id, **kwargs_
        )
        self.ion_channel = _cast(None, ion_channel)
        self.ion_channel_nsprefix_ = None
        self.number = _cast(int, number)
        self.number_nsprefix_ = None
        self.erev = _cast(None, erev)
        self.erev_nsprefix_ = None
        self.segment_groups = _cast(None, segment_groups)
        self.segment_groups_nsprefix_ = None
        self.segments = _cast(int, segments)
        self.segments_nsprefix_ = None
        self.ion = _cast(None, ion)
        self.ion_nsprefix_ = None
        if variable_parameters is None:
            self.variable_parameters = []
        else:
            self.variable_parameters = variable_parameters
        self.variable_parameters_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, ChannelPopulation)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if ChannelPopulation.subclass:
            return ChannelPopulation.subclass(*args_, **kwargs_)
        else:
            return ChannelPopulation(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_NmlId(self, value):
        # Validate type NmlId, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_NmlId_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_NmlId_patterns_,
                    )
                )

    validate_NmlId_patterns_ = [["^([a-zA-Z_][a-zA-Z0-9_]*)$"]]

    def validate_NonNegativeInteger(self, value):
        # Validate type NonNegativeInteger, a restriction on xs:nonNegativeInteger.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, int):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (int)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            pass

    def validate_Nml2Quantity_voltage(self, value):
        # Validate type Nml2Quantity_voltage, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            if not self.gds_validate_simple_patterns(
                self.validate_Nml2Quantity_voltage_patterns_, value
            ):
                self.gds_collector_.add_message(
                    'Value "%s" does not match xsd pattern restrictions: %s'
                    % (
                        encode_str_2_3(value),
                        self.validate_Nml2Quantity_voltage_patterns_,
                    )
                )

    validate_Nml2Quantity_voltage_patterns_ = [
        ["^(-?([0-9]*(\\.[0-9]+)?)([eE]-?[0-9]+)?[\\s]*(V|mV))$"]
    ]

    def _hasContent(self):
        if self.variable_parameters or super(ChannelPopulation, self)._hasContent():
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ChannelPopulation",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("ChannelPopulation")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "ChannelPopulation":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelPopulation",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="ChannelPopulation",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="ChannelPopulation",
    ):
        super(ChannelPopulation, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="ChannelPopulation",
        )
        if self.ion_channel is not None and "ion_channel" not in already_processed:
            already_processed.add("ion_channel")
            outfile.write(
                " ionChannel=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.ion_channel), input_name="ionChannel"
                        )
                    ),
                )
            )
        if self.number is not None and "number" not in already_processed:
            already_processed.add("number")
            outfile.write(
                ' number="%s"'
                % self.gds_format_integer(self.number, input_name="number")
            )
        if self.erev is not None and "erev" not in already_processed:
            already_processed.add("erev")
            outfile.write(
                " erev=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.erev), input_name="erev"
                        )
                    ),
                )
            )
        if self.segment_groups != "all" and "segment_groups" not in already_processed:
            already_processed.add("segment_groups")
            outfile.write(
                " segmentGroup=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.segment_groups), input_name="segmentGroup"
                        )
                    ),
                )
            )
        if self.segments is not None and "segments" not in already_processed:
            already_processed.add("segments")
            outfile.write(
                ' segment="%s"'
                % self.gds_format_integer(self.segments, input_name="segment")
            )
        if self.ion is not None and "ion" not in already_processed:
            already_processed.add("ion")
            outfile.write(
                " ion=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(quote_attrib(self.ion), input_name="ion")
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="ChannelPopulation",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(ChannelPopulation, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        for variableParameter_ in self.variable_parameters:
            namespaceprefix_ = (
                self.variable_parameters_nsprefix_ + ":"
                if (UseCapturedNS_ and self.variable_parameters_nsprefix_)
                else ""
            )
            variableParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="variableParameter",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("ionChannel", node)
        if value is not None and "ionChannel" not in already_processed:
            already_processed.add("ionChannel")
            self.ion_channel = value
            self.validate_NmlId(self.ion_channel)  # validate type NmlId
        value = find_attr_value_("number", node)
        if value is not None and "number" not in already_processed:
            already_processed.add("number")
            self.number = self.gds_parse_integer(value, node, "number")
            if self.number < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.number
            )  # validate type NonNegativeInteger
        value = find_attr_value_("erev", node)
        if value is not None and "erev" not in already_processed:
            already_processed.add("erev")
            self.erev = value
            self.validate_Nml2Quantity_voltage(
                self.erev
            )  # validate type Nml2Quantity_voltage
        value = find_attr_value_("segmentGroup", node)
        if value is not None and "segmentGroup" not in already_processed:
            already_processed.add("segmentGroup")
            self.segment_groups = value
            self.validate_NmlId(self.segment_groups)  # validate type NmlId
        value = find_attr_value_("segment", node)
        if value is not None and "segment" not in already_processed:
            already_processed.add("segment")
            self.segments = self.gds_parse_integer(value, node, "segment")
            if self.segments < 0:
                raise_parse_error(node, "Invalid NonNegativeInteger")
            self.validate_NonNegativeInteger(
                self.segments
            )  # validate type NonNegativeInteger
        value = find_attr_value_("ion", node)
        if value is not None and "ion" not in already_processed:
            already_processed.add("ion")
            self.ion = value
            self.validate_NmlId(self.ion)  # validate type NmlId
        super(ChannelPopulation, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "variableParameter":
            obj_ = VariableParameter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.variable_parameters.append(obj_)
            obj_.original_tagname_ = "variableParameter"
        super(ChannelPopulation, self)._buildChildren(child_, node, nodeName_, True)


# end class ChannelPopulation


class BiophysicalProperties2CaPools(Standalone):
    """BiophysicalProperties2CaPools -- The biophysical properties of the  **cell** , including the  **membraneProperties2CaPools**  and the  **intracellularProperties2CaPools**  for a cell with two Ca pools"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "membrane_properties2_ca_pools",
            "MembraneProperties2CaPools",
            0,
            0,
            {
                "name": "membraneProperties2CaPools",
                "type": "MembraneProperties2CaPools",
            },
            None,
        ),
        MemberSpec_(
            "intracellular_properties2_ca_pools",
            "IntracellularProperties2CaPools",
            0,
            1,
            {
                "minOccurs": "0",
                "name": "intracellularProperties2CaPools",
                "type": "IntracellularProperties2CaPools",
            },
            None,
        ),
        MemberSpec_(
            "extracellular_properties",
            "ExtracellularProperties",
            0,
            1,
            {
                "minOccurs": "0",
                "name": "extracellularProperties",
                "type": "ExtracellularProperties",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        membrane_properties2_ca_pools=None,
        intracellular_properties2_ca_pools=None,
        extracellular_properties=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("BiophysicalProperties2CaPools"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.membrane_properties2_ca_pools = membrane_properties2_ca_pools
        self.membrane_properties2_ca_pools_nsprefix_ = None
        self.intracellular_properties2_ca_pools = intracellular_properties2_ca_pools
        self.intracellular_properties2_ca_pools_nsprefix_ = None
        self.extracellular_properties = extracellular_properties
        self.extracellular_properties_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BiophysicalProperties2CaPools
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BiophysicalProperties2CaPools.subclass:
            return BiophysicalProperties2CaPools.subclass(*args_, **kwargs_)
        else:
            return BiophysicalProperties2CaPools(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if (
            self.membrane_properties2_ca_pools is not None
            or self.intracellular_properties2_ca_pools is not None
            or self.extracellular_properties is not None
            or super(BiophysicalProperties2CaPools, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="BiophysicalProperties2CaPools",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BiophysicalProperties2CaPools")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if (
            self.original_tagname_ is not None
            and name_ == "BiophysicalProperties2CaPools"
        ):
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="BiophysicalProperties2CaPools",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BiophysicalProperties2CaPools",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BiophysicalProperties2CaPools",
    ):
        super(BiophysicalProperties2CaPools, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="BiophysicalProperties2CaPools",
        )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="BiophysicalProperties2CaPools",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(BiophysicalProperties2CaPools, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.membrane_properties2_ca_pools is not None:
            namespaceprefix_ = (
                self.membrane_properties2_ca_pools_nsprefix_ + ":"
                if (UseCapturedNS_ and self.membrane_properties2_ca_pools_nsprefix_)
                else ""
            )
            self.membrane_properties2_ca_pools.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="membraneProperties2CaPools",
                pretty_print=pretty_print,
            )
        if self.intracellular_properties2_ca_pools is not None:
            namespaceprefix_ = (
                self.intracellular_properties2_ca_pools_nsprefix_ + ":"
                if (
                    UseCapturedNS_ and self.intracellular_properties2_ca_pools_nsprefix_
                )
                else ""
            )
            self.intracellular_properties2_ca_pools.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="intracellularProperties2CaPools",
                pretty_print=pretty_print,
            )
        if self.extracellular_properties is not None:
            namespaceprefix_ = (
                self.extracellular_properties_nsprefix_ + ":"
                if (UseCapturedNS_ and self.extracellular_properties_nsprefix_)
                else ""
            )
            self.extracellular_properties.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="extracellularProperties",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        super(BiophysicalProperties2CaPools, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "membraneProperties2CaPools":
            obj_ = MembraneProperties2CaPools.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.membrane_properties2_ca_pools = obj_
            obj_.original_tagname_ = "membraneProperties2CaPools"
        elif nodeName_ == "intracellularProperties2CaPools":
            obj_ = IntracellularProperties2CaPools.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.intracellular_properties2_ca_pools = obj_
            obj_.original_tagname_ = "intracellularProperties2CaPools"
        elif nodeName_ == "extracellularProperties":
            obj_ = ExtracellularProperties.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.extracellular_properties = obj_
            obj_.original_tagname_ = "extracellularProperties"
        super(BiophysicalProperties2CaPools, self)._buildChildren(
            child_, node, nodeName_, True
        )


# end class BiophysicalProperties2CaPools


class BiophysicalProperties(Standalone):
    """BiophysicalProperties -- The biophysical properties of the  **cell** , including the  **membraneProperties**  and the  **intracellularProperties**"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "membrane_properties",
            "MembraneProperties",
            0,
            0,
            {"name": "membraneProperties", "type": "MembraneProperties"},
            None,
        ),
        MemberSpec_(
            "intracellular_properties",
            "IntracellularProperties",
            0,
            1,
            {
                "minOccurs": "0",
                "name": "intracellularProperties",
                "type": "IntracellularProperties",
            },
            None,
        ),
        MemberSpec_(
            "extracellular_properties",
            "ExtracellularProperties",
            0,
            1,
            {
                "minOccurs": "0",
                "name": "extracellularProperties",
                "type": "ExtracellularProperties",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        membrane_properties=None,
        intracellular_properties=None,
        extracellular_properties=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("BiophysicalProperties"), self).__init__(
            neuro_lex_id, id, metaid, notes, properties, annotation, **kwargs_
        )
        self.membrane_properties = membrane_properties
        self.membrane_properties_nsprefix_ = None
        self.intracellular_properties = intracellular_properties
        self.intracellular_properties_nsprefix_ = None
        self.extracellular_properties = extracellular_properties
        self.extracellular_properties_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, BiophysicalProperties
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if BiophysicalProperties.subclass:
            return BiophysicalProperties.subclass(*args_, **kwargs_)
        else:
            return BiophysicalProperties(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if (
            self.membrane_properties is not None
            or self.intracellular_properties is not None
            or self.extracellular_properties is not None
            or super(BiophysicalProperties, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="BiophysicalProperties",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("BiophysicalProperties")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "BiophysicalProperties":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="BiophysicalProperties",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="BiophysicalProperties",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="BiophysicalProperties",
    ):
        super(BiophysicalProperties, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="BiophysicalProperties",
        )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="BiophysicalProperties",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(BiophysicalProperties, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.membrane_properties is not None:
            namespaceprefix_ = (
                self.membrane_properties_nsprefix_ + ":"
                if (UseCapturedNS_ and self.membrane_properties_nsprefix_)
                else ""
            )
            self.membrane_properties.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="membraneProperties",
                pretty_print=pretty_print,
            )
        if self.intracellular_properties is not None:
            namespaceprefix_ = (
                self.intracellular_properties_nsprefix_ + ":"
                if (UseCapturedNS_ and self.intracellular_properties_nsprefix_)
                else ""
            )
            self.intracellular_properties.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="intracellularProperties",
                pretty_print=pretty_print,
            )
        if self.extracellular_properties is not None:
            namespaceprefix_ = (
                self.extracellular_properties_nsprefix_ + ":"
                if (UseCapturedNS_ and self.extracellular_properties_nsprefix_)
                else ""
            )
            self.extracellular_properties.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="extracellularProperties",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        super(BiophysicalProperties, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "membraneProperties":
            class_obj_ = self.get_class_obj_(child_, MembraneProperties)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.membrane_properties = obj_
            obj_.original_tagname_ = "membraneProperties"
        elif nodeName_ == "intracellularProperties":
            class_obj_ = self.get_class_obj_(child_, IntracellularProperties)
            obj_ = class_obj_.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.intracellular_properties = obj_
            obj_.original_tagname_ = "intracellularProperties"
        elif nodeName_ == "extracellularProperties":
            obj_ = ExtracellularProperties.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.extracellular_properties = obj_
            obj_.original_tagname_ = "extracellularProperties"
        super(BiophysicalProperties, self)._buildChildren(child_, node, nodeName_, True)


# end class BiophysicalProperties


class InhomogeneousParameter(Base):
    """InhomogeneousParameter -- An inhomogeneous parameter specified across the  **segmentGroup**  ( see  **variableParameter**  for usage )."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "variable", "xs:string", 0, 0, {"use": "required", "name": "variable"}
        ),
        MemberSpec_("metric", "Metric", 0, 0, {"use": "required", "name": "metric"}),
        MemberSpec_(
            "proximal",
            "ProximalDetails",
            0,
            1,
            {"minOccurs": "0", "name": "proximal", "type": "ProximalDetails"},
            None,
        ),
        MemberSpec_(
            "distal",
            "DistalDetails",
            0,
            1,
            {"minOccurs": "0", "name": "distal", "type": "DistalDetails"},
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        variable=None,
        metric=None,
        proximal=None,
        distal=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("InhomogeneousParameter"), self).__init__(
            neuro_lex_id, id, **kwargs_
        )
        self.variable = _cast(None, variable)
        self.variable_nsprefix_ = None
        self.metric = _cast(None, metric)
        self.metric_nsprefix_ = None
        self.proximal = proximal
        self.proximal_nsprefix_ = None
        self.distal = distal
        self.distal_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(
                CurrentSubclassModule_, InhomogeneousParameter
            )
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if InhomogeneousParameter.subclass:
            return InhomogeneousParameter.subclass(*args_, **kwargs_)
        else:
            return InhomogeneousParameter(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Metric(self, value):
        # Validate type Metric, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            value = value
            enumerations = ["Path Length from root"]
            if value not in enumerations:
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s does not match xsd enumeration restriction on Metric'
                    % {"value": encode_str_2_3(value), "lineno": lineno}
                )
                result = False

    def _hasContent(self):
        if (
            self.proximal is not None
            or self.distal is not None
            or super(InhomogeneousParameter, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="InhomogeneousParameter",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("InhomogeneousParameter")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "InhomogeneousParameter":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="InhomogeneousParameter",
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="InhomogeneousParameter",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="InhomogeneousParameter",
    ):
        super(InhomogeneousParameter, self)._exportAttributes(
            outfile,
            level,
            already_processed,
            namespaceprefix_,
            name_="InhomogeneousParameter",
        )
        if self.variable is not None and "variable" not in already_processed:
            already_processed.add("variable")
            outfile.write(
                " variable=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.variable), input_name="variable"
                        )
                    ),
                )
            )
        if self.metric is not None and "metric" not in already_processed:
            already_processed.add("metric")
            outfile.write(
                " metric=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.metric), input_name="metric"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="InhomogeneousParameter",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(InhomogeneousParameter, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.proximal is not None:
            namespaceprefix_ = (
                self.proximal_nsprefix_ + ":"
                if (UseCapturedNS_ and self.proximal_nsprefix_)
                else ""
            )
            self.proximal.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="proximal",
                pretty_print=pretty_print,
            )
        if self.distal is not None:
            namespaceprefix_ = (
                self.distal_nsprefix_ + ":"
                if (UseCapturedNS_ and self.distal_nsprefix_)
                else ""
            )
            self.distal.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="distal",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("variable", node)
        if value is not None and "variable" not in already_processed:
            already_processed.add("variable")
            self.variable = value
        value = find_attr_value_("metric", node)
        if value is not None and "metric" not in already_processed:
            already_processed.add("metric")
            self.metric = value
            self.validate_Metric(self.metric)  # validate type Metric
        super(InhomogeneousParameter, self)._buildAttributes(
            node, attrs, already_processed
        )

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "proximal":
            obj_ = ProximalDetails.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.proximal = obj_
            obj_.original_tagname_ = "proximal"
        elif nodeName_ == "distal":
            obj_ = DistalDetails.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.distal = obj_
            obj_.original_tagname_ = "distal"
        super(InhomogeneousParameter, self)._buildChildren(
            child_, node, nodeName_, True
        )


# end class InhomogeneousParameter


class SegmentGroup(Base):
    """SegmentGroup -- A method to describe a group of  **segment** s in a  **morphology** , e. g. soma_group, dendrite_group, axon_group. While a name is useful to describe the group, the **neuroLexId**  attribute can be used to explicitly specify the meaning of the group, e. g. sao1044911821 for 'Neuronal Cell Body', sao1211023249 for 'Dendrite'. The  **segment** s in this group can be specified as: a list of individual  **member**  segments; a  **path** , all of the segments along which should be included; a  **subTree**  of the  **cell**  to include; other segmentGroups to  **include**  ( so all segments from those get included here ). An  **inhomogeneousParameter**  can be defined on the region of the cell specified by this group ( see  **variableParameter**  for usage )."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "notes",
            ["Notes", "xs:string"],
            0,
            1,
            {"minOccurs": "0", "name": "notes", "type": "xs:string"},
            None,
        ),
        MemberSpec_(
            "properties",
            "Property",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "property",
                "type": "Property",
            },
            None,
        ),
        MemberSpec_(
            "annotation",
            "Annotation",
            0,
            1,
            {"minOccurs": "0", "name": "annotation", "type": "Annotation"},
            None,
        ),
        MemberSpec_(
            "members",
            "Member",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "member",
                "type": "Member",
            },
            None,
        ),
        MemberSpec_(
            "includes",
            "Include",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "include",
                "type": "Include",
            },
            None,
        ),
        MemberSpec_(
            "paths",
            "Path",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "path",
                "type": "Path",
            },
            None,
        ),
        MemberSpec_(
            "sub_trees",
            "SubTree",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "subTree",
                "type": "SubTree",
            },
            None,
        ),
        MemberSpec_(
            "inhomogeneous_parameters",
            "InhomogeneousParameter",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "inhomogeneousParameter",
                "type": "InhomogeneousParameter",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Base

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        notes=None,
        properties=None,
        annotation=None,
        members=None,
        includes=None,
        paths=None,
        sub_trees=None,
        inhomogeneous_parameters=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("SegmentGroup"), self).__init__(neuro_lex_id, id, **kwargs_)
        self.notes = notes
        self.validate_Notes(self.notes)
        self.notes_nsprefix_ = None
        if properties is None:
            self.properties = []
        else:
            self.properties = properties
        self.properties_nsprefix_ = None
        self.annotation = annotation
        self.annotation_nsprefix_ = None
        if members is None:
            self.members = []
        else:
            self.members = members
        self.members_nsprefix_ = None
        if includes is None:
            self.includes = []
        else:
            self.includes = includes
        self.includes_nsprefix_ = None
        if paths is None:
            self.paths = []
        else:
            self.paths = paths
        self.paths_nsprefix_ = None
        if sub_trees is None:
            self.sub_trees = []
        else:
            self.sub_trees = sub_trees
        self.sub_trees_nsprefix_ = None
        if inhomogeneous_parameters is None:
            self.inhomogeneous_parameters = []
        else:
            self.inhomogeneous_parameters = inhomogeneous_parameters
        self.inhomogeneous_parameters_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, SegmentGroup)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if SegmentGroup.subclass:
            return SegmentGroup.subclass(*args_, **kwargs_)
        else:
            return SegmentGroup(*args_, **kwargs_)

    factory = staticmethod(factory)

    def validate_Notes(self, value):
        result = True
        # Validate type Notes, a restriction on xs:string.
        if (
            value is not None
            and Validate_simpletypes_
            and self.gds_collector_ is not None
        ):
            if not isinstance(value, str):
                lineno = self.gds_get_node_lineno_()
                self.gds_collector_.add_message(
                    'Value "%(value)s"%(lineno)s is not of the correct base simple type (str)'
                    % {
                        "value": value,
                        "lineno": lineno,
                    }
                )
                return False
            pass
        return result

    def _hasContent(self):
        if (
            self.notes is not None
            or self.properties
            or self.annotation is not None
            or self.members
            or self.includes
            or self.paths
            or self.sub_trees
            or self.inhomogeneous_parameters
            or super(SegmentGroup, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="SegmentGroup",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("SegmentGroup")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "SegmentGroup":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SegmentGroup"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="SegmentGroup",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self,
        outfile,
        level,
        already_processed,
        namespaceprefix_="",
        name_="SegmentGroup",
    ):
        super(SegmentGroup, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="SegmentGroup"
        )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="SegmentGroup",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(SegmentGroup, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.notes is not None:
            namespaceprefix_ = (
                self.notes_nsprefix_ + ":"
                if (UseCapturedNS_ and self.notes_nsprefix_)
                else ""
            )
            showIndent(outfile, level, pretty_print)
            outfile.write(
                "<%snotes>%s</%snotes>%s"
                % (
                    namespaceprefix_,
                    self.gds_encode(
                        self.gds_format_string(
                            quote_xml(self.notes), input_name="notes"
                        )
                    ),
                    namespaceprefix_,
                    eol_,
                )
            )
        for property_ in self.properties:
            namespaceprefix_ = (
                self.properties_nsprefix_ + ":"
                if (UseCapturedNS_ and self.properties_nsprefix_)
                else ""
            )
            property_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="property",
                pretty_print=pretty_print,
            )
        if self.annotation is not None:
            namespaceprefix_ = (
                self.annotation_nsprefix_ + ":"
                if (UseCapturedNS_ and self.annotation_nsprefix_)
                else ""
            )
            self.annotation.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="annotation",
                pretty_print=pretty_print,
            )
        for member_ in self.members:
            namespaceprefix_ = (
                self.members_nsprefix_ + ":"
                if (UseCapturedNS_ and self.members_nsprefix_)
                else ""
            )
            member_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="member",
                pretty_print=pretty_print,
            )
        for include_ in self.includes:
            namespaceprefix_ = (
                self.includes_nsprefix_ + ":"
                if (UseCapturedNS_ and self.includes_nsprefix_)
                else ""
            )
            include_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="include",
                pretty_print=pretty_print,
            )
        for path_ in self.paths:
            namespaceprefix_ = (
                self.paths_nsprefix_ + ":"
                if (UseCapturedNS_ and self.paths_nsprefix_)
                else ""
            )
            path_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="path",
                pretty_print=pretty_print,
            )
        for subTree_ in self.sub_trees:
            namespaceprefix_ = (
                self.sub_trees_nsprefix_ + ":"
                if (UseCapturedNS_ and self.sub_trees_nsprefix_)
                else ""
            )
            subTree_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="subTree",
                pretty_print=pretty_print,
            )
        for inhomogeneousParameter_ in self.inhomogeneous_parameters:
            namespaceprefix_ = (
                self.inhomogeneous_parameters_nsprefix_ + ":"
                if (UseCapturedNS_ and self.inhomogeneous_parameters_nsprefix_)
                else ""
            )
            inhomogeneousParameter_.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="inhomogeneousParameter",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        super(SegmentGroup, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "notes":
            value_ = child_.text
            value_ = self.gds_parse_string(value_, node, "notes")
            value_ = self.gds_validate_string(value_, node, "notes")
            self.notes = value_
            self.notes_nsprefix_ = child_.prefix
            # validate type Notes
            self.validate_Notes(self.notes)
        elif nodeName_ == "property":
            obj_ = Property.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.properties.append(obj_)
            obj_.original_tagname_ = "property"
        elif nodeName_ == "annotation":
            obj_ = Annotation.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.annotation = obj_
            obj_.original_tagname_ = "annotation"
        elif nodeName_ == "member":
            obj_ = Member.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.members.append(obj_)
            obj_.original_tagname_ = "member"
        elif nodeName_ == "include":
            obj_ = Include.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.includes.append(obj_)
            obj_.original_tagname_ = "include"
        elif nodeName_ == "path":
            obj_ = Path.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.paths.append(obj_)
            obj_.original_tagname_ = "path"
        elif nodeName_ == "subTree":
            obj_ = SubTree.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.sub_trees.append(obj_)
            obj_.original_tagname_ = "subTree"
        elif nodeName_ == "inhomogeneousParameter":
            obj_ = InhomogeneousParameter.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.inhomogeneous_parameters.append(obj_)
            obj_.original_tagname_ = "inhomogeneousParameter"
        super(SegmentGroup, self)._buildChildren(child_, node, nodeName_, True)

    def __str__(self):

        return (
            "SegmentGroup: "
            + str(self.id)
            + ", "
            + str(len(self.members))
            + " member(s), "
            + str(len(self.includes))
            + " included group(s)"
        )

    def __repr__(self):

        return str(self)


# end class SegmentGroup


class Segment(BaseNonNegativeIntegerId):
    """Segment -- A segment defines the smallest unit within a possibly branching structure (  **morphology**  ), such as a dendrite or axon. Its **id**  should be a nonnegative integer ( usually soma/root = 0 ). Its end points are given by the  **proximal**  and  **distal**  points. The  **proximal**  point can be omitted, usually because it is the same as a point on the  **parent**  segment, see  **proximal**  for details.  **parent**  specifies the parent segment. The first segment of a  **cell**  ( with no  **parent**  ) usually represents the soma. The shape is normally a cylinder ( radii of the  **proximal**  and  **distal**  equal, but positions different ) or a conical frustum ( radii and positions different ). If the x, y, x positions of the  **proximal**  and  **distal**  are equal, the segment can be interpreted as a sphere, and in this case the radii of these points must be equal. NOTE: LEMS does not yet support multicompartmental modelling, so the Dynamics here is only appropriate for single compartment modelling."""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_("name", "xs:string", 0, 1, {"use": "optional", "name": "name"}),
        MemberSpec_(
            "parent",
            "SegmentParent",
            0,
            1,
            {"minOccurs": "0", "name": "parent", "type": "SegmentParent"},
            None,
        ),
        MemberSpec_(
            "proximal",
            "Point3DWithDiam",
            0,
            1,
            {"minOccurs": "0", "name": "proximal", "type": "Point3DWithDiam"},
            None,
        ),
        MemberSpec_(
            "distal",
            "Point3DWithDiam",
            0,
            0,
            {"minOccurs": "1", "name": "distal", "type": "Point3DWithDiam"},
            None,
        ),
    ]
    subclass = None
    superclass = BaseNonNegativeIntegerId

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        name=None,
        parent=None,
        proximal=None,
        distal=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_ = None
        super(globals().get("Segment"), self).__init__(neuro_lex_id, id, **kwargs_)
        self.name = _cast(None, name)
        self.name_nsprefix_ = None
        self.parent = parent
        self.parent_nsprefix_ = None
        self.proximal = proximal
        self.proximal_nsprefix_ = None
        self.distal = distal
        self.distal_nsprefix_ = None

    def factory(*args_, **kwargs_):
        if CurrentSubclassModule_ is not None:
            subclass = getSubclassFromModule_(CurrentSubclassModule_, Segment)
            if subclass is not None:
                return subclass(*args_, **kwargs_)
        if Segment.subclass:
            return Segment.subclass(*args_, **kwargs_)
        else:
            return Segment(*args_, **kwargs_)

    factory = staticmethod(factory)

    def _hasContent(self):
        if (
            self.parent is not None
            or self.proximal is not None
            or self.distal is not None
            or super(Segment, self)._hasContent()
        ):
            return True
        else:
            return False

    def export(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Segment",
        pretty_print=True,
    ):
        imported_ns_def_ = GenerateDSNamespaceDefs_.get("Segment")
        if imported_ns_def_ is not None:
            namespacedef_ = imported_ns_def_
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.original_tagname_ is not None and name_ == "Segment":
            name_ = self.original_tagname_
        if UseCapturedNS_ and self.ns_prefix_:
            namespaceprefix_ = self.ns_prefix_ + ":"
        showIndent(outfile, level, pretty_print)
        outfile.write(
            "<%s%s%s"
            % (
                namespaceprefix_,
                name_,
                namespacedef_ and " " + namespacedef_ or "",
            )
        )
        already_processed = set()
        self._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Segment"
        )
        if self._hasContent():
            outfile.write(">%s" % (eol_,))
            self._exportChildren(
                outfile,
                level + 1,
                namespaceprefix_,
                namespacedef_,
                name_="Segment",
                pretty_print=pretty_print,
            )
            showIndent(outfile, level, pretty_print)
            outfile.write("</%s%s>%s" % (namespaceprefix_, name_, eol_))
        else:
            outfile.write("/>%s" % (eol_,))

    def _exportAttributes(
        self, outfile, level, already_processed, namespaceprefix_="", name_="Segment"
    ):
        super(Segment, self)._exportAttributes(
            outfile, level, already_processed, namespaceprefix_, name_="Segment"
        )
        if self.name is not None and "name" not in already_processed:
            already_processed.add("name")
            outfile.write(
                " name=%s"
                % (
                    self.gds_encode(
                        self.gds_format_string(
                            quote_attrib(self.name), input_name="name"
                        )
                    ),
                )
            )

    def _exportChildren(
        self,
        outfile,
        level,
        namespaceprefix_="",
        namespacedef_=' xmlns:None="http://www.neuroml.org/schema/neuroml2" ',
        name_="Segment",
        fromsubclass_=False,
        pretty_print=True,
    ):
        super(Segment, self)._exportChildren(
            outfile,
            level,
            namespaceprefix_,
            namespacedef_,
            name_,
            True,
            pretty_print=pretty_print,
        )
        if pretty_print:
            eol_ = "\n"
        else:
            eol_ = ""
        if self.parent is not None:
            namespaceprefix_ = (
                self.parent_nsprefix_ + ":"
                if (UseCapturedNS_ and self.parent_nsprefix_)
                else ""
            )
            self.parent.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="parent",
                pretty_print=pretty_print,
            )
        if self.proximal is not None:
            namespaceprefix_ = (
                self.proximal_nsprefix_ + ":"
                if (UseCapturedNS_ and self.proximal_nsprefix_)
                else ""
            )
            self.proximal.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="proximal",
                pretty_print=pretty_print,
            )
        if self.distal is not None:
            namespaceprefix_ = (
                self.distal_nsprefix_ + ":"
                if (UseCapturedNS_ and self.distal_nsprefix_)
                else ""
            )
            self.distal.export(
                outfile,
                level,
                namespaceprefix_,
                namespacedef_="",
                name_="distal",
                pretty_print=pretty_print,
            )

    def build(self, node, gds_collector_=None):
        self.gds_collector_ = gds_collector_
        if SaveElementTreeNode:
            self.gds_elementtree_node_ = node
        already_processed = set()
        self.ns_prefix_ = node.prefix
        self._buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self._buildChildren(child, node, nodeName_, gds_collector_=gds_collector_)
        return self

    def _buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_("name", node)
        if value is not None and "name" not in already_processed:
            already_processed.add("name")
            self.name = value
        super(Segment, self)._buildAttributes(node, attrs, already_processed)

    def _buildChildren(
        self, child_, node, nodeName_, fromsubclass_=False, gds_collector_=None
    ):
        if nodeName_ == "parent":
            obj_ = SegmentParent.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.parent = obj_
            obj_.original_tagname_ = "parent"
        elif nodeName_ == "proximal":
            obj_ = Point3DWithDiam.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.proximal = obj_
            obj_.original_tagname_ = "proximal"
        elif nodeName_ == "distal":
            obj_ = Point3DWithDiam.factory(parent_object_=self)
            obj_.build(child_, gds_collector_=gds_collector_)
            self.distal = obj_
            obj_.original_tagname_ = "distal"
        super(Segment, self)._buildChildren(child_, node, nodeName_, True)

    @property
    def length(self):
        """Get the length of the segment.

        :returns: length of the segment
        :rtype: float
        """

        if self.proximal == None:
            raise Exception(
                "Cannot get length of segment "
                + str(self.id)
                + " using the length property, since no proximal point is set on it (the proximal point comes from the parent segment). Use the method get_segment_length(segment_id) on the cell instead."
            )

        prox_x = self.proximal.x
        prox_y = self.proximal.y
        prox_z = self.proximal.z

        dist_x = self.distal.x
        dist_y = self.distal.y
        dist_z = self.distal.z

        length = (
            (prox_x - dist_x) ** 2 + (prox_y - dist_y) ** 2 + (prox_z - dist_z) ** 2
        ) ** (0.5)

        return length

    def __str__(self):

        return (
            "<Segment|"
            + str(self.id)
            + ("|" + self.name if self.name is not None else "")
            + ">"
        )

    def __repr__(self):

        return str(self)

    @property
    def volume(self):
        """Get the volume of the segment.

        :returns: volume of segment
        :rtype: float
        """

        from math import pi

        if self.proximal == None:
            raise Exception(
                "Cannot get volume of segment "
                + str(self.id)
                + " using the volume property, since no proximal point is set on it (the proximal point comes from the parent segment). Use the method get_segment_volume(segment_id) on the cell instead."
            )

        prox_rad = self.proximal.diameter / 2.0
        dist_rad = self.distal.diameter / 2.0

        if (
            self.proximal.x == self.distal.x
            and self.proximal.y == self.distal.y
            and self.proximal.z == self.distal.z
        ):

            if prox_rad != dist_rad:
                raise Exception(
                    "Cannot get volume of segment "
                    + str(self.id)
                    + ". The (x,y,z) coordinates of the proximal and distal points match (i.e. it is a sphere), but the diameters of these points are different, making the volume calculation ambiguous."
                )

            return 4.0 / 3 * pi * prox_rad**3

        length = self.length

        volume = (
            (pi / 3) * length * (prox_rad**2 + dist_rad**2 + prox_rad * dist_rad)
        )

        return volume

    @property
    def surface_area(self):
        """Get the surface area of the segment.

        :returns: surface area of segment
        :rtype: float
        """
        from math import pi
        from math import sqrt

        if self.proximal == None:
            raise Exception(
                "Cannot get surface area of segment "
                + str(self.id)
                + " using the surface_area property, since no proximal point is set on it (the proximal point comes from the parent segment). Use the method get_segment_surface_area(segment_id) on the cell instead."
            )

        prox_rad = self.proximal.diameter / 2.0
        dist_rad = self.distal.diameter / 2.0

        if (
            self.proximal.x == self.distal.x
            and self.proximal.y == self.distal.y
            and self.proximal.z == self.distal.z
        ):

            if prox_rad != dist_rad:
                raise Exception(
                    "Cannot get surface area of segment "
                    + str(self.id)
                    + ". The (x,y,z) coordinates of the proximal and distal points match (i.e. it is a sphere), but the diameters of these points are different, making the surface area calculation ambiguous."
                )

            return 4.0 * pi * prox_rad**2

        length = self.length

        surface_area = (
            pi * (prox_rad + dist_rad) * sqrt((prox_rad - dist_rad) ** 2 + length**2)
        )

        return surface_area

    # end class Segment


class Morphology(Standalone):
    """Morphology -- The collection of  **segment** s which specify the 3D structure of the cell, along with a number of  **segmentGroup** s"""

    __hash__ = GeneratedsSuper.__hash__
    member_data_items_ = [
        MemberSpec_(
            "segments",
            "Segment",
            1,
            0,
            {"maxOccurs": "unbounded", "name": "segment", "type": "Segment"},
            None,
        ),
        MemberSpec_(
            "segment_groups",
            "SegmentGroup",
            1,
            1,
            {
                "maxOccurs": "unbounded",
                "minOccurs": "0",
                "name": "segmentGroup",
                "type": "SegmentGroup",
            },
            None,
        ),
    ]
    subclass = None
    superclass = Standalone

    def __init__(
        self,
        neuro_lex_id=None,
        id=None,
        metaid=None,
        notes=None,
        properties=None,
        annotation=None,
        segments=None,
        segment_groups=None,
        gds_collector_=None,
        **kwargs_
    ):
        self.gds_collector_ = gds_collector_
        self.gds_elementtree_node_ = None
        self.original_tagname_ = None
        self.parent_object_ = kwargs_.get("parent_object_")
        self.ns_prefix_