# coding: utf-8

"""
    Groupe PSA Connected Car - WEB API B2C

    *PSA B2C Connected Car API*  # Introduction This is the description of the *Groupe PSA Connected Car V2 API*. The speccification is  is based on **OpenAPI Specification version 3** and can be displayed via [ReDoc](https://github.com/Rebilly/ReDoc)a or [Swagger](http://swagger.io).   This API allows applications to fetch data from the connected Vehicles data platform. # Authentication PSA Connected Car APIs uses the [OAuth 2.0](https://tools.ietf.org/html/rfc6749) protocol for authentication and Authorization. any application require a valid [Access Token](https://tools.ietf.org/html/rfc6749#section-1.4) to access to user data. # Errors   Error codes returned by all REST APIs comply with the standard. Nevertheless, PSA Services (callers) need to have more complete data structures (even when the answer is not Http-OK) to better detail the type of error by providing application code, message and a debugging code(for investigation purposes). The http code of the response is managed by the protocol itself (in the header).      **Errors are  returned as a generic error response:**    * ```xError``` object model.       # noqa: E501

    OpenAPI spec version: 4.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from psa_car_controller.psa.connected_car_api.api_client import ApiClient


class TripsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_path_for_trip(self, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Gives the wayPoints for a specified User Trip.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_path_for_trip(tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :return: WayPoints
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_path_for_trip_with_http_info(tid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_path_for_trip_with_http_info(tid, **kwargs)  # noqa: E501
            return data

    def get_path_for_trip_with_http_info(self, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Gives the wayPoints for a specified User Trip.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_path_for_trip_with_http_info(tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :return: WayPoints
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tid', 'index_range']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_path_for_trip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_path_for_trip`")  # noqa: E501

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_path_for_trip`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/trips/{tid}/wayPoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WayPoints',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_path_for_trip_0(self, id, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Gives the Vehicle's wayPoints for a specified Trip.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_path_for_trip_0(id, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param float tolerance: Tolerance factor is expressed in length KM unit and is used to simplify path by reducing the total number of points by is using Douglas-Peucker algorithme to find a similar curve with fewer points (find more info here: [Ramer_Douglas_Peucker_algorithm](https://en.wikipedia.org/wiki/Ramer%E2%80%93Douglas%E2%80%93Peucker_algorithm#Algorithm) ). 
        :return: WayPoints
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_path_for_trip_0_with_http_info(id, tid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_path_for_trip_0_with_http_info(id, tid, **kwargs)  # noqa: E501
            return data

    def get_path_for_trip_0_with_http_info(self, id, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Gives the Vehicle's wayPoints for a specified Trip.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_path_for_trip_0_with_http_info(id, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param float tolerance: Tolerance factor is expressed in length KM unit and is used to simplify path by reducing the total number of points by is using Douglas-Peucker algorithme to find a similar curve with fewer points (find more info here: [Ramer_Douglas_Peucker_algorithm](https://en.wikipedia.org/wiki/Ramer%E2%80%93Douglas%E2%80%93Peucker_algorithm#Algorithm) ). 
        :return: WayPoints
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'tid', 'index_range', 'timestamps', 'tolerance']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_path_for_trip_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_path_for_trip_0`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_path_for_trip_0`")  # noqa: E501

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_path_for_trip_0`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'timestamps' in params:
            query_params.append(('timestamps', params['timestamps']))  # noqa: E501
            collection_formats['timestamps'] = 'multi'  # noqa: E501
        if 'tolerance' in params:
            query_params.append(('tolerance', params['tolerance']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/trips/{tid}/wayPoints', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WayPoints',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_telemetry_for_trip(self, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the set of Telemetry values that occurred for a given vehicle (id) and a speific Trip (tid) during the timestamp ranges and bounded by an index range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telemetry_for_trip(tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :param list[str] type: Results will only contain Telemetry messages of this kind. You can add more than one message type.
        :param list[str] extension: Additional data set that will be included in embedded field    * _Disclaimer_:  **Enabling ```maintenance``` extension will automatically disable ```Kinetic``` telemetry message**
        :return: Telemetry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telemetry_for_trip_with_http_info(tid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_telemetry_for_trip_with_http_info(tid, **kwargs)  # noqa: E501
            return data

    def get_telemetry_for_trip_with_http_info(self, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the set of Telemetry values that occurred for a given vehicle (id) and a speific Trip (tid) during the timestamp ranges and bounded by an index range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telemetry_for_trip_with_http_info(tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :param list[str] type: Results will only contain Telemetry messages of this kind. You can add more than one message type.
        :param list[str] extension: Additional data set that will be included in embedded field    * _Disclaimer_:  **Enabling ```maintenance``` extension will automatically disable ```Kinetic``` telemetry message**
        :return: Telemetry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tid', 'timestamps', 'index_range', 'locale', 'type', 'extension']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telemetry_for_trip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_telemetry_for_trip`")  # noqa: E501

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_telemetry_for_trip`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []
        if 'timestamps' in params:
            query_params.append(('timestamps', params['timestamps']))  # noqa: E501
            collection_formats['timestamps'] = 'multi'  # noqa: E501
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'locale' in params:
            query_params.append(('locale', params['locale']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
            collection_formats['type'] = 'multi'  # noqa: E501
        if 'extension' in params:
            query_params.append(('extension', params['extension']))  # noqa: E501
            collection_formats['extension'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/trips/{tid}/telemetry', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Telemetry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_telemetry_for_trip_0(self, id, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the set of Telemetry values that occurred for a given vehicle (id) and a speific Trip (tid) during the timestamp ranges and bounded by an index range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telemetry_for_trip_0(id, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :param list[str] type: Results will only contain Telemetry messages of this kind. You can add more than one message type.
        :param list[str] extension: Additional data set that will be included in embedded field    * _Disclaimer_:  **Enabling ```maintenance``` extension will automatically disable ```Kinetic``` telemetry message**
        :return: Telemetry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telemetry_for_trip_0_with_http_info(id, tid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_telemetry_for_trip_0_with_http_info(id, tid, **kwargs)  # noqa: E501
            return data

    def get_telemetry_for_trip_0_with_http_info(self, id, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the set of Telemetry values that occurred for a given vehicle (id) and a speific Trip (tid) during the timestamp ranges and bounded by an index range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telemetry_for_trip_0_with_http_info(id, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :param list[str] type: Results will only contain Telemetry messages of this kind. You can add more than one message type.
        :param list[str] extension: Additional data set that will be included in embedded field    * _Disclaimer_:  **Enabling ```maintenance``` extension will automatically disable ```Kinetic``` telemetry message**
        :return: Telemetry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'tid', 'timestamps', 'index_range', 'locale', 'type', 'extension']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telemetry_for_trip_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_telemetry_for_trip_0`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_telemetry_for_trip_0`")  # noqa: E501

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_telemetry_for_trip_0`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []
        if 'timestamps' in params:
            query_params.append(('timestamps', params['timestamps']))  # noqa: E501
            collection_formats['timestamps'] = 'multi'  # noqa: E501
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'locale' in params:
            query_params.append(('locale', params['locale']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
            collection_formats['type'] = 'multi'  # noqa: E501
        if 'extension' in params:
            query_params.append(('extension', params['extension']))  # noqa: E501
            collection_formats['extension'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/trips/{tid}/telemetry', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Telemetry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trip_by_vehicle(self, id, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        This method returns the Trip that matches the Trip id (tid) a given Vehicle (id) has taken.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trip_by_vehicle(id, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :return: Trip
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trip_by_vehicle_with_http_info(id, tid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trip_by_vehicle_with_http_info(id, tid, **kwargs)  # noqa: E501
            return data

    def get_trip_by_vehicle_with_http_info(self, id, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        This method returns the Trip that matches the Trip id (tid) a given Vehicle (id) has taken.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trip_by_vehicle_with_http_info(id, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :return: Trip
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'tid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trip_by_vehicle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_trip_by_vehicle`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_trip_by_vehicle`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/trips/{tid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Trip',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trips_by_vehicle(self, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        This method returns the Trip that matches the Trip id (tid) User has taken.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trips_by_vehicle(tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :return: Trip
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trips_by_vehicle_with_http_info(tid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trips_by_vehicle_with_http_info(tid, **kwargs)  # noqa: E501
            return data

    def get_trips_by_vehicle_with_http_info(self, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        This method returns the Trip that matches the Trip id (tid) User has taken.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trips_by_vehicle_with_http_info(tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :return: Trip
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trips_by_vehicle" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_trips_by_vehicle`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/trips/{tid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Trip',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trips_by_vehicle_0(self, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Return the User Trip ECoaching evaluation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trips_by_vehicle_0(tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :return: ECoaching
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trips_by_vehicle_0_with_http_info(tid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trips_by_vehicle_0_with_http_info(tid, **kwargs)  # noqa: E501
            return data

    def get_trips_by_vehicle_0_with_http_info(self, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Return the User Trip ECoaching evaluation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trips_by_vehicle_0_with_http_info(tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :return: ECoaching
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tid', 'locale']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trips_by_vehicle_0" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_trips_by_vehicle_0`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []
        if 'locale' in params:
            query_params.append(('locale', params['locale']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/trips/{tid}/ecoaching', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ECoaching',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trips_by_vehicle_1(self, id, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        This method returns a list of all Trips that a given Vehicle has taken. This will NOT include Trips that have not yet been completed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trips_by_vehicle_1(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Trips
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trips_by_vehicle_1_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trips_by_vehicle_1_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_trips_by_vehicle_1_with_http_info(self, id, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        This method returns a list of all Trips that a given Vehicle has taken. This will NOT include Trips that have not yet been completed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trips_by_vehicle_1_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Trips
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'timestamps', 'index_range', 'page_size', 'page_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trips_by_vehicle_1" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_trips_by_vehicle_1`")  # noqa: E501

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_trips_by_vehicle_1`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_trips_by_vehicle_1`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'timestamps' in params:
            query_params.append(('timestamps', params['timestamps']))  # noqa: E501
            collection_formats['timestamps'] = 'multi'  # noqa: E501
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/trips', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Trips',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_trips_by_vehicle_2(self, id, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Return the Trip ECoaching evaluation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trips_by_vehicle_2(id, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :return: ECoaching
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_trips_by_vehicle_2_with_http_info(id, tid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_trips_by_vehicle_2_with_http_info(id, tid, **kwargs)  # noqa: E501
            return data

    def get_trips_by_vehicle_2_with_http_info(self, id, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Return the Trip ECoaching evaluation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_trips_by_vehicle_2_with_http_info(id, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :return: ECoaching
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'tid', 'locale']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_trips_by_vehicle_2" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_trips_by_vehicle_2`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_trips_by_vehicle_2`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []
        if 'locale' in params:
            query_params.append(('locale', params['locale']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/trips/{tid}/ecoaching', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ECoaching',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_collision_by_tip_by_id(self, tid, cid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the Collision(cid) that occurred for a given vehicle(id) during a Trip(tid) .  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_collision_by_tip_by_id(tid, cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param str cid: Results will only contain the Collision related to this Collision *id*. (required)
        :return: Collision
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_collision_by_tip_by_id_with_http_info(tid, cid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_collision_by_tip_by_id_with_http_info(tid, cid, **kwargs)  # noqa: E501
            return data

    def get_user_collision_by_tip_by_id_with_http_info(self, tid, cid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the Collision(cid) that occurred for a given vehicle(id) during a Trip(tid) .  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_collision_by_tip_by_id_with_http_info(tid, cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param str cid: Results will only contain the Collision related to this Collision *id*. (required)
        :return: Collision
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tid', 'cid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_collision_by_tip_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_user_collision_by_tip_by_id`")  # noqa: E501
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_user_collision_by_tip_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/trips/{tid}/collisions/{cid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collision',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_collisions_by_trip_id(self, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the set of Collisions that occurred for a given vehicle (id) and a speific Trip (tid) during the timestamp ranges and bounded by an index range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_collisions_by_trip_id(tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Collisions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_collisions_by_trip_id_with_http_info(tid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_collisions_by_trip_id_with_http_info(tid, **kwargs)  # noqa: E501
            return data

    def get_user_collisions_by_trip_id_with_http_info(self, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the set of Collisions that occurred for a given vehicle (id) and a speific Trip (tid) during the timestamp ranges and bounded by an index range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_collisions_by_trip_id_with_http_info(tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Collisions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tid', 'timestamps', 'index_range', 'page_size', 'page_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_collisions_by_trip_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_user_collisions_by_trip_id`")  # noqa: E501

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_user_collisions_by_trip_id`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_user_collisions_by_trip_id`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []
        if 'timestamps' in params:
            query_params.append(('timestamps', params['timestamps']))  # noqa: E501
            collection_formats['timestamps'] = 'multi'  # noqa: E501
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/trips/{tid}/collisions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collisions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_trip_alert_by_aid(self, tid, aid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns information about a specific alert messages for a given Trip.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_trip_alert_by_aid(tid, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param str aid: id of the alert. (required)
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_trip_alert_by_aid_with_http_info(tid, aid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_trip_alert_by_aid_with_http_info(tid, aid, **kwargs)  # noqa: E501
            return data

    def get_user_trip_alert_by_aid_with_http_info(self, tid, aid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns information about a specific alert messages for a given Trip.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_trip_alert_by_aid_with_http_info(tid, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param str aid: id of the alert. (required)
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tid', 'aid', 'locale']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_trip_alert_by_aid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_user_trip_alert_by_aid`")  # noqa: E501
        # verify the required parameter 'aid' is set
        if ('aid' not in params or
                params['aid'] is None):
            raise ValueError("Missing the required parameter `aid` when calling `get_user_trip_alert_by_aid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501
        if 'aid' in params:
            path_params['aid'] = params['aid']  # noqa: E501

        query_params = []
        if 'locale' in params:
            query_params.append(('locale', params['locale']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/trips/{tid}/alerts/{aid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Alert',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_trip_alerts(self, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the latest alert messages during a Trip.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_trip_alerts(tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats.
        :return: Alerts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_trip_alerts_with_http_info(tid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_trip_alerts_with_http_info(tid, **kwargs)  # noqa: E501
            return data

    def get_user_trip_alerts_with_http_info(self, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the latest alert messages during a Trip.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_trip_alerts_with_http_info(tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tid: the *id* of Trip (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats.
        :return: Alerts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tid', 'timestamps', 'index_range', 'page_size', 'page_token', 'locale']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_trip_alerts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_user_trip_alerts`")  # noqa: E501

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_user_trip_alerts`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_user_trip_alerts`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []
        if 'timestamps' in params:
            query_params.append(('timestamps', params['timestamps']))  # noqa: E501
            collection_formats['timestamps'] = 'multi'  # noqa: E501
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'locale' in params:
            query_params.append(('locale', params['locale']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/trips/{tid}/alerts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Alerts',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_trips(self, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        This method returns a list of all Trips the User has taken. This will NOT include Trips that have not yet been completed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_trips(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Trips
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_trips_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_user_trips_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_user_trips_with_http_info(self, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        This method returns a list of all Trips the User has taken. This will NOT include Trips that have not yet been completed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_trips_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Trips
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['timestamps', 'index_range', 'page_size', 'page_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_trips" % key
                )
            params[key] = val
        del params['kwargs']

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_user_trips`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_user_trips`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timestamps' in params:
            query_params.append(('timestamps', params['timestamps']))  # noqa: E501
            collection_formats['timestamps'] = 'multi'  # noqa: E501
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/trips', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Trips',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicle_collision_by_tip_by_id(self, id, tid, cid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the Collision(cid) that occurred for a given vehicle(id) during a Trip(tid) .  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_collision_by_tip_by_id(id, tid, cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param str cid: Results will only contain the Collision related to this Collision *id*. (required)
        :return: Collision
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicle_collision_by_tip_by_id_with_http_info(id, tid, cid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicle_collision_by_tip_by_id_with_http_info(id, tid, cid, **kwargs)  # noqa: E501
            return data

    def get_vehicle_collision_by_tip_by_id_with_http_info(self, id, tid, cid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the Collision(cid) that occurred for a given vehicle(id) during a Trip(tid) .  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_collision_by_tip_by_id_with_http_info(id, tid, cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param str cid: Results will only contain the Collision related to this Collision *id*. (required)
        :return: Collision
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'tid', 'cid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicle_collision_by_tip_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle_collision_by_tip_by_id`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_vehicle_collision_by_tip_by_id`")  # noqa: E501
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_vehicle_collision_by_tip_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/trips/{tid}/collisions/{cid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collision',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicle_collisions_by_trip_id(self, id, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the set of Collisions that occurred for a given vehicle (id) and a speific Trip (tid) during the timestamp ranges and bounded by an index range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_collisions_by_trip_id(id, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Collisions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicle_collisions_by_trip_id_with_http_info(id, tid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicle_collisions_by_trip_id_with_http_info(id, tid, **kwargs)  # noqa: E501
            return data

    def get_vehicle_collisions_by_trip_id_with_http_info(self, id, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the set of Collisions that occurred for a given vehicle (id) and a speific Trip (tid) during the timestamp ranges and bounded by an index range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_collisions_by_trip_id_with_http_info(id, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Collisions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'tid', 'timestamps', 'index_range', 'page_size', 'page_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicle_collisions_by_trip_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle_collisions_by_trip_id`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_vehicle_collisions_by_trip_id`")  # noqa: E501

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_vehicle_collisions_by_trip_id`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_vehicle_collisions_by_trip_id`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []
        if 'timestamps' in params:
            query_params.append(('timestamps', params['timestamps']))  # noqa: E501
            collection_formats['timestamps'] = 'multi'  # noqa: E501
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/trips/{tid}/collisions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collisions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicle_trip_alert_by_aid(self, id, tid, aid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns information about a specific alert messages for a given Vehicle and Trip.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_trip_alert_by_aid(id, tid, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param str aid: id of the alert. (required)
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicle_trip_alert_by_aid_with_http_info(id, tid, aid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicle_trip_alert_by_aid_with_http_info(id, tid, aid, **kwargs)  # noqa: E501
            return data

    def get_vehicle_trip_alert_by_aid_with_http_info(self, id, tid, aid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns information about a specific alert messages for a given Vehicle and Trip.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_trip_alert_by_aid_with_http_info(id, tid, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param str aid: id of the alert. (required)
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'tid', 'aid', 'locale']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicle_trip_alert_by_aid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle_trip_alert_by_aid`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_vehicle_trip_alert_by_aid`")  # noqa: E501
        # verify the required parameter 'aid' is set
        if ('aid' not in params or
                params['aid'] is None):
            raise ValueError("Missing the required parameter `aid` when calling `get_vehicle_trip_alert_by_aid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501
        if 'aid' in params:
            path_params['aid'] = params['aid']  # noqa: E501

        query_params = []
        if 'locale' in params:
            query_params.append(('locale', params['locale']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/trips/{tid}/alerts/{aid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Alert',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicle_trip_alerts(self, id, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the latest alert messages for a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_trip_alerts(id, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats.
        :return: Alerts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicle_trip_alerts_with_http_info(id, tid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicle_trip_alerts_with_http_info(id, tid, **kwargs)  # noqa: E501
            return data

    def get_vehicle_trip_alerts_with_http_info(self, id, tid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the latest alert messages for a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_trip_alerts_with_http_info(id, tid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str tid: the *id* of Trip (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats.
        :return: Alerts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'tid', 'timestamps', 'index_range', 'page_size', 'page_token', 'locale']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicle_trip_alerts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle_trip_alerts`")  # noqa: E501
        # verify the required parameter 'tid' is set
        if ('tid' not in params or
                params['tid'] is None):
            raise ValueError("Missing the required parameter `tid` when calling `get_vehicle_trip_alerts`")  # noqa: E501

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_vehicle_trip_alerts`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_vehicle_trip_alerts`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'tid' in params:
            path_params['tid'] = params['tid']  # noqa: E501

        query_params = []
        if 'timestamps' in params:
            query_params.append(('timestamps', params['timestamps']))  # noqa: E501
            collection_formats['timestamps'] = 'multi'  # noqa: E501
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'locale' in params:
            query_params.append(('locale', params['locale']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/trips/{tid}/alerts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Alerts',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
