from distutils.core import setup
from setuptools import find_packages
import os


# User-friendly description from README.md
current_directory = os.path.dirname(os.path.abspath(__file__))
try:
    with open(os.path.join(current_directory, 'README.md'), encoding='utf-8') as f:
        long_description = f.read()
except Exception:
    long_description = ''

setup(
	# Name of the package 
	name='telebot-utils',
	# Packages to include into the distribution 
	packages=find_packages('.'),
	# Start with a small number and increase it with 
	# every change you make https://semver.org 
	version='0.0.6',
	# Chose a license from here: https: // 
	# help.github.com / articles / licensing - a - 
	# repository. For example: MIT 
	license='MIT',
	# Short description of your library 
	description='Utils for pyTelegramBotAPI module',
	# Long description of your library 
	long_description=long_description,
	long_description_content_type='text/markdown',
	# Your name 
	author='voilalex',
	# Your email 
	author_email='ilya.vouk@gmail.com',
	# Either the link to your github or to your website 
	url='https://github.com/VoIlAlex/telebot-utils',
	# Link from which the project can be downloaded 
	download_url='https://github.com/VoIlAlex/telebot-utils/archive/v0.0.6.tar.gz',
	# List of keywords 
	keywords=[
		'telebot',
		'utils',
		'chat',
		'bot'
	],
	# List of packages to install with this one 
	install_requires=[
		"pyTelegramBotAPI==3.7.2"
	],
	# https://pypi.org/classifiers/ 
	classifiers=[
		'Development Status :: 1 - Planning',
		'License :: OSI Approved :: MIT License',
		'Programming Language :: Python :: 3',
		'Topic :: Communications :: Chat',
		'Topic :: Software Development',
		'Topic :: Utilities'
	]
)
