/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler.constraints;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.core.base.ObjectType;
import org.drools.core.base.ValueType;
import org.drools.core.base.field.ObjectFieldImpl;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.accessor.FieldValue;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.rule.accessor.TupleValueExtractor;
import org.drools.core.time.Interval;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.index.IndexUtil;
import org.drools.model.AlphaIndex;
import org.drools.model.BetaIndex;
import org.drools.model.BetaIndex2;
import org.drools.model.BetaIndex3;
import org.drools.model.BetaIndex4;
import org.drools.model.BetaIndexN;
import org.drools.model.Index;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Function2;
import org.drools.model.functions.Function3;
import org.drools.model.functions.Function4;
import org.drools.model.functions.PredicateInformation;
import org.drools.modelcompiler.constraints.AbstractConstraint;
import org.drools.modelcompiler.constraints.ConstraintEvaluationException;
import org.drools.modelcompiler.constraints.ConstraintEvaluator;
import org.drools.modelcompiler.constraints.LambdaReadAccessor;
import org.drools.modelcompiler.util.EvaluationUtil;
import org.kie.api.KieBaseConfiguration;

public class LambdaConstraint
extends AbstractConstraint {
    private final ConstraintEvaluator evaluator;
    private final PredicateInformation predicateInformation;
    private FieldValue field;
    private ReadAccessor readAccessor;
    private AbstractIndexValueExtractor indexExtractor;

    public LambdaConstraint(ConstraintEvaluator evaluator, PredicateInformation predicateInformation) {
        this.evaluator = evaluator;
        this.predicateInformation = predicateInformation;
        this.initIndexes();
    }

    public LambdaConstraint(ConstraintEvaluator evaluator) {
        this(evaluator, PredicateInformation.EMPTY_PREDICATE_INFORMATION);
    }

    public ConstraintEvaluator getEvaluator() {
        return this.evaluator;
    }

    private void initIndexes() {
        Index index = this.evaluator.getIndex();
        if (index != null) {
            this.readAccessor = new LambdaReadAccessor(index.getIndexId(), index.getIndexedClass(), index.getLeftOperandExtractor());
            switch (index.getIndexType()) {
                case ALPHA: {
                    this.field = new ObjectFieldImpl(((AlphaIndex)index).getRightValue());
                    break;
                }
                case BETA: {
                    this.indexExtractor = this.initBetaIndex((BetaIndexN)index);
                }
            }
        }
    }

    private AbstractIndexValueExtractor initBetaIndex(BetaIndexN index) {
        switch (index.getArity()) {
            case 1: {
                BetaIndex index1 = (BetaIndex)index;
                return new IndexValueExtractor1(this.evaluator.getRequiredDeclarations()[0], index1.getRightOperandExtractor(), index1.getRightReturnType());
            }
            case 2: {
                BetaIndex2 index2 = (BetaIndex2)index;
                return new IndexValueExtractor2(this.evaluator.getRequiredDeclarations()[0], this.evaluator.getRequiredDeclarations()[1], index2.getRightOperandExtractor(), index2.getRightReturnType());
            }
            case 3: {
                BetaIndex3 index3 = (BetaIndex3)index;
                return new IndexValueExtractor3(this.evaluator.getRequiredDeclarations()[0], this.evaluator.getRequiredDeclarations()[1], this.evaluator.getRequiredDeclarations()[2], index3.getRightOperandExtractor(), index3.getRightReturnType());
            }
            case 4: {
                BetaIndex4 index4 = (BetaIndex4)index;
                return new IndexValueExtractor4(this.evaluator.getRequiredDeclarations()[0], this.evaluator.getRequiredDeclarations()[1], this.evaluator.getRequiredDeclarations()[2], this.evaluator.getRequiredDeclarations()[3], index4.getRightOperandExtractor(), index4.getRightReturnType());
            }
        }
        throw new UnsupportedOperationException("Unsupported arity " + index.getArity() + " for beta index");
    }

    public String toString() {
        return "[" + this.evaluator.toString() + ", " + this.predicateInformation.getStringConstraint() + "]";
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.evaluator.getRequiredDeclarations();
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        this.evaluator.replaceDeclaration(oldDecl, newDecl);
        if (this.indexExtractor != null) {
            this.indexExtractor.replaceDeclaration(oldDecl, newDecl);
        }
    }

    @Override
    public BitMask getListenedPropertyMask(ObjectType objectType, List<String> settableProperties) {
        BitMask mask = EvaluationUtil.adaptBitMask(this.evaluator.getReactivityBitMask());
        if (mask != null) {
            return mask;
        }
        if (this.evaluator.getReactiveProps().length == 0) {
            return super.getListenedPropertyMask(objectType, settableProperties);
        }
        mask = PropertySpecificUtil.getEmptyPropertyReactiveMask(settableProperties.size());
        for (String prop : this.evaluator.getReactiveProps()) {
            int pos = settableProperties.indexOf(prop);
            if (pos < 0) continue;
            mask = mask.set(pos + 1);
        }
        return mask;
    }

    @Override
    public LambdaConstraint clone() {
        LambdaConstraint clone = new LambdaConstraint(this.evaluator.clone(), this.predicateInformation);
        clone.field = this.field;
        clone.readAccessor = this.readAccessor;
        return clone;
    }

    @Override
    public boolean isTemporal() {
        return this.evaluator.isTemporal();
    }

    @Override
    public Interval getInterval() {
        return this.evaluator.getInterval();
    }

    @Override
    public boolean isAllowed(InternalFactHandle handle, ReteEvaluator reteEvaluator) {
        try {
            return this.evaluator.evaluate(handle, reteEvaluator);
        }
        catch (RuntimeException e) {
            throw new ConstraintEvaluationException(this.predicateInformation, (Throwable)e);
        }
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        LambdaContextEntry lambdaContext = (LambdaContextEntry)context;
        try {
            return this.evaluator.evaluate(handle, lambdaContext.getTuple(), lambdaContext.getReteEvaluator());
        }
        catch (RuntimeException e) {
            throw new ConstraintEvaluationException(this.predicateInformation, (Throwable)e);
        }
    }

    @Override
    public boolean isAllowedCachedRight(Tuple tuple, ContextEntry context) {
        LambdaContextEntry lambdaContext = (LambdaContextEntry)context;
        try {
            return this.evaluator.evaluate(lambdaContext.getHandle(), tuple, lambdaContext.getReteEvaluator());
        }
        catch (RuntimeException e) {
            throw new ConstraintEvaluationException(this.predicateInformation, (Throwable)e);
        }
    }

    @Override
    public ContextEntry createContextEntry() {
        return new LambdaContextEntry();
    }

    @Override
    public boolean isUnification() {
        return false;
    }

    @Override
    public boolean isIndexable(short nodeType, KieBaseConfiguration config) {
        return this.getConstraintType().isIndexableForNode(nodeType, this, config);
    }

    @Override
    public IndexUtil.ConstraintType getConstraintType() {
        Index index = this.evaluator.getIndex();
        if (index != null) {
            switch (index.getConstraintType()) {
                case EQUAL: {
                    return IndexUtil.ConstraintType.EQUAL;
                }
                case NOT_EQUAL: {
                    return IndexUtil.ConstraintType.NOT_EQUAL;
                }
                case GREATER_THAN: {
                    return IndexUtil.ConstraintType.GREATER_THAN;
                }
                case GREATER_OR_EQUAL: {
                    return IndexUtil.ConstraintType.GREATER_OR_EQUAL;
                }
                case LESS_THAN: {
                    return IndexUtil.ConstraintType.LESS_THAN;
                }
                case LESS_OR_EQUAL: {
                    return IndexUtil.ConstraintType.LESS_OR_EQUAL;
                }
                case RANGE: {
                    return IndexUtil.ConstraintType.RANGE;
                }
            }
        }
        return IndexUtil.ConstraintType.UNKNOWN;
    }

    @Override
    public FieldValue getField() {
        return this.field;
    }

    @Override
    public AbstractHashTable.FieldIndex getFieldIndex() {
        return new AbstractHashTable.FieldIndex(this.readAccessor, this.indexExtractor);
    }

    @Override
    public ReadAccessor getFieldExtractor() {
        return this.readAccessor;
    }

    @Override
    public TupleValueExtractor getIndexExtractor() {
        return this.indexExtractor;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.evaluator.equals(((LambdaConstraint)other).evaluator);
    }

    public int hashCode() {
        return this.evaluator.hashCode();
    }

    public PredicateInformation getPredicateInformation() {
        return this.predicateInformation;
    }

    public static class IndexValueExtractor4
    extends AbstractIndexValueExtractor {
        private Declaration d2;
        private Declaration d3;
        private Declaration d4;
        private final Function4 extractor;

        public IndexValueExtractor4(Declaration d1, Declaration d2, Declaration d3, Declaration d4, Function4 extractor, Class<?> clazz) {
            super(d1, clazz);
            this.d2 = d2;
            this.d3 = d3;
            this.d4 = d4;
            this.extractor = extractor;
        }

        public IndexValueExtractor4(Declaration d1, Declaration d2, Declaration d3, Declaration d4, Function4 extractor, ValueType valueType) {
            super(d1, valueType);
            this.d2 = d2;
            this.d3 = d3;
            this.d4 = d4;
            this.extractor = extractor;
        }

        @Override
        public ValueType getValueType() {
            return this.valueType;
        }

        @Override
        public Object getValue(ReteEvaluator reteEvaluator, Tuple tuple) {
            return this.extractor.apply(this.d1.getValue(reteEvaluator, tuple), this.d2.getValue(reteEvaluator, tuple), this.d3.getValue(reteEvaluator, tuple), this.d4.getValue(reteEvaluator, tuple));
        }

        @Override
        public TupleValueExtractor clone() {
            return new IndexValueExtractor4(this.d1.clone(), this.d2.clone(), this.d3.clone(), this.d4.clone(), this.extractor, this.valueType);
        }

        @Override
        public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
            this.d1 = this.replaceDeclaration(oldDecl, newDecl, this.d1);
            this.d2 = this.replaceDeclaration(oldDecl, newDecl, this.d2);
            this.d3 = this.replaceDeclaration(oldDecl, newDecl, this.d3);
            this.d4 = this.replaceDeclaration(oldDecl, newDecl, this.d4);
        }
    }

    public static class IndexValueExtractor3
    extends AbstractIndexValueExtractor {
        private Declaration d2;
        private Declaration d3;
        private final Function3 extractor;

        public IndexValueExtractor3(Declaration d1, Declaration d2, Declaration d3, Function3 extractor, Class<?> clazz) {
            super(d1, clazz);
            this.d2 = d2;
            this.d3 = d3;
            this.extractor = extractor;
        }

        public IndexValueExtractor3(Declaration d1, Declaration d2, Declaration d3, Function3 extractor, ValueType valueType) {
            super(d1, valueType);
            this.d2 = d2;
            this.d3 = d3;
            this.extractor = extractor;
        }

        @Override
        public ValueType getValueType() {
            return this.valueType;
        }

        @Override
        public Object getValue(ReteEvaluator reteEvaluator, Tuple tuple) {
            return this.extractor.apply(this.d1.getValue(reteEvaluator, tuple), this.d2.getValue(reteEvaluator, tuple), this.d3.getValue(reteEvaluator, tuple));
        }

        @Override
        public TupleValueExtractor clone() {
            return new IndexValueExtractor3(this.d1.clone(), this.d2.clone(), this.d3.clone(), this.extractor, this.valueType);
        }

        @Override
        public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
            this.d1 = this.replaceDeclaration(oldDecl, newDecl, this.d1);
            this.d2 = this.replaceDeclaration(oldDecl, newDecl, this.d2);
            this.d3 = this.replaceDeclaration(oldDecl, newDecl, this.d3);
        }
    }

    public static class IndexValueExtractor2
    extends AbstractIndexValueExtractor {
        private Declaration d2;
        private final Function2 extractor;

        public IndexValueExtractor2(Declaration d1, Declaration d2, Function2 extractor, Class<?> clazz) {
            super(d1, clazz);
            this.d2 = d2;
            this.extractor = extractor;
        }

        public IndexValueExtractor2(Declaration d1, Declaration d2, Function2 extractor, ValueType valueType) {
            super(d1, valueType);
            this.d2 = d2;
            this.extractor = extractor;
        }

        @Override
        public ValueType getValueType() {
            return this.valueType;
        }

        @Override
        public Object getValue(ReteEvaluator reteEvaluator, Tuple tuple) {
            return this.extractor.apply(this.d1.getValue(reteEvaluator, tuple), this.d2.getValue(reteEvaluator, tuple));
        }

        @Override
        public TupleValueExtractor clone() {
            return new IndexValueExtractor2(this.d1.clone(), this.d2.clone(), this.extractor, this.valueType);
        }

        @Override
        public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
            this.d1 = this.replaceDeclaration(oldDecl, newDecl, this.d1);
            this.d2 = this.replaceDeclaration(oldDecl, newDecl, this.d2);
        }
    }

    public static class IndexValueExtractor1
    extends AbstractIndexValueExtractor {
        private final Function1 extractor;

        public IndexValueExtractor1(Declaration d1, Function1 extractor, Class<?> clazz) {
            super(d1, clazz);
            this.extractor = extractor;
        }

        public IndexValueExtractor1(Declaration d1, Function1 extractor, ValueType valueType) {
            super(d1, valueType);
            this.extractor = extractor;
        }

        @Override
        public Object getValue(ReteEvaluator reteEvaluator, Tuple tuple) {
            return this.extractor.apply(this.d1.getValue(reteEvaluator, tuple));
        }

        @Override
        public TupleValueExtractor clone() {
            return new IndexValueExtractor1(this.d1.clone(), this.extractor, this.valueType);
        }

        @Override
        public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
            this.d1 = this.replaceDeclaration(oldDecl, newDecl, this.d1);
        }
    }

    public static abstract class AbstractIndexValueExtractor
    implements TupleValueExtractor {
        protected Declaration d1;
        protected final ValueType valueType;

        protected AbstractIndexValueExtractor(Declaration d1, Class<?> clazz) {
            this(d1, ValueType.determineValueType(clazz));
        }

        protected AbstractIndexValueExtractor(Declaration d1, ValueType valueType) {
            this.d1 = d1;
            this.valueType = valueType;
        }

        @Override
        public ValueType getValueType() {
            return this.valueType;
        }

        @Override
        public abstract TupleValueExtractor clone();

        public abstract void replaceDeclaration(Declaration var1, Declaration var2);

        protected Declaration replaceDeclaration(Declaration oldDecl, Declaration newDecl, Declaration indexingDeclaration) {
            if (indexingDeclaration.getIdentifier().equals(oldDecl.getIdentifier()) && indexingDeclaration.getPattern() == oldDecl.getPattern()) {
                Declaration newIndexingDeclaration = newDecl.clone();
                newIndexingDeclaration.setReadAccessor(indexingDeclaration.getExtractor());
                return newIndexingDeclaration;
            }
            return indexingDeclaration;
        }
    }

    public static class LambdaContextEntry
    implements ContextEntry {
        private Tuple tuple;
        private InternalFactHandle handle;
        private transient ReteEvaluator reteEvaluator;

        @Override
        public void updateFromTuple(ReteEvaluator reteEvaluator, Tuple tuple) {
            this.tuple = tuple;
            this.reteEvaluator = reteEvaluator;
        }

        @Override
        public void updateFromFactHandle(ReteEvaluator reteEvaluator, InternalFactHandle handle) {
            this.reteEvaluator = reteEvaluator;
            this.handle = handle;
        }

        @Override
        public void resetTuple() {
            this.tuple = null;
        }

        @Override
        public void resetFactHandle() {
            this.reteEvaluator = null;
            this.handle = null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.tuple);
            out.writeObject(this.handle);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.tuple = (Tuple)in.readObject();
            this.handle = (InternalFactHandle)in.readObject();
        }

        public Tuple getTuple() {
            return this.tuple;
        }

        public InternalFactHandle getHandle() {
            return this.handle;
        }

        public ReteEvaluator getReteEvaluator() {
            return this.reteEvaluator;
        }

        @Override
        public ContextEntry getNext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNext(ContextEntry entry) {
            throw new UnsupportedOperationException();
        }
    }
}

