/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.core.base.ObjectType;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.accessor.GlobalExtractor;
import org.drools.model.Global;
import org.drools.model.Variable;
import org.drools.modelcompiler.KiePackagesBuilder;

public class RuleContext {
    private final KiePackagesBuilder builder;
    private final InternalKnowledgePackage pkg;
    private final RuleImpl rule;
    private final Map<Variable, Declaration> declarations = new HashMap<Variable, Declaration>();
    private Map<Variable, Declaration> queryDeclarations;
    private Map<Variable, Accumulate> accumulateSource;
    private int patternIndex = -1;
    private boolean needStreamMode = false;
    private Deque<Set<Variable>> variablesInOrCondition;

    public RuleContext(KiePackagesBuilder builder, InternalKnowledgePackage pkg, RuleImpl rule) {
        this.builder = builder;
        this.pkg = pkg;
        this.rule = rule;
    }

    public Collection<InternalKnowledgePackage> getKnowledgePackages() {
        return this.builder.getKiePackages();
    }

    public InternalKnowledgePackage getPkg() {
        return this.pkg;
    }

    public RuleImpl getRule() {
        return this.rule;
    }

    int getNextPatternIndex() {
        return ++this.patternIndex;
    }

    void startOrCondition() {
        if (this.variablesInOrCondition == null) {
            this.variablesInOrCondition = new ArrayDeque<Set<Variable>>();
        }
        this.variablesInOrCondition.addLast(new HashSet());
    }

    void endOrCondition() {
        this.variablesInOrCondition.removeLast();
    }

    void registerPattern(Variable variable, Pattern pattern) {
        if (this.variablesInOrCondition != null && !this.variablesInOrCondition.isEmpty() && !this.variablesInOrCondition.getLast().add(variable)) {
            this.declarations.put(variable, pattern.getDeclaration());
        } else {
            this.declarations.computeIfAbsent(variable, k -> pattern.getDeclaration());
        }
    }

    Pattern getPattern(Variable variable) {
        Declaration declaration = this.declarations.get(variable);
        return declaration == null ? null : declaration.getPattern();
    }

    Declaration getDeclaration(Variable variable) {
        if (variable == null) {
            return null;
        }
        if (variable.isFact()) {
            Declaration declaration = this.declarations.get(variable);
            if (declaration == null) {
                declaration = this.getQueryDeclaration(variable);
            }
            return declaration;
        }
        Global global = (Global)variable;
        ObjectType objectType = this.builder.getObjectType(global);
        GlobalExtractor globalExtractor = new GlobalExtractor(global.getName(), objectType);
        return new Declaration(global.getName(), globalExtractor, new Pattern(0, objectType));
    }

    Declaration getQueryDeclaration(Variable variable) {
        return this.queryDeclarations == null ? null : this.queryDeclarations.get(variable);
    }

    void addQueryDeclaration(Variable variable, Declaration declaration) {
        if (this.queryDeclarations == null) {
            this.queryDeclarations = new HashMap<Variable, Declaration>();
        }
        this.queryDeclarations.put(variable, declaration);
    }

    void addDeclaration(Variable variable, Declaration declaration) {
        this.declarations.put(variable, declaration);
    }

    void addGroupByDeclaration(Variable groupKeyVar, Declaration declaration) {
        this.addDeclaration(groupKeyVar, declaration);
    }

    Accumulate getAccumulateSource(Variable variable) {
        return this.accumulateSource == null ? null : this.accumulateSource.get(variable);
    }

    void addAccumulateSource(Variable variable, Accumulate accumulate) {
        if (this.accumulateSource == null) {
            this.accumulateSource = new HashMap<Variable, Accumulate>();
        }
        this.accumulateSource.put(variable, accumulate);
    }

    public ClassLoader getClassLoader() {
        return this.builder.getClassLoader();
    }

    public boolean needsStreamMode() {
        return this.needStreamMode;
    }

    public void setNeedStreamMode() {
        this.needStreamMode = true;
    }

    public Map<String, Declaration> getDeclarations() {
        HashMap<String, Declaration> decls = new HashMap<String, Declaration>();
        this.declarations.forEach((var, decl) -> decls.put(var.getName(), (Declaration)decl));
        return decls;
    }
}

