/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.compiler.rule.builder.RuleBuilder;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.EnabledBoolean;
import org.drools.core.base.ObjectType;
import org.drools.core.base.SalienceInteger;
import org.drools.core.base.accumulators.CountAccumulateFunction;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.base.extractors.SelfReferenceClassFieldReader;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.impl.KnowledgePackageImpl;
import org.drools.core.definitions.rule.impl.QueryImpl;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.facttemplates.FactTemplateObjectType;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.AsyncReceive;
import org.drools.core.rule.AsyncSend;
import org.drools.core.rule.Behavior;
import org.drools.core.rule.ConditionalBranch;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.EvalCondition;
import org.drools.core.rule.Forall;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.MultiAccumulate;
import org.drools.core.rule.NamedConsequence;
import org.drools.core.rule.PatternSource;
import org.drools.core.rule.QueryArgument;
import org.drools.core.rule.QueryElement;
import org.drools.core.rule.RuleConditionElement;
import org.drools.core.rule.SingleAccumulate;
import org.drools.core.rule.SlidingLengthWindow;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.WindowDeclaration;
import org.drools.core.rule.accessor.Accumulator;
import org.drools.core.rule.accessor.DataProvider;
import org.drools.core.rule.accessor.Enabled;
import org.drools.core.rule.accessor.PatternExtractor;
import org.drools.core.rule.accessor.ReadAccessor;
import org.drools.core.rule.accessor.Salience;
import org.drools.core.rule.constraint.QueryNameConstraint;
import org.drools.core.time.impl.Timer;
import org.drools.model.AccumulatePattern;
import org.drools.model.Argument;
import org.drools.model.Binding;
import org.drools.model.Condition;
import org.drools.model.Consequence;
import org.drools.model.Constraint;
import org.drools.model.DSL;
import org.drools.model.Declaration;
import org.drools.model.DomainClassMetadata;
import org.drools.model.DynamicValueSupplier;
import org.drools.model.EntryPoint;
import org.drools.model.From;
import org.drools.model.From0;
import org.drools.model.From1;
import org.drools.model.From2;
import org.drools.model.From3;
import org.drools.model.From4;
import org.drools.model.Global;
import org.drools.model.GroupByPattern;
import org.drools.model.Index;
import org.drools.model.Model;
import org.drools.model.Pattern;
import org.drools.model.Prototype;
import org.drools.model.PrototypeVariable;
import org.drools.model.Query;
import org.drools.model.Rule;
import org.drools.model.SingleConstraint;
import org.drools.model.TypeMetaData;
import org.drools.model.UnitData;
import org.drools.model.Value;
import org.drools.model.Variable;
import org.drools.model.View;
import org.drools.model.WindowDefinition;
import org.drools.model.WindowReference;
import org.drools.model.bitmask.BitMaskUtil;
import org.drools.model.consequences.ConditionalNamedConsequenceImpl;
import org.drools.model.consequences.ConsequenceImpl;
import org.drools.model.consequences.NamedConsequenceImpl;
import org.drools.model.constraints.AbstractSingleConstraint;
import org.drools.model.constraints.SingleConstraint1;
import org.drools.model.functions.Function0;
import org.drools.model.functions.Function1;
import org.drools.model.functions.FunctionUtils;
import org.drools.model.functions.Predicate1;
import org.drools.model.impl.DeclarationImpl;
import org.drools.model.impl.Exchange;
import org.drools.model.impl.NamesGenerator;
import org.drools.model.patterns.CompositePatterns;
import org.drools.model.patterns.EvalImpl;
import org.drools.model.patterns.ExistentialPatternImpl;
import org.drools.model.patterns.GroupByPatternImpl;
import org.drools.model.patterns.PatternImpl;
import org.drools.model.patterns.QueryCallPattern;
import org.drools.model.view.SelfPatternBiding;
import org.drools.modelcompiler.CanonicalKiePackages;
import org.drools.modelcompiler.RuleContext;
import org.drools.modelcompiler.attributes.LambdaEnabled;
import org.drools.modelcompiler.attributes.LambdaSalience;
import org.drools.modelcompiler.consequence.LambdaConsequence;
import org.drools.modelcompiler.constraints.AbstractConstraint;
import org.drools.modelcompiler.constraints.BindingEvaluator;
import org.drools.modelcompiler.constraints.BindingInnerObjectEvaluator;
import org.drools.modelcompiler.constraints.CombinedConstraint;
import org.drools.modelcompiler.constraints.ConstraintEvaluator;
import org.drools.modelcompiler.constraints.LambdaAccumulator;
import org.drools.modelcompiler.constraints.LambdaConstraint;
import org.drools.modelcompiler.constraints.LambdaDataProvider;
import org.drools.modelcompiler.constraints.LambdaEvalExpression;
import org.drools.modelcompiler.constraints.LambdaGroupByAccumulate;
import org.drools.modelcompiler.constraints.LambdaReadAccessor;
import org.drools.modelcompiler.constraints.TemporalConstraintEvaluator;
import org.drools.modelcompiler.constraints.UnificationConstraint;
import org.drools.modelcompiler.facttemplate.FactFactory;
import org.drools.modelcompiler.util.EvaluationUtil;
import org.drools.modelcompiler.util.TimerUtil;
import org.drools.modelcompiler.util.TypeDeclarationUtil;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.definition.rule.All;
import org.kie.api.definition.rule.Direct;
import org.kie.api.definition.rule.Propagation;
import org.kie.api.definition.type.Role;
import org.kie.api.runtime.rule.AccumulateFunction;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.conf.PropertySpecificOption;

public class KiePackagesBuilder {
    private static final ObjectType JAVA_CLASS_ARRAY_TYPE = new ClassObjectType(Object[].class);
    private final KieBaseConfiguration configuration;
    private final KnowledgeBuilderConfiguration builderConf;
    private final Map<String, InternalKnowledgePackage> packages = new HashMap<String, InternalKnowledgePackage>();
    private final Map<String, ObjectType> objectTypeCache = new HashMap<String, ObjectType>();
    private final Collection<Model> models;

    public KiePackagesBuilder(KieBaseConfiguration conf) {
        this(conf, null, new ArrayList<Model>());
    }

    public KiePackagesBuilder(KieBaseConfiguration conf, KnowledgeBuilderConfiguration builderConf, Collection<Model> models) {
        this.configuration = conf;
        this.builderConf = builderConf;
        this.models = models;
    }

    public void addModel(Model model) {
        this.models.add(model);
    }

    public CanonicalKiePackages build() {
        for (Model model : this.models) {
            InternalKnowledgePackage pkg;
            for (EntryPoint entryPoint : model.getEntryPoints()) {
                pkg = this.packages.computeIfAbsent(model.getName(), this::createKiePackage);
                pkg.addEntryPointId(entryPoint.getName());
            }
            for (TypeMetaData metaType : model.getTypeMetaDatas()) {
                pkg = this.packages.computeIfAbsent(metaType.getPackage(), this::createKiePackage);
                pkg.addTypeDeclaration(TypeDeclarationUtil.createTypeDeclaration(metaType, this.getPropertySpecificOption(), pkg.getTypeResolver()));
            }
            for (Global global : model.getGlobals()) {
                pkg = this.packages.computeIfAbsent(global.getPackage(), this::createKiePackage);
                pkg.addGlobal(global.getName(), global.getType());
            }
            for (Query query : model.getQueries()) {
                pkg = this.packages.computeIfAbsent(query.getPackage(), this::createKiePackage);
                pkg.addRule(this.compileQuery(pkg, query));
            }
            int ruleCounter = 0;
            for (Rule rule : model.getRules()) {
                InternalKnowledgePackage pkg2 = this.packages.computeIfAbsent(rule.getPackage(), this::createKiePackage);
                for (RuleImpl ruleImpl : this.compileRule(pkg2, rule)) {
                    ruleImpl.setLoadOrder(ruleCounter++);
                    pkg2.addRule(ruleImpl);
                }
            }
        }
        return new CanonicalKiePackages(this.packages);
    }

    public ClassLoader getClassLoader() {
        return this.configuration.getClassLoader();
    }

    private InternalKnowledgePackage createKiePackage(String name) {
        InternalKnowledgePackage kpkg = CoreComponentFactory.get().createKnowledgePackage(name);
        kpkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(this.getClassLoader()));
        kpkg.setClassLoader(this.getClassLoader());
        return kpkg;
    }

    private List<RuleImpl> compileRule(InternalKnowledgePackage pkg, Rule rule) {
        RuleImpl ruleImpl = new RuleImpl(rule.getName());
        ruleImpl.setPackage(pkg.getName());
        ruleImpl.setPackage(rule.getPackage());
        if (rule.getUnit() != null) {
            ruleImpl.setRuleUnitClassName(rule.getUnit());
            pkg.getRuleUnitDescriptionLoader().getDescription(ruleImpl);
        }
        RuleContext ctx = new RuleContext(this, pkg, ruleImpl);
        this.populateLHS(ctx, rule.getView());
        this.processConsequences(ctx, rule.getConsequences());
        if (ctx.needsStreamMode()) {
            pkg.setNeedStreamMode();
        }
        this.setRuleAttributes(rule, ruleImpl, ctx);
        this.setRuleMetaAttributes(rule, ruleImpl);
        return Collections.singletonList(ruleImpl);
    }

    private void setRuleAttributes(Rule rule, RuleImpl ruleImpl, RuleContext ctx) {
        Boolean noLoop = this.setAttribute(rule, Rule.Attribute.NO_LOOP, ruleImpl::setNoLoop);
        Boolean lockOnActive = this.setAttribute(rule, Rule.Attribute.LOCK_ON_ACTIVE, ruleImpl::setLockOnActive);
        this.setAttribute(rule, Rule.Attribute.AUTO_FOCUS, ruleImpl::setAutoFocus);
        this.setDynamicAttribute(rule, Rule.Attribute.ENABLED, e -> ruleImpl.setEnabled(this.createEnabled(e)));
        this.setDynamicAttribute(rule, Rule.Attribute.SALIENCE, s -> ruleImpl.setSalience(this.createSalience(s)));
        String agendaGroup = this.setAttribute(rule, Rule.Attribute.AGENDA_GROUP, ruleImpl::setAgendaGroup);
        this.setAttribute(rule, Rule.Attribute.RULEFLOW_GROUP, rfg -> {
            ruleImpl.setRuleFlowGroup((String)rfg);
            if (agendaGroup == null) {
                ruleImpl.setAgendaGroup((String)rfg);
            }
        });
        this.setAttribute(rule, Rule.Attribute.ACTIVATION_GROUP, ruleImpl::setActivationGroup);
        this.setAttribute(rule, Rule.Attribute.DURATION, t -> ruleImpl.setTimer(this.parseTimer(ruleImpl, (String)t, ctx)));
        this.setAttribute(rule, Rule.Attribute.TIMER, t -> ruleImpl.setTimer(this.parseTimer(ruleImpl, (String)t, ctx)));
        this.setAttribute(rule, Rule.Attribute.CALENDARS, ruleImpl::setCalendars);
        this.setAttribute(rule, Rule.Attribute.DATE_EFFECTIVE, ruleImpl::setDateEffective);
        this.setAttribute(rule, Rule.Attribute.DATE_EXPIRES, ruleImpl::setDateExpires);
        ruleImpl.setEager(ruleImpl.isEager() || noLoop != null || lockOnActive != null);
    }

    private Salience createSalience(Object s) {
        if (s instanceof Integer) {
            return new SalienceInteger((Integer)s);
        }
        if (s instanceof DynamicValueSupplier) {
            return new LambdaSalience((DynamicValueSupplier)s);
        }
        throw new UnsupportedOperationException("Unknown salience type: " + s.getClass().getCanonicalName());
    }

    private Enabled createEnabled(Object e) {
        if (e instanceof Boolean) {
            return new EnabledBoolean((Boolean)e);
        }
        if (e instanceof DynamicValueSupplier) {
            return new LambdaEnabled((DynamicValueSupplier)e);
        }
        throw new UnsupportedOperationException("Unknown salience type: " + e.getClass().getCanonicalName());
    }

    private <T> T setAttribute(Rule rule, Rule.Attribute<T> attribute, Consumer<T> consumer) {
        T value = rule.getAttribute(attribute);
        if (value != attribute.getDefaultValue()) {
            consumer.accept(value);
            return value;
        }
        return null;
    }

    private void setDynamicAttribute(Rule rule, Rule.Attribute<?> attribute, Consumer<Object> consumer) {
        Object value = rule.getAttribute(attribute);
        if (value != attribute.getDefaultValue()) {
            consumer.accept(value);
        }
    }

    public void setRuleMetaAttributes(Rule rule, RuleImpl ruleImpl) {
        for (Map.Entry<String, Object> kv : rule.getMetaData().entrySet()) {
            ruleImpl.addMetaAttribute(kv.getKey(), kv.getValue());
            if (kv.getKey().equals(Propagation.class.getName()) || kv.getKey().equals(Propagation.class.getSimpleName())) {
                if (Propagation.Type.IMMEDIATE.toString().equals(kv.getValue()) || Propagation.Type.IMMEDIATE == kv.getValue()) {
                    ruleImpl.setDataDriven(true);
                    continue;
                }
                if (!Propagation.Type.EAGER.toString().equals(kv.getValue()) && Propagation.Type.EAGER != kv.getValue()) continue;
                ruleImpl.setEager(true);
                continue;
            }
            if (kv.getKey().equals(All.class.getName()) || kv.getKey().equals(All.class.getSimpleName())) {
                ruleImpl.setAllMatches(true);
                continue;
            }
            if (!kv.getKey().equals(Direct.class.getName()) && !kv.getKey().equals(Direct.class.getSimpleName())) continue;
            ruleImpl.setActivationListener("direct");
        }
    }

    private Timer parseTimer(RuleImpl ruleImpl, String timerExpr, RuleContext ctx) {
        return RuleBuilder.buildTimer(timerExpr, null, expr -> TimerUtil.buildTimerExpression(expr, ctx.getDeclarations()), e -> {
            throw new IllegalArgumentException("Invalid timer expression: '" + e + "' in rule " + ruleImpl.getName());
        });
    }

    private QueryImpl compileQuery(InternalKnowledgePackage pkg, Query query) {
        QueryImpl queryImpl = new QueryImpl(query.getName());
        queryImpl.setPackage(query.getPackage());
        RuleContext ctx = new RuleContext(this, pkg, queryImpl);
        this.addQueryPattern(query, queryImpl, ctx);
        this.populateLHS(ctx, query.getView());
        return queryImpl;
    }

    private void addQueryPattern(Query query, QueryImpl queryImpl, RuleContext ctx) {
        org.drools.core.rule.Pattern pattern = new org.drools.core.rule.Pattern(ctx.getNextPatternIndex(), 0, 0, ClassObjectType.DroolsQuery_ObjectType, null);
        LambdaReadAccessor extractor = new LambdaReadAccessor(DroolsQuery.class, q -> ((DroolsQuery)q).getName());
        QueryNameConstraint constraint = new QueryNameConstraint(extractor, query.getName());
        pattern.addConstraint(constraint);
        queryImpl.getLhs().addChild(pattern);
        Variable<?>[] args = query.getArguments();
        org.drools.core.rule.Declaration[] declarations = new org.drools.core.rule.Declaration[args.length];
        for (int i = 0; i < args.length; ++i) {
            int index = i;
            LambdaReadAccessor accessor = new LambdaReadAccessor(index, args[index].getType(), obj -> ((DroolsQuery)obj).getElements()[index]);
            declarations[i] = new org.drools.core.rule.Declaration(args[i].getName(), accessor, pattern, false);
            pattern.addDeclaration(declarations[i]);
            ctx.addQueryDeclaration(args[i], declarations[i]);
        }
        queryImpl.setParameters(declarations);
    }

    private void processConsequences(RuleContext ctx, Map<String, Consequence> consequences) {
        if (consequences.isEmpty()) {
            this.processConsequence(ctx, ConsequenceImpl.EMPTY, "default");
        } else {
            for (Map.Entry<String, Consequence> entry : consequences.entrySet()) {
                this.processConsequence(ctx, entry.getValue(), entry.getKey());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processConsequence(RuleContext ctx, Consequence consequence, String name) {
        boolean enabledTupleOptimization;
        org.drools.core.rule.Declaration[] requiredDeclarations = this.getRequiredDeclarationsIfPossible(ctx, consequence, name);
        boolean bl = enabledTupleOptimization = requiredDeclarations != null && requiredDeclarations.length > 0;
        if (name.equals("default")) {
            if (!"java".equals(consequence.getLanguage())) throw new UnsupportedOperationException("Unknown script language for consequence: " + consequence.getLanguage());
            ctx.getRule().setConsequence(new LambdaConsequence(consequence, enabledTupleOptimization));
            return;
        } else {
            ctx.getRule().addNamedConsequence(name, new LambdaConsequence(consequence, enabledTupleOptimization));
        }
    }

    private org.drools.core.rule.Declaration[] getRequiredDeclarationsIfPossible(RuleContext ctx, Consequence consequence, String name) {
        boolean ruleHasFirstLevelOr = this.ruleHasFirstLevelOr(ctx.getRule());
        Variable[] consequenceVars = consequence.getDeclarations();
        String[] requiredDeclarationNames = new String[consequenceVars.length];
        org.drools.core.rule.Declaration[] requiredDeclarations = ruleHasFirstLevelOr ? null : new org.drools.core.rule.Declaration[consequenceVars.length];
        for (int i = 0; i < consequenceVars.length; ++i) {
            requiredDeclarationNames[i] = consequenceVars[i].getName();
            if (ruleHasFirstLevelOr) continue;
            requiredDeclarations[i] = ctx.getDeclaration(consequenceVars[i]);
        }
        ctx.getRule().setRequiredDeclarationsForConsequence(name, requiredDeclarationNames);
        return requiredDeclarations;
    }

    private boolean ruleHasFirstLevelOr(RuleImpl rule) {
        GroupElement lhs = rule.getLhs();
        if (lhs.getType() == GroupElement.OR) {
            return true;
        }
        if (lhs.getType() == GroupElement.Type.AND) {
            for (RuleConditionElement child : lhs.getChildren()) {
                if (!(child instanceof GroupElement) || ((GroupElement)child).getType() != GroupElement.OR) continue;
                return true;
            }
        }
        return false;
    }

    private void populateLHS(RuleContext ctx, View view) {
        GroupElement lhs = ctx.getRule().getLhs();
        this.addSubConditions(ctx, lhs, view.getSubConditions());
        if (this.requiresLeftActivation(lhs)) {
            lhs.addChild(0, new org.drools.core.rule.Pattern(ctx.getNextPatternIndex(), ClassObjectType.InitialFact_ObjectType));
        }
    }

    private boolean requiresLeftActivation(RuleConditionElement rce) {
        if (rce instanceof GroupElement) {
            GroupElement and = (GroupElement)rce;
            return and.getChildren().isEmpty() || this.requiresLeftActivation(and.getChildren().get(0));
        }
        return rce instanceof QueryElement;
    }

    private Variable getUnitVariable(RuleContext ctx, KnowledgePackageImpl pkg, View view) {
        String unitClassName = ctx.getRule().getRuleUnitClassName();
        for (Variable<?> var : view.getBoundVariables()) {
            if (!(var instanceof DeclarationImpl) || !var.getType().getName().equals(unitClassName)) continue;
            return ((DeclarationImpl)var).setSource(DSL.entryPoint("$$units$$"));
        }
        try {
            return DSL.declarationOf(pkg.getTypeResolver().resolveType(unitClassName), DSL.entryPoint("$$units$$"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private RuleConditionElement conditionToElement(RuleContext ctx, GroupElement group, Condition condition) {
        if (condition.getType().isComposite()) {
            return this.addSubConditions(ctx, new GroupElement(KiePackagesBuilder.conditionToGroupElementType(condition.getType())), condition.getSubConditions());
        }
        switch (condition.getType()) {
            case SENDER: 
            case RECEIVER: 
            case PATTERN: {
                RuleConditionElement rce = this.buildPattern(ctx, group, (Pattern)condition);
                if (rce instanceof org.drools.core.rule.Pattern) {
                    org.drools.core.rule.Pattern pattern = (org.drools.core.rule.Pattern)rce;
                    return !group.getChildren().contains(pattern) ? pattern : null;
                }
                return rce;
            }
            case EVAL: {
                return this.buildEval(ctx, (EvalImpl)condition);
            }
            case ACCUMULATE: 
            case GROUP_BY: {
                return this.buildAccumulate(ctx, group, (AccumulatePattern)condition);
            }
            case QUERY: {
                return this.buildQueryPattern(ctx, (QueryCallPattern)condition);
            }
            case NOT: 
            case EXISTS: {
                return new GroupElement(KiePackagesBuilder.conditionToGroupElementType(condition.getType())).addChild(this.conditionToElement(ctx, group, condition.getSubConditions().get(0)));
            }
            case FORALL: {
                return this.buildForAll(ctx, group, condition);
            }
            case CONSEQUENCE: {
                if (condition instanceof NamedConsequenceImpl) {
                    NamedConsequenceImpl consequence = (NamedConsequenceImpl)condition;
                    return consequence.getName().equals("default") ? null : new NamedConsequence(consequence.getName(), consequence.isBreaking());
                }
                if (!(condition instanceof ConditionalNamedConsequenceImpl)) break;
                return this.buildConditionalConsequence(ctx, (ConditionalNamedConsequenceImpl)condition);
            }
        }
        throw new UnsupportedOperationException();
    }

    private ConditionalElement buildForAll(RuleContext ctx, GroupElement group, Condition condition) {
        Condition innerCondition = condition.getSubConditions().get(0);
        if (innerCondition instanceof PatternImpl) {
            return new GroupElement(GroupElement.Type.NOT).addChild(this.conditionToElement(ctx, group, ((PatternImpl)innerCondition).negate()));
        }
        Constraint selfJoinConstraint = this.getForallSelfJoin(innerCondition);
        if (selfJoinConstraint != null) {
            return this.buildSelfJoinForAll(ctx, group, innerCondition, selfJoinConstraint);
        }
        ArrayList<org.drools.core.rule.Pattern> remainingPatterns = new ArrayList<org.drools.core.rule.Pattern>();
        org.drools.core.rule.Pattern basePattern = (org.drools.core.rule.Pattern)this.conditionToElement(ctx, group, innerCondition.getSubConditions().get(0));
        for (int i = 1; i < innerCondition.getSubConditions().size(); ++i) {
            remainingPatterns.add((org.drools.core.rule.Pattern)this.conditionToElement(ctx, group, innerCondition.getSubConditions().get(i)));
        }
        return new Forall(basePattern, remainingPatterns);
    }

    private GroupElement buildSelfJoinForAll(RuleContext ctx, GroupElement group, Condition innerCondition, Constraint selfJoinConstraint) {
        PatternImpl forallPattern = (PatternImpl)innerCondition.getSubConditions().get(0);
        PatternImpl joinPattern = (PatternImpl)innerCondition.getSubConditions().get(1);
        GroupElement transformedForall = new GroupElement(GroupElement.Type.AND);
        transformedForall.addChild(new GroupElement(GroupElement.Type.EXISTS).addChild(this.conditionToElement(ctx, group, forallPattern)));
        joinPattern.getConstraint().getChildren().remove(selfJoinConstraint);
        forallPattern.addConstraint(joinPattern.negate().getConstraint().replaceVariable(joinPattern.getPatternVariable(), forallPattern.getPatternVariable()));
        transformedForall.addChild(new GroupElement(GroupElement.Type.NOT).addChild(this.conditionToElement(ctx, group, forallPattern)));
        return transformedForall;
    }

    private RuleConditionElement buildAccumulate(RuleContext ctx, GroupElement group, AccumulatePattern accumulatePattern) {
        RuleConditionElement source;
        boolean existingPattern;
        org.drools.core.rule.Pattern pattern = null;
        boolean isGroupBy = accumulatePattern instanceof GroupByPattern;
        if (accumulatePattern.getAccumulateFunctions() != null) {
            if (!isGroupBy && accumulatePattern.getAccumulateFunctions().length == 1) {
                pattern = ctx.getPattern(accumulatePattern.getAccumulateFunctions()[0].getResult());
            } else if (accumulatePattern.getAccumulateFunctions().length > 0 && ctx.getPattern(accumulatePattern.getAccumulateFunctions()[0].getResult()) != null) {
                throw new RuntimeException("Only single accumulate functions, with no group by can optimize the result pattern to be the function return value");
            }
        }
        boolean bl = existingPattern = pattern != null;
        if (!existingPattern) {
            ObjectType type = !isGroupBy && accumulatePattern.getAccumulateFunctions().length == 1 ? new ClassObjectType(accumulatePattern.getAccumulateFunctions()[0].getResult().getType()) : JAVA_CLASS_ARRAY_TYPE;
            pattern = new org.drools.core.rule.Pattern(ctx.getNextPatternIndex(), type);
        }
        PatternImpl sourcePattern = (PatternImpl)accumulatePattern.getPattern();
        LinkedHashSet<String> usedVariableName = new LinkedHashSet<String>();
        if (sourcePattern != null) {
            for (Variable v : sourcePattern.getInputVariables()) {
                usedVariableName.add(v.getName());
            }
        }
        if (accumulatePattern.isQuerySource()) {
            source = this.buildQueryPattern(ctx, (QueryCallPattern)accumulatePattern.getCondition());
        } else if (accumulatePattern.isCompositePatterns()) {
            CompositePatterns compositePatterns = (CompositePatterns)accumulatePattern.getCondition();
            GroupElement allSubConditions = new GroupElement(KiePackagesBuilder.conditionToGroupElementType(compositePatterns.getType()));
            for (Condition c : compositePatterns.getSubConditions()) {
                this.recursivelyAddConditions(ctx, group, allSubConditions, c);
            }
            source = allSubConditions.getChildren().size() == 1 ? allSubConditions.getChildren().get(0) : allSubConditions;
        } else {
            source = this.buildPattern(ctx, group, accumulatePattern);
        }
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        if (sourcePattern != null) {
            bindings.addAll(sourcePattern.getBindings());
            bindings.add(new SelfPatternBiding(sourcePattern.getPatternVariable()));
        } else {
            this.addInnerBindings(bindings, accumulatePattern.getAccumulateFunctions(), accumulatePattern.getCondition());
        }
        pattern.setSource(this.buildAccumulate(ctx, accumulatePattern, source, pattern, usedVariableName, bindings));
        return existingPattern ? null : pattern;
    }

    private void addInnerBindings(Collection<Binding> bindings, org.drools.model.functions.accumulate.AccumulateFunction[] accumulateFunctions, Condition condition) {
        List functionArgList = Arrays.stream(accumulateFunctions).map(function -> function.getSource()).filter(Declaration.class::isInstance).map(Declaration.class::cast).collect(Collectors.toList());
        if (condition instanceof CompositePatterns) {
            CompositePatterns compositePatterns = (CompositePatterns)condition;
            for (Condition c : compositePatterns.getSubConditions()) {
                Variable<?>[] boundVariables = c.getBoundVariables();
                Arrays.stream(boundVariables).filter(Declaration.class::isInstance).map(Declaration.class::cast).filter(decl -> functionArgList.contains(decl)).forEach(decl -> bindings.add(new SelfPatternBiding(decl)));
            }
        }
    }

    private Constraint getForallSelfJoin(Condition condition) {
        if (condition instanceof CompositePatterns && condition.getSubConditions().size() == 2 && condition.getSubConditions().get(0) instanceof PatternImpl && condition.getSubConditions().get(1) instanceof PatternImpl) {
            PatternImpl joinPattern = (PatternImpl)condition.getSubConditions().get(1);
            for (Constraint constraint : joinPattern.getConstraint().getChildren()) {
                Index index;
                if (!(constraint instanceof AbstractSingleConstraint) || (index = ((AbstractSingleConstraint)constraint).getIndex()) == null || index.getConstraintType() != Index.ConstraintType.FORALL_SELF_JOIN) continue;
                return constraint;
            }
        }
        return null;
    }

    private void recursivelyAddConditions(RuleContext ctx, GroupElement group, GroupElement allSubConditions, Condition c) {
        if (c instanceof CompositePatterns) {
            c.getSubConditions().forEach(sc -> this.recursivelyAddConditions(ctx, group, allSubConditions, (Condition)sc));
        } else if (c instanceof ExistentialPatternImpl) {
            if (c.getType() == Condition.Type.FORALL) {
                allSubConditions.addChild(this.buildForAll(ctx, allSubConditions, c));
            } else {
                GroupElement existGroupElement = new GroupElement(KiePackagesBuilder.conditionToGroupElementType(c.getType()));
                allSubConditions.addChild(existGroupElement);
                this.recursivelyAddConditions(ctx, existGroupElement, existGroupElement, c.getSubConditions().iterator().next());
            }
        } else if (c instanceof PatternImpl) {
            Pattern pattern = (Pattern)c;
            RuleConditionElement rce = this.buildPattern(ctx, allSubConditions, pattern);
            if (ctx.getAccumulateSource(pattern.getPatternVariable()) == null) {
                allSubConditions.addChild(rce);
            }
        } else if (c instanceof AccumulatePattern) {
            RuleConditionElement rce = this.buildAccumulate(ctx, group, (AccumulatePattern)c);
            if (rce != null) {
                allSubConditions.addChild(rce);
            }
        } else if (c instanceof EvalImpl) {
            allSubConditions.addChild(this.buildEval(ctx, (EvalImpl)c));
        }
    }

    private EvalCondition buildEval(RuleContext ctx, EvalImpl eval) {
        org.drools.core.rule.Declaration[] declarations = (org.drools.core.rule.Declaration[])Stream.of(eval.getExpr().getVariables()).map(ctx::getDeclaration).toArray(org.drools.core.rule.Declaration[]::new);
        LambdaEvalExpression evalExpr = new LambdaEvalExpression(declarations, eval.getExpr());
        return new EvalCondition(evalExpr, declarations);
    }

    private ConditionalBranch buildConditionalConsequence(RuleContext ctx, ConditionalNamedConsequenceImpl consequence) {
        EvalCondition evalCondition;
        if (consequence.getExpr() != null) {
            org.drools.core.rule.Pattern pattern = ctx.getPattern(consequence.getExpr().getVariables()[0]);
            if (pattern.getDeclaration() != null) {
                LambdaEvalExpression eval = new LambdaEvalExpression(pattern, consequence.getExpr());
                evalCondition = new EvalCondition(eval, new org.drools.core.rule.Declaration[]{pattern.getDeclaration()});
            } else {
                org.drools.core.rule.Declaration[] declarations = pattern.getDeclarations().values().toArray(new org.drools.core.rule.Declaration[pattern.getDeclarations().size()]);
                LambdaEvalExpression eval = new LambdaEvalExpression(declarations, consequence.getExpr());
                evalCondition = new EvalCondition(eval, declarations);
            }
        } else {
            evalCondition = new EvalCondition(LambdaEvalExpression.EMPTY, null);
        }
        return new ConditionalBranch(evalCondition, new NamedConsequence(consequence.getThenConsequence().getName(), consequence.getThenConsequence().isBreaking()), consequence.getElseBranch() != null ? this.buildConditionalConsequence(ctx, consequence.getElseBranch()) : null);
    }

    private RuleConditionElement addSubConditions(RuleContext ctx, GroupElement ge, List<Condition> subconditions) {
        if (ge.getType() == GroupElement.OR) {
            ctx.startOrCondition();
        }
        for (int i = 0; i < subconditions.size(); ++i) {
            RuleConditionElement element = this.conditionToElement(ctx, ge, subconditions.get(i));
            if (element == null) continue;
            ge.addChild(element);
        }
        if (ge.getType() == GroupElement.OR) {
            ctx.endOrCondition();
        }
        if (ge.getType() == GroupElement.AND && ge.getChildren().size() == 1) {
            return ge.getChildren().get(0);
        }
        return ge;
    }

    private RuleConditionElement buildQueryPattern(RuleContext ctx, QueryCallPattern queryPattern) {
        org.drools.core.rule.Pattern pattern = new org.drools.core.rule.Pattern(ctx.getNextPatternIndex(), 0, 0, ClassObjectType.ObjectArray_ObjectType, null);
        QueryArgument[] arguments = new QueryArgument[queryPattern.getArguments().length];
        ArrayList<Integer> varIndexList = new ArrayList<Integer>();
        ArrayList<org.drools.core.rule.Declaration> requiredDeclarations = new ArrayList<org.drools.core.rule.Declaration>();
        for (int i2 = 0; i2 < queryPattern.getArguments().length; ++i2) {
            Argument<?> arg = queryPattern.getArguments()[i2];
            if (arg instanceof Variable) {
                Variable var = (Variable)arg;
                org.drools.core.rule.Declaration decl = ctx.getDeclaration(var);
                if (decl != null) {
                    requiredDeclarations.add(decl);
                    arguments[i2] = new QueryArgument.Declr(decl);
                    continue;
                }
                ArrayElementReader reader = new ArrayElementReader(new SelfReferenceClassFieldReader(Object[].class), i2, arg.getType());
                org.drools.core.rule.Declaration varDeclaration = pattern.addDeclaration(var.getName());
                varDeclaration.setReadAccessor(reader);
                ctx.addDeclaration(var, varDeclaration);
                arguments[i2] = QueryArgument.VAR;
                varIndexList.add(i2);
                continue;
            }
            if (arg instanceof Value) {
                arguments[i2] = new QueryArgument.Literal(((Value)arg).getValue());
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return new QueryElement(pattern, queryPattern.getQuery().getName(), arguments, varIndexList.stream().mapToInt(i -> i).toArray(), requiredDeclarations.toArray(new org.drools.core.rule.Declaration[requiredDeclarations.size()]), queryPattern.isOpen(), false);
    }

    private RuleConditionElement buildPattern(RuleContext ctx, GroupElement group, Pattern<?> modelPattern) {
        Variable<?> patternVariable = modelPattern.getPatternVariable();
        org.drools.core.rule.Pattern pattern = this.addPatternForVariable(ctx, group, patternVariable, modelPattern.getType());
        Arrays.stream(modelPattern.getWatchedProps()).forEach(pattern::addWatchedProperty);
        pattern.setPassive(modelPattern.isPassive());
        for (Binding binding : modelPattern.getBindings()) {
            Function1 f1 = this.getBindingFunction(ctx, patternVariable, binding);
            org.drools.core.rule.Declaration declaration = new org.drools.core.rule.Declaration(binding.getBoundVariable().getName(), new LambdaReadAccessor(binding.getBoundVariable().getType(), f1), pattern, true);
            pattern.addDeclaration(declaration);
            if (binding.getReactOn() != null) {
                Arrays.stream(binding.getReactOn()).forEach(pattern::addBoundProperty);
            }
            ctx.addDeclaration(binding.getBoundVariable(), declaration);
        }
        org.drools.core.rule.Declaration queryArgDecl = ctx.getQueryDeclaration(patternVariable);
        if (queryArgDecl != null) {
            pattern.addConstraint(new UnificationConstraint(queryArgDecl));
        }
        this.addConstraintsToPattern(ctx, pattern, modelPattern.getConstraint());
        this.addReactiveMasksToPattern(pattern, modelPattern.getPatternClassMetadata());
        return pattern;
    }

    private Function1 getBindingFunction(RuleContext ctx, Variable patternVariable, Binding binding) {
        org.drools.core.rule.Declaration declr = ctx.getDeclaration(patternVariable);
        if (!declr.isPatternDeclaration()) {
            ReadAccessor reader = declr.getExtractor();
            return o -> binding.getBindingFunction().apply(reader.getValue(o));
        }
        return binding.getBindingFunction();
    }

    private void addReactiveMasksToPattern(org.drools.core.rule.Pattern pattern, DomainClassMetadata patternMetadata) {
        if (pattern.getListenedProperties() != null && patternMetadata != null) {
            String[] listenedProperties = pattern.getListenedProperties().toArray(new String[pattern.getListenedProperties().size()]);
            pattern.setPositiveWatchMask(EvaluationUtil.adaptBitMask(BitMaskUtil.calculatePatternMask(patternMetadata, true, listenedProperties)));
            pattern.setNegativeWatchMask(EvaluationUtil.adaptBitMask(BitMaskUtil.calculatePatternMask(patternMetadata, false, listenedProperties)));
        }
    }

    private Accumulate buildAccumulate(RuleContext ctx, AccumulatePattern accPattern, RuleConditionElement source, org.drools.core.rule.Pattern pattern, Set<String> usedVariableName, Collection<Binding> bindings) {
        Accumulate accumulate;
        boolean isGroupBy = accPattern instanceof GroupByPattern;
        org.drools.model.functions.accumulate.AccumulateFunction[] accFunctions = accPattern.getAccumulateFunctions();
        org.drools.core.rule.Declaration groupByDeclaration = null;
        Class<Object[]> selfType = isGroupBy || accFunctions.length > 1 ? Object[].class : accFunctions[0].getResult().getType();
        SelfReferenceClassFieldReader selfReader = new SelfReferenceClassFieldReader(selfType);
        int arrayIndexOffset = 0;
        if (isGroupBy) {
            if (accFunctions.length == 0) {
                accFunctions = new org.drools.model.functions.accumulate.AccumulateFunction[]{new org.drools.model.functions.accumulate.AccumulateFunction(null, CountAccumulateFunction::new)};
                arrayIndexOffset = 1;
            }
            Variable groupVar = ((GroupByPattern)accPattern).getVarKey();
            groupByDeclaration = new org.drools.core.rule.Declaration(groupVar.getName(), new ArrayElementReader(selfReader, accFunctions.length, groupVar.getType()), pattern, true);
            pattern.addDeclaration(groupByDeclaration);
        }
        Accumulator[] accumulators = new Accumulator[accFunctions.length];
        ArrayList<org.drools.core.rule.Declaration> requiredDeclarationList = new ArrayList<org.drools.core.rule.Declaration>();
        for (int i = 0; i < accFunctions.length; ++i) {
            Variable boundVar = this.processFunctions(ctx, accPattern, source, pattern, usedVariableName, bindings, isGroupBy, accFunctions[i], selfReader, accumulators, requiredDeclarationList, arrayIndexOffset, i);
            if (!isGroupBy) continue;
            ctx.addGroupByDeclaration(((GroupByPattern)accPattern).getVarKey(), groupByDeclaration);
        }
        if (accFunctions.length == 1) {
            accumulate = new SingleAccumulate(source, requiredDeclarationList.toArray(new org.drools.core.rule.Declaration[requiredDeclarationList.size()]), accumulators[0]);
        } else {
            if (source instanceof org.drools.core.rule.Pattern) {
                requiredDeclarationList.forEach(((org.drools.core.rule.Pattern)source)::addDeclaration);
            }
            accumulate = new MultiAccumulate(source, new org.drools.core.rule.Declaration[]{}, accumulators, accumulators.length + (isGroupBy ? 1 : 0));
        }
        if (isGroupBy) {
            GroupByPatternImpl groupBy = (GroupByPatternImpl)accPattern;
            org.drools.core.rule.Declaration[] groupingDeclarations = new org.drools.core.rule.Declaration[groupBy.getVars().length];
            for (int i = 0; i < groupBy.getVars().length; ++i) {
                groupingDeclarations[i] = ctx.getDeclaration(groupBy.getVars()[i]);
            }
            accumulate = new LambdaGroupByAccumulate(accumulate, groupingDeclarations, groupBy.getGroupingFunction());
        }
        for (Variable<?> boundVar : accPattern.getBoundVariables()) {
            ctx.addAccumulateSource(boundVar, accumulate);
        }
        return accumulate;
    }

    private Variable processFunctions(RuleContext ctx, AccumulatePattern accPattern, RuleConditionElement source, org.drools.core.rule.Pattern pattern, Set<String> usedVariableName, Collection<Binding> bindings, boolean isGroupBy, org.drools.model.functions.accumulate.AccumulateFunction accFunction, ReadAccessor selfReader, Accumulator[] accumulators, List<org.drools.core.rule.Declaration> requiredDeclarationList, int arrayIndexOffset, int i) {
        Binding binding = this.findBindingForAccumulate(bindings, accFunction);
        if (binding != null) {
            for (Variable var : binding.getInputVariables()) {
                usedVariableName.add(var.getName());
            }
        }
        BindingEvaluator bindingEvaluator = this.createBindingEvaluator(ctx, binding);
        Accumulator accumulator = this.createAccumulator(usedVariableName, bindingEvaluator, accFunction);
        Variable<?> boundVar = accPattern.getBoundVariables()[i];
        org.drools.core.rule.Declaration declaration = !isGroupBy && accumulators.length == 1 ? new org.drools.core.rule.Declaration(boundVar.getName(), new PatternExtractor(new ClassObjectType(boundVar.getType())), pattern, true) : new org.drools.core.rule.Declaration(boundVar.getName(), new ArrayElementReader(selfReader, i + arrayIndexOffset, boundVar.getType()), pattern, true);
        pattern.addDeclaration(declaration);
        ctx.addDeclaration(boundVar, declaration);
        accumulators[i] = accumulator;
        org.drools.core.rule.Declaration[] requiredDeclarations = this.getRequiredDeclarationsForAccumulate(ctx, source, accFunction, binding, bindingEvaluator);
        requiredDeclarationList.addAll(Arrays.asList(requiredDeclarations));
        return boundVar;
    }

    private Binding findBindingForAccumulate(Collection<Binding> bindings, org.drools.model.functions.accumulate.AccumulateFunction accFunction) {
        return bindings.stream().filter(b -> b.getBoundVariable() == accFunction.getSource()).findFirst().orElse(null);
    }

    private org.drools.core.rule.Declaration[] getRequiredDeclarationsForAccumulate(RuleContext ctx, RuleConditionElement source, org.drools.model.functions.accumulate.AccumulateFunction accFunction, Binding binding, BindingEvaluator bindingEvaluator) {
        org.drools.core.rule.Declaration[] requiredDeclarations = this.getRequiredDeclarationsForAccumulate(ctx, binding, accFunction);
        if (requiredDeclarations.length == 0 && source instanceof org.drools.core.rule.Pattern && bindingEvaluator != null && bindingEvaluator.getDeclarations() != null) {
            ArrayList<org.drools.core.rule.Declaration> previousDecl = new ArrayList<org.drools.core.rule.Declaration>();
            org.drools.core.rule.Pattern patternSource = (org.drools.core.rule.Pattern)source;
            patternSource.resetDeclarations();
            for (org.drools.core.rule.Declaration d : bindingEvaluator.getDeclarations()) {
                if (d.getIdentifier().equals(patternSource.getDeclaration().getIdentifier())) {
                    patternSource.addDeclaration(d);
                    continue;
                }
                previousDecl.add(d);
            }
            requiredDeclarations = previousDecl.toArray(new org.drools.core.rule.Declaration[previousDecl.size()]);
        }
        return requiredDeclarations;
    }

    private org.drools.core.rule.Declaration[] getRequiredDeclarationsForAccumulate(RuleContext ctx, Binding binding, org.drools.model.functions.accumulate.AccumulateFunction accFunction) {
        if (binding != null || accFunction.getSource() == null) {
            if (accFunction.getExternalVars() != null) {
                Variable[] extVars = accFunction.getExternalVars();
                org.drools.core.rule.Declaration[] bindingDeclaration = new org.drools.core.rule.Declaration[extVars.length];
                for (int i = 0; i < extVars.length; ++i) {
                    bindingDeclaration[i] = ctx.getDeclaration(extVars[i]);
                }
                return bindingDeclaration;
            }
            return new org.drools.core.rule.Declaration[0];
        }
        if (accFunction.getSource() instanceof Variable) {
            org.drools.core.rule.Declaration[] declarationArray;
            org.drools.core.rule.Pattern pattern = ctx.getPattern((Variable)accFunction.getSource());
            if (pattern == null || pattern.getDeclaration() == null) {
                declarationArray = new org.drools.core.rule.Declaration[]{};
            } else {
                org.drools.core.rule.Declaration[] declarationArray2 = new org.drools.core.rule.Declaration[1];
                declarationArray = declarationArray2;
                declarationArray2[0] = pattern.getDeclaration();
            }
            return declarationArray;
        }
        return new org.drools.core.rule.Declaration[0];
    }

    private BindingEvaluator createBindingEvaluator(RuleContext ctx, Binding binding) {
        if (binding == null) {
            return null;
        }
        Variable[] inputs = binding.getInputVariables();
        if (inputs.length == 1) {
            return new BindingInnerObjectEvaluator(binding);
        }
        org.drools.core.rule.Declaration[] declarations = new org.drools.core.rule.Declaration[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            declarations[i] = ctx.getDeclaration(inputs[i]);
        }
        return new BindingEvaluator(declarations, binding);
    }

    private Accumulator createAccumulator(Collection<String> usedVariableName, BindingEvaluator binding, org.drools.model.functions.accumulate.AccumulateFunction accFunction) {
        Object functionObject = accFunction.createFunctionObject();
        if (accFunction.isFixedValue()) {
            return new LambdaAccumulator.FixedValueAcc((AccumulateFunction)functionObject, ((Value)accFunction.getSource()).getValue());
        }
        if (functionObject instanceof AccumulateFunction) {
            return this.createLambdaAccumulator(usedVariableName, binding, (AccumulateFunction)functionObject);
        }
        if (functionObject instanceof Accumulator) {
            return (Accumulator)functionObject;
        }
        throw new RuntimeException("Unknown functionClass" + functionObject.getClass().getCanonicalName());
    }

    private Accumulator createLambdaAccumulator(Collection<String> usedVariableName, BindingEvaluator binding, AccumulateFunction function) {
        if (binding == null) {
            return new LambdaAccumulator.NotBindingAcc(function);
        }
        return new LambdaAccumulator.BindingAcc(function, usedVariableName, binding);
    }

    private org.drools.core.rule.Pattern addPatternForVariable(RuleContext ctx, GroupElement group, Variable patternVariable, Condition.Type type) {
        Accumulate accSource;
        Declaration decl;
        org.drools.core.rule.Pattern pattern = null;
        if (patternVariable instanceof Declaration && (decl = (Declaration)patternVariable).getSource() == null && (accSource = ctx.getAccumulateSource(patternVariable)) != null) {
            for (RuleConditionElement element : group.getChildren()) {
                if (!(element instanceof org.drools.core.rule.Pattern) || ((org.drools.core.rule.Pattern)element).getSource() != accSource) continue;
                pattern = (org.drools.core.rule.Pattern)element;
                break;
            }
        }
        PatternSource priorSource = null;
        if (pattern != null && type == Condition.Type.ACCUMULATE && pattern.getSource() instanceof SingleAccumulate) {
            group.getChildren().remove(pattern);
            priorSource = pattern.getSource();
            pattern = null;
        }
        if (pattern == null) {
            pattern = new org.drools.core.rule.Pattern(ctx.getNextPatternIndex(), 0, 0, this.getObjectType(patternVariable), patternVariable.getName(), true);
            pattern.setSource(priorSource);
        }
        if (patternVariable instanceof Declaration) {
            Declaration decl2 = (Declaration)patternVariable;
            if (decl2.getSource() != null) {
                if (decl2.getSource() instanceof EntryPoint) {
                    pattern.setSource(new EntryPointId(((EntryPoint)decl2.getSource()).getName()));
                } else if (decl2.getSource() instanceof WindowReference) {
                    WindowReference window = (WindowReference)decl2.getSource();
                    if (!ctx.getPkg().getWindowDeclarations().containsKey(window.getName())) {
                        this.createWindowReference(ctx, window);
                    }
                    pattern.setSource(new org.drools.core.rule.WindowReference(window.getName()));
                } else if (decl2.getSource() instanceof From) {
                    pattern.setSource(this.buildFrom(ctx, pattern, (From)decl2.getSource()));
                } else if (decl2.getSource() instanceof UnitData) {
                    UnitData unitData = (UnitData)decl2.getSource();
                    pattern.setSource(new EntryPointId(ctx.getRule().getRuleUnitClassName() + "." + unitData.getName()));
                } else {
                    throw new UnsupportedOperationException("Unknown source: " + decl2.getSource());
                }
            }
            if (decl2.getWindow() != null) {
                pattern.addBehavior(this.createWindow(decl2.getWindow()));
                ctx.setNeedStreamMode();
            }
        } else if (patternVariable instanceof Exchange) {
            if (type == Condition.Type.SENDER) {
                Function0 supplier = ((Exchange)patternVariable).getMessageSupplier();
                LambdaDataProvider provider = new LambdaDataProvider(x -> supplier.apply(), false, new org.drools.core.rule.Declaration[0]);
                pattern.setSource(new AsyncSend(pattern, patternVariable.getName(), provider));
            } else if (type == Condition.Type.RECEIVER) {
                pattern.setSource(new AsyncReceive(pattern, patternVariable.getName()));
            } else {
                throw new UnsupportedOperationException();
            }
        }
        ctx.registerPattern(patternVariable, pattern);
        return pattern;
    }

    private org.drools.core.rule.From buildFrom(RuleContext ctx, org.drools.core.rule.Pattern pattern, From<?> from) {
        DataProvider provider = this.createFromDataProvider(ctx, from);
        org.drools.core.rule.From fromSource = new org.drools.core.rule.From(provider);
        fromSource.setResultPattern(pattern);
        return fromSource;
    }

    private DataProvider createFromDataProvider(RuleContext ctx, From<?> from) {
        if (from instanceof From0) {
            return new LambdaDataProvider(FunctionUtils.toFunctionN(((From0)from).getProvider()), from.isReactive(), new org.drools.core.rule.Declaration[0]);
        }
        if (from instanceof From1) {
            return new LambdaDataProvider(FunctionUtils.toFunctionN(((From1)from).getProvider()), from.isReactive(), ctx.getDeclaration(from.getVariable()));
        }
        if (from instanceof From2) {
            return new LambdaDataProvider(FunctionUtils.toFunctionN(((From2)from).getProvider()), from.isReactive(), ctx.getDeclaration(from.getVariable()), ctx.getDeclaration(((From2)from).getVariable2()));
        }
        if (from instanceof From3) {
            return new LambdaDataProvider(FunctionUtils.toFunctionN(((From3)from).getProvider()), from.isReactive(), ctx.getDeclaration(from.getVariable()), ctx.getDeclaration(((From3)from).getVariable2()), ctx.getDeclaration(((From3)from).getVariable3()));
        }
        if (from instanceof From4) {
            return new LambdaDataProvider(FunctionUtils.toFunctionN(((From4)from).getProvider()), from.isReactive(), ctx.getDeclaration(from.getVariable()), ctx.getDeclaration(((From4)from).getVariable2()), ctx.getDeclaration(((From4)from).getVariable3()), ctx.getDeclaration(((From4)from).getVariable4()));
        }
        throw new UnsupportedOperationException("Unknown from type " + from);
    }

    private <T> void createWindowReference(RuleContext ctx, WindowReference<T> window) {
        WindowDeclaration windowDeclaration = new WindowDeclaration(window.getName(), ctx.getPkg().getName());
        Declaration<T> variable = DSL.declarationOf(window.getPatternType());
        org.drools.core.rule.Pattern windowPattern = new org.drools.core.rule.Pattern(ctx.getNextPatternIndex(), this.getClassObjectType(window.getPatternType()), variable.getName());
        windowDeclaration.setPattern(windowPattern);
        if (window.getEntryPoint() != null) {
            windowPattern.setSource(new EntryPointId(window.getEntryPoint().getName()));
        }
        for (Predicate1<T> predicate : window.getPredicates()) {
            SingleConstraint1<T> singleConstraint = new SingleConstraint1<T>(NamesGenerator.generateName("expr"), variable, predicate);
            ConstraintEvaluator constraintEvaluator = new ConstraintEvaluator(windowPattern, singleConstraint);
            windowPattern.addConstraint(new LambdaConstraint(constraintEvaluator, singleConstraint.predicateInformation()));
        }
        windowPattern.addBehavior(this.createWindow(window));
        ctx.getPkg().addWindowDeclaration(windowDeclaration);
    }

    private Behavior createWindow(WindowDefinition window) {
        switch (window.getType()) {
            case LENGTH: {
                return new SlidingLengthWindow((int)window.getValue());
            }
            case TIME: {
                return new SlidingTimeWindow(window.getValue());
            }
        }
        throw new IllegalArgumentException("Unknown window type: " + window.getType());
    }

    private void addConstraintsToPattern(RuleContext ctx, org.drools.core.rule.Pattern pattern, Constraint constraint) {
        if (constraint.getType() == Constraint.Type.MULTIPLE) {
            for (Constraint child : constraint.getChildren()) {
                this.addConstraintsToPattern(ctx, pattern, child);
            }
            return;
        }
        this.createConstraint(ctx, pattern, constraint).ifPresent(pattern::addConstraint);
    }

    private Optional<org.drools.core.rule.constraint.Constraint> createConstraint(RuleContext ctx, org.drools.core.rule.Pattern pattern, Constraint constraint) {
        if (constraint.getType() == Constraint.Type.SINGLE) {
            SingleConstraint singleConstraint = (SingleConstraint)constraint;
            if (singleConstraint.getVariables().length > 0 || singleConstraint.equals(SingleConstraint.FALSE)) {
                return Optional.of(this.createSingleConstraint(ctx, pattern, singleConstraint));
            }
            return Optional.empty();
        }
        List<AbstractConstraint> constraints = constraint.getChildren().stream().map(child -> this.createConstraint(ctx, pattern, (Constraint)child)).filter(Optional::isPresent).map(Optional::get).map(AbstractConstraint.class::cast).collect(Collectors.toList());
        return Optional.of(new CombinedConstraint(constraint.getType(), constraints));
    }

    private org.drools.core.rule.constraint.Constraint createSingleConstraint(RuleContext ctx, org.drools.core.rule.Pattern pattern, SingleConstraint singleConstraint) {
        Variable[] vars = singleConstraint.getVariables();
        org.drools.core.rule.Declaration[] declarations = new org.drools.core.rule.Declaration[vars.length];
        org.drools.core.rule.Declaration unificationDeclaration = this.collectConstraintDeclarations(ctx, pattern, singleConstraint, vars, declarations);
        ConstraintEvaluator constraintEvaluator = singleConstraint.isTemporal() ? new TemporalConstraintEvaluator(declarations, pattern, singleConstraint) : new ConstraintEvaluator(declarations, pattern, singleConstraint);
        return unificationDeclaration != null ? new UnificationConstraint(unificationDeclaration, constraintEvaluator) : new LambdaConstraint(constraintEvaluator, singleConstraint.predicateInformation());
    }

    private org.drools.core.rule.Declaration collectConstraintDeclarations(RuleContext ctx, org.drools.core.rule.Pattern pattern, SingleConstraint singleConstraint, Variable[] vars, org.drools.core.rule.Declaration[] declarations) {
        org.drools.core.rule.Declaration unificationDeclaration = null;
        boolean isEqual = singleConstraint.getIndex() != null && singleConstraint.getIndex().getConstraintType() == Index.ConstraintType.EQUAL;
        for (int i = 0; i < vars.length; ++i) {
            org.drools.core.rule.Declaration accDeclaration;
            declarations[i] = ctx.getDeclaration(vars[i]);
            if (isEqual && declarations[i].getPattern().getObjectType().equals(ClassObjectType.DroolsQuery_ObjectType)) {
                unificationDeclaration = declarations[i];
                continue;
            }
            if (!(pattern.getSource() instanceof MultiAccumulate) || (accDeclaration = pattern.getDeclarations().get(declarations[i].getBindingName())) == null) continue;
            declarations[i].setReadAccessor(accDeclaration.getExtractor());
        }
        return unificationDeclaration;
    }

    Collection<InternalKnowledgePackage> getKiePackages() {
        return this.packages.values();
    }

    ObjectType getObjectType(Variable patternVariable) {
        return patternVariable instanceof PrototypeVariable ? this.getPrototypeObjectType(((PrototypeVariable)patternVariable).getPrototype()) : this.getClassObjectType(patternVariable.getType());
    }

    private ObjectType getPrototypeObjectType(Prototype prototype) {
        return this.objectTypeCache.computeIfAbsent(prototype.getFullName(), name -> {
            KnowledgePackageImpl pkg = (KnowledgePackageImpl)this.packages.computeIfAbsent(prototype.getPackage(), this::createKiePackage);
            FactTemplateObjectType objectType = new FactTemplateObjectType(FactFactory.prototypeToFactTemplate(prototype, pkg));
            objectType.setEvent(prototype.isEvent());
            return objectType;
        });
    }

    private ObjectType getClassObjectType(Class<?> patternClass) {
        return this.objectTypeCache.computeIfAbsent(patternClass.getCanonicalName(), name -> {
            boolean isEvent = false;
            if (!(patternClass.getPackage() == null || patternClass.isPrimitive() || name.startsWith("java.lang") && !this.packages.containsKey(patternClass.getPackage().getName()))) {
                KnowledgePackageImpl pkg = (KnowledgePackageImpl)this.packages.computeIfAbsent(patternClass.getPackage().getName(), this::createKiePackage);
                TypeDeclaration typeDeclaration = pkg.getExactTypeDeclaration(patternClass);
                if (typeDeclaration == null) {
                    typeDeclaration = TypeDeclarationUtil.createTypeDeclaration(patternClass, this.getPropertySpecificOption());
                    pkg.addTypeDeclaration(typeDeclaration);
                }
                isEvent = typeDeclaration.getRole() == Role.Type.EVENT;
            }
            return new ClassObjectType(patternClass, isEvent);
        });
    }

    private PropertySpecificOption getPropertySpecificOption() {
        return this.builderConf != null ? this.builderConf.getOption(PropertySpecificOption.KEY) : PropertySpecificOption.ALWAYS;
    }

    private static GroupElement.Type conditionToGroupElementType(Condition.Type type) {
        switch (type) {
            case AND: {
                return GroupElement.Type.AND;
            }
            case OR: {
                return GroupElement.Type.OR;
            }
            case EXISTS: {
                return GroupElement.Type.EXISTS;
            }
            case NOT: {
                return GroupElement.Type.NOT;
            }
        }
        throw new UnsupportedOperationException();
    }
}

