/*
 * Decompiled with CFR 0.152.
 */
package org.drools.modelcompiler;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.compiler.builder.InternalKnowledgeBuilder;
import org.drools.compiler.builder.impl.CompositeKnowledgeBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieBaseUpdaterImpl;
import org.drools.compiler.kie.builder.impl.KieBaseUpdaterImplContext;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.KieBaseUpdate;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.rule.Function;
import org.drools.core.rule.TypeDeclaration;
import org.drools.modelcompiler.CanonicalKieModule;
import org.drools.modelcompiler.CanonicalKiePackages;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.rule.Rule;
import org.kie.internal.builder.ChangeType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResourceChangeSet;

public class CanonicalKieBaseUpdater
extends KieBaseUpdaterImpl {
    public CanonicalKieBaseUpdater(KieBaseUpdaterImplContext ctx) {
        super(ctx);
    }

    @Override
    public void run() {
        ArrayList<RuleImpl> rulesToBeAdded;
        ArrayList<RuleImpl> rulesToBeRemoved;
        CanonicalKieModule oldKM = (CanonicalKieModule)this.ctx.currentKM;
        CanonicalKieModule newKM = (CanonicalKieModule)this.ctx.newKM;
        HashMap<String, AtomicInteger> globalsCounter = new HashMap<String, AtomicInteger>();
        newKM.setIncrementalUpdate(true);
        CanonicalKiePackages newPkgs = newKM.getKiePackages(this.ctx.newKieBaseModel);
        InternalKnowledgeBuilder pkgbuilder = this.ctx.kbuilder;
        CompositeKnowledgeBuilder ckbuilder = pkgbuilder.batch();
        newKM.setIncrementalUpdate(false);
        this.removeResources(pkgbuilder);
        if (this.ctx.modifyingUsedClass) {
            for (Class<?> cls : this.ctx.modifiedClasses) {
                this.clearInstancesOfModifiedClass(cls);
            }
            for (InternalKnowledgePackage kpkg : this.ctx.kBase.getPackagesMap().values()) {
                ArrayList<TypeDeclaration> types = new ArrayList<TypeDeclaration>(kpkg.getTypeDeclarations().values());
                for (TypeDeclaration type : types) {
                    kpkg.removeTypeDeclaration(type.getTypeName());
                    kpkg.addTypeDeclaration(((InternalKnowledgePackage)newPkgs.getKiePackage(kpkg.getName())).getTypeDeclaration(type.getTypeName()));
                }
            }
            rulesToBeRemoved = this.getAllRulesInKieBase(oldKM, this.ctx.currentKieBaseModel);
            rulesToBeAdded = this.getAllRulesInKieBase(newKM, this.ctx.newKieBaseModel);
        } else {
            this.ctx.kBase.processAllTypesDeclaration(newPkgs.getKiePackages());
            rulesToBeRemoved = new ArrayList();
            rulesToBeAdded = new ArrayList();
            for (ResourceChangeSet changeSet : this.ctx.cs.getChanges().values()) {
                if (!CanonicalKieBaseUpdater.isPackageInKieBase(this.ctx.newKieBaseModel, changeSet.getResourceName())) continue;
                InternalKnowledgePackage kpkg = (InternalKnowledgePackage)newPkgs.getKiePackage(changeSet.getResourceName());
                InternalKnowledgePackage oldKpkg = this.ctx.kBase.getPackage(changeSet.getResourceName());
                if (oldKpkg == null) {
                    try {
                        oldKpkg = (InternalKnowledgePackage)this.ctx.kBase.addPackage(CoreComponentFactory.get().createKnowledgePackage(changeSet.getResourceName())).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (kpkg != null) {
                    for (Rule newRule : kpkg.getRules()) {
                        RuleImpl rule = oldKpkg.getRule(newRule.getName());
                        if (rule == null) continue;
                        rule.setLoadOrder(((RuleImpl)newRule).getLoadOrder());
                    }
                }
                this.updateResource(pkgbuilder, ckbuilder, changeSet);
                block19: for (ResourceChange change : changeSet.getChanges()) {
                    String changedItemName = change.getName();
                    if (change.getChangeType() == ChangeType.UPDATED || change.getChangeType() == ChangeType.REMOVED) {
                        switch (change.getType()) {
                            case GLOBAL: {
                                oldKpkg.removeGlobal(changedItemName);
                                AtomicInteger globalCounter = (AtomicInteger)globalsCounter.get(changedItemName);
                                if (globalCounter != null && globalCounter.decrementAndGet() > 0) break;
                                this.ctx.kBase.removeGlobal(changedItemName);
                                break;
                            }
                            case RULE: {
                                RuleImpl removedRule = oldKpkg.getRule(changedItemName);
                                if (removedRule == null) break;
                                rulesToBeRemoved.add(removedRule);
                                oldKpkg.removeRule(removedRule);
                                break;
                            }
                            case DECLARATION: {
                                oldKpkg.removeTypeDeclaration(changedItemName);
                                break;
                            }
                            case FUNCTION: {
                                oldKpkg.removeFunction(changedItemName);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unsupported change type: " + change.getType() + "!");
                            }
                        }
                    }
                    if (kpkg == null || change.getChangeType() != ChangeType.UPDATED && change.getChangeType() != ChangeType.ADDED) continue;
                    switch (change.getType()) {
                        case GLOBAL: {
                            globalsCounter.computeIfAbsent(changedItemName, name -> this.ctx.kBase.getGlobals().get(name) == null ? new AtomicInteger(1) : new AtomicInteger(0)).incrementAndGet();
                            Type globalClass = kpkg.getGlobals().get(changedItemName);
                            oldKpkg.addGlobal(changedItemName, globalClass);
                            this.ctx.kBase.addGlobal(changedItemName, globalClass);
                            continue block19;
                        }
                        case RULE: {
                            RuleImpl addedRule = kpkg.getRule(changedItemName);
                            rulesToBeAdded.add(addedRule);
                            oldKpkg.addRule(addedRule);
                            continue block19;
                        }
                        case DECLARATION: {
                            TypeDeclaration addedType = kpkg.getTypeDeclaration(changedItemName);
                            oldKpkg.addTypeDeclaration(addedType);
                            continue block19;
                        }
                        case FUNCTION: {
                            Function addedFunction = kpkg.getFunctions().get(changedItemName);
                            oldKpkg.addFunction(addedFunction);
                            continue block19;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported change type: " + change.getType() + "!");
                }
            }
        }
        if (this.ctx.modifyingUsedClass) {
            this.invalidateAccessorForOldClass();
            this.updateAllResources(pkgbuilder, ckbuilder);
        }
        ((CompositeKnowledgeBuilderImpl)ckbuilder).build(false);
        KieBaseUpdate kieBaseUpdate = new KieBaseUpdate(rulesToBeRemoved, rulesToBeAdded);
        this.ctx.kBase.beforeIncrementalUpdate(kieBaseUpdate);
        this.ctx.kBase.removeRules(rulesToBeRemoved);
        this.ctx.kBase.addRules(rulesToBeAdded);
        this.ctx.kBase.afterIncrementalUpdate(kieBaseUpdate);
        for (InternalWorkingMemory wm : this.ctx.kBase.getWorkingMemories()) {
            wm.notifyWaitOnRest();
        }
    }

    private List<RuleImpl> getAllRulesInKieBase(CanonicalKieModule kieModule, KieBaseModelImpl model) {
        ArrayList<RuleImpl> rules = new ArrayList<RuleImpl>();
        for (KiePackage kiePackage : kieModule.getKiePackages(model).getKiePackages()) {
            if (!CanonicalKieBaseUpdater.isPackageInKieBase(this.ctx.currentKieBaseModel, kiePackage.getName())) continue;
            for (Rule oldRule : kiePackage.getRules()) {
                rules.add((RuleImpl)oldRule);
            }
        }
        return rules;
    }
}

