/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.drools.core.SessionConfiguration;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.AbstractRuntime;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.session.StatefulKnowledgeSessionImpl;
import org.drools.kiesession.session.StatefulSessionPool;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class StatelessKnowledgeSessionImpl
extends AbstractRuntime
implements StatelessKieSession {
    private InternalKnowledgeBase kBase;
    private MapGlobalResolver sessionGlobals = new MapGlobalResolver();
    private Map<String, Channel> channels = new HashMap<String, Channel>();
    private final List<ListnerHolder> listeners = new CopyOnWriteArrayList<ListnerHolder>();
    private SessionConfiguration conf;
    private Environment environment;
    private AtomicBoolean mbeanRegistered = new AtomicBoolean(false);
    private DroolsManagementAgent.CBSKey mbeanRegisteredCBSKey;
    private final AtomicLong wmCreated;
    private final StatefulSessionPool pool;

    public StatelessKnowledgeSessionImpl() {
        this.pool = null;
        this.wmCreated = new AtomicLong(0L);
    }

    public StatelessKnowledgeSessionImpl(InternalKnowledgeBase kBase, KieSessionConfiguration conf) {
        this.kBase = kBase;
        this.conf = conf != null ? conf.as(SessionConfiguration.KEY) : kBase.getSessionConfiguration().as(SessionConfiguration.KEY);
        this.environment = EnvironmentFactory.newEnvironment();
        this.pool = null;
        this.wmCreated = new AtomicLong(0L);
    }

    public StatelessKnowledgeSessionImpl(KieSessionConfiguration conf, StatefulSessionPool pool) {
        this.kBase = pool.getKieBase();
        this.conf = conf != null ? conf.as(SessionConfiguration.KEY) : this.kBase.getSessionConfiguration().as(SessionConfiguration.KEY);
        this.environment = null;
        this.pool = pool;
        this.wmCreated = new AtomicLong(1L);
    }

    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    private StatefulKnowledgeSession newWorkingMemory() {
        StatefulKnowledgeSessionImpl ksession = (StatefulKnowledgeSessionImpl)(this.pool != null ? this.pool.get() : this.createWorkingMemory());
        ((Globals)((Object)ksession.getGlobalResolver())).setDelegate(this.sessionGlobals);
        this.registerListeners(ksession);
        for (Map.Entry<String, Channel> entry : this.channels.entrySet()) {
            ksession.registerChannel(entry.getKey(), entry.getValue());
        }
        return ksession;
    }

    private InternalWorkingMemory createWorkingMemory() {
        this.kBase.readLock();
        try {
            StatefulKnowledgeSessionImpl ksession = ((StatefulKnowledgeSessionImpl)RuntimeComponentFactory.get().createStatefulSession(this.kBase, this.environment, this.conf, false)).setStateless(true);
            this.wmCreated.incrementAndGet();
            StatefulKnowledgeSessionImpl statefulKnowledgeSessionImpl = ksession;
            return statefulKnowledgeSessionImpl;
        }
        finally {
            this.kBase.readUnlock();
        }
    }

    public void initMBeans(String containerId, String kbaseId, String ksessionName) {
        if (this.kBase.getConfiguration() != null && this.kBase.getKieBaseConfiguration().isMBeansEnabled() && this.mbeanRegistered.compareAndSet(false, true)) {
            this.mbeanRegisteredCBSKey = new DroolsManagementAgent.CBSKey(containerId, kbaseId, ksessionName);
            DroolsManagementAgent.getInstance().registerKnowledgeSessionUnderName(this.mbeanRegisteredCBSKey, this);
        }
    }

    public long getWorkingMemoryCreated() {
        return this.wmCreated.get();
    }

    private void registerListeners(StatefulKnowledgeSessionImpl wm) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListnerHolder listnerHolder : this.listeners) {
            switch (listnerHolder.type) {
                case AGENDA: {
                    wm.addEventListener((AgendaEventListener)listnerHolder.listener);
                    break;
                }
                case RUNTIME: {
                    wm.addEventListener((RuleRuntimeEventListener)listnerHolder.listener);
                    break;
                }
                case PROCESS: {
                    wm.addEventListener((ProcessEventListener)listnerHolder.listener);
                }
            }
        }
    }

    @Override
    public void addEventListener(AgendaEventListener listener) {
        this.listeners.add(new ListnerHolder(ListnerHolder.Type.AGENDA, listener));
    }

    @Override
    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return this.getListeners(ListnerHolder.Type.AGENDA);
    }

    @Override
    public void removeEventListener(AgendaEventListener listener) {
        this.listeners.remove(new ListnerHolder(ListnerHolder.Type.AGENDA, listener));
    }

    @Override
    public void addEventListener(RuleRuntimeEventListener listener) {
        this.listeners.add(new ListnerHolder(ListnerHolder.Type.RUNTIME, listener));
    }

    @Override
    public void removeEventListener(RuleRuntimeEventListener listener) {
        this.listeners.remove(new ListnerHolder(ListnerHolder.Type.RUNTIME, listener));
    }

    @Override
    public Collection<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
        return this.getListeners(ListnerHolder.Type.RUNTIME);
    }

    @Override
    public void addEventListener(ProcessEventListener listener) {
        this.listeners.add(new ListnerHolder(ListnerHolder.Type.PROCESS, listener));
    }

    @Override
    public Collection<ProcessEventListener> getProcessEventListeners() {
        return this.getListeners(ListnerHolder.Type.PROCESS);
    }

    private Collection<? extends EventListener> getListeners(ListnerHolder.Type type) {
        if (this.listeners.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<EventListener> l = new ArrayList<EventListener>();
        for (ListnerHolder listnerHolder : this.listeners) {
            if (listnerHolder.type != type) continue;
            l.add(listnerHolder.listener);
        }
        return l;
    }

    @Override
    public void removeEventListener(ProcessEventListener listener) {
        this.listeners.remove(new ListnerHolder(ListnerHolder.Type.RUNTIME, listener));
    }

    @Override
    public void setGlobal(String identifier, Object value) {
        this.sessionGlobals.setGlobal(identifier, value);
    }

    @Override
    public Globals getGlobals() {
        return this.sessionGlobals;
    }

    @Override
    public void registerChannel(String name, Channel channel) {
        this.channels.put(name, channel);
    }

    @Override
    public void unregisterChannel(String name) {
        this.channels.remove(name);
    }

    @Override
    public Map<String, Channel> getChannels() {
        return Collections.unmodifiableMap(this.channels);
    }

    @Override
    public KieBase getKieBase() {
        return this.getKnowledgeBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Command<T> command) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        RegistryContext context = RegistryContext.create().register(KieSession.class, ksession);
        try {
            if (command instanceof BatchExecutionCommand) {
                context.register(ExecutionResults.class, KieServices.get().getCommands().newExecutionResults());
            }
            ((StatefulKnowledgeSessionImpl)ksession).startBatchExecution();
            ExecutableCommand executableCommand = (ExecutableCommand)command;
            Object o = executableCommand.execute(context);
            if (executableCommand.autoFireAllRules()) {
                ksession.fireAllRules();
            }
            if (command instanceof BatchExecutionCommand) {
                ExecutionResults executionResults = context.lookup(ExecutionResults.class);
                return (T)executionResults;
            }
            Object t = o;
            return t;
        }
        finally {
            ((StatefulKnowledgeSessionImpl)ksession).endBatchExecution();
            this.dispose(ksession);
        }
    }

    @Override
    public void execute(Object object) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        try {
            ksession.insert(object);
            ksession.fireAllRules();
        }
        finally {
            this.dispose(ksession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Iterable objects) {
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        try {
            for (Object object : objects) {
                ksession.insert(object);
            }
            ksession.fireAllRules();
        }
        finally {
            this.dispose(ksession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeWithResults(Iterable objects, ObjectFilter filter) {
        ArrayList<Object> list = new ArrayList<Object>();
        StatefulKnowledgeSession ksession = this.newWorkingMemory();
        try {
            for (Object object : objects) {
                ksession.insert(object);
            }
            ksession.fireAllRules();
            for (FactHandle fh : ksession.getFactHandles(filter)) {
                list.add(((InternalFactHandle)fh).getObject());
            }
        }
        finally {
            this.dispose(ksession);
        }
        return list;
    }

    private void dispose(StatefulKnowledgeSession ksession) {
        ksession.dispose();
    }

    private static class ListnerHolder {
        final Type type;
        final EventListener listener;

        private ListnerHolder(Type type, EventListener listener) {
            this.type = type;
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ListnerHolder)) {
                return false;
            }
            ListnerHolder that = (ListnerHolder)obj;
            return this.type == that.type && this.listener == that.listener;
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.listener.hashCode();
            return result;
        }

        static enum Type {
            AGENDA,
            RUNTIME,
            PROCESS;

        }
    }
}

