/*
 * Decompiled with CFR 0.152.
 */
package org.drools.kiesession.rulebase;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.core.KieBaseConfigurationImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.impl.InternalKieContainer;
import org.drools.core.impl.KieBaseUpdate;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.rule.InvalidPatternException;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.rule.accessor.FactHandleFactory;
import org.drools.core.ruleunit.RuleUnitDescriptionRegistry;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KieBaseEventSupport;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.rule.Query;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.kiebase.KieBaseEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.KieSessionsPool;
import org.kie.api.runtime.StatelessKieSession;

public class SessionsAwareKnowledgeBase
implements InternalKnowledgeBase {
    private final KnowledgeBaseImpl delegate;
    private final transient Set<InternalWorkingMemory> statefulSessions = ConcurrentHashMap.newKeySet();
    private KieSessionsPool sessionPool;
    private final AtomicInteger workingMemoryCounter = new AtomicInteger(0);
    private InternalKieContainer kieContainer;
    private final Queue<Runnable> kbaseModificationsQueue = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicInteger sessionDeactivationsCounter = new AtomicInteger();
    private final AtomicBoolean flushingUpdates = new AtomicBoolean(false);
    private final AtomicBoolean mbeanRegistered = new AtomicBoolean(false);
    private final KieBaseEventSupport eventSupport = new KieBaseEventSupport(this);
    public final Set<KieBaseEventListener> kieBaseListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public SessionsAwareKnowledgeBase() {
        this(RuleBaseFactory.newRuleBase());
    }

    public SessionsAwareKnowledgeBase(KieBaseConfiguration kbaseConfiguration) {
        this(RuleBaseFactory.newRuleBase(kbaseConfiguration));
    }

    public SessionsAwareKnowledgeBase(RuleBase delegate) {
        this.delegate = (KnowledgeBaseImpl)delegate;
        if (this.delegate.getRuleBaseConfiguration().getSessionPoolSize() > 0) {
            this.sessionPool = this.newKieSessionsPool(this.delegate.getRuleBaseConfiguration().getSessionPoolSize());
        }
    }

    public KnowledgeBaseImpl getDelegate() {
        return this.delegate;
    }

    @Override
    public void setKieContainer(InternalKieContainer kieContainer) {
        this.kieContainer = kieContainer;
    }

    @Override
    public InternalKieContainer getKieContainer() {
        return this.kieContainer;
    }

    @Override
    public KieSessionsPool getSessionPool() {
        return this.sessionPool;
    }

    @Override
    public Collection<? extends KieSession> getKieSessions() {
        return Collections.unmodifiableSet(this.statefulSessions);
    }

    @Override
    public StatelessKieSession newStatelessKieSession(KieSessionConfiguration conf) {
        return RuntimeComponentFactory.get().createStatelessSession(this, conf);
    }

    @Override
    public StatelessKieSession newStatelessKieSession() {
        return RuntimeComponentFactory.get().createStatelessSession(this, null);
    }

    @Override
    public KieSessionsPool newKieSessionsPool(int initialSize) {
        return RuntimeComponentFactory.get().createSessionsPool(this, initialSize);
    }

    @Override
    public KieSession newKieSession() {
        return this.newKieSession(this.getSessionConfiguration(), EnvironmentFactory.newEnvironment());
    }

    @Override
    public KieSession newKieSession(KieSessionConfiguration conf, Environment environment) {
        return this.newKieSession(conf, environment, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KieSession newKieSession(KieSessionConfiguration conf, Environment environment, boolean fromPool) {
        if (conf == null) {
            conf = this.getSessionConfiguration();
        }
        SessionConfiguration sessionConfig = conf.as(SessionConfiguration.KEY);
        if (environment == null) {
            environment = EnvironmentFactory.newEnvironment();
        }
        if (this.getRuleBaseConfiguration().isSequential()) {
            throw new RuntimeException("Cannot have a stateful rule session, with sequential configuration set to true");
        }
        this.readLock();
        try {
            KieSession kieSession = (KieSession)((Object)RuntimeComponentFactory.get().createStatefulSession(this, environment, sessionConfig, fromPool));
            return kieSession;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void addStatefulSession(InternalWorkingMemory wm) {
        this.statefulSessions.add(wm);
    }

    @Override
    public void disposeStatefulSession(InternalWorkingMemory statefulSession) {
        this.statefulSessions.remove(statefulSession);
        if (this.kieContainer != null) {
            this.kieContainer.disposeSession((KieSession)((Object)statefulSession));
        }
    }

    @Override
    public int nextWorkingMemoryCounter() {
        return this.workingMemoryCounter.getAndIncrement();
    }

    @Override
    public int getWorkingMemoryCounter() {
        return this.workingMemoryCounter.get();
    }

    @Override
    public Collection<InternalWorkingMemory> getWorkingMemories() {
        return Collections.unmodifiableSet(this.statefulSessions);
    }

    @Override
    public void addPackages(Collection<? extends KiePackage> newPkgs) {
        ArrayList<InternalKnowledgePackage> clonedPkgs = new ArrayList<InternalKnowledgePackage>();
        for (KiePackage kiePackage : newPkgs) {
            clonedPkgs.add(((InternalKnowledgePackage)kiePackage).deepCloneIfAlreadyInUse(this.delegate.getRootClassLoader()));
        }
        clonedPkgs.sort(Comparator.comparing(p -> p.getRules().size()).reversed().thenComparing(KiePackage::getName));
        this.enqueueModification(() -> this.internalAddPackages(clonedPkgs));
    }

    @Override
    public void removeGlobal(String identifier) {
        this.delegate.removeGlobal(identifier);
        for (InternalWorkingMemory wm : this.getWorkingMemories()) {
            wm.removeGlobal(identifier);
        }
    }

    @Override
    public Future<KiePackage> addPackage(KiePackage newPkg) {
        InternalKnowledgePackage clonedPkg = ((InternalKnowledgePackage)newPkg).deepCloneIfAlreadyInUse(this.delegate.getRootClassLoader());
        CompletableFuture<KiePackage> result = new CompletableFuture<KiePackage>();
        this.enqueueModification(() -> {
            this.internalAddPackages(Collections.singletonList(clonedPkg));
            result.complete(this.getPackage(newPkg.getName()));
        });
        return result;
    }

    private void internalAddPackages(List<InternalKnowledgePackage> clonedPkgs) {
        for (InternalWorkingMemory wm : this.getWorkingMemories()) {
            wm.flushPropagations();
        }
        for (InternalKnowledgePackage newPkg : clonedPkgs) {
            this.eventSupport.fireBeforePackageAdded(newPkg);
            for (Rule rule : newPkg.getRules()) {
                this.eventSupport.fireBeforeRuleAdded((RuleImpl)rule);
            }
        }
        this.delegate.kBaseInternal_addPackages(clonedPkgs, this.statefulSessions);
        for (InternalKnowledgePackage newPkg : clonedPkgs) {
            for (Rule rule : newPkg.getRules()) {
                this.eventSupport.fireAfterRuleAdded((RuleImpl)rule);
            }
            this.eventSupport.fireAfterPackageAdded(newPkg);
        }
    }

    @Override
    public void removeKiePackage(String packageName) {
        this.enqueueModification(() -> {
            InternalKnowledgePackage pkg = this.getPackage(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            this.eventSupport.fireBeforePackageRemoved(pkg);
            this.removeRules(pkg.getRules());
            this.delegate.kBaseInternal_removePackage(pkg, this.statefulSessions);
            this.eventSupport.fireAfterPackageRemoved(pkg);
        });
    }

    @Override
    public void enqueueModification(Runnable modification) {
        if (this.tryLockAndDeactivate()) {
            try {
                modification.run();
            }
            finally {
                this.unlockAndActivate();
            }
        } else {
            this.kbaseModificationsQueue.offer(modification);
        }
    }

    @Override
    public boolean flushModifications() {
        if (!this.flushingUpdates.compareAndSet(false, true)) {
            return false;
        }
        if (this.kbaseModificationsQueue.isEmpty()) {
            this.flushingUpdates.set(false);
            return false;
        }
        try {
            this.lockAndDeactivate();
            while (!this.kbaseModificationsQueue.isEmpty()) {
                this.kbaseModificationsQueue.poll().run();
            }
        }
        finally {
            this.flushingUpdates.set(false);
            this.unlockAndActivate();
        }
        return true;
    }

    private void lockAndDeactivate() {
        this.lock();
        this.deactivateAllSessions();
    }

    private void unlockAndActivate() {
        this.activateAllSessions();
        this.unlock();
    }

    public void lock() {
        boolean firstLock;
        boolean bl = firstLock = !this.delegate.kBaseInternal_getLock().isWriteLockedByCurrentThread();
        if (firstLock) {
            this.eventSupport.fireBeforeRuleBaseLocked();
        }
        this.delegate.kBaseInternal_lock();
        if (firstLock) {
            this.eventSupport.fireAfterRuleBaseLocked();
        }
    }

    public void unlock() {
        boolean lastUnlock;
        boolean bl = lastUnlock = this.delegate.kBaseInternal_getLock().getWriteHoldCount() == 1;
        if (lastUnlock) {
            this.eventSupport.fireBeforeRuleBaseUnlocked();
        }
        this.delegate.kBaseInternal_unlock();
        if (lastUnlock) {
            this.eventSupport.fireAfterRuleBaseUnlocked();
        }
    }

    private boolean tryDeactivateAllSessions() {
        Collection<InternalWorkingMemory> wms = this.getWorkingMemories();
        if (wms.isEmpty()) {
            return true;
        }
        ArrayList<InternalWorkingMemory> deactivatedWMs = new ArrayList<InternalWorkingMemory>();
        for (InternalWorkingMemory wm : wms) {
            if (wm.tryDeactivate()) {
                deactivatedWMs.add(wm);
                continue;
            }
            for (InternalWorkingMemory deactivatedWM : deactivatedWMs) {
                deactivatedWM.activate();
            }
            return false;
        }
        return true;
    }

    private boolean tryLockAndDeactivate() {
        if (this.sessionDeactivationsCounter.incrementAndGet() > 1) {
            this.delegate.kBaseInternal_writeLock();
            return true;
        }
        boolean locked = this.delegate.kBaseInternal_tryWriteLock();
        if (locked && !this.tryDeactivateAllSessions()) {
            this.delegate.kBaseInternal_writeUnlock();
            locked = false;
        }
        if (!locked) {
            this.sessionDeactivationsCounter.decrementAndGet();
        }
        return locked;
    }

    private void deactivateAllSessions() {
        if (this.sessionDeactivationsCounter.incrementAndGet() < 2) {
            for (InternalWorkingMemory wm : this.getWorkingMemories()) {
                wm.deactivate();
            }
        }
    }

    private void activateAllSessions() {
        if (this.sessionDeactivationsCounter.decrementAndGet() == 0) {
            for (InternalWorkingMemory wm : this.getWorkingMemories()) {
                wm.activate();
            }
        }
    }

    @Override
    public void initMBeans() {
        if (this.getConfiguration() != null && this.getKieBaseConfiguration().isMBeansEnabled() && this.mbeanRegistered.compareAndSet(false, true)) {
            DroolsManagementAgent.getInstance().registerKnowledgeBase(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(KieBaseEventListener listener) {
        Set<KieBaseEventListener> set = this.kieBaseListeners;
        synchronized (set) {
            if (!this.kieBaseListeners.contains(listener)) {
                this.eventSupport.addEventListener(listener);
                this.kieBaseListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventListener(KieBaseEventListener listener) {
        Set<KieBaseEventListener> set = this.kieBaseListeners;
        synchronized (set) {
            this.eventSupport.removeEventListener(listener);
            this.kieBaseListeners.remove(listener);
        }
    }

    @Override
    public Collection<KieBaseEventListener> getKieBaseEventListeners() {
        return Collections.unmodifiableCollection(this.kieBaseListeners);
    }

    @Override
    public SessionConfiguration getSessionConfiguration() {
        return this.delegate.getSessionConfiguration();
    }

    @Override
    public void registerAddedEntryNodeCache(EntryPointNode node) {
        this.delegate.registerAddedEntryNodeCache(node);
    }

    @Override
    public Set<EntryPointNode> getAddedEntryNodeCache() {
        return this.delegate.getAddedEntryNodeCache();
    }

    @Override
    public void registeRremovedEntryNodeCache(EntryPointNode node) {
        this.delegate.registeRremovedEntryNodeCache(node);
    }

    @Override
    public Set<EntryPointNode> getRemovedEntryNodeCache() {
        return this.delegate.getRemovedEntryNodeCache();
    }

    @Override
    public Rete getRete() {
        return this.delegate.getRete();
    }

    @Override
    public ReteooBuilder getReteooBuilder() {
        return this.delegate.getReteooBuilder();
    }

    @Override
    public int getNodeCount() {
        return this.delegate.getNodeCount();
    }

    @Override
    public int getMemoryCount() {
        return this.delegate.getMemoryCount();
    }

    @Override
    public void invalidateSegmentPrototype(LeftTupleNode rootNode) {
        this.delegate.invalidateSegmentPrototype(rootNode);
    }

    @Override
    public SegmentMemory createSegmentFromPrototype(ReteEvaluator reteEvaluator, LeftTupleSource tupleSource) {
        return this.delegate.createSegmentFromPrototype(reteEvaluator, tupleSource);
    }

    @Override
    public SegmentMemory createSegmentFromPrototype(ReteEvaluator reteEvaluator, SegmentMemory.SegmentPrototype smem) {
        return this.delegate.createSegmentFromPrototype(reteEvaluator, smem);
    }

    @Override
    public boolean hasSegmentPrototypes() {
        return this.delegate.hasSegmentPrototypes();
    }

    @Override
    public SegmentMemory.SegmentPrototype getSegmentPrototype(LeftTupleNode node) {
        return this.delegate.getSegmentPrototype(node);
    }

    @Override
    public SegmentMemory.SegmentPrototype getSegmentPrototype(SegmentMemory segment) {
        return this.delegate.getSegmentPrototype(segment);
    }

    @Override
    public TypeDeclaration getExactTypeDeclaration(Class<?> clazz) {
        return this.delegate.getExactTypeDeclaration(clazz);
    }

    @Override
    public TypeDeclaration getOrCreateExactTypeDeclaration(Class<?> clazz) {
        return this.delegate.getOrCreateExactTypeDeclaration(clazz);
    }

    @Override
    public TypeDeclaration getTypeDeclaration(Class<?> clazz) {
        return this.delegate.getTypeDeclaration(clazz);
    }

    @Override
    public Collection<TypeDeclaration> getTypeDeclarations() {
        return this.delegate.getTypeDeclarations();
    }

    @Override
    public void beforeIncrementalUpdate(KieBaseUpdate kieBaseUpdate) {
        this.delegate.beforeIncrementalUpdate(kieBaseUpdate);
    }

    @Override
    public void afterIncrementalUpdate(KieBaseUpdate kieBaseUpdate) {
        this.delegate.afterIncrementalUpdate(kieBaseUpdate);
    }

    @Override
    public void processAllTypesDeclaration(Collection<InternalKnowledgePackage> pkgs) {
        this.delegate.processAllTypesDeclaration(pkgs);
    }

    @Override
    public boolean hasMultipleAgendaGroups() {
        return this.delegate.hasMultipleAgendaGroups();
    }

    @Override
    public void registerTypeDeclaration(TypeDeclaration newDecl, InternalKnowledgePackage newPkg) {
        this.delegate.registerTypeDeclaration(newDecl, newPkg);
    }

    @Override
    public Class<?> registerAndLoadTypeDefinition(String className, byte[] def) throws ClassNotFoundException {
        return this.delegate.registerAndLoadTypeDefinition(className, def);
    }

    @Override
    public void addGlobal(String identifier, Type type) {
        this.delegate.addGlobal(identifier, type);
    }

    @Override
    public Rule getRule(String packageName, String ruleName) {
        return this.delegate.getRule(packageName, ruleName);
    }

    @Override
    public Query getQuery(String packageName, String queryName) {
        return this.delegate.getQuery(packageName, queryName);
    }

    @Override
    public Collection<KiePackage> getKiePackages() {
        return this.delegate.getKiePackages();
    }

    @Override
    public KiePackage getKiePackage(String packageName) {
        return this.delegate.getKiePackage(packageName);
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public FactHandleFactory newFactHandleFactory() {
        return this.delegate.newFactHandleFactory();
    }

    @Override
    public FactHandleFactory newFactHandleFactory(long id, long counter) {
        return this.delegate.newFactHandleFactory(id, counter);
    }

    @Override
    public Collection<Process> getProcesses() {
        return this.delegate.getProcesses();
    }

    @Override
    public InternalKnowledgePackage[] getPackages() {
        return this.delegate.getPackages();
    }

    @Override
    public Map<String, InternalKnowledgePackage> getPackagesMap() {
        return this.delegate.getPackagesMap();
    }

    @Override
    public Map<String, Type> getGlobals() {
        return this.delegate.getGlobals();
    }

    @Override
    public void readLock() {
        this.delegate.readLock();
    }

    @Override
    public void readUnlock() {
        this.delegate.readUnlock();
    }

    @Override
    public void addRules(Collection<RuleImpl> rules) throws InvalidPatternException {
        this.enqueueModification(() -> {
            for (RuleImpl rule : rules) {
                this.eventSupport.fireBeforeRuleAdded(rule);
            }
            this.delegate.kBaseInternal_addRules(rules, this.statefulSessions);
            for (RuleImpl rule : rules) {
                this.eventSupport.fireAfterRuleAdded(rule);
            }
        });
    }

    @Override
    public void removeQuery(String packageName, String ruleName) {
        this.delegate.removeQuery(packageName, ruleName);
    }

    @Override
    public void removeRule(String packageName, String ruleName) {
        this.enqueueModification(() -> {
            InternalKnowledgePackage pkg = this.getPackage(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            RuleImpl rule = pkg.getRule(ruleName);
            if (rule == null) {
                throw new IllegalArgumentException("Rule name '" + ruleName + "' does not exist in the Package '" + packageName + "'.");
            }
            this.eventSupport.fireBeforeRuleRemoved(rule);
            this.delegate.kBaseInternal_removeRule(pkg, rule, this.statefulSessions);
            this.eventSupport.fireAfterRuleRemoved(rule);
        });
    }

    @Override
    public void removeRules(Collection<RuleImpl> rules) {
        this.enqueueModification(() -> {
            for (RuleImpl rule : rules) {
                this.eventSupport.fireBeforeRuleRemoved(rule);
            }
            this.delegate.kBaseInternal_removeRules(rules, this.statefulSessions);
            for (RuleImpl rule : rules) {
                this.eventSupport.fireAfterRuleRemoved(rule);
            }
        });
    }

    @Override
    public void removeFunction(String packageName, String functionName) {
        this.enqueueModification(() -> {
            InternalKnowledgePackage pkg = this.getPackage(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            this.eventSupport.fireBeforeFunctionRemoved(pkg, functionName);
            this.delegate.kBaseInternal_removeFunction(pkg, functionName);
            this.eventSupport.fireAfterFunctionRemoved(pkg, functionName);
        });
    }

    @Override
    public void addProcess(Process process) {
        this.lock();
        try {
            this.eventSupport.fireBeforeProcessAdded(process);
            this.delegate.kBaseInternal_addProcess(process);
            this.eventSupport.fireAfterProcessAdded(process);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void removeProcess(String id) {
        this.enqueueModification(() -> {
            Process process = this.getProcess(id);
            if (process == null) {
                throw new IllegalArgumentException("Process '" + id + "' does not exist for this Rule Base.");
            }
            this.eventSupport.fireBeforeProcessRemoved(process);
            this.delegate.kBaseInternal_removeProcess(id, process);
            this.eventSupport.fireAfterProcessRemoved(process);
        });
    }

    @Override
    public Process getProcess(String id) {
        return this.delegate.getProcess(id);
    }

    @Override
    public InternalKnowledgePackage getPackage(String name) {
        return this.delegate.getPackage(name);
    }

    @Override
    public KieBaseConfigurationImpl getKieBaseConfiguration() {
        return this.delegate.getKieBaseConfiguration();
    }

    @Override
    public KieBaseConfiguration getConfiguration() {
        return this.delegate.getConfiguration();
    }

    @Override
    public RuleBaseConfiguration getRuleBaseConfiguration() {
        return this.delegate.getRuleBaseConfiguration();
    }

    @Override
    public ClassLoader getRootClassLoader() {
        return this.delegate.getRootClassLoader();
    }

    @Override
    public void executeQueuedActions() {
        this.delegate.executeQueuedActions();
    }

    @Override
    public RuleBasePartitionId createNewPartitionId() {
        return this.delegate.createNewPartitionId();
    }

    @Override
    public FactType getFactType(String packageName, String typeName) {
        return this.delegate.getFactType(packageName, typeName);
    }

    @Override
    public ClassFieldAccessorCache getClassFieldAccessorCache() {
        return this.delegate.getClassFieldAccessorCache();
    }

    @Override
    public Set<String> getEntryPointIds() {
        return this.delegate.getEntryPointIds();
    }

    @Override
    public boolean removeObjectsGeneratedFromResource(Resource resource, Collection<InternalWorkingMemory> workingMemories) {
        return this.delegate.removeObjectsGeneratedFromResource(resource, workingMemories);
    }

    @Override
    public ReleaseId getResolvedReleaseId() {
        return this.delegate.getResolvedReleaseId();
    }

    @Override
    public void setResolvedReleaseId(ReleaseId currentReleaseId) {
        this.delegate.setResolvedReleaseId(currentReleaseId);
    }

    @Override
    public String getContainerId() {
        return this.delegate.getContainerId();
    }

    @Override
    public void setContainerId(String containerId) {
        this.delegate.setContainerId(containerId);
    }

    @Override
    public RuleUnitDescriptionRegistry getRuleUnitDescriptionRegistry() {
        return this.delegate.getRuleUnitDescriptionRegistry();
    }

    @Override
    public boolean hasUnits() {
        return this.delegate.hasUnits();
    }

    @Override
    public List<AsyncReceiveNode> getReceiveNodes() {
        return this.delegate.getReceiveNodes();
    }

    @Override
    public void addReceiveNode(AsyncReceiveNode node) {
        this.delegate.addReceiveNode(node);
    }

    @Override
    public void registerSegmentPrototype(LeftTupleNode tupleSource, SegmentMemory.SegmentPrototype smem) {
        this.delegate.registerSegmentPrototype(tupleSource, smem);
    }
}

