/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.drools.core.BaseConfiguration;
import org.drools.core.BeliefSystemType;
import org.drools.util.StringUtils;
import org.kie.api.conf.ConfigurationKey;
import org.kie.api.conf.OptionKey;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.AccumulateNullPropagationOption;
import org.kie.api.runtime.conf.BeliefSystemTypeOption;
import org.kie.api.runtime.conf.DirectFiringOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.MultiValueKieSessionOption;
import org.kie.api.runtime.conf.QueryListenerOption;
import org.kie.api.runtime.conf.SingleValueKieSessionOption;
import org.kie.api.runtime.conf.ThreadSafeOption;
import org.kie.api.runtime.conf.TimedRuleExecutionFilter;
import org.kie.api.runtime.conf.TimedRuleExecutionOption;
import org.kie.internal.conf.CompositeConfiguration;
import org.kie.internal.conf.InternalPropertiesConfiguration;
import org.kie.internal.runtime.conf.ForceEagerActivationFilter;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;

public class RuleSessionConfiguration
extends BaseConfiguration<KieSessionOption, SingleValueKieSessionOption, MultiValueKieSessionOption>
implements KieSessionConfiguration,
InternalPropertiesConfiguration,
Externalizable {
    public static final ConfigurationKey<RuleSessionConfiguration> KEY = new ConfigurationKey("Rule");
    private static final long serialVersionUID = 510L;
    private boolean directFiring;
    private boolean threadSafe;
    private boolean accumulateNullPropagation;
    private ForceEagerActivationFilter forceEagerActivationFilter;
    private TimedRuleExecutionFilter timedRuleExecutionFilter;
    private BeliefSystemType beliefSystemType;
    private QueryListenerOption queryListener;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.queryListener);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.queryListener = (QueryListenerOption)in.readObject();
    }

    public final boolean hasForceEagerActivationFilter() {
        try {
            return this.getForceEagerActivationFilter().accept(null);
        }
        catch (Exception e) {
            return true;
        }
    }

    public RuleSessionConfiguration(CompositeConfiguration<KieSessionOption, SingleValueKieSessionOption, MultiValueKieSessionOption> compConfig) {
        super(compConfig);
        this.init();
    }

    private void init() {
        this.setDirectFiring(Boolean.parseBoolean(this.getPropertyValue("drools.directFiring", "false")));
        this.setThreadSafe(Boolean.parseBoolean(this.getPropertyValue("drools.threadSafe", "true")));
        this.setAccumulateNullPropagation(Boolean.parseBoolean(this.getPropertyValue("drools.accumulateNullPropagation", "false")));
        this.setForceEagerActivationFilter(ForceEagerActivationOption.resolve(this.getPropertyValue("drools.forceEagerActivation", "false")).getFilter());
        this.setTimedRuleExecutionFilter(TimedRuleExecutionOption.resolve(this.getPropertyValue("drools.timedRuleExecution", "false")).getFilter());
        this.setBeliefSystemType(BeliefSystemType.resolveBeliefSystemType(this.getPropertyValue("drools.beliefSystem", BeliefSystemType.SIMPLE.getId())));
        this.setQueryListenerOption(QueryListenerOption.determineQueryListenerClassOption(this.getPropertyValue("drools.queryListener", QueryListenerOption.STANDARD.getAsString())));
    }

    public void setDirectFiring(boolean directFiring) {
        this.checkCanChange();
        this.directFiring = directFiring;
    }

    public boolean isDirectFiring() {
        return this.directFiring;
    }

    public void setThreadSafe(boolean threadSafe) {
        this.checkCanChange();
        this.threadSafe = threadSafe;
    }

    public boolean isThreadSafe() {
        return this.threadSafe;
    }

    public void setAccumulateNullPropagation(boolean accumulateNullPropagation) {
        this.checkCanChange();
        this.accumulateNullPropagation = accumulateNullPropagation;
    }

    public boolean isAccumulateNullPropagation() {
        return this.accumulateNullPropagation;
    }

    public void setForceEagerActivationFilter(ForceEagerActivationFilter forceEagerActivationFilter) {
        this.checkCanChange();
        this.forceEagerActivationFilter = forceEagerActivationFilter;
    }

    public ForceEagerActivationFilter getForceEagerActivationFilter() {
        return this.forceEagerActivationFilter;
    }

    public void setTimedRuleExecutionFilter(TimedRuleExecutionFilter timedRuleExecutionFilter) {
        this.checkCanChange();
        this.timedRuleExecutionFilter = timedRuleExecutionFilter;
    }

    public TimedRuleExecutionFilter getTimedRuleExecutionFilter() {
        return this.timedRuleExecutionFilter;
    }

    public BeliefSystemType getBeliefSystemType() {
        return this.beliefSystemType;
    }

    public void setBeliefSystemType(BeliefSystemType beliefSystemType) {
        this.checkCanChange();
        this.beliefSystemType = beliefSystemType;
    }

    public QueryListenerOption getQueryListenerOption() {
        return this.queryListener;
    }

    public void setQueryListenerOption(QueryListenerOption queryListener) {
        this.checkCanChange();
        this.queryListener = queryListener;
    }

    @Override
    public final <T extends KieSessionOption> void setOption(T option) {
        switch (option.propertyName()) {
            case "drools.directFiring": {
                this.setDirectFiring(((DirectFiringOption)option).isDirectFiring());
                break;
            }
            case "drools.threadSafe": {
                this.setThreadSafe(((ThreadSafeOption)option).isThreadSafe());
                break;
            }
            case "drools.accumulateNullPropagation": {
                this.setAccumulateNullPropagation(((AccumulateNullPropagationOption)option).isAccumulateNullPropagation());
                break;
            }
            case "drools.forceEagerActivation": {
                this.setForceEagerActivationFilter(((ForceEagerActivationOption)option).getFilter());
                break;
            }
            case "drools.timedRuleExecution": {
                this.setTimedRuleExecutionFilter(((TimedRuleExecutionOption)option).getFilter());
                break;
            }
            case "drools.queryListener": {
                this.setQueryListenerOption((QueryListenerOption)option);
                break;
            }
            case "drools.beliefSystem": {
                this.setBeliefSystemType(BeliefSystemType.resolveBeliefSystemType(((BeliefSystemTypeOption)option).getBeliefSystemType()));
                break;
            }
            default: {
                this.compConfig.setOption(option);
            }
        }
    }

    @Override
    public final <T extends SingleValueKieSessionOption> T getOption(OptionKey<T> option) {
        switch (option.name()) {
            case "drools.directFiring": {
                return (T)(this.isDirectFiring() ? DirectFiringOption.YES : DirectFiringOption.NO);
            }
            case "drools.threadSafe": {
                return (T)(this.isThreadSafe() ? ThreadSafeOption.YES : ThreadSafeOption.NO);
            }
            case "drools.accumulateNullPropagation": {
                return (T)(this.isAccumulateNullPropagation() ? AccumulateNullPropagationOption.YES : AccumulateNullPropagationOption.NO);
            }
            case "drools.queryListener": {
                return (T)this.getQueryListenerOption();
            }
            case "drools.beliefSystem": {
                return (T)BeliefSystemTypeOption.get(this.getBeliefSystemType().getId());
            }
        }
        return (T)((SingleValueKieSessionOption)this.compConfig.getOption(option));
    }

    @Override
    public final <T extends MultiValueKieSessionOption> T getOption(OptionKey<T> option, String subKey) {
        return (T)((MultiValueKieSessionOption)this.compConfig.getOption(option, subKey));
    }

    @Override
    public <C extends MultiValueKieSessionOption> Set<String> getOptionSubKeys(OptionKey<C> optionKey) {
        return this.compConfig.getOptionSubKeys(optionKey);
    }

    @Override
    public boolean setInternalProperty(String name, String value) {
        switch (name) {
            case "drools.directFiring": {
                this.setDirectFiring(!StringUtils.isEmpty(value) && Boolean.parseBoolean(value));
                break;
            }
            case "drools.threadSafe": {
                this.setThreadSafe(StringUtils.isEmpty(value) || Boolean.parseBoolean(value));
                break;
            }
            case "drools.accumulateNullPropagation": {
                this.setAccumulateNullPropagation(!StringUtils.isEmpty(value) && Boolean.parseBoolean(value));
                break;
            }
            case "drools.forceEagerActivation": {
                this.setForceEagerActivationFilter(ForceEagerActivationOption.resolve(StringUtils.isEmpty(value) ? "false" : value).getFilter());
                break;
            }
            case "drools.timedRuleExecution": {
                this.setTimedRuleExecutionFilter(TimedRuleExecutionOption.resolve(StringUtils.isEmpty(value) ? "false" : value).getFilter());
                break;
            }
            case "drools.queryListener": {
                String property = StringUtils.isEmpty(value) ? QueryListenerOption.STANDARD.getAsString() : value;
                this.setQueryListenerOption(QueryListenerOption.determineQueryListenerClassOption(property));
                break;
            }
            case "drools.beliefSystem": {
                this.setBeliefSystemType(StringUtils.isEmpty(value) ? BeliefSystemType.SIMPLE : BeliefSystemType.resolveBeliefSystemType(value));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getInternalProperty(String name) {
        switch (name) {
            case "drools.directFiring": {
                return Boolean.toString(this.isDirectFiring());
            }
            case "drools.threadSafe": {
                return Boolean.toString(this.isThreadSafe());
            }
            case "drools.accumulateNullPropagation": {
                return Boolean.toString(this.isAccumulateNullPropagation());
            }
            case "drools.queryListener": {
                return this.getQueryListenerOption().getAsString();
            }
            case "drools.beliefSystem": {
                return this.getBeliefSystemType().getId();
            }
        }
        return null;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleSessionConfiguration that = (RuleSessionConfiguration)o;
        return this.getBeliefSystemType() == that.getBeliefSystemType();
    }

    public final int hashCode() {
        return this.getBeliefSystemType().hashCode();
    }
}

