/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Type;
import java.util.Optional;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.compiler.Dialect;
import org.drools.compiler.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.compiler.RuleBuildError;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.drools.core.common.TruthMaintenanceSystemFactory;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.accessor.DeclarationScopeResolver;
import org.drools.drl.ast.descr.QueryDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.util.TypeResolver;
import org.kie.internal.ruleunit.RuleUnitComponentFactory;
import org.kie.internal.ruleunit.RuleUnitDescription;

public class RuleBuildContext
extends PackageBuildContext {
    private final RuleImpl rule;
    private final RuleDescr ruleDescr;
    private DeclarationScopeResolver declarationResolver;
    private int patternId = -1;
    private boolean needStreamMode = false;
    private Pattern prefixPattern;
    private boolean inXpath;
    private int xpathChuckNr = 0;
    private int xpathOffsetadjustment = 0;

    public RuleBuildContext(TypeDeclarationContext kBuilder, RuleDescr ruleDescr, DialectCompiletimeRegistry dialectCompiletimeRegistry, InternalKnowledgePackage pkg, Dialect defaultDialect) {
        Dialect dialect;
        this.ruleDescr = ruleDescr;
        this.rule = ruleDescr instanceof QueryDescr ? TruthMaintenanceSystemFactory.createQuery(ruleDescr.getName(), ruleDescr::hasAnnotation) : RuleBuildContext.descrToRule(ruleDescr);
        this.rule.setPackage(pkg.getName());
        this.rule.setDialect(ruleDescr.getDialect());
        this.rule.setLoadOrder(ruleDescr.getLoadOrder());
        this.initContext(kBuilder, pkg, ruleDescr, dialectCompiletimeRegistry, defaultDialect, this.rule);
        if (this.rule.getDialect() == null) {
            this.rule.setDialect(this.getDialect().getId());
        }
        if (ruleDescr.getUnit() != null) {
            this.rule.setRuleUnitClassName(pkg.getName() + "." + ruleDescr.getUnit().getTarget().replace('.', '$'));
        }
        if ((dialect = this.getDialect()) != null) {
            dialect.init(ruleDescr);
        }
        this.declarationResolver = new DeclarationScopeResolver(kBuilder.getGlobals(), this.getPkg());
    }

    public RuleImpl getRule() {
        return this.rule;
    }

    public RuleDescr getRuleDescr() {
        return this.ruleDescr;
    }

    public DeclarationScopeResolver getDeclarationResolver() {
        return this.declarationResolver;
    }

    public void setDeclarationResolver(DeclarationScopeResolver declarationResolver) {
        this.declarationResolver = declarationResolver;
    }

    public int getNextPatternId() {
        return ++this.patternId;
    }

    public boolean needsStreamMode() {
        return this.needStreamMode;
    }

    public void setNeedStreamMode() {
        this.needStreamMode = true;
    }

    public void setPrefixPattern(Pattern prefixPattern) {
        this.prefixPattern = prefixPattern;
    }

    public Pattern getPrefixPattern() {
        return this.prefixPattern;
    }

    public boolean isInXpath() {
        return this.inXpath;
    }

    public void setInXpath(boolean inXpath) {
        this.inXpath = inXpath;
    }

    public void initRule() {
        this.initRuleUnitClassName();
        this.declarationResolver.setRule(this.rule);
    }

    @Override
    public Type resolveVarType(String identifier) {
        return this.getDeclarationResolver().resolveVarType(identifier);
    }

    private void initRuleUnitClassName() {
        String ruleUnitClassName = this.rule.getRuleUnitClassName();
        boolean nameInferredFromResource = false;
        if (ruleUnitClassName == null && this.rule.getResource() != null && this.rule.getResource().getSourcePath() != null) {
            ruleUnitClassName = this.extractClassNameFromSourcePath();
            nameInferredFromResource = true;
        }
        if (RuleUnitComponentFactory.get() != null && ruleUnitClassName != null) {
            Class<?> ruleUnitClass;
            boolean unitFound;
            block10: {
                TypeResolver typeResolver = this.getPkg().getTypeResolver();
                unitFound = false;
                ruleUnitClass = null;
                try {
                    ruleUnitClass = typeResolver.resolveType(ruleUnitClassName);
                }
                catch (ClassNotFoundException e) {
                    if (nameInferredFromResource) break block10;
                    this.addError(new RuleBuildError(this.rule, this.getParentDescr(), null, "Cannot find rule unit class " + ruleUnitClassName));
                    return;
                }
            }
            if (ruleUnitClass != null) {
                unitFound = RuleUnitComponentFactory.get().isRuleUnitClass(ruleUnitClass);
                if (unitFound && nameInferredFromResource) {
                    this.rule.setRuleUnitClassName(ruleUnitClassName);
                }
                try {
                    for (PropertyDescriptor prop : Introspector.getBeanInfo(ruleUnitClass).getPropertyDescriptors()) {
                        if ("class".equals(prop.getName())) continue;
                        this.getPkg().addGlobal(prop.getName(), prop.getPropertyType());
                    }
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException();
                }
            }
            if (!unitFound && !nameInferredFromResource) {
                this.addError(new RuleBuildError(this.rule, this.getParentDescr(), null, ruleUnitClassName + " must implement RuleUnitData"));
            }
        }
    }

    public Optional<EntryPointId> getEntryPointId(String name) {
        return this.getPkg().getRuleUnitDescriptionLoader().getDescription(this.getRule()).flatMap(ruDescr -> this.getEntryPointId((RuleUnitDescription)ruDescr, name));
    }

    public Optional<EntryPointId> getEntryPointId(RuleUnitDescription ruDescr, String name) {
        return ruDescr.hasVar(name) ? Optional.of(new EntryPointId(name)) : Optional.empty();
    }

    private String extractClassNameFromSourcePath() {
        String drlPath = this.rule.getResource().getSourcePath();
        int fileTypeDotIndex = drlPath.lastIndexOf(46);
        if (fileTypeDotIndex > 0) {
            drlPath = drlPath.substring(0, fileTypeDotIndex);
        }
        StringBuilder classNameBuilder = new StringBuilder();
        int actualIndex = drlPath.length() - 1;
        char actualChar = drlPath.charAt(actualIndex);
        while (Character.isJavaIdentifierPart(actualChar) || Character.isJavaIdentifierStart(actualChar)) {
            classNameBuilder.append(actualChar);
            if (--actualIndex < 0) break;
            actualChar = drlPath.charAt(actualIndex);
        }
        return this.rule.getPackage() + "." + classNameBuilder.reverse();
    }

    public void increaseXpathChuckNr() {
        ++this.xpathChuckNr;
    }

    public void resetXpathChuckNr() {
        this.xpathChuckNr = 0;
    }

    public int getXpathChuckNr() {
        return this.xpathChuckNr + this.xpathOffsetadjustment;
    }

    public void setXpathChuckNr(int chunkNbr) {
        this.xpathChuckNr = chunkNbr + this.xpathOffsetadjustment;
    }

    public void setXpathOffsetadjustment(int xpathOffsetadjustment) {
        this.xpathOffsetadjustment = xpathOffsetadjustment;
    }

    public int getXpathOffsetadjustment() {
        return this.xpathOffsetadjustment;
    }

    public static RuleImpl descrToRule(RuleDescr ruleDescr) {
        RuleImpl rule = new RuleImpl(ruleDescr.getName());
        rule.setResource(rule.getResource());
        return rule;
    }
}

