/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler.io.memory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.FileSystem;
import org.drools.compiler.compiler.io.FileSystemItem;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFolder;
import org.drools.io.ByteArrayResource;
import org.drools.io.InternalResource;
import org.drools.util.IoUtils;
import org.drools.util.PortablePath;
import org.drools.util.StringUtils;
import org.kie.api.io.Resource;
import org.kie.memorycompiler.resources.ResourceReader;
import org.kie.memorycompiler.resources.ResourceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryFileSystem
implements FileSystem,
ResourceReader,
Serializable,
ResourceStore {
    private static final Logger log = LoggerFactory.getLogger(MemoryFileSystem.class);
    private final MemoryFolder folder;
    private final Map<PortablePath, Set<FileSystemItem>> folders = new HashMap<PortablePath, Set<FileSystemItem>>();
    private final Map<PortablePath, Folder> folderMap = new HashMap<PortablePath, Folder>();
    private final Map<PortablePath, InternalResource> fileContents = new HashMap<PortablePath, InternalResource>();
    private Set<String> modifiedFilesSinceLastMark;

    public MemoryFileSystem() {
        this.folder = new MemoryFolder(this, PortablePath.ROOT_PATH);
        this.folders.put(PortablePath.ROOT_PATH, new HashSet());
    }

    @Override
    public Folder getRootFolder() {
        return this.folder;
    }

    @Override
    public Collection<PortablePath> getFilePaths() {
        return this.fileContents.keySet();
    }

    public Map<PortablePath, byte[]> getMap() {
        HashMap<PortablePath, byte[]> bytesMap = new HashMap<PortablePath, byte[]>();
        for (Map.Entry<PortablePath, InternalResource> kv : this.fileContents.entrySet()) {
            bytesMap.put(kv.getKey(), this.resourceToBytes(kv.getValue()));
        }
        return bytesMap;
    }

    private byte[] resourceToBytes(Resource resource) {
        return resource != null ? ((InternalResource)resource).getBytes() : null;
    }

    @Override
    public File getFile(PortablePath path) {
        PortablePath parent = path.getParent();
        return new MemoryFile(this, path.getFileName(), parent != null ? this.getFolder(parent) : this.getRootFolder());
    }

    @Override
    public Folder getFolder(PortablePath path) {
        return this.folderMap.computeIfAbsent(path, p -> new MemoryFolder(this, (PortablePath)p));
    }

    public Set<? extends FileSystemItem> getMembers(Folder folder) {
        return this.folders.get(folder.getPath());
    }

    public byte[] getFileContents(MemoryFile file) {
        return this.resourceToBytes(this.getResource(file));
    }

    public InternalResource getResource(MemoryFile file) {
        return this.fileContents.get(file.getPath());
    }

    public void setFileContents(MemoryFile file, byte[] contents) throws IOException {
        this.setFileContents(file, new ByteArrayResource(contents));
    }

    public void setFileContents(MemoryFile file, Resource resource) throws IOException {
        if (!this.existsFolder((MemoryFolder)file.getFolder())) {
            this.createFolder((MemoryFolder)file.getFolder());
        }
        PortablePath filePath = file.getPath();
        if (this.modifiedFilesSinceLastMark != null) {
            byte[] contents = this.resourceToBytes(resource);
            byte[] oldContent = this.resourceToBytes(this.fileContents.get(filePath));
            if (oldContent == null || !Arrays.equals(oldContent, contents)) {
                this.modifiedFilesSinceLastMark.add(filePath.asString());
            }
        }
        this.fileContents.put(filePath, (InternalResource)resource);
        resource.setSourcePath(file.getPath().asString());
        this.folders.get(file.getFolder().getPath()).add(file);
    }

    @Override
    public void mark() {
        this.modifiedFilesSinceLastMark = new HashSet<String>();
    }

    @Override
    public Collection<String> getModifiedResourcesSinceLastMark() {
        return this.modifiedFilesSinceLastMark;
    }

    public boolean existsFolder(MemoryFolder folder) {
        return this.existsFolder(folder.getPath());
    }

    public boolean existsFolder(PortablePath path) {
        return this.folders.get(path) != null;
    }

    public boolean existsFile(PortablePath path) {
        return this.fileContents.containsKey(path);
    }

    public void createFolder(MemoryFolder folder) {
        if (!this.existsFolder(folder)) {
            if (!this.existsFolder((MemoryFolder)folder.getParent())) {
                this.createFolder((MemoryFolder)folder.getParent());
            }
            this.folders.put(folder.getPath(), new HashSet());
            Folder parent = folder.getParent();
            this.folders.get(parent.getPath()).add(folder);
        }
    }

    @Override
    public boolean remove(Folder folder) {
        if (folder.exists()) {
            this.remove(this.folders.get(folder.getPath()));
            this.folders.remove(folder.getPath());
            return true;
        }
        return false;
    }

    public void remove(Set<FileSystemItem> members) {
        Iterator<FileSystemItem> it = members.iterator();
        while (it.hasNext()) {
            FileSystemItem res = it.next();
            if (res instanceof Folder) {
                this.remove(this.folders.get(res.getPath()));
            } else {
                PortablePath filePath = res.getPath();
                this.fileContents.remove(filePath);
                if (this.modifiedFilesSinceLastMark != null) {
                    this.modifiedFilesSinceLastMark.add(filePath.asString());
                }
            }
            it.remove();
        }
    }

    @Override
    public boolean remove(File file) {
        if (file.exists()) {
            PortablePath filePath = file.getPath();
            this.fileContents.remove(filePath);
            if (this.modifiedFilesSinceLastMark != null) {
                this.modifiedFilesSinceLastMark.add(filePath.asString());
            }
            this.folders.get(((MemoryFile)file).getFolder().getPath()).remove(file);
            return true;
        }
        return false;
    }

    public int copyFolder(Folder srcFolder, MemoryFileSystem trgMfs, Folder trgFolder, String ... filters) {
        return MemoryFileSystem.copyFolder(this, srcFolder, trgMfs, trgFolder, 0, filters);
    }

    private static int copyFolder(MemoryFileSystem srcMfs, Folder srcFolder, MemoryFileSystem trgMfs, Folder trgFolder, int count, String ... filters) {
        if (!trgFolder.exists()) {
            trgMfs.getFolder(trgFolder.getPath()).create();
        }
        if (srcFolder != null) {
            for (FileSystemItem fileSystemItem : srcFolder.getMembers()) {
                if (fileSystemItem instanceof Folder) {
                    count = MemoryFileSystem.copyFolder(srcMfs, (Folder)fileSystemItem, trgMfs, trgFolder.getFolder(((Folder)fileSystemItem).getName()), count, filters);
                    continue;
                }
                MemoryFile trgFile = (MemoryFile)trgFolder.getFile(((File)fileSystemItem).getName());
                boolean accept = false;
                if (filters == null || filters.length == 0) {
                    accept = true;
                } else {
                    for (String filter : filters) {
                        if (!trgFile.getName().endsWith(filter)) continue;
                        accept = true;
                        break;
                    }
                }
                if (!accept) continue;
                try {
                    trgMfs.setFileContents(trgFile, srcMfs.getResource((MemoryFile)fileSystemItem));
                    ++count;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return count;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fileContents.hashCode();
        result = 31 * result + (this.folder == null ? 0 : this.folder.hashCode());
        result = 31 * result + this.folders.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryFileSystem other = (MemoryFileSystem)obj;
        if (this.folder == null ? other.folder != null : !this.folder.equals(other.folder)) {
            return false;
        }
        return this.fileContents.equals(other.fileContents) && this.folders.equals(other.folders);
    }

    public String toString() {
        return "MemoryFileSystem [folder=" + this.folder + ", folders=" + this.folders + ", fileContents=" + this.fileContents + "]";
    }

    public void printFs(PrintStream out) {
        this.printFs(this.getRootFolder(), out);
    }

    public void printFs(Folder f, PrintStream out) {
        for (FileSystemItem fileSystemItem : f.getMembers()) {
            out.println(fileSystemItem);
            if (fileSystemItem instanceof Folder) {
                this.printFs((Folder)fileSystemItem, out);
                continue;
            }
            out.println(new String(this.getFileContents((MemoryFile)fileSystemItem), IoUtils.UTF8_CHARSET));
        }
    }

    @Override
    public boolean isAvailable(PortablePath resourcePath) {
        return this.existsFile(resourcePath);
    }

    @Override
    public byte[] getBytes(PortablePath resourcePath) {
        return this.getFileContents((MemoryFile)this.getFile(resourcePath));
    }

    public InternalResource getResource(PortablePath resourcePath) {
        return this.getResource((MemoryFile)this.getFile(resourcePath));
    }

    @Override
    public void write(PortablePath resourcePath, byte[] pResourceData) {
        this.write(resourcePath, pResourceData, false);
    }

    @Override
    public void write(PortablePath resourcePath, byte[] pResourceData, boolean createFolder) {
        this.write(resourcePath, new ByteArrayResource(pResourceData), createFolder);
    }

    public void write(PortablePath resourcePath, Resource resource) {
        this.write(resourcePath, resource, false);
    }

    public void write(PortablePath resourcePath, Resource resource, boolean createFolder) {
        PortablePath folderPath;
        MemoryFile memoryFile = (MemoryFile)this.getFile(resourcePath);
        if (createFolder && !this.existsFolder(folderPath = memoryFile.getFolder().getPath())) {
            memoryFile.getFolder().create();
        }
        try {
            this.setFileContents(memoryFile, resource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] read(PortablePath resourcePath) {
        return this.getBytes(resourcePath);
    }

    @Override
    public void remove(PortablePath resourcePath) {
        this.remove(this.getFile(resourcePath));
    }

    public byte[] writeAsBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.zip(baos);
        return baos.toByteArray();
    }

    public java.io.File writeAsJar(java.io.File folder, String jarName) {
        try {
            java.io.File jarFile = new java.io.File(folder, jarName + ".jar");
            System.out.println(jarFile);
            this.zip(new FileOutputStream(jarFile));
            return jarFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void zip(OutputStream outputStream) {
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(outputStream);
            this.writeJarEntries(this.getRootFolder(), out);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public void writeAsFs(java.io.File file) {
        file.mkdir();
        this.writeAsFs(this.getRootFolder(), file);
    }

    public void writeAsFs(Folder f, java.io.File file1) {
        for (FileSystemItem fileSystemItem : f.getMembers()) {
            if (fileSystemItem instanceof Folder) {
                java.io.File file2 = new java.io.File(file1, ((Folder)fileSystemItem).getName());
                file2.mkdir();
                this.writeAsFs((Folder)fileSystemItem, file2);
                continue;
            }
            byte[] bytes = this.getFileContents((MemoryFile)fileSystemItem);
            try {
                IoUtils.write(new java.io.File(file1, ((File)fileSystemItem).getName()), bytes);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write project to file system\n", e);
            }
        }
    }

    private void writeJarEntries(Folder f, ZipOutputStream out) throws IOException {
        for (FileSystemItem fileSystemItem : f.getMembers()) {
            ZipEntry entry;
            Object rname = fileSystemItem.getPath().asString();
            if (fileSystemItem instanceof Folder) {
                rname = ((String)rname).endsWith("/") ? rname : (String)rname + "/";
                entry = new ZipEntry((String)rname);
                out.putNextEntry(entry);
                this.writeJarEntries((Folder)fileSystemItem, out);
                continue;
            }
            entry = new ZipEntry((String)rname);
            out.putNextEntry(entry);
            byte[] contents = this.getFileContents((MemoryFile)fileSystemItem);
            if (contents == null) {
                IOException e = new IOException("No content found for: " + fileSystemItem);
                log.error(e.getMessage(), e);
                throw e;
            }
            out.write(contents);
            out.closeEntry();
        }
    }

    public static MemoryFileSystem readFromJar(java.io.File jarFile) {
        MemoryFileSystem mfs = new MemoryFileSystem();
        try (ZipFile zipFile = new ZipFile(jarFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                int separator = entry.getName().lastIndexOf(47);
                PortablePath path = separator > 0 ? PortablePath.of(entry.getName().substring(0, separator)) : PortablePath.ROOT_PATH;
                String name = entry.getName().substring(separator + 1);
                Folder folder = mfs.getFolder(path);
                folder.create();
                File file = folder.getFile(name);
                file.create(zipFile.getInputStream(entry));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return mfs;
    }

    public static MemoryFileSystem readFromJar(byte[] jarFile) {
        return MemoryFileSystem.readFromJar(new ByteArrayInputStream(jarFile));
    }

    public static MemoryFileSystem readFromJar(InputStream jarFile) {
        MemoryFileSystem mfs = new MemoryFileSystem();
        try (JarInputStream zipFile = new JarInputStream(jarFile);){
            ZipEntry entry;
            while ((entry = zipFile.getNextEntry()) != null) {
                int b;
                if (entry.isDirectory()) continue;
                ByteArrayOutputStream content = new ByteArrayOutputStream();
                while ((b = zipFile.read()) != -1) {
                    content.write(b);
                }
                mfs.write(entry.getName(), content.toByteArray(), true);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return mfs;
    }

    public String findPomProperties() {
        for (Map.Entry<PortablePath, InternalResource> content : this.fileContents.entrySet()) {
            String string;
            block9: {
                if (!content.getKey().endsWith("pom.properties") || !content.getKey().startsWith("META-INF/maven/")) continue;
                InputStream resourceStream = content.getValue().getInputStream();
                try {
                    string = StringUtils.readFileAsString(new InputStreamReader(resourceStream, IoUtils.UTF8_CHARSET));
                    if (resourceStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (resourceStream != null) {
                            try {
                                resourceStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                resourceStream.close();
            }
            return string;
        }
        return null;
    }

    public MemoryFileSystem clone() {
        MemoryFileSystem clone = new MemoryFileSystem();
        for (Map.Entry<PortablePath, InternalResource> entry : this.fileContents.entrySet()) {
            clone.write(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    public ClassLoader memoryClassLoader(ClassLoader parent) {
        return new ByteClassLoader(parent, this);
    }

    static class ByteClassLoader
    extends URLClassLoader {
        private final Map<String, byte[]> extraClassDefs = new HashMap<String, byte[]>();

        public ByteClassLoader(ClassLoader parent, MemoryFileSystem memoryFileSystem) {
            super(new URL[0], parent);
            memoryFileSystem.getFilePaths().stream().filter(fn -> fn.endsWith(".class")).forEach(f -> {
                MemoryFile file = (MemoryFile)memoryFileSystem.getFile((PortablePath)f);
                byte[] fileContents = memoryFileSystem.getFileContents(file);
                this.extraClassDefs.put(f.asClassName(), fileContents);
            });
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] classBytes = this.extraClassDefs.remove(name);
            if (classBytes != null) {
                return this.defineClass(name, classBytes, 0, classBytes.length);
            }
            return super.findClass(name);
        }
    }
}

