/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.compiler.builder.impl.AssetFilter;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.builder.impl.processors.CompilationPhase;
import org.drools.compiler.builder.impl.processors.ImmutableRuleCompilationPhase;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.kie.api.definition.rule.Rule;
import org.kie.api.io.Resource;
import org.kie.internal.builder.ResourceChange;

public class RuleCompilationPhase
extends ImmutableRuleCompilationPhase {
    private InternalKnowledgeBase kBase;
    private final AssetFilter assetFilter;

    public static CompilationPhase of(PackageRegistry pkgRegistry, PackageDescr packageDescr, InternalKnowledgeBase kBase, int parallelRulesBuildThreshold, AssetFilter assetFilter, Map<String, AttributeDescr> packageAttributes, Resource resource, TypeDeclarationContext typeDeclarationContext) {
        if (kBase == null) {
            return new ImmutableRuleCompilationPhase(pkgRegistry, packageDescr, parallelRulesBuildThreshold, packageAttributes, resource, typeDeclarationContext);
        }
        return new RuleCompilationPhase(pkgRegistry, packageDescr, kBase, parallelRulesBuildThreshold, assetFilter, packageAttributes, resource, typeDeclarationContext);
    }

    private RuleCompilationPhase(PackageRegistry pkgRegistry, PackageDescr packageDescr, InternalKnowledgeBase kBase, int parallelRulesBuildThreshold, AssetFilter assetFilter, Map<String, AttributeDescr> packageAttributes, Resource resource, TypeDeclarationContext typeDeclarationContext) {
        super(pkgRegistry, packageDescr, parallelRulesBuildThreshold, packageAttributes, resource, typeDeclarationContext);
        this.kBase = kBase;
        this.assetFilter = assetFilter;
    }

    @Override
    public void process() {
        this.preProcessRules(this.packageDescr, this.pkgRegistry);
        super.process();
    }

    @Override
    protected boolean parallelRulesBuild(List<RuleDescr> rules) {
        return false;
    }

    private void preProcessRules(PackageDescr packageDescr, PackageRegistry pkgRegistry) {
        InternalKnowledgePackage pkg = pkgRegistry.getPackage();
        boolean needsRemoval = false;
        for (Rule rule : pkg.getRules()) {
            if (!this.filterAcceptsRemoval(ResourceChange.Type.RULE, rule.getPackageName(), rule.getName())) continue;
            needsRemoval = true;
            break;
        }
        if (!needsRemoval) {
            for (RuleDescr ruleDescr : packageDescr.getRules()) {
                if (!this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName()) || pkg.getRule(ruleDescr.getName()) == null) continue;
                needsRemoval = true;
                break;
            }
        }
        if (needsRemoval) {
            this.kBase.enqueueModification(() -> {
                HashSet<RuleImpl> rulesToBeRemoved = new HashSet<RuleImpl>();
                for (Rule rule : pkg.getRules()) {
                    if (!this.filterAcceptsRemoval(ResourceChange.Type.RULE, rule.getPackageName(), rule.getName())) continue;
                    rulesToBeRemoved.add((RuleImpl)rule);
                }
                rulesToBeRemoved.forEach(pkg::removeRule);
                for (RuleDescr ruleDescr : packageDescr.getRules()) {
                    RuleImpl rule;
                    if (!this.filterAccepts(ResourceChange.Type.RULE, ruleDescr.getNamespace(), ruleDescr.getName()) || (rule = pkg.getRule(ruleDescr.getName())) == null) continue;
                    rulesToBeRemoved.add(rule);
                }
                if (!rulesToBeRemoved.isEmpty()) {
                    rulesToBeRemoved.addAll(this.findChildrenRulesToBeRemoved(packageDescr, rulesToBeRemoved));
                    this.kBase.removeRules(rulesToBeRemoved);
                }
            });
        }
    }

    @Override
    protected boolean filterAccepts(ResourceChange.Type type, String namespace, String name) {
        return this.assetFilter == null || !AssetFilter.Action.DO_NOTHING.equals((Object)this.assetFilter.accept(type, namespace, name));
    }

    private boolean filterAcceptsRemoval(ResourceChange.Type type, String namespace, String name) {
        return this.assetFilter != null && AssetFilter.Action.REMOVE.equals((Object)this.assetFilter.accept(type, namespace, name));
    }

    private Collection<RuleImpl> findChildrenRulesToBeRemoved(PackageDescr packageDescr, Collection<RuleImpl> rulesToBeRemoved) {
        HashSet<String> childrenRuleNamesToBeRemoved = new HashSet<String>();
        HashSet<RuleImpl> childrenRulesToBeRemoved = new HashSet<RuleImpl>();
        for (RuleImpl rule : rulesToBeRemoved) {
            if (!rule.hasChildren()) continue;
            for (RuleImpl child : rule.getChildren()) {
                if (rulesToBeRemoved.contains(child)) continue;
                childrenRulesToBeRemoved.add(child);
                childrenRuleNamesToBeRemoved.add(child.getName());
                RuleDescr toBeReadded = new RuleDescr(child.getName());
                toBeReadded.setNamespace(packageDescr.getNamespace());
                packageDescr.addRule(toBeReadded);
            }
        }
        if (!childrenRuleNamesToBeRemoved.isEmpty()) {
            ((CompositePackageDescr)packageDescr).addFilter((type, pkgName, assetName) -> childrenRuleNamesToBeRemoved.contains(assetName) ? AssetFilter.Action.UPDATE : AssetFilter.Action.DO_NOTHING);
        }
        return childrenRulesToBeRemoved;
    }
}

