/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.util.Collection;
import org.drools.compiler.builder.impl.processors.AnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.CompilationPhase;
import org.drools.drl.ast.descr.AnnotatedBaseDescr;
import org.drools.drl.ast.descr.BaseDescr;
import org.drools.drl.ast.descr.ConditionalElementDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.PatternDescr;
import org.drools.drl.ast.descr.PatternDestinationDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class RuleAnnotationNormalizer
implements CompilationPhase {
    private final AnnotationNormalizer annotationNormalizer;
    private final PackageDescr packageDescr;

    public RuleAnnotationNormalizer(AnnotationNormalizer annotationNormalizer, PackageDescr packageDescr) {
        this.annotationNormalizer = annotationNormalizer;
        this.packageDescr = packageDescr;
    }

    @Override
    public void process() {
        for (RuleDescr ruleDescr : this.packageDescr.getRules()) {
            this.annotationNormalizer.normalize(ruleDescr);
            this.traverseAnnotations(ruleDescr.getLhs());
        }
    }

    @Override
    public Collection<? extends KnowledgeBuilderResult> getResults() {
        return this.annotationNormalizer.getResults();
    }

    private void traverseAnnotations(BaseDescr descr) {
        if (descr instanceof AnnotatedBaseDescr) {
            this.annotationNormalizer.normalize((AnnotatedBaseDescr)descr);
        }
        if (descr instanceof ConditionalElementDescr) {
            for (BaseDescr baseDescr : ((ConditionalElementDescr)((Object)descr)).getDescrs()) {
                this.traverseAnnotations(baseDescr);
            }
        }
        if (descr instanceof PatternDescr && ((PatternDescr)descr).getSource() != null) {
            this.traverseAnnotations(((PatternDescr)descr).getSource());
        }
        if (descr instanceof PatternDestinationDescr) {
            this.traverseAnnotations(((PatternDestinationDescr)((Object)descr)).getInputPattern());
        }
    }
}

