/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.drools.compiler.builder.PackageRegistryManager;
import org.drools.compiler.builder.impl.BuildResultCollector;
import org.drools.compiler.builder.impl.GlobalVariableContext;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.TypeDeclarationBuilder;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.builder.impl.processors.AccumulateFunctionCompilationPhase;
import org.drools.compiler.builder.impl.processors.AnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.CompilationPhase;
import org.drools.compiler.builder.impl.processors.EntryPointDeclarationCompilationPhase;
import org.drools.compiler.builder.impl.processors.FunctionCompilationPhase;
import org.drools.compiler.builder.impl.processors.GlobalCompilationPhase;
import org.drools.compiler.builder.impl.processors.ImportCompilationPhase;
import org.drools.compiler.builder.impl.processors.IteratingPhase;
import org.drools.compiler.builder.impl.processors.RuleAnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.SinglePackagePhaseFactory;
import org.drools.compiler.builder.impl.processors.TypeDeclarationAnnotationNormalizer;
import org.drools.compiler.builder.impl.processors.TypeDeclarationCompositeCompilationPhase;
import org.drools.compiler.builder.impl.processors.WindowDeclarationCompilationPhase;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.util.StringUtils;
import org.drools.util.TypeResolver;
import org.kie.api.conf.OptionKey;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.builder.conf.LanguageLevelOption;

public class CompositePackageCompilationPhase
implements CompilationPhase {
    private final Collection<CompositePackageDescr> packages;
    private final PackageRegistryManager pkgRegistryManager;
    private final TypeDeclarationBuilder typeBuilder;
    private GlobalVariableContext globalVariableContext;
    private TypeDeclarationContext typeDeclarationContext;
    private final InternalKnowledgeBase kBase;
    private final KnowledgeBuilderConfigurationImpl configuration;
    private final BuildResultCollector buildResultCollector;

    public CompositePackageCompilationPhase(Collection<CompositePackageDescr> packages, PackageRegistryManager pkgRegistryManager, TypeDeclarationBuilder typeBuilder, GlobalVariableContext globalVariableContext, TypeDeclarationContext typeDeclarationContext, BuildResultCollector buildResultCollector, InternalKnowledgeBase kBase, KnowledgeBuilderConfigurationImpl configuration) {
        this.packages = packages;
        this.pkgRegistryManager = pkgRegistryManager;
        this.typeBuilder = typeBuilder;
        this.globalVariableContext = globalVariableContext;
        this.typeDeclarationContext = typeDeclarationContext;
        this.buildResultCollector = buildResultCollector;
        this.kBase = kBase;
        this.configuration = configuration;
    }

    @Override
    public void process() {
        Map<String, Supplier<AnnotationNormalizer>> annotationNormalizers = this.initAnnotationNormalizers();
        List<CompilationPhase> phases = Arrays.asList(this.iteratingPhase((pkgRegistry, packageDescr) -> new TypeDeclarationAnnotationNormalizer((AnnotationNormalizer)((Supplier)annotationNormalizers.get(packageDescr.getNamespace())).get(), packageDescr)), new TypeDeclarationCompositeCompilationPhase(this.packages, this.typeBuilder), this.iteratingPhase(ImportCompilationPhase::new), this.iteratingPhase(EntryPointDeclarationCompilationPhase::new), this.iteratingPhase(AccumulateFunctionCompilationPhase::new), this.iteratingPhase((reg, desc) -> new WindowDeclarationCompilationPhase(reg, (PackageDescr)desc, this.typeDeclarationContext)), this.iteratingPhase((reg, desc) -> new FunctionCompilationPhase(reg, (PackageDescr)desc, this.configuration)), this.iteratingPhase((reg, desc) -> GlobalCompilationPhase.of(reg, desc, this.kBase, this.globalVariableContext, desc.getFilter())), this.iteratingPhase((pkgRegistry, packageDescr) -> new RuleAnnotationNormalizer((AnnotationNormalizer)((Supplier)annotationNormalizers.get(packageDescr.getNamespace())).get(), packageDescr)));
        for (CompilationPhase phase : phases) {
            phase.process();
            phase.getResults().forEach(this.buildResultCollector::addBuilderResult);
        }
    }

    private Map<String, Supplier<AnnotationNormalizer>> initAnnotationNormalizers() {
        HashMap<String, Supplier<AnnotationNormalizer>> annotationNormalizers = new HashMap<String, Supplier<AnnotationNormalizer>>();
        boolean isStrict = ((LanguageLevelOption)this.configuration.getOption((OptionKey)LanguageLevelOption.KEY)).useJavaAnnotations();
        for (CompositePackageDescr packageDescr : this.packages) {
            if (StringUtils.isEmpty(packageDescr.getName())) {
                packageDescr.setName(this.configuration.getDefaultPackageName());
            }
            PackageRegistry pkgRegistry = this.pkgRegistryManager.getOrCreatePackageRegistry(packageDescr);
            TypeResolver typeResolver = pkgRegistry.getTypeResolver();
            annotationNormalizers.put(packageDescr.getNamespace(), () -> AnnotationNormalizer.of(typeResolver, isStrict));
        }
        return annotationNormalizers;
    }

    private IteratingPhase iteratingPhase(SinglePackagePhaseFactory phaseFactory) {
        return new IteratingPhase(this.packages, this.pkgRegistryManager, phaseFactory);
    }

    @Override
    public Collection<? extends KnowledgeBuilderResult> getResults() {
        return this.buildResultCollector.getResults(ResultSeverity.INFO, ResultSeverity.WARNING, ResultSeverity.ERROR);
    }
}

