/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl.processors;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.compiler.compiler.AnnotationDeclarationError;
import org.drools.drl.ast.descr.AnnotatedBaseDescr;
import org.drools.drl.ast.descr.AnnotationDescr;
import org.drools.util.StringUtils;
import org.drools.util.TypeResolver;
import org.kie.internal.builder.KnowledgeBuilderResult;

public abstract class AnnotationNormalizer {
    protected final TypeResolver typeResolver;
    protected final Collection<KnowledgeBuilderResult> results;

    AnnotationNormalizer(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
        this.results = new ArrayList<KnowledgeBuilderResult>();
    }

    public static AnnotationNormalizer of(TypeResolver typeResolver, boolean isStrict) {
        if (isStrict) {
            return new Strict(typeResolver);
        }
        return new NonStrict(typeResolver);
    }

    abstract boolean isStrict();

    abstract AnnotationDescr doNormalize(AnnotationDescr var1);

    public void normalize(AnnotatedBaseDescr annotationsContainer) {
        for (AnnotationDescr annotationDescr : annotationsContainer.getAnnotations()) {
            annotationDescr.setResource(annotationsContainer.getResource());
            annotationDescr.setStrict(this.isStrict());
            if (annotationDescr.isDuplicated()) {
                this.results.add(new AnnotationDeclarationError(annotationDescr, "Duplicated annotation: " + annotationDescr.getName()));
            }
            this.doNormalize(annotationDescr);
        }
        annotationsContainer.indexByFQN(this.isStrict());
    }

    public Collection<KnowledgeBuilderResult> getResults() {
        return this.results;
    }

    static class NonStrict
    extends AnnotationNormalizer {
        public NonStrict(TypeResolver typeResolver) {
            super(typeResolver);
        }

        @Override
        boolean isStrict() {
            return false;
        }

        @Override
        AnnotationDescr doNormalize(AnnotationDescr annotationDescr) {
            Class<?> annotationClass = null;
            try {
                annotationClass = this.typeResolver.resolveType(annotationDescr.getName(), TypeResolver.ONLY_ANNOTATION_CLASS_FILTER);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                String className = this.normalizeAnnotationNonStrictName(annotationDescr.getName());
                try {
                    annotationClass = this.typeResolver.resolveType(className, TypeResolver.ONLY_ANNOTATION_CLASS_FILTER);
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                    // empty catch block
                }
            }
            if (annotationClass != null) {
                annotationDescr.setFullyQualifiedName(annotationClass.getCanonicalName());
                for (String key : annotationDescr.getValueMap().keySet()) {
                    try {
                        Method m = annotationClass.getMethod(key, new Class[0]);
                        Object[] val = annotationDescr.getValue(key);
                        if (val instanceof Object[] && !m.getReturnType().isArray()) {
                            this.results.add(new AnnotationDeclarationError(annotationDescr, "Wrong cardinality on property " + key));
                            return annotationDescr;
                        }
                        if (m.getReturnType().isArray() && !(val instanceof Object[])) {
                            val = new Object[]{val};
                            annotationDescr.setKeyValue(key, val);
                        }
                        if (m.getReturnType().isArray()) {
                            int n = Array.getLength(val);
                            for (int j = 0; j < n; ++j) {
                                if (Class.class.equals(m.getReturnType().getComponentType())) {
                                    String className = Array.get(val, j).toString().replace(".class", "");
                                    Array.set(val, j, this.typeResolver.resolveType(className).getName() + ".class");
                                    continue;
                                }
                                if (!m.getReturnType().getComponentType().isAnnotation()) continue;
                                Array.set(val, j, this.doNormalize((AnnotationDescr)Array.get(val, j)));
                            }
                            continue;
                        }
                        if (Class.class.equals(m.getReturnType())) {
                            String className = annotationDescr.getValueAsString(key).replace(".class", "");
                            annotationDescr.setKeyValue(key, this.typeResolver.resolveType(className));
                            continue;
                        }
                        if (!m.getReturnType().isAnnotation()) continue;
                        annotationDescr.setKeyValue(key, this.doNormalize((AnnotationDescr)annotationDescr.getValue(key)));
                    }
                    catch (NoSuchMethodException e) {
                        this.results.add(new AnnotationDeclarationError(annotationDescr, "Unknown annotation property " + key));
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError e) {
                        this.results.add(new AnnotationDeclarationError(annotationDescr, "Unknown class " + annotationDescr.getValue(key) + " used in property " + key + " of annotation " + annotationDescr.getName()));
                    }
                }
            }
            return annotationDescr;
        }

        private String normalizeAnnotationNonStrictName(String name) {
            if ("typesafe".equalsIgnoreCase(name)) {
                return "TypeSafe";
            }
            return StringUtils.ucFirst(name);
        }
    }

    static class Strict
    extends AnnotationNormalizer {
        public Strict(TypeResolver typeResolver) {
            super(typeResolver);
        }

        @Override
        boolean isStrict() {
            return true;
        }

        @Override
        AnnotationDescr doNormalize(AnnotationDescr annotationDescr) {
            try {
                Class<?> annotationClass = this.typeResolver.resolveType(annotationDescr.getName(), TypeResolver.ONLY_ANNOTATION_CLASS_FILTER);
                annotationDescr.setFullyQualifiedName(annotationClass.getCanonicalName());
                return annotationDescr;
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                this.results.add(new AnnotationDeclarationError(annotationDescr, "Unknown annotation: " + annotationDescr.getName()));
                return null;
            }
        }
    }
}

