/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import org.drools.compiler.builder.PackageRegistryManager;
import org.drools.compiler.builder.impl.InternalKnowledgeBaseProvider;
import org.drools.compiler.builder.impl.PackageAttributeManagerImpl;
import org.drools.compiler.builder.impl.PackageDescrManager;
import org.drools.compiler.builder.impl.PackageRegistryCompiler;
import org.drools.compiler.builder.impl.RootClassLoaderProvider;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.util.StringUtils;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.conf.DefaultDialectOption;
import org.kie.internal.builder.conf.DefaultPackageNameOption;

public class PackageRegistryManagerImpl
implements PackageRegistryManager,
PackageRegistryCompiler,
PackageDescrManager {
    private final KnowledgeBuilderConfiguration configuration;
    private final RootClassLoaderProvider rootClassLoaderProvider;
    private final InternalKnowledgeBaseProvider kBaseProvider;
    private final Map<String, PackageRegistry> pkgRegistryMap = new ConcurrentHashMap<String, PackageRegistry>();
    private final PackageAttributeManagerImpl packageAttributes;
    private final Map<String, List<PackageDescr>> packages = new ConcurrentHashMap<String, List<PackageDescr>>();

    public PackageRegistryManagerImpl(KnowledgeBuilderConfiguration configuration, RootClassLoaderProvider rootClassLoaderProvider, InternalKnowledgeBaseProvider kBaseProvider) {
        this.configuration = configuration;
        this.rootClassLoaderProvider = rootClassLoaderProvider;
        this.kBaseProvider = kBaseProvider;
        this.packageAttributes = new PackageAttributeManagerImpl();
    }

    @Override
    public List<PackageDescr> getPackageDescrs(String packageName) {
        return this.packages.get(packageName);
    }

    public PackageAttributeManagerImpl getPackageAttributes() {
        return this.packageAttributes;
    }

    @Override
    public Collection<List<PackageDescr>> getPackageDescrs() {
        return this.packages.values();
    }

    @Override
    public void registerPackage(PackageDescr packageDescr) {
        if (StringUtils.isEmpty(packageDescr.getNamespace())) {
            packageDescr.setNamespace(this.configuration.getOption(DefaultDialectOption.KEY).dialectName());
        }
        this.initPackage(packageDescr);
    }

    @Override
    public PackageRegistry getPackageRegistry(String packageName) {
        return this.pkgRegistryMap.get(packageName);
    }

    @Override
    public PackageRegistry getOrCreatePackageRegistry(PackageDescr packageDescr) {
        if (packageDescr == null) {
            return null;
        }
        if (StringUtils.isEmpty(packageDescr.getNamespace())) {
            packageDescr.setNamespace(this.configuration.getOption(DefaultPackageNameOption.KEY).packageName());
        }
        return this.pkgRegistryMap.computeIfAbsent(packageDescr.getName(), name -> this.createPackageRegistry(packageDescr));
    }

    @Override
    public Map<String, PackageRegistry> getPackageRegistry() {
        return this.pkgRegistryMap;
    }

    @Override
    public Collection<String> getPackageNames() {
        return this.pkgRegistryMap.keySet();
    }

    private PackageRegistry createPackageRegistry(PackageDescr packageDescr) {
        InternalKnowledgePackage pkg;
        this.initPackage(packageDescr);
        InternalKnowledgeBase kBase = this.kBaseProvider.getKnowledgeBase();
        ClassLoader rootClassLoader = this.rootClassLoaderProvider.getRootClassLoader();
        if (kBase == null || (pkg = kBase.getPackage(packageDescr.getName())) == null) {
            pkg = CoreComponentFactory.get().createKnowledgePackage(packageDescr.getName());
            pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(rootClassLoader));
            if (kBase != null) {
                try {
                    pkg = (InternalKnowledgePackage)kBase.addPackage(pkg).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            } else {
                pkg.getDialectRuntimeRegistry().onAdd(rootClassLoader);
            }
        }
        PackageRegistry pkgRegistry = new PackageRegistry(rootClassLoader, this.configuration, pkg);
        pkgRegistry.addImport(new ImportDescr(packageDescr.getNamespace() + ".*"));
        for (ImportDescr importDescr : packageDescr.getImports()) {
            pkgRegistry.registerImport(importDescr.getTarget());
        }
        pkgRegistry.setDialect(this.getPackageDialect(packageDescr));
        return pkgRegistry;
    }

    private void initPackage(PackageDescr packageDescr) {
        List packageDescrsForPackage = this.packages.computeIfAbsent(packageDescr.getName(), k -> new ArrayList());
        packageDescrsForPackage.add(packageDescr);
        HashSet<ImportDescr> imports = new HashSet<ImportDescr>();
        for (PackageDescr pd : packageDescrsForPackage) {
            imports.addAll(pd.getImports());
        }
        for (PackageDescr pd : packageDescrsForPackage) {
            pd.getImports().clear();
            pd.addAllImports(imports);
        }
        if (!packageDescr.getAttributes().isEmpty()) {
            Map<String, AttributeDescr> pkgAttributes = this.packageAttributes.get(packageDescr.getNamespace());
            if (pkgAttributes == null) {
                pkgAttributes = new HashMap<String, AttributeDescr>();
                this.packageAttributes.put(packageDescr.getNamespace(), pkgAttributes);
            }
            for (AttributeDescr attr : packageDescr.getAttributes()) {
                pkgAttributes.put(attr.getName(), attr);
            }
        }
    }

    private String getPackageDialect(PackageDescr packageDescr) {
        String dialectName = this.configuration.getOption(DefaultDialectOption.KEY).dialectName();
        for (AttributeDescr value : packageDescr.getAttributes()) {
            if (!"dialect".equals(value.getName())) continue;
            dialectName = value.getValue();
            break;
        }
        return dialectName;
    }

    @Override
    public void compileAll() {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            pkgRegistry.compileAll();
        }
    }

    @Override
    public void reloadAll() {
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            pkgRegistry.getDialectRuntimeRegistry().onBeforeExecute();
        }
    }

    @Override
    public Collection<KnowledgeBuilderResult> getResults() {
        List<KnowledgeBuilderResult> results = new ArrayList<KnowledgeBuilderResult>();
        for (PackageRegistry pkgRegistry : this.pkgRegistryMap.values()) {
            results = pkgRegistry.getDialectCompiletimeRegistry().addResults(results);
        }
        return results;
    }
}

