/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import java.util.function.Supplier;
import org.drools.compiler.builder.InternalKnowledgeBuilder;
import org.drools.compiler.builder.PackageRegistryManager;
import org.drools.compiler.builder.impl.AssetFilter;
import org.drools.compiler.builder.impl.BuildResultCollector;
import org.drools.compiler.builder.impl.BuildResultCollectorImpl;
import org.drools.compiler.builder.impl.CompositeKnowledgeBuilderImpl;
import org.drools.compiler.builder.impl.DefaultTypeDeclarationBuilderFactory;
import org.drools.compiler.builder.impl.GlobalVariableContext;
import org.drools.compiler.builder.impl.GlobalVariableContextImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationImpl;
import org.drools.compiler.builder.impl.KnowledgeBuilderFactoryServiceImpl;
import org.drools.compiler.builder.impl.PackageRegistryManagerImpl;
import org.drools.compiler.builder.impl.ResourceHandlerManager;
import org.drools.compiler.builder.impl.TypeDeclarationBuilder;
import org.drools.compiler.builder.impl.TypeDeclarationBuilderFactory;
import org.drools.compiler.builder.impl.TypeDeclarationContext;
import org.drools.compiler.builder.impl.TypeDeclarationManagerImpl;
import org.drools.compiler.builder.impl.processors.CompilationPhase;
import org.drools.compiler.builder.impl.processors.CompositePackageCompilationPhase;
import org.drools.compiler.builder.impl.processors.ConsequenceCompilationPhase;
import org.drools.compiler.builder.impl.processors.FunctionCompiler;
import org.drools.compiler.builder.impl.processors.PackageCompilationPhase;
import org.drools.compiler.builder.impl.processors.ReteCompiler;
import org.drools.compiler.builder.impl.processors.RuleCompilationPhase;
import org.drools.compiler.builder.impl.processors.RuleValidator;
import org.drools.compiler.builder.impl.resources.ResourceHandler;
import org.drools.compiler.compiler.DroolsWarning;
import org.drools.compiler.compiler.DuplicateFunction;
import org.drools.compiler.compiler.PackageBuilderErrors;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.compiler.ProcessBuilder;
import org.drools.compiler.compiler.ProcessBuilderFactory;
import org.drools.compiler.compiler.ResourceTypeDeclarationWarning;
import org.drools.compiler.kie.builder.impl.BuildContext;
import org.drools.compiler.lang.descr.CompositePackageDescr;
import org.drools.core.base.ObjectType;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.impl.RuleBase;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.rule.ImportDeclaration;
import org.drools.core.rule.TypeDeclaration;
import org.drools.drl.ast.descr.AttributeDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.drl.parser.DroolsParserException;
import org.drools.drl.parser.ParserError;
import org.drools.drl.parser.lang.dsl.DSLMappingFile;
import org.drools.drl.parser.lang.dsl.DSLTokenizedMappingFile;
import org.drools.drl.parser.lang.dsl.DefaultExpander;
import org.drools.io.BaseResource;
import org.drools.io.InternalResource;
import org.drools.io.ReaderResource;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.drools.wiring.api.ComponentsFactory;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.rule.Rule;
import org.kie.api.internal.assembler.KieAssemblers;
import org.kie.api.internal.io.ResourceTypePackage;
import org.kie.api.internal.utils.KieService;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.api.io.ResourceWithConfiguration;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.KnowledgeBuilderResults;
import org.kie.internal.builder.ResourceChange;
import org.kie.internal.builder.ResultSeverity;
import org.kie.internal.builder.conf.DefaultDialectOption;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.internal.builder.conf.ParallelRulesBuildThresholdOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeBuilderImpl
implements InternalKnowledgeBuilder,
TypeDeclarationContext,
BuildResultCollector,
GlobalVariableContext {
    protected static final transient Logger logger = LoggerFactory.getLogger(KnowledgeBuilderImpl.class);
    private final PackageRegistryManagerImpl pkgRegistryManager;
    private final BuildResultCollectorImpl results;
    private final KnowledgeBuilderConfiguration configuration;
    private InternalKnowledgeBase kBase;
    private final String defaultDialect;
    private final ClassLoader rootClassLoader;
    private int parallelRulesBuildThreshold;
    private final GlobalVariableContext globals = new GlobalVariableContextImpl();
    private List<DSLTokenizedMappingFile> dslFiles;
    private final ProcessBuilder processBuilder;
    private final Deque<List<Resource>> buildResources = new ArrayDeque<List<Resource>>();
    private AssetFilter assetFilter = null;
    private TypeDeclarationManagerImpl typeDeclarationManager;
    private Map<String, Object> builderCache;
    private ReleaseId releaseId;
    private BuildContext buildContext;

    public KnowledgeBuilderImpl() {
        this((InternalKnowledgeBase)null, null);
    }

    public KnowledgeBuilderImpl(InternalKnowledgePackage pkg) {
        this(pkg, null);
    }

    public KnowledgeBuilderImpl(InternalKnowledgeBase kBase) {
        this(kBase, null);
    }

    public KnowledgeBuilderImpl(InternalKnowledgeBase kBase, KnowledgeBuilderConfiguration configuration) {
        this.configuration = configuration == null ? KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration() : configuration;
        this.rootClassLoader = kBase != null ? kBase.getRootClassLoader() : this.configuration.getClassLoader();
        this.defaultDialect = this.configuration.getOption(DefaultDialectOption.KEY).dialectName();
        this.parallelRulesBuildThreshold = this.configuration.getOption(ParallelRulesBuildThresholdOption.KEY).getParallelRulesBuildThreshold();
        this.results = new BuildResultCollectorImpl();
        this.kBase = kBase;
        this.pkgRegistryManager = new PackageRegistryManagerImpl(this.configuration, this, this);
        this.processBuilder = ProcessBuilderFactory.newProcessBuilder(this);
        this.typeDeclarationManager = new TypeDeclarationManagerImpl(this.createTypeDeclarationBuilder(), this.kBase);
    }

    public KnowledgeBuilderImpl(KnowledgeBuilderConfiguration configuration) {
        this((InternalKnowledgeBase)null, configuration);
    }

    public KnowledgeBuilderImpl(InternalKnowledgePackage pkg, KnowledgeBuilderConfiguration configuration) {
        this.configuration = configuration == null ? new KnowledgeBuilderFactoryServiceImpl().newKnowledgeBuilderConfiguration() : configuration;
        this.rootClassLoader = this.configuration.getClassLoader();
        this.defaultDialect = this.configuration.getOption(DefaultDialectOption.KEY).dialectName();
        this.parallelRulesBuildThreshold = this.configuration.getOption(ParallelRulesBuildThresholdOption.KEY).getParallelRulesBuildThreshold();
        this.results = new BuildResultCollectorImpl();
        this.pkgRegistryManager = new PackageRegistryManagerImpl(this.configuration, this, this);
        PackageRegistry pkgRegistry = new PackageRegistry(this.rootClassLoader, this.configuration, pkg);
        pkgRegistry.setDialect(this.defaultDialect);
        this.pkgRegistryManager.getPackageRegistry().put(pkg.getName(), pkgRegistry);
        for (ImportDeclaration implDecl : pkg.getImports().values()) {
            pkgRegistry.addImport(new ImportDescr(implDecl.getTarget()));
        }
        this.processBuilder = ProcessBuilderFactory.newProcessBuilder(this);
        this.typeDeclarationManager = new TypeDeclarationManagerImpl(this.createTypeDeclarationBuilder(), this.kBase);
    }

    private TypeDeclarationBuilder createTypeDeclarationBuilder() {
        TypeDeclarationBuilderFactory typeDeclarationBuilderFactory = Optional.ofNullable(KieService.load(TypeDeclarationBuilderFactory.class)).orElse(new DefaultTypeDeclarationBuilderFactory());
        return typeDeclarationBuilderFactory.createTypeDeclarationBuilder(this);
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    public void setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
    }

    public BuildContext getBuildContext() {
        if (this.buildContext == null) {
            this.buildContext = this.createBuildContext();
        }
        return this.buildContext;
    }

    protected BuildContext createBuildContext() {
        return new BuildContext();
    }

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    @Override
    public InternalKnowledgeBase getKnowledgeBase() {
        return this.kBase;
    }

    @Override
    public TypeDeclarationBuilder getTypeBuilder() {
        return this.typeDeclarationManager.getTypeDeclarationBuilder();
    }

    public void addPackageFromDrl(Reader reader) throws DroolsParserException, IOException {
        this.addPackageFromDrl(reader, new ReaderResource(reader, ResourceType.DRL));
    }

    public void addPackageFromDrl(Reader reader, Resource sourceResource) throws DroolsParserException, IOException {
        DrlParser parser = new DrlParser(this.configuration.getOption(LanguageLevelOption.KEY));
        PackageDescr pkg = parser.parse(sourceResource, reader);
        this.results.addAll(parser.getErrors());
        if (pkg == null) {
            this.addBuilderResult(new ParserError(sourceResource, "Parser returned a null Package", 0, 0));
        }
        if (!parser.hasErrors()) {
            this.addPackageWithResource(pkg, sourceResource);
        }
    }

    public static File createDumpDrlFile(File dumpDir, String fileName, String extension) {
        return new File(dumpDir, fileName.replaceAll("[^a-zA-Z0-9\\.\\-_]+", "_") + extension);
    }

    public void addDsl(Resource resource) throws IOException {
        DSLTokenizedMappingFile file = new DSLTokenizedMappingFile();
        try (Reader reader = resource.getReader();){
            if (!file.parseAndLoad(reader)) {
                this.results.addAll(file.getErrors());
            }
            if (this.dslFiles == null) {
                this.dslFiles = new ArrayList<DSLTokenizedMappingFile>();
            }
            this.dslFiles.add(file);
        }
    }

    public void addRuleFlow(Reader processSource) {
        this.addKnowledgeResource(new ReaderResource(processSource, ResourceType.DRF), ResourceType.DRF, null);
    }

    @Deprecated
    public void addProcessFromXml(Resource resource) {
        this.addKnowledgeResource(resource, resource.getResourceType(), resource.getConfiguration());
    }

    public ProcessBuilder getProcessBuilder() {
        return this.processBuilder;
    }

    @Deprecated
    public void addProcessFromXml(Reader processSource) {
        this.addProcessFromXml(new ReaderResource(processSource, ResourceType.DRF));
    }

    public void addKnowledgeResource(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        try {
            ((InternalResource)resource).setResourceType(type);
            ResourceHandlerManager handlerManager = new ResourceHandlerManager(this.getBuilderConfiguration(), this.releaseId, this::getDslExpander);
            if (handlerManager.handles(type)) {
                ResourceHandler handler = handlerManager.handlerForType(type);
                PackageDescr descr = handler.process(resource, ResourceType.DTABLE.equals(type) ? configuration : null);
                this.results.addAll(handler.getResults());
                this.addPackageWithResource(descr, resource);
            } else if (ResourceType.DSL.equals(type)) {
                this.addDsl(resource);
            } else if (ResourceType.XSD.equals(type)) {
                this.addPackageFromXSD(resource, configuration);
            } else {
                this.addPackageForExternalType(resource, type, configuration);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    void addPackageForExternalType(Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
        KieAssemblers assemblers = KieService.load(KieAssemblers.class);
        assemblers.addResourceAfterRules(this, resource, type, configuration);
    }

    @Deprecated
    void addPackageForExternalType(ResourceType type, List<ResourceWithConfiguration> resources) throws Exception {
        KieAssemblers assemblers = KieService.load(KieAssemblers.class);
        assemblers.addResourcesAfterRules(this, resources, type);
    }

    void addPackageFromXSD(Resource resource, ResourceConfiguration configuration) throws IOException {
        if (configuration != null) {
            ComponentsFactory.addPackageFromXSD(this, resource, configuration);
        }
    }

    @Override
    public final void addPackage(PackageDescr packageDescr) {
        this.addPackageWithResource(packageDescr, null);
    }

    protected void addPackageWithResource(PackageDescr packageDescr, Resource resource) {
        PackageRegistry pkgRegistry = this.getOrCreatePackageRegistry(packageDescr);
        if (pkgRegistry == null) {
            return;
        }
        PackageCompilationPhase packageProcessor = new PackageCompilationPhase(this, this.kBase, this.configuration, this.typeDeclarationManager.getTypeDeclarationBuilder(), this.assetFilter, pkgRegistry, packageDescr, resource);
        packageProcessor.process();
        this.results.addAll(packageProcessor.getResults());
        this.compileKnowledgePackages(packageDescr, pkgRegistry, resource);
        this.wireAllRules();
        this.compileRete(pkgRegistry, packageDescr);
    }

    private void compileKnowledgePackages(PackageDescr packageDescr, PackageRegistry pkgRegistry, Resource resource) {
        pkgRegistry.setDialect(this.getPackageDialect(packageDescr));
        PackageRegistry packageRegistry = this.pkgRegistryManager.getPackageRegistry(packageDescr.getNamespace());
        Map<String, AttributeDescr> packageAttributes = this.pkgRegistryManager.getPackageAttributes().get(packageDescr.getNamespace());
        List<CompilationPhase> phases = Arrays.asList(new RuleValidator(packageRegistry, packageDescr, this.configuration), FunctionCompiler.of(pkgRegistry, packageDescr, this.assetFilter, this.rootClassLoader), RuleCompilationPhase.of(pkgRegistry, packageDescr, this.kBase, this.parallelRulesBuildThreshold, this.assetFilter, packageAttributes, resource, this));
        phases.forEach(CompilationPhase::process);
        phases.forEach(p -> this.results.addAll(p.getResults()));
    }

    protected void wireAllRules() {
        ConsequenceCompilationPhase compilationPhase = new ConsequenceCompilationPhase(this.pkgRegistryManager);
        compilationPhase.process();
        this.results.addAll(compilationPhase.getResults());
    }

    protected void processKieBaseTypes() {
        if (!this.hasErrors() && this.kBase != null) {
            ArrayList<InternalKnowledgePackage> pkgs = new ArrayList<InternalKnowledgePackage>();
            for (PackageRegistry pkgReg : this.pkgRegistryManager.getPackageRegistry().values()) {
                pkgs.add(pkgReg.getPackage());
            }
            this.kBase.processAllTypesDeclaration(pkgs);
        }
    }

    private void compileRete(PackageRegistry pkgRegistry, PackageDescr packageDescr) {
        if (!this.hasErrors() && this.kBase != null) {
            ReteCompiler reteCompiler = new ReteCompiler(pkgRegistry, packageDescr, this.kBase, this.assetFilter);
            reteCompiler.process();
        }
    }

    @Override
    public void addBuilderResult(KnowledgeBuilderResult result) {
        this.results.addBuilderResult(result);
    }

    protected BuildResultCollector getBuildResultCollector() {
        return this.results;
    }

    @Override
    public <T extends ResourceTypePackage<?>> T computeIfAbsent(ResourceType resourceType, String namespace, Function<? super ResourceType, T> mappingFunction) {
        PackageRegistry pkgReg = this.getOrCreatePackageRegistry(new PackageDescr(namespace));
        InternalKnowledgePackage kpkgs = pkgReg.getPackage();
        return kpkgs.getResourceTypePackages().computeIfAbsent(resourceType, mappingFunction);
    }

    @Override
    public PackageRegistry getOrCreatePackageRegistry(PackageDescr packageDescr) {
        return this.pkgRegistryManager.getOrCreatePackageRegistry(packageDescr);
    }

    public void registerPackage(PackageDescr packageDescr) {
        this.pkgRegistryManager.registerPackage(packageDescr);
    }

    protected PackageRegistryManager getPackageRegistryManager() {
        return this.pkgRegistryManager;
    }

    @Override
    public boolean filterAccepts(ResourceChange.Type type, String namespace, String name) {
        return this.assetFilter == null || !AssetFilter.Action.DO_NOTHING.equals((Object)this.assetFilter.accept(type, namespace, name));
    }

    private String getPackageDialect(PackageDescr packageDescr) {
        String dialectName = this.defaultDialect;
        for (AttributeDescr value : packageDescr.getAttributes()) {
            if (!"dialect".equals(value.getName())) continue;
            dialectName = value.getValue();
            break;
        }
        return dialectName;
    }

    public void updateResults() {
        this.updateResults(new ArrayList<KnowledgeBuilderResult>(this.results.getAllResults()));
    }

    public void updateResults(List<KnowledgeBuilderResult> results) {
        this.results.addAll(this.getResults(results));
    }

    public void compileAll() {
        this.pkgRegistryManager.compileAll();
    }

    public void reloadAll() {
        this.pkgRegistryManager.reloadAll();
    }

    private List<KnowledgeBuilderResult> getResults(List<KnowledgeBuilderResult> results) {
        results.addAll(this.pkgRegistryManager.getResults());
        return results;
    }

    public synchronized void addPackage(InternalKnowledgePackage newPkg) {
        PackageRegistry pkgRegistry = this.pkgRegistryManager.getPackageRegistry(newPkg.getName());
        InternalKnowledgePackage pkg = null;
        if (pkgRegistry != null) {
            pkg = pkgRegistry.getPackage();
        }
        if (pkg == null) {
            PackageDescr packageDescr = new PackageDescr(newPkg.getName());
            pkgRegistry = this.getOrCreatePackageRegistry(packageDescr);
            PackageCompilationPhase packageCompilationPhase = new PackageCompilationPhase(this, this.kBase, this.configuration, this.typeDeclarationManager.getTypeDeclarationBuilder(), this.assetFilter, this.pkgRegistryManager.getPackageRegistry(packageDescr.getNamespace()), packageDescr, null);
            packageCompilationPhase.process();
            this.results.addAll(packageCompilationPhase.getResults());
            pkg = pkgRegistry.getPackage();
        }
        pkg.getDialectRuntimeRegistry().merge(newPkg.getDialectRuntimeRegistry(), this.rootClassLoader);
        if (newPkg.getFunctions() != null) {
            for (Map.Entry entry : newPkg.getFunctions().entrySet()) {
                if (pkg.getFunctions().containsKey(entry.getKey())) {
                    this.addBuilderResult(new DuplicateFunction((org.drools.core.rule.Function)entry.getValue(), this.configuration));
                }
                pkg.addFunction((org.drools.core.rule.Function)entry.getValue());
            }
        }
        pkg.mergeStore(newPkg);
        pkg.getDialectRuntimeRegistry().onBeforeExecute();
        TypeDeclaration lastType = null;
        try {
            if (newPkg.getTypeDeclarations() != null) {
                Iterator<TypeDeclaration> iterator = newPkg.getTypeDeclarations().values().iterator();
                while (iterator.hasNext()) {
                    TypeDeclaration type;
                    lastType = type = iterator.next();
                    type.setTypeClass(this.rootClassLoader.loadClass(type.getTypeClassName()));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("unable to resolve Type Declaration class '" + lastType.getTypeName() + "'");
        }
        this.mergePackage(pkg, newPkg);
    }

    private void mergePackage(InternalKnowledgePackage pkg, InternalKnowledgePackage newPkg) {
        Map<String, ImportDeclaration> imports = pkg.getImports();
        imports.putAll(newPkg.getImports());
        if (newPkg.getGlobals() != null && !newPkg.getGlobals().isEmpty()) {
            Iterator<TypeDeclaration> pkgGlobals = pkg.getGlobals();
            for (Map.Entry<String, Type> entry : newPkg.getGlobals().entrySet()) {
                String identifier = entry.getKey();
                Type type = entry.getValue();
                if (pkgGlobals.containsKey(identifier) && !((Type)pkgGlobals.get(identifier)).equals(type)) {
                    throw new RuntimeException(pkg.getName() + " cannot be integrated");
                }
                pkg.addGlobal(identifier, type);
                this.globals.addGlobal(identifier, type);
            }
        }
        if (newPkg.getTypeDeclarations() != null) {
            for (TypeDeclaration type : newPkg.getTypeDeclarations().values()) {
                if (pkg.getTypeDeclarations().containsKey(type.getTypeName())) continue;
                pkg.addTypeDeclaration(type);
            }
        }
        for (Rule newRule : newPkg.getRules()) {
            pkg.addRule((RuleImpl)newRule);
        }
        if (newPkg.getRuleFlows() != null) {
            Map<String, Process> flows = newPkg.getRuleFlows();
            for (Object object : flows.values()) {
                Process flow = (Process)object;
                pkg.addProcess(flow);
            }
        }
    }

    @Override
    public TypeDeclaration getAndRegisterTypeDeclaration(Class<?> cls, String packageName) {
        return this.typeDeclarationManager.getAndRegisterTypeDeclaration(cls, packageName);
    }

    public InternalKnowledgePackage[] getPackages() {
        InternalKnowledgePackage[] pkgs = new InternalKnowledgePackage[this.pkgRegistryManager.getPackageRegistry().size()];
        String errors = null;
        if (!this.getErrors().isEmpty()) {
            errors = this.getErrors().toString();
        }
        int i = 0;
        for (PackageRegistry pkgRegistry : this.pkgRegistryManager.getPackageRegistry().values()) {
            InternalKnowledgePackage pkg = pkgRegistry.getPackage();
            pkg.getDialectRuntimeRegistry().onBeforeExecute();
            if (errors != null) {
                pkg.setError(errors);
            }
            pkgs[i++] = pkg;
        }
        return pkgs;
    }

    @Override
    public KnowledgeBuilderConfigurationImpl getBuilderConfiguration() {
        return this.configuration.as(KnowledgeBuilderConfigurationImpl.KEY);
    }

    @Override
    public PackageRegistry getPackageRegistry(String name) {
        return this.pkgRegistryManager.getPackageRegistry(name);
    }

    @Override
    public InternalKnowledgePackage getPackage(String name) {
        PackageRegistry registry = this.getPackageRegistry(name);
        return registry == null ? null : registry.getPackage();
    }

    @Override
    public Map<String, PackageRegistry> getPackageRegistry() {
        return this.pkgRegistryManager.getPackageRegistry();
    }

    @Override
    public Collection<String> getPackageNames() {
        return this.pkgRegistryManager.getPackageNames();
    }

    @Override
    public List<PackageDescr> getPackageDescrs(String packageName) {
        return this.pkgRegistryManager.getPackageDescrs(packageName);
    }

    public DefaultExpander getDslExpander() {
        DefaultExpander expander = new DefaultExpander();
        if (this.dslFiles == null || this.dslFiles.isEmpty()) {
            return null;
        }
        for (DSLMappingFile dSLMappingFile : this.dslFiles) {
            expander.addDSLMapping(dSLMappingFile.getMapping());
        }
        return expander;
    }

    @Override
    public Map<String, Type> getGlobals() {
        return this.globals.getGlobals();
    }

    @Override
    public void addGlobal(String name, Type type) {
        this.globals.addGlobal(name, type);
    }

    protected GlobalVariableContext getGlobalVariableContext() {
        return this.globals;
    }

    @Override
    public boolean hasErrors() {
        return this.results.hasErrors();
    }

    @Override
    public KnowledgeBuilderResults getResults(ResultSeverity ... problemTypes) {
        return this.results.getResults(problemTypes);
    }

    @Override
    public boolean hasResults(ResultSeverity ... problemTypes) {
        return this.results.hasResults(problemTypes);
    }

    public boolean hasWarnings() {
        return this.results.hasWarnings();
    }

    public boolean hasInfo() {
        return this.results.hasInfo();
    }

    public List<DroolsWarning> getWarnings() {
        return this.results.getWarnings();
    }

    @Override
    public void reportError(KnowledgeBuilderError error) {
        this.results.reportError(error);
    }

    @Override
    public PackageBuilderErrors getErrors() {
        return this.results.getErrors();
    }

    public void resetErrors() {
        this.results.resetErrors();
    }

    public void resetWarnings() {
        this.results.resetWarnings();
    }

    public void resetProblems() {
        this.results.resetProblems();
        if (this.processBuilder != null) {
            this.processBuilder.getErrors().clear();
        }
    }

    @Override
    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    public void registerBuildResource(Resource resource, ResourceType type) {
        InternalResource ires = (InternalResource)resource;
        if (ires.getResourceType() == null) {
            ires.setResourceType(type);
        } else if (ires.getResourceType() != type) {
            this.addBuilderResult(new ResourceTypeDeclarationWarning(resource, ires.getResourceType(), type));
        }
        this.buildResources.push(Collections.singletonList(resource));
    }

    public void registerBuildResources(List<Resource> resources) {
        this.buildResources.push(resources);
    }

    @Override
    public void undo() {
        if (this.buildResources.isEmpty()) {
            return;
        }
        for (Resource resource : this.buildResources.pop()) {
            this.removeObjectsGeneratedFromResource(resource);
        }
    }

    @Override
    public InternalKnowledgeBuilder.ResourceRemovalResult removeObjectsGeneratedFromResource(Resource resource) {
        boolean modified = false;
        for (PackageRegistry packageRegistry : this.pkgRegistryManager.getPackageRegistry().values()) {
            modified = packageRegistry.removeObjectsGeneratedFromResource(resource) || modified;
        }
        if (this.results != null) {
            this.results.getAllResults().removeIf(knowledgeBuilderResult -> resource.equals(knowledgeBuilderResult.getResource()));
        }
        if (this.processBuilder != null && this.processBuilder.getErrors() != null) {
            this.processBuilder.getErrors().removeIf(knowledgeBuilderResult -> resource.equals(knowledgeBuilderResult.getResource()));
        }
        if (this.results != null && this.results.getAllResults().size() == 0) {
            for (PackageRegistry packageRegistry : this.pkgRegistryManager.getPackageRegistry().values()) {
                packageRegistry.getPackage().resetErrors();
            }
        }
        Collection<String> removedTypes = this.typeDeclarationManager.getTypeDeclarationBuilder().removeTypesGeneratedFromResource(resource);
        for (List<PackageDescr> pkgDescrs : this.pkgRegistryManager.getPackageDescrs()) {
            for (PackageDescr pkgDescr : pkgDescrs) {
                pkgDescr.removeObjectsGeneratedFromResource(resource);
            }
        }
        if (this.kBase != null) {
            modified = this.kBase.removeObjectsGeneratedFromResource(resource, this.kBase.getWorkingMemories()) || modified;
        }
        return new InternalKnowledgeBuilder.ResourceRemovalResult(modified, removedTypes);
    }

    @Override
    public void rewireAllClassObjectTypes() {
        if (this.kBase != null) {
            for (InternalKnowledgePackage pkg : this.kBase.getPackagesMap().values()) {
                pkg.getDialectRuntimeRegistry().getDialectData("java").setDirty(true);
                pkg.wireStore();
            }
        }
    }

    public void setAssetFilter(AssetFilter assetFilter) {
        this.assetFilter = assetFilter;
    }

    protected AssetFilter getAssetFilter() {
        return this.assetFilter;
    }

    @Override
    public void add(Resource resource, ResourceType type) {
        ResourceConfiguration resourceConfiguration = resource instanceof BaseResource ? resource.getConfiguration() : null;
        this.add(resource, type, resourceConfiguration);
    }

    @Override
    public CompositeKnowledgeBuilder batch() {
        return new CompositeKnowledgeBuilderImpl(this);
    }

    @Override
    public void add(Resource resource, ResourceType type, ResourceConfiguration configuration) {
        this.registerBuildResource(resource, type);
        this.addKnowledgeResource(resource, type, configuration);
    }

    @Override
    public Collection<KiePackage> getKnowledgePackages() {
        if (this.hasErrors()) {
            return new ArrayList<KiePackage>(0);
        }
        InternalKnowledgePackage[] pkgs = this.getPackages();
        ArrayList<KiePackage> list = new ArrayList<KiePackage>(pkgs.length);
        Collections.addAll(list, pkgs);
        return list;
    }

    @Override
    public KieBase newKieBase() {
        return this.newKnowledgeBase(KieServices.get().newKieBaseConfiguration());
    }

    public KieBase newKnowledgeBase(KieBaseConfiguration conf) {
        PackageBuilderErrors errors = this.getErrors();
        if (!errors.isEmpty()) {
            for (KnowledgeBuilderError error : errors) {
                logger.error(error.toString());
            }
            throw new IllegalArgumentException("Could not parse knowledge. See the logs for details.");
        }
        RuleBase kbase = RuleBaseFactory.newRuleBase(conf);
        kbase.addPackages(Arrays.asList(this.getPackages()));
        return KnowledgeBaseFactory.newKnowledgeBase(kbase);
    }

    @Override
    public TypeDeclaration getTypeDeclaration(Class<?> cls) {
        return this.typeDeclarationManager.getTypeDeclaration(cls);
    }

    @Override
    public TypeDeclaration getTypeDeclaration(ObjectType objectType) {
        return this.typeDeclarationManager.getTypeDeclaration(objectType);
    }

    private Map<String, Object> getBuilderCache() {
        if (this.builderCache == null) {
            this.builderCache = new HashMap<String, Object>();
        }
        return this.builderCache;
    }

    public <T> T getCachedOrCreate(String key, Supplier<T> creator) {
        Map<String, Object> builderCache = this.getBuilderCache();
        Object cachedValue = builderCache.get(key);
        if (cachedValue == null) {
            T newValue = creator.get();
            builderCache.put(key, newValue);
            return newValue;
        }
        return (T)cachedValue;
    }

    public final void buildPackages(Collection<CompositePackageDescr> packages) {
        this.doFirstBuildStep(packages);
        this.doSecondBuildStep(packages);
    }

    protected void doFirstBuildStep(Collection<CompositePackageDescr> packages) {
        this.buildPackagesWithoutRules(packages);
        this.buildRules(packages);
    }

    protected void doSecondBuildStep(Collection<CompositePackageDescr> packages) {
    }

    public void buildPackagesWithoutRules(Collection<CompositePackageDescr> packages) {
        CompositePackageCompilationPhase compositePackageCompilationPhase = new CompositePackageCompilationPhase(packages, this.pkgRegistryManager, this.typeDeclarationManager.getTypeDeclarationBuilder(), this.globals, this, this.results, this.kBase, this.configuration.as(KnowledgeBuilderConfigurationImpl.KEY));
        compositePackageCompilationPhase.process();
    }

    private void buildRules(Collection<CompositePackageDescr> packages) {
        PackageRegistry pkgRegistry;
        for (CompositePackageDescr packageDescr : packages) {
            this.setAssetFilter(packageDescr.getFilter());
            pkgRegistry = this.getPackageRegistry(packageDescr.getNamespace());
            this.compileKnowledgePackages(packageDescr, pkgRegistry, null);
            this.setAssetFilter(null);
        }
        this.wireAllRules();
        this.processKieBaseTypes();
        for (CompositePackageDescr packageDescr : packages) {
            this.setAssetFilter(packageDescr.getFilter());
            pkgRegistry = this.getPackageRegistry(packageDescr.getNamespace());
            this.compileRete(pkgRegistry, packageDescr);
            this.setAssetFilter(null);
        }
    }

    public static class ForkJoinPoolHolder {
        public static final ForkJoinPool COMPILER_POOL = new ForkJoinPool();
    }
}

