/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.builder.impl;

import java.util.Properties;
import org.drools.compiler.builder.conf.DecisionTableConfigurationImpl;
import org.drools.compiler.builder.impl.CompositeBuilderConfiguration;
import org.drools.compiler.builder.impl.KnowledgeBuilderConfigurationFactories;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.api.KieBase;
import org.kie.internal.builder.DecisionTableConfiguration;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderFactoryService;
import org.kie.internal.conf.ConfigurationFactory;
import org.kie.internal.utils.ChainedProperties;

public class KnowledgeBuilderFactoryServiceImpl
implements KnowledgeBuilderFactoryService {
    @Override
    public KnowledgeBuilderConfiguration newKnowledgeBuilderConfiguration() {
        ClassLoader projClassLoader = this.getClassLoader(null);
        ChainedProperties chained = ChainedProperties.getChainedProperties(projClassLoader);
        return new CompositeBuilderConfiguration(chained, projClassLoader, new ConfigurationFactory[]{KnowledgeBuilderConfigurationFactories.baseConf, KnowledgeBuilderConfigurationFactories.ruleConf, KnowledgeBuilderConfigurationFactories.flowConf});
    }

    @Override
    public KnowledgeBuilderConfiguration newKnowledgeBuilderConfiguration(ClassLoader classLoader) {
        return this.newKnowledgeBuilderConfiguration(null, classLoader);
    }

    protected ClassLoader getClassLoader(ClassLoader classLoader) {
        ClassLoader projClassLoader = classLoader instanceof ProjectClassLoader ? classLoader : ProjectClassLoader.getClassLoader(classLoader, this.getClass());
        return projClassLoader;
    }

    @Override
    public KnowledgeBuilderConfiguration newKnowledgeBuilderConfiguration(Properties properties, ClassLoader classLoader) {
        ClassLoader projClassLoader = this.getClassLoader(classLoader);
        ChainedProperties chained = ChainedProperties.getChainedProperties(projClassLoader);
        if (properties != null) {
            chained.addProperties(properties);
        }
        return new CompositeBuilderConfiguration(chained, projClassLoader, new ConfigurationFactory[]{KnowledgeBuilderConfigurationFactories.baseConf, KnowledgeBuilderConfigurationFactories.ruleConf, KnowledgeBuilderConfigurationFactories.flowConf});
    }

    @Override
    public DecisionTableConfiguration newDecisionTableConfiguration() {
        return new DecisionTableConfigurationImpl();
    }

    @Override
    public KnowledgeBuilder newKnowledgeBuilder() {
        return new KnowledgeBuilderImpl();
    }

    @Override
    public KnowledgeBuilder newKnowledgeBuilder(KnowledgeBuilderConfiguration conf) {
        return new KnowledgeBuilderImpl(conf);
    }

    @Override
    public KnowledgeBuilder newKnowledgeBuilder(KieBase kbase) {
        if (kbase != null) {
            return new KnowledgeBuilderImpl((InternalKnowledgeBase)kbase);
        }
        return new KnowledgeBuilderImpl();
    }

    @Override
    public KnowledgeBuilder newKnowledgeBuilder(KieBase kbase, KnowledgeBuilderConfiguration conf) {
        if (kbase != null) {
            return new KnowledgeBuilderImpl((InternalKnowledgeBase)kbase, conf);
        }
        return new KnowledgeBuilderImpl(conf);
    }
}

