/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.core.jpy;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.drools.ansible.rulebook.integration.api.RuleConfigurationOption;
import org.drools.ansible.rulebook.integration.api.RuleFormat;
import org.drools.ansible.rulebook.integration.api.RuleNotation;
import org.drools.ansible.rulebook.integration.api.RulesExecutor;
import org.drools.ansible.rulebook.integration.api.RulesExecutorContainer;
import org.drools.ansible.rulebook.integration.api.RulesExecutorFactory;
import org.drools.ansible.rulebook.integration.api.domain.RulesSet;
import org.drools.ansible.rulebook.integration.api.io.AstRuleMatch;
import org.drools.ansible.rulebook.integration.api.io.JsonMapper;
import org.json.JSONObject;
import org.kie.api.runtime.rule.Match;

public class AstRulesEngine
implements Closeable {
    private final RulesExecutorContainer rulesExecutorContainer = new RulesExecutorContainer();
    private boolean shutdown = false;

    public long createRuleset(String rulesetString) {
        RulesSet rulesSet = RuleNotation.CoreNotation.INSTANCE.toRulesSet(RuleFormat.JSON, rulesetString);
        return this.createRuleset(rulesSet);
    }

    public long createRuleset(RulesSet rulesSet) {
        this.checkAlive();
        if (rulesSet.hasTemporalConstraint()) {
            rulesSet.withOptions(RuleConfigurationOption.USE_PSEUDO_CLOCK);
            if (rulesSet.hasAsyncExecution()) {
                this.rulesExecutorContainer.allowAsync();
            }
        }
        RulesExecutor executor = this.rulesExecutorContainer.register(RulesExecutorFactory.createRulesExecutor(rulesSet));
        return executor.getId();
    }

    public String dispose(long sessionId) {
        RulesExecutor rulesExecutor = this.rulesExecutorContainer.get(sessionId);
        if (rulesExecutor == null) {
            return null;
        }
        return JsonMapper.toJson(rulesExecutor.dispose());
    }

    public String retractFact(long sessionId, String serializedFact) {
        Map<String, Object> fact = new JSONObject(serializedFact).toMap();
        List<Match> matches = this.rulesExecutorContainer.get(sessionId).processRetract(fact).join();
        return JsonMapper.toJson(AstRuleMatch.asList(matches));
    }

    public String assertFact(long sessionId, String serializedFact) {
        Map<String, Object> fact = new JSONObject(serializedFact).toMap();
        List<Match> matches = this.rulesExecutorContainer.get(sessionId).processFacts(fact).join();
        return JsonMapper.toJson(AstRuleMatch.asList(matches));
    }

    public String assertEvent(long sessionId, String serializedFact) {
        Map<String, Object> fact = new JSONObject(serializedFact).toMap();
        List<Match> matches = this.rulesExecutorContainer.get(sessionId).processEvents(fact).join();
        return JsonMapper.toJson(AstRuleMatch.asList(matches));
    }

    public String getFacts(long sessionId) {
        RulesExecutor executor = this.rulesExecutorContainer.get(sessionId);
        if (executor == null) {
            throw new NoSuchElementException("No such session id: " + sessionId + ". Was it disposed?");
        }
        return JsonMapper.toJson(executor.getAllFactsAsMap());
    }

    public String advanceTime(long sessionId, long amount, String unit) {
        List<Match> matches = this.rulesExecutorContainer.get(sessionId).advanceTime(amount, TimeUnit.valueOf(unit.toUpperCase())).join();
        return JsonMapper.toJson(AstRuleMatch.asList(matches));
    }

    public void shutdown() {
        this.close();
    }

    @Override
    public void close() {
        this.shutdown = true;
        this.rulesExecutorContainer.disposeAll();
    }

    public int port() {
        return this.rulesExecutorContainer.port();
    }

    private void checkAlive() {
        if (this.shutdown) {
            throw new IllegalStateException("This AstRulesEngine is shutting down");
        }
    }
}

