/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.rulesmodel;

import org.drools.ansible.rulebook.integration.api.domain.RuleGenerationContext;
import org.drools.ansible.rulebook.integration.api.domain.constraints.NegationOperator;
import org.drools.model.Condition;
import org.drools.model.ConstraintOperator;
import org.drools.model.DSL;
import org.drools.model.PrototypeDSL;
import org.drools.model.PrototypeExpression;
import org.drools.model.PrototypeVariable;
import org.drools.model.view.CombinedExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;

public class ParsedCondition {
    private final PrototypeExpression left;
    private final ConstraintOperator operator;
    private final PrototypeExpression right;
    private boolean notPattern = false;
    private boolean implicitPattern = false;
    private boolean negated = false;

    public ParsedCondition(String left, ConstraintOperator operator, Object right) {
        this(PrototypeExpression.prototypeField(left), operator, PrototypeExpression.fixedValue(right));
    }

    public ParsedCondition(PrototypeExpression left, ConstraintOperator operator, PrototypeExpression right) {
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public PrototypeExpression getLeft() {
        return this.left;
    }

    public ConstraintOperator getOperator() {
        return this.negated ? new NegationOperator(this.operator) : this.operator;
    }

    public PrototypeExpression getRight() {
        return this.right;
    }

    public ParsedCondition withNotPattern(boolean notPattern) {
        this.notPattern = notPattern;
        return this;
    }

    public ParsedCondition withImplicitPattern(boolean implicitPattern) {
        this.implicitPattern = implicitPattern;
        return this;
    }

    public ParsedCondition negate() {
        this.negated = true;
        return this;
    }

    public ViewItem addConditionToPattern(RuleGenerationContext ruleContext, PrototypeDSL.PrototypePatternDef pattern) {
        if (this.implicitPattern) {
            PrototypeDSL.PrototypePatternDef first = ruleContext.getOrCreatePattern(ruleContext.generateBinding(), "DROOLS_PROTOTYPE");
            pattern.expr(this.getLeft(), this.getOperator(), (PrototypeVariable)first.getFirstVariable(), this.getRight());
            return new CombinedExprViewItem(Condition.Type.AND, new ViewItem[]{first, pattern});
        }
        pattern.expr(this.getLeft(), this.getOperator(), this.getRight());
        return this.notPattern ? DSL.not(pattern, new ViewItemBuilder[0]) : pattern;
    }

    public String toString() {
        return this.getLeft() + " " + this.getOperator() + " " + this.getRight();
    }
}

