/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.rulesengine;

import java.time.Instant;
import java.util.List;
import org.drools.ansible.rulebook.integration.api.rulesengine.RulesExecutorSession;
import org.drools.ansible.rulebook.integration.api.rulesengine.SessionStats;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;

public class SessionStatsCollector {
    private final long id;
    private final Instant start = Instant.now();
    private int rulesTriggered;
    private int totalEvents;
    private int matchedEvents;
    private int asyncResponses;
    private int bytesSentOnAsync;

    public SessionStatsCollector(long id) {
        this.id = id;
    }

    public SessionStats generateStats(RulesExecutorSession session) {
        return new SessionStats(this, session);
    }

    public Instant getStart() {
        return this.start;
    }

    public int getRulesTriggered() {
        return this.rulesTriggered;
    }

    public int getTotalEvents() {
        return this.totalEvents;
    }

    public int getMatchedEvents() {
        return this.matchedEvents;
    }

    public int getAsyncResponses() {
        return this.asyncResponses;
    }

    public int getBytesSentOnAsync() {
        return this.bytesSentOnAsync;
    }

    public void registerMatch(Match match) {
        ++this.rulesTriggered;
    }

    public void registerMatchedEvents(List<FactHandle> events) {
        this.matchedEvents += events.size();
    }

    public void registerProcessedEvent(FactHandle fh) {
        ++this.totalEvents;
    }

    public void registerAsyncResponse(byte[] bytes) {
        ++this.asyncResponses;
        this.bytesSentOnAsync += bytes.length;
    }
}

