/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.rulesengine;

import java.time.Instant;
import java.util.function.Predicate;
import org.drools.ansible.rulebook.integration.api.rulesengine.RulesExecutorSession;
import org.drools.ansible.rulebook.integration.api.rulesengine.SessionStatsCollector;
import org.drools.core.facttemplates.Event;

public class SessionStats {
    private final String start;
    private final String end;
    private final int numberOfRules;
    private final int rulesTriggered;
    private final int eventsProcessed;
    private final int eventsMatched;
    private final int eventsSuppressed;
    private final int permanentStorageSize;
    private final int asyncResponses;
    private final int bytesSentOnAsync;
    private final long sessionId;
    private final String ruleSetName;

    public SessionStats(SessionStatsCollector stats, RulesExecutorSession session) {
        this.start = stats.getStart().toString();
        this.end = Instant.now().toString();
        this.numberOfRules = (int)session.rulesCount();
        this.rulesTriggered = stats.getRulesTriggered();
        this.eventsProcessed = stats.getTotalEvents();
        this.eventsMatched = stats.getMatchedEvents();
        this.eventsSuppressed = this.eventsProcessed - this.eventsMatched;
        this.permanentStorageSize = (int)session.getObjects().stream().filter(Predicate.not(Event.class::isInstance)).count();
        this.asyncResponses = stats.getAsyncResponses();
        this.bytesSentOnAsync = stats.getBytesSentOnAsync();
        this.sessionId = session.getId();
        this.ruleSetName = session.getRuleSetName();
    }

    public SessionStats(String start, String end, int numberOfRules, int rulesTriggered, int eventsProcessed, int eventsMatched, int eventsSuppressed, int permanentStorageSize, int asyncResponses, int bytesSentOnAsync, long sessionId, String ruleSetName) {
        this.start = start;
        this.end = end;
        this.numberOfRules = numberOfRules;
        this.rulesTriggered = rulesTriggered;
        this.eventsProcessed = eventsProcessed;
        this.eventsMatched = eventsMatched;
        this.eventsSuppressed = eventsSuppressed;
        this.permanentStorageSize = permanentStorageSize;
        this.asyncResponses = asyncResponses;
        this.bytesSentOnAsync = bytesSentOnAsync;
        this.sessionId = sessionId;
        this.ruleSetName = ruleSetName;
    }

    public String toString() {
        return "SessionStats{start=" + this.start + ", end=" + this.end + ", numberOfRules=" + this.numberOfRules + ", rulesTriggered=" + this.rulesTriggered + ", eventsProcessed=" + this.eventsProcessed + ", eventsMatched=" + this.eventsMatched + ", eventsSuppressed=" + this.eventsSuppressed + ", permanentStorageSize=" + this.permanentStorageSize + ", asyncResponses=" + this.asyncResponses + ", bytesSentOnAsync=" + this.bytesSentOnAsync + "}";
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public int getNumberOfRules() {
        return this.numberOfRules;
    }

    public int getRulesTriggered() {
        return this.rulesTriggered;
    }

    public int getEventsProcessed() {
        return this.eventsProcessed;
    }

    public int getEventsMatched() {
        return this.eventsMatched;
    }

    public int getEventsSuppressed() {
        return this.eventsSuppressed;
    }

    public int getPermanentStorageSize() {
        return this.permanentStorageSize;
    }

    public int getAsyncResponses() {
        return this.asyncResponses;
    }

    public int getBytesSentOnAsync() {
        return this.bytesSentOnAsync;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public String getRuleSetName() {
        return this.ruleSetName;
    }

    public static SessionStats aggregate(SessionStats stats1, SessionStats stats2) {
        return new SessionStats(stats1.getStart().compareTo(stats2.getStart()) < 0 ? stats1.getStart() : stats2.getStart(), stats1.getEnd().compareTo(stats2.getEnd()) > 0 ? stats1.getStart() : stats2.getStart(), stats1.numberOfRules + stats2.numberOfRules, stats1.rulesTriggered + stats2.rulesTriggered, stats1.eventsProcessed + stats2.eventsProcessed, stats1.eventsMatched + stats2.eventsMatched, stats1.eventsSuppressed + stats2.eventsSuppressed, stats1.permanentStorageSize + stats2.permanentStorageSize, stats1.asyncResponses + stats2.asyncResponses, stats1.bytesSentOnAsync + stats2.bytesSentOnAsync, -1L, stats1.getRuleSetName().equals(stats2.getRuleSetName()) ? stats1.getRuleSetName() : "");
    }
}

