/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.rulesengine;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.drools.ansible.rulebook.integration.api.domain.RulesSet;
import org.drools.ansible.rulebook.integration.api.rulesengine.RulesExecutionController;
import org.drools.ansible.rulebook.integration.api.rulesengine.SessionStats;
import org.drools.ansible.rulebook.integration.api.rulesengine.SessionStatsCollector;
import org.drools.core.facttemplates.Fact;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.time.SessionPseudoClock;

public class RulesExecutorSession {
    private final RulesSet rulesSet;
    private final KieSession kieSession;
    private final RulesExecutionController rulesExecutionController;
    private final long id;
    private final SessionStatsCollector sessionStatsCollector;

    public RulesExecutorSession(RulesSet rulesSet, KieSession kieSession, RulesExecutionController rulesExecutionController, long id) {
        this.rulesSet = rulesSet;
        this.kieSession = kieSession;
        this.rulesExecutionController = rulesExecutionController;
        this.id = id;
        this.sessionStatsCollector = new SessionStatsCollector(id);
    }

    long getId() {
        return this.id;
    }

    String getRuleSetName() {
        return this.rulesSet.getName();
    }

    Collection<? extends Object> getObjects() {
        return this.kieSession.getObjects();
    }

    FactHandle insert(Object object) {
        return this.kieSession.insert(object);
    }

    void delete(FactHandle fh) {
        this.kieSession.delete(fh);
    }

    boolean deleteFact(Fact toBeRetracted) {
        return this.kieSession.getFactHandles(o -> o instanceof Fact && Objects.equals(((Fact)o).asMap(), toBeRetracted.asMap())).stream().findFirst().map(fh -> {
            this.kieSession.delete((FactHandle)fh);
            return true;
        }).orElse(false);
    }

    int fireAllRules() {
        return this.kieSession.fireAllRules();
    }

    int fireAllRules(AgendaFilter agendaFilter) {
        return this.kieSession.fireAllRules(agendaFilter);
    }

    public SessionStatsCollector getSessionStats() {
        return this.sessionStatsCollector;
    }

    SessionStats dispose() {
        SessionStats stats = this.sessionStatsCollector.generateStats(this);
        this.kieSession.dispose();
        return stats;
    }

    long rulesCount() {
        return this.kieSession.getKieBase().getKiePackages().stream().flatMap(p -> p.getRules().stream()).filter(r -> r.getMetaData().get("SYNTHETIC_RULE") == null).count();
    }

    void advanceTime(long amount, TimeUnit unit) {
        SessionPseudoClock clock = this.getPseudoClock();
        clock.advanceTime(amount, unit);
    }

    SessionPseudoClock getPseudoClock() {
        return (SessionPseudoClock)this.kieSession.getSessionClock();
    }

    void setExecuteActions(boolean executeActions) {
        this.rulesExecutionController.setExecuteActions(executeActions);
    }
}

