/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ansible.rulebook.integration.api.rulesengine;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.drools.ansible.rulebook.integration.api.RulesExecutorContainer;
import org.drools.ansible.rulebook.integration.api.io.AstRuleMatch;
import org.drools.ansible.rulebook.integration.api.io.JsonMapper;
import org.drools.ansible.rulebook.integration.api.io.Response;
import org.drools.ansible.rulebook.integration.api.io.RuleExecutorChannel;
import org.drools.ansible.rulebook.integration.api.rulesengine.AsyncExecutor;
import org.drools.ansible.rulebook.integration.api.rulesengine.AutomaticPseudoClock;
import org.drools.ansible.rulebook.integration.api.rulesengine.FullMatchDecorator;
import org.drools.ansible.rulebook.integration.api.rulesengine.RegisterOnlyAgendaFilter;
import org.drools.ansible.rulebook.integration.api.rulesengine.RulesEvaluator;
import org.drools.ansible.rulebook.integration.api.rulesengine.RulesExecutorSession;
import org.drools.ansible.rulebook.integration.api.rulesengine.SessionStats;
import org.drools.ansible.rulebook.integration.api.rulesmodel.RulesModelUtil;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.facttemplates.Fact;
import org.kie.api.runtime.rule.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRulesEvaluator
implements RulesEvaluator {
    protected static final Logger log = LoggerFactory.getLogger(AbstractRulesEvaluator.class);
    protected final RulesExecutorSession rulesExecutorSession;
    protected final RegisterOnlyAgendaFilter registerOnlyAgendaFilter;
    private RulesExecutorContainer rulesExecutorContainer;
    private AutomaticPseudoClock automaticClock;
    protected RuleExecutorChannel channel;
    protected AsyncExecutor asyncExecutor;

    public AbstractRulesEvaluator(RulesExecutorSession rulesExecutorSession) {
        this.rulesExecutorSession = rulesExecutorSession;
        this.registerOnlyAgendaFilter = new RegisterOnlyAgendaFilter(rulesExecutorSession);
    }

    @Override
    public long getSessionId() {
        return this.rulesExecutorSession.getId();
    }

    @Override
    public void setRulesExecutorContainer(RulesExecutorContainer rulesExecutorContainer) {
        this.rulesExecutorContainer = rulesExecutorContainer;
        this.asyncExecutor = rulesExecutorContainer.getAsyncExecutor();
        this.channel = rulesExecutorContainer.getChannel();
    }

    @Override
    public void startAutomaticPseudoClock(long period, TimeUnit unit) {
        if (log.isInfoEnabled()) {
            log.info("Start automatic pseudo clock with a tick every " + period + " " + unit.toString().toLowerCase());
        }
        this.automaticClock = new AutomaticPseudoClock(this, period, unit);
    }

    @Override
    public long getAutomaticPseudoClockPeriod() {
        return this.automaticClock == null ? -1L : this.automaticClock.getPeriod();
    }

    @Override
    public long rulesCount() {
        return this.rulesExecutorSession.rulesCount();
    }

    @Override
    public Collection<?> getAllFacts() {
        return this.rulesExecutorSession.getObjects();
    }

    @Override
    public CompletableFuture<List<Match>> fire() {
        return this.engineEvaluate(() -> this.getMatches(false));
    }

    @Override
    public CompletableFuture<List<Match>> processFacts(Map<String, Object> factMap) {
        return this.engineEvaluate(() -> this.process(factMap, false));
    }

    @Override
    public CompletableFuture<List<Match>> processEvents(Map<String, Object> factMap) {
        return this.engineEvaluate(() -> this.process(factMap, true));
    }

    @Override
    public CompletableFuture<List<Match>> advanceTime(long amount, TimeUnit unit) {
        return this.channel != null ? this.engineEvaluate(() -> this.writeResponseOnChannel(this.internalAdvanceTime(amount, unit))) : this.engineEvaluate(() -> this.internalAdvanceTime(amount, unit));
    }

    CompletableFuture<List<Match>> scheduledAdvanceTimeToMills(long millis) {
        long currentTime = this.rulesExecutorSession.getPseudoClock().getCurrentTime();
        if (currentTime >= millis) {
            return this.completeFutureOf(Collections.emptyList());
        }
        if (log.isTraceEnabled()) {
            log.trace("Automatic advance of " + (millis - currentTime) + " milliseconds");
        }
        return this.asyncExecutor == null ? this.completeFutureOf(this.internalAdvanceTime(millis - currentTime, TimeUnit.MILLISECONDS)) : this.asyncExecutor.submit(() -> this.writeResponseOnChannel(this.internalAdvanceTime(millis - currentTime, TimeUnit.MILLISECONDS)));
    }

    @Override
    public CompletableFuture<List<Match>> processRetract(Map<String, Object> json) {
        return this.engineEvaluate(() -> this.syncProcessRetract(json));
    }

    protected abstract CompletableFuture<List<Match>> engineEvaluate(Supplier<List<Match>> var1);

    private List<Match> internalAdvanceTime(long amount, TimeUnit unit) {
        this.rulesExecutorSession.advanceTime(amount, unit);
        return this.findMatchedRules();
    }

    protected int internalExecuteFacts(Map<String, Object> factMap) {
        this.insertFact(factMap, false);
        return this.rulesExecutorSession.fireAllRules();
    }

    @Override
    public SessionStats dispose() {
        if (this.rulesExecutorContainer != null) {
            this.rulesExecutorContainer.removeExecutor(this.getSessionId());
        }
        if (this.automaticClock != null) {
            this.automaticClock.shutdown();
        }
        return this.rulesExecutorSession.dispose();
    }

    protected List<Match> process(Map<String, Object> factMap, boolean event) {
        Collection<InternalFactHandle> fhs = this.insertFacts(factMap, event);
        List<Match> matches = this.getMatches(event);
        if (log.isDebugEnabled()) {
            for (InternalFactHandle fh : fhs) {
                if (!fh.isDisconnected()) continue;
                String factAsString = fhs.size() == 1 ? JsonMapper.toJson(factMap) : JsonMapper.toJson(((Fact)fh.getObject()).asMap());
                log.debug((event ? "Event " : "Fact ") + factAsString + " didn't match any rule and has been immediately discarded");
            }
        }
        return matches;
    }

    private Collection<InternalFactHandle> insertFacts(Map<String, Object> factMap, boolean event) {
        String key;
        String string = key = event ? "events" : "facts";
        if (factMap.size() == 1 && factMap.containsKey(key)) {
            return ((List)factMap.get(key)).stream().flatMap(map -> this.insertFacts((Map<String, Object>)map, event).stream()).collect(Collectors.toList());
        }
        return Collections.singletonList(this.insertFact(factMap, event));
    }

    private InternalFactHandle insertFact(Map<String, Object> factMap, boolean event) {
        InternalFactHandle fh = (InternalFactHandle)this.rulesExecutorSession.insert(RulesModelUtil.mapToFact(factMap, event));
        if (event) {
            this.rulesExecutorSession.getSessionStats().registerProcessedEvent(fh);
        }
        return fh;
    }

    protected List<Match> getMatches(boolean event) {
        List<Match> matches = this.findMatchedRules();
        return !event || matches.size() < 2 ? matches : matches.stream().takeWhile(match -> match.getRule().getName().equals(((Match)matches.get(0)).getRule().getName())).collect(Collectors.toList());
    }

    private synchronized List<Match> findMatchedRules() {
        this.rulesExecutorSession.setExecuteActions(false);
        this.rulesExecutorSession.fireAllRules(this.registerOnlyAgendaFilter);
        this.rulesExecutorSession.setExecuteActions(true);
        return this.registerOnlyAgendaFilter.finalizeAndGetResults();
    }

    protected List<Match> syncProcessRetract(Map<String, Object> json) {
        List<Match> matches = this.retractFact(json) ? this.findMatchedRules() : Collections.emptyList();
        matches = matches.stream().map(FullMatchDecorator::new).map(m -> m.withBoundObject("m", json)).collect(Collectors.toList());
        return matches;
    }

    @Override
    public boolean retractFact(Map<String, Object> factMap) {
        return this.rulesExecutorSession.deleteFact(RulesModelUtil.mapToFact(factMap, false));
    }

    protected <T> CompletableFuture<T> completeFutureOf(T value) {
        CompletableFuture<T> future = new CompletableFuture<T>();
        future.complete(value);
        return future;
    }

    protected List<Match> writeResponseOnChannel(List<Match> matches) {
        if (!matches.isEmpty()) {
            byte[] bytes = this.channel.write(new Response(this.getSessionId(), AstRuleMatch.asList(matches)));
            this.rulesExecutorSession.getSessionStats().registerAsyncResponse(bytes);
        }
        return matches;
    }
}

